<?xml version="1.0" encoding="UTF-8"?>
<!--
   Licensed Materials - Property of IBM
   5655-FLW (C) Copyright IBM Corporation 2004, 2006.
   US Government Users Restricted Rights- Use, duplication or disclosure
   restricted by GSA ADP Schedule Contract with IBM Corp.
-->

<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xalan="http://xml.apache.org/xslt" 
	xmlns:staff="http://www.ibm.com/schemas/workflow/wswf/plugins/staff" 
	xmlns:swmm="http://www.ibm.com/schemas/workflow/wswf/plugins/staff/membermanager" version="1.0">
	
	<xsl:output standalone="no" encoding="UTF-8" omit-xml-declaration="no" media-type="text/xml" method="xml" indent="yes" version="1.0"/>
	<xsl:strip-space elements="*"/>
	
	<!-- Begin global variables -->
	<xsl:variable name="Threshold">20</xsl:variable>
	<xsl:variable name="DefaultUserIdType">memberDN</xsl:variable>
	<xsl:variable name="DefaultUserSearchAttribute">uid</xsl:variable>
	<xsl:variable name="DefaultUserReturnAttribute">uid</xsl:variable>
	<xsl:variable name="DefaultUserManagerAttribute">manager</xsl:variable>

  	<xsl:variable name="DefaultMailAttribute">ibm-primaryEmail</xsl:variable> 
	
	<xsl:variable name="DefaultSearchBase">o=Default Organization</xsl:variable>
	<xsl:variable name="DefaultGroupIdType">memberDN</xsl:variable>
	<xsl:variable name="DefaultGroupNameAttribute">cn</xsl:variable>
	<xsl:variable name="DefaultGroupNameSuffix">,o=Default Organization</xsl:variable>
	
	<xsl:variable name="DefaultDepartmentNameAttribute">o</xsl:variable>
	<xsl:variable name="DefaultDepartmentNameSuffix">,o=Default Organization</xsl:variable>
	<xsl:variable name="DefaultRoleNameAttribute">o</xsl:variable>
	<xsl:variable name="DefaultRoleNameSuffix">,o=Default Organization</xsl:variable>

	<!-- search attribute mappings for Group Search verb -->
  	<xsl:variable name="GS_GroupID">cn</xsl:variable>
  	<xsl:variable name="GS_Type">unknown</xsl:variable>
  	<xsl:variable name="GS_IndustryType">unknown</xsl:variable>
  	<xsl:variable name="GS_BusinessType">businesscategory</xsl:variable>
  	<xsl:variable name="GS_GeographicLocation">unknown</xsl:variable>
  	<xsl:variable name="GS_Affiliates">unknown</xsl:variable>
  	<xsl:variable name="GS_DisplayName">unknown</xsl:variable>
  	<xsl:variable name="GS_Secretary">unknown</xsl:variable>
  	<xsl:variable name="GS_Assistant">unknown</xsl:variable>
  	<xsl:variable name="GS_Manager">unknown</xsl:variable>
  	<xsl:variable name="GS_BusinessCategory">unknown</xsl:variable>
  	<xsl:variable name="GS_ParentCompany">unknown</xsl:variable>

	<!-- search attribute mappings for Person Search verb -->
  	<xsl:variable name="PS_UserID">uid</xsl:variable>
  	<xsl:variable name="PS_Profile">unknown</xsl:variable>
  	<xsl:variable name="PS_LastName">sn</xsl:variable>
  	<xsl:variable name="PS_FirstName">unknown</xsl:variable>
  	<xsl:variable name="PS_MiddleName">unknown</xsl:variable>
  	<xsl:variable name="PS_Email">unknown</xsl:variable>
  	<xsl:variable name="PS_Company">unknown</xsl:variable>
  	<xsl:variable name="PS_DisplayName">unknown</xsl:variable>
  	<xsl:variable name="PS_Assistant">unknown</xsl:variable>
  	<xsl:variable name="PS_Secretary">unknown</xsl:variable>
  	<xsl:variable name="PS_Manager">manager</xsl:variable>
  	<xsl:variable name="PS_Department">unknown</xsl:variable>
  	<xsl:variable name="PS_EmployeeID">unknown</xsl:variable>
  	<xsl:variable name="PS_TaxPayerID">unknown</xsl:variable>
  	<xsl:variable name="PS_Phone">unknown</xsl:variable>
  	<xsl:variable name="PS_Fax">unknown</xsl:variable>
  	<xsl:variable name="PS_Gender">unknown</xsl:variable>
  	<xsl:variable name="PS_Timezone">unknown</xsl:variable>
  	<xsl:variable name="PS_PreferredLanguage">unknown</xsl:variable>
	<!-- End global variables -->

	<!-- set retrieval attribute to point to a user id attribute or, for email verbs, to an email attribute -->	
	<xsl:variable name="verb" select="normalize-space(/staff:verb/staff:name/text())"/>
	<xsl:variable name="returnAttribute">
    		<xsl:choose>				    		
			<xsl:when test="$verb='Email Address for Users by user ID'"> <xsl:value-of select="$DefaultMailAttribute"/> </xsl:when>
			<xsl:when test="$verb='Email Address for Users'"> <xsl:value-of select="$DefaultMailAttribute"/> </xsl:when>
			<xsl:when test="$verb='Email Address for Group Members'"> <xsl:value-of select="$DefaultMailAttribute"/> </xsl:when>
			<xsl:when test="$verb='Email Address for Group Members without Filtered Users'"> <xsl:value-of select="$DefaultMailAttribute"/> </xsl:when>
			<xsl:when test="$verb='Email Address for Department Members'"> <xsl:value-of select="$DefaultMailAttribute"/> </xsl:when>
			<xsl:when test="$verb='Email Address for Role Members'"> <xsl:value-of select="$DefaultMailAttribute"/> </xsl:when>
			<xsl:when test="$verb='Email Address for Group Search'"> <xsl:value-of select="$DefaultMailAttribute"/> </xsl:when>
					
			<xsl:otherwise> <xsl:value-of select="$DefaultUserReturnAttribute"/> </xsl:otherwise>
    		</xsl:choose>
    	</xsl:variable>	
	
	<!-- Begin global dispatching -->
	<xsl:template match="/staff:verb">	
		
    		<xsl:choose>
    		
			<xsl:when test="$verb='Users'">
				<xsl:call-template name="Users"/>
			</xsl:when>
			<xsl:when test="$verb='Users by user ID'">
				<xsl:call-template name="UsersByUserID"/>
			</xsl:when>

      			<xsl:when test="$verb='Users by user ID without Named Users'">
				<xsl:call-template name="UsersByUserIDWithoutNamedUsers"/>
      			</xsl:when>
			
			<xsl:when test="$verb='Group Members'">
				<xsl:call-template name="GroupMembers"/>
			</xsl:when>
			<xsl:when test="$verb='Group Members without Named Users'">
				<xsl:call-template name="GroupMembersWithoutNamedUsers"/>
			</xsl:when>			
			<xsl:when test="$verb='Group Members without Filtered Users'">
				<xsl:call-template name="GroupMembersWithoutFilteredUsers"/>
			</xsl:when>				
						
			<xsl:when test="$verb='Role Members'">
				<xsl:call-template name="RoleMembers"/>
			</xsl:when>
			<xsl:when test="$verb='Department Members'">
				<xsl:call-template name="DepartmentMembers"/>
			</xsl:when>
			
			<xsl:when test="$verb='Manager of Employee'">
				<xsl:call-template name="ManagerOfEmployee"/>
			</xsl:when>
			<xsl:when test="$verb='Manager of Employee by user ID'">
				<xsl:call-template name="ManagerOfEmployeeByUserID"/>
			</xsl:when>
			
			<xsl:when test="$verb='Person Search'">
				<xsl:call-template name="PersonSearch"/>
			</xsl:when>
			<xsl:when test="$verb='Group Search'">
				<xsl:call-template name="GroupSearch"/>
			</xsl:when>
			<xsl:when test="$verb='Native Query'">
				<xsl:call-template name="NativeQuery"/>
			</xsl:when>
			
			<xsl:when test="$verb='Everybody'">
				<xsl:call-template name="Everybody"/>
			</xsl:when>
			<xsl:when test="$verb='Nobody'">
				<xsl:call-template name="Nobody"/>
			</xsl:when>
		      	<xsl:when test="$verb='Group'">
        			<xsl:call-template name="Group"/>
      			</xsl:when>

      			<!-- email verbs -->
      			<!-- special verb for this case -->
      			<xsl:when test="$verb='Email Address for Users by user ID'">
        			<xsl:call-template name="EmailForUsersByUserID"/>
      			</xsl:when>
      			
      			<!-- these email verbs map onto regular verbs, as 'returnAttribute' is set to point to an email attribute -->
      			<xsl:when test="$verb='Email Address for Users'">
        			<xsl:call-template name="Users"/>
      			</xsl:when>
      			<xsl:when test="$verb='Email Address for Group Members'">
        			<xsl:call-template name="GroupMembers"/>
      			</xsl:when>
      			<xsl:when test="$verb='Email Address for Group Members without Filtered Users'">
        			<xsl:call-template name="GroupMembersWithoutFilteredUsers"/>
      			</xsl:when>     
      			<xsl:when test="$verb='Email Address for Department Members'">
        			<xsl:call-template name="DepartmentMembers"/>
      			</xsl:when>
      			<xsl:when test="$verb='Email Address for Role Members'">
        			<xsl:call-template name="RoleMembers"/>
      			</xsl:when>
      			<xsl:when test="$verb='Email Address for Group Search'">
        			<xsl:call-template name="GroupSearch"/>
      			</xsl:when>  

			<xsl:otherwise>
				<xsl:message terminate="no">ERROR: Unsupported verb: '<xsl:value-of select="$verb"/>'.</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- End global dispatching -->

	<!-- Begin template Users and children -->
	<xsl:template name="Users">
		<xsl:variable name="Name0">
			<xsl:value-of select="staff:parameter[@id='Name']"/>
		</xsl:variable>
		<xsl:variable name="Name1">
			<xsl:value-of select="staff:parameter[@id='AlternativeName1']"/>
		</xsl:variable>
		<xsl:variable name="Name2">
			<xsl:value-of select="staff:parameter[@id='AlternativeName2']"/>
		</xsl:variable>
		<swmm:staffQueries>
			<xsl:attribute name="threshold"><xsl:value-of select="$Threshold"/></xsl:attribute>
			<xsl:call-template name="GetUser">
				<xsl:with-param name="username">
					<xsl:value-of select="$Name0"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:if test="$Name1!=''">
				<xsl:call-template name="GetUser">
					<xsl:with-param name="username">
						<xsl:value-of select="$Name1"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$Name2!=''">
				<xsl:call-template name="GetUser">
					<xsl:with-param name="username">
						<xsl:value-of select="$Name2"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</swmm:staffQueries>
	</xsl:template>
	
	<xsl:template name="GetUser">
		<xsl:param name="username">default</xsl:param>
		<swmm:user>
			<xsl:attribute name="id"><xsl:value-of select="$username"/></xsl:attribute>
			<xsl:attribute name="idType"><xsl:value-of select="$DefaultUserIdType"/></xsl:attribute>
			<xsl:attribute name="attribute"><xsl:value-of select="$returnAttribute"/></xsl:attribute>
		</swmm:user>
	</xsl:template>
	<!-- End template Users and children -->


	<!-- Begin template UsersByUserID and children -->
	<xsl:template name="UsersByUserID">
		<xsl:variable name="Name0">
			<xsl:value-of select="staff:parameter[@id='UserID']"/>
		</xsl:variable>
		<xsl:variable name="Name1">
			<xsl:value-of select="staff:parameter[@id='AlternativeID1']"/>
		</xsl:variable>
		<xsl:variable name="Name2">
			<xsl:value-of select="staff:parameter[@id='AlternativeID2']"/>
		</xsl:variable>
		<swmm:staffQueries>
			<xsl:call-template name="GetUserByID">
				<xsl:with-param name="username">
					<xsl:value-of select="$Name0"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:if test="$Name1!=''">
				<xsl:call-template name="GetUserByID">
					<xsl:with-param name="username">
						<xsl:value-of select="$Name1"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$Name2!=''">
				<xsl:call-template name="GetUserByID">
					<xsl:with-param name="username">
						<xsl:value-of select="$Name2"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</swmm:staffQueries>
	</xsl:template>
	
	<xsl:template name="GetUserByID">
		<xsl:param name="username">default</xsl:param>
		<swmm:userID>
		      	<xsl:attribute name="name">
        			<xsl:value-of select="$username"/>
      			</xsl:attribute>
		</swmm:userID>
	</xsl:template>
	<!-- End template UsersByUserID and children -->


	<!-- Begin template UsersByUserIDWithtoutNamedUsers -->
	<xsl:template name="UsersByUserIDWithoutNamedUsers">
		<xsl:variable name="Name0">
			<xsl:value-of select="staff:parameter[@id='UserID']"/>
		</xsl:variable>
		<xsl:variable name="Name1">
			<xsl:value-of select="staff:parameter[@id='AlternativeID1']"/>
		</xsl:variable>
		<xsl:variable name="Name2">
			<xsl:value-of select="staff:parameter[@id='AlternativeID2']"/>
		</xsl:variable>
		<swmm:staffQueries>
			<xsl:call-template name="GetUserByID">
				<xsl:with-param name="username">
					<xsl:value-of select="$Name0"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:if test="$Name1!=''">
				<xsl:call-template name="GetUserByID">
					<xsl:with-param name="username">
						<xsl:value-of select="$Name1"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$Name2!=''">
				<xsl:call-template name="GetUserByID">
					<xsl:with-param name="username">
						<xsl:value-of select="$Name2"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>

			<swmm:remove>
				<xsl:attribute name="value"><xsl:value-of select="staff:parameter[@id='NamedUsers']"/></xsl:attribute>
			</swmm:remove>			
			
		</swmm:staffQueries>
	</xsl:template>
	<!-- End template UsersByUserIDWithoutNamedUsers -->


	<!-- Begin template GroupMembers and children -->
	<xsl:template name="GroupMembers">
		<xsl:variable name="Group0">
			<xsl:value-of select="staff:parameter[@id='GroupName']"/>
		</xsl:variable>
		<xsl:variable name="Group1">
			<xsl:value-of select="staff:parameter[@id='AlternativeGroupName1']"/>
		</xsl:variable>
		<xsl:variable name="Group2">
			<xsl:value-of select="staff:parameter[@id='AlternativeGroupName2']"/>
		</xsl:variable>
		<swmm:staffQueries>
			<xsl:attribute name="threshold"><xsl:value-of select="$Threshold"/></xsl:attribute>
			<xsl:call-template name="GetGroupMembers">
				<xsl:with-param name="groupname">
					<xsl:value-of select="$Group0"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:if test="$Group1!=''">
				<xsl:call-template name="GetGroupMembers">
					<xsl:with-param name="groupname">
						<xsl:value-of select="$Group1"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$Group2!=''">
				<xsl:call-template name="GetGroupMembers">
					<xsl:with-param name="groupname">
						<xsl:value-of select="$Group2"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</swmm:staffQueries>
	</xsl:template>
	
	<xsl:template name="GetGroupMembers">
		<xsl:param name="groupname">default</xsl:param>
		<swmm:usersOfGroup>
			<xsl:attribute name="id"><xsl:value-of select="$DefaultGroupNameAttribute"/>=<xsl:value-of select="$groupname"/><xsl:value-of select="$DefaultGroupNameSuffix"/></xsl:attribute>
			<xsl:attribute name="idType"><xsl:value-of select="$DefaultGroupIdType"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="staff:parameter[@id='IncludeSubgroups']='false'">
					<xsl:attribute name="recursive">no</xsl:attribute>
				</xsl:when>
				<xsl:when test="staff:parameter[@id='IncludeSubgroups']='true'">
					<xsl:attribute name="recursive">yes</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:message terminate="no">WARNING: Unexpected value: '<xsl:value-of select="staff:parameter[@id='IncludeSubgroups']"/>' for IncludeSubgroups. Continue using the default value 'true'.</xsl:message>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:attribute name="attribute"><xsl:value-of select="$returnAttribute"/></xsl:attribute>
		</swmm:usersOfGroup>
	</xsl:template>
	<!-- End template GroupMembers and children -->

	<!-- Begin template group members without named users -->
	<xsl:template name="GroupMembersWithoutNamedUsers">	
		<swmm:staffQueries>				
			<swmm:usersOfGroup>
				<xsl:attribute name="id"><xsl:value-of select="$DefaultGroupNameAttribute"/>=<xsl:value-of select="staff:parameter[@id='GroupName']"/><xsl:value-of select="$DefaultGroupNameSuffix"/></xsl:attribute>
				<xsl:attribute name="idType"> <xsl:value-of select="$DefaultGroupIdType"/> </xsl:attribute>
				<xsl:choose>
					<xsl:when test="staff:parameter[@id='IncludeSubgroups']='false'">
						<xsl:attribute name="recursive">no</xsl:attribute>
					</xsl:when>
					<xsl:when test="staff:parameter[@id='IncludeSubgroups']='true'">
						<xsl:attribute name="recursive">yes</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:message terminate="no">WARNING: Unexpected value: '<xsl:value-of select="staff:parameter[@id='IncludeSubgroups']"/>' for IncludeSubgroups. Continue using the default value 'true'.</xsl:message>
					</xsl:otherwise>			
				</xsl:choose>				
				<xsl:attribute name="attribute"> <xsl:value-of select="$returnAttribute"/> </xsl:attribute>
			</swmm:usersOfGroup>	

			<swmm:remove>
				<xsl:attribute name="value"><xsl:value-of select="staff:parameter[@id='NamedUsers']"/></xsl:attribute>
			</swmm:remove>
		</swmm:staffQueries>
	</xsl:template>
	<!-- End template group members without named users -->

	<!-- Begin template group members without filtered users -->
	<xsl:template name="GroupMembersWithoutFilteredUsers">
		
		<swmm:staffQueries>
			<swmm:usersOfGroup>
				<xsl:attribute name="id"><xsl:value-of select="$DefaultGroupNameAttribute"/>=<xsl:value-of select="staff:parameter[@id='GroupName']"/><xsl:value-of select="$DefaultGroupNameSuffix"/></xsl:attribute>
				<xsl:attribute name="idType"> <xsl:value-of select="$DefaultGroupIdType"/> </xsl:attribute>
				<xsl:choose>
					<xsl:when test="staff:parameter[@id='IncludeSubgroups']='false'">
						<xsl:attribute name="recursive">no</xsl:attribute>
					</xsl:when>
					<xsl:when test="staff:parameter[@id='IncludeSubgroups']='true'">
						<xsl:attribute name="recursive">yes</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:message terminate="no">WARNING: Unexpected value: '<xsl:value-of select="staff:parameter[@id='IncludeSubgroups']"/>' for IncludeSubgroups. Continue using the default value 'true'.</xsl:message>
					</xsl:otherwise>			
				</xsl:choose>				
				<xsl:attribute name="attribute"> <xsl:value-of select="$returnAttribute"/> </xsl:attribute>
			</swmm:usersOfGroup>

			<swmm:intermediateResult>
				<xsl:attribute name="name">filteredusers</xsl:attribute>
				<swmm:search>
					<xsl:attribute name="operator">like</xsl:attribute>				
					<xsl:attribute name="searchAttribute"><xsl:value-of select="staff:parameter[@id='FilterAttribute']"/></xsl:attribute>
					<xsl:attribute name="referenceValue"><xsl:value-of select="staff:parameter[@id='FilterValue']"/></xsl:attribute>															
					<xsl:attribute name="returnAttribute"><xsl:value-of select="$returnAttribute"/></xsl:attribute>							
					<xsl:attribute name="returnType">person</xsl:attribute>
					<xsl:attribute name="referenceType">String</xsl:attribute>
				</swmm:search>
			</swmm:intermediateResult>

			<swmm:remove>
				<xsl:attribute name="value">%filteredusers%</xsl:attribute>
			</swmm:remove>
		</swmm:staffQueries>
	</xsl:template>
	<!-- End template group members without filtered users -->



	<!-- Begin template DepartmentMembers -->
	<xsl:template name="DepartmentMembers">
		<xsl:variable name="Dept0">
			<xsl:value-of select="staff:parameter[@id='DepartmentName']"/>
		</xsl:variable>
		<xsl:variable name="Dept1">
			<xsl:value-of select="staff:parameter[@id='AlternativeDepartmentName1']"/>
		</xsl:variable>
		<xsl:variable name="Dept2">
			<xsl:value-of select="staff:parameter[@id='AlternativeDepartmentName2']"/>
		</xsl:variable>
		<swmm:staffQueries>
			<xsl:attribute name="threshold"><xsl:value-of select="$Threshold"/></xsl:attribute>
			<xsl:call-template name="GetDepartmentMembers">
				<xsl:with-param name="deptname">
					<xsl:value-of select="$Dept0"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:if test="$Dept1!=''">
				<xsl:call-template name="GetDepartmentMembers">
					<xsl:with-param name="deptname">
						<xsl:value-of select="$Dept1"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$Dept2!=''">
				<xsl:call-template name="GetDepartmentMembers">
					<xsl:with-param name="deptname">
						<xsl:value-of select="$Dept2"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</swmm:staffQueries>
	</xsl:template>
	
	<xsl:template name="GetDepartmentMembers">
		<xsl:param name="deptname">default</xsl:param>
		
		<swmm:search>
			<xsl:attribute name="searchBase"><xsl:value-of select="$DefaultDepartmentNameAttribute"/>=<xsl:value-of select="$deptname"/><xsl:value-of select="$DefaultDepartmentNameSuffix"/></xsl:attribute>
			<xsl:attribute name="returnType">person</xsl:attribute>
			<xsl:attribute name="returnAttribute"><xsl:value-of select="$returnAttribute"/></xsl:attribute>
			<xsl:attribute name="searchAttribute"><xsl:value-of select="$DefaultUserSearchAttribute"/></xsl:attribute>
			<xsl:attribute name="operator">notNULL</xsl:attribute>
			<xsl:attribute name="referenceValue">dummy</xsl:attribute>
			<xsl:attribute name="referenceType">String</xsl:attribute>
		</swmm:search>
	</xsl:template>
	<!-- End template DepartmentMembers -->


	<!-- Begin template RoleMembers -->
	<xsl:template name="RoleMembers">
		<xsl:variable name="Role0">
			<xsl:value-of select="staff:parameter[@id='RoleName']"/>
		</xsl:variable>
		<xsl:variable name="Role1">
			<xsl:value-of select="staff:parameter[@id='AlternativeRoleName1']"/>
		</xsl:variable>
		<xsl:variable name="Role2">
			<xsl:value-of select="staff:parameter[@id='AlternativeRoleName2']"/>
		</xsl:variable>
		<swmm:staffQueries>
			<xsl:attribute name="threshold"><xsl:value-of select="$Threshold"/></xsl:attribute>
			<xsl:call-template name="GetRoleMembers">
				<xsl:with-param name="rolename">
					<xsl:value-of select="$Role0"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:if test="$Role1!=''">
				<xsl:call-template name="GetRoleMembers">
					<xsl:with-param name="rolename">
						<xsl:value-of select="$Role1"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$Role2!=''">
				<xsl:call-template name="GetRoleMembers">
					<xsl:with-param name="rolename">
						<xsl:value-of select="$Role2"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</swmm:staffQueries>
	</xsl:template>
	
	<xsl:template name="GetRoleMembers">
		<xsl:param name="rolename">default</xsl:param>
		<!-- alt 2 using search -->
		<swmm:search>
			<xsl:attribute name="searchBase"><xsl:value-of select="$DefaultRoleNameAttribute"/>=<xsl:value-of select="$rolename"/><xsl:value-of select="$DefaultRoleNameSuffix"/></xsl:attribute>
			<xsl:attribute name="returnType">person</xsl:attribute>
			<xsl:attribute name="returnAttribute"><xsl:value-of select="$returnAttribute"/></xsl:attribute>
			<xsl:attribute name="searchAttribute"><xsl:value-of select="$DefaultUserSearchAttribute"/></xsl:attribute>
			<xsl:attribute name="operator">notNULL</xsl:attribute>
			<xsl:attribute name="referenceValue">dummy</xsl:attribute>
			<xsl:attribute name="referenceType">String</xsl:attribute>
		</swmm:search>
	</xsl:template>
	<!-- End template RoleMembers -->


	<!-- Begin template ManagerOfEmployee -->
	<xsl:template name="ManagerOfEmployee">
		<swmm:staffQueries>
			<xsl:attribute name="threshold"><xsl:value-of select="$Threshold"/></xsl:attribute>
			<swmm:intermediateResult>
				<xsl:attribute name="name">manager</xsl:attribute>
				<swmm:user>
					<xsl:attribute name="id"><xsl:value-of select="staff:parameter[@id='EmployeeName']"/></xsl:attribute>
					<xsl:attribute name="idType"><xsl:value-of select="$DefaultUserIdType"/></xsl:attribute>
					<xsl:attribute name="attribute"><xsl:value-of select="$DefaultUserManagerAttribute"/></xsl:attribute>
				</swmm:user>
			</swmm:intermediateResult>
			<swmm:user>
				<xsl:attribute name="id">%manager%</xsl:attribute>
				<xsl:attribute name="idType">memberDN</xsl:attribute>
				<xsl:attribute name="attribute"><xsl:value-of select="$returnAttribute"/></xsl:attribute>
			</swmm:user>
		</swmm:staffQueries>
	</xsl:template>
	<!-- End template ManagerOfEmployee -->


	<!-- Begin template ManagerOfEmployeeByUserID-->
	<xsl:template name="ManagerOfEmployeeByUserID">
		<swmm:staffQueries>
			<xsl:attribute name="threshold"><xsl:value-of select="$Threshold"/></xsl:attribute>
			<swmm:intermediateResult>
				<xsl:attribute name="name">manager</xsl:attribute>
				<swmm:user>
					<xsl:attribute name="id"><xsl:value-of select="staff:parameter[@id='EmployeeUserID']"/></xsl:attribute>
					<xsl:attribute name="idType">WASUserID</xsl:attribute>
					<xsl:attribute name="attribute"><xsl:value-of select="$DefaultUserManagerAttribute"/></xsl:attribute>
				</swmm:user>
			</swmm:intermediateResult>
			<swmm:user>
				<xsl:attribute name="id">%manager%</xsl:attribute>
				<xsl:attribute name="idType">memberDN</xsl:attribute>
				<xsl:attribute name="attribute"><xsl:value-of select="$returnAttribute"/></xsl:attribute>
			</swmm:user>
		</swmm:staffQueries>
	</xsl:template>
	<!-- End template ManagerOfEmployeeByUserID-->


	<!-- Begin template PersonSearch -->
	<xsl:template name="PersonSearch">
		<xsl:variable name="searchparam">
	          	<xsl:if test="staff:parameter[@id='UserID']!=''"><xsl:value-of select="$PS_UserID"/></xsl:if>			          	
			<xsl:if test="staff:parameter[@id='Profile']!=''"><xsl:value-of select="$PS_Profile"/></xsl:if>
			<xsl:if test="staff:parameter[@id='LastName']!=''"><xsl:value-of select="$PS_LastName"/></xsl:if>          
			<xsl:if test="staff:parameter[@id='FirstName']!=''"><xsl:value-of select="$PS_FirstName"/></xsl:if>
			<xsl:if test="staff:parameter[@id='MiddleName']!=''"><xsl:value-of select="$PS_MiddleName"/></xsl:if>
			<xsl:if test="staff:parameter[@id='Email']!=''"><xsl:value-of select="$PS_Email"/></xsl:if>
			<xsl:if test="staff:parameter[@id='Company']!=''"><xsl:value-of select="$PS_Company"/></xsl:if>
			<xsl:if test="staff:parameter[@id='DisplayName']!=''"><xsl:value-of select="$PS_DisplayName"/></xsl:if>
			<xsl:if test="staff:parameter[@id='Assistant']!=''"><xsl:value-of select="$PS_Assistant"/></xsl:if>
			<xsl:if test="staff:parameter[@id='Secretary']!=''"><xsl:value-of select="$PS_Secretary"/></xsl:if>
			<xsl:if test="staff:parameter[@id='Manager']!=''"><xsl:value-of select="$PS_Manager"/></xsl:if>
			<xsl:if test="staff:parameter[@id='Department']!=''"><xsl:value-of select="$PS_Department"/></xsl:if>
			<xsl:if test="staff:parameter[@id='EmployeeID']!=''"><xsl:value-of select="$PS_EmployeeID"/></xsl:if>
			<xsl:if test="staff:parameter[@id='TaxPayerID']!=''"><xsl:value-of select="$PS_TaxPayerID"/></xsl:if>
			<xsl:if test="staff:parameter[@id='Phone']!=''"><xsl:value-of select="$PS_Phone"/></xsl:if>
			<xsl:if test="staff:parameter[@id='Fax']!=''"><xsl:value-of select="$PS_Fax"/></xsl:if>
			<xsl:if test="staff:parameter[@id='Gender']!=''"><xsl:value-of select="$PS_Gender"/></xsl:if>
			<xsl:if test="staff:parameter[@id='Timezone']!=''"><xsl:value-of select="$PS_Timezone"/></xsl:if>
			<xsl:if test="staff:parameter[@id='PreferredLanguage']!=''"><xsl:value-of select="$PS_PreferredLanguage"/></xsl:if>		
		</xsl:variable>
		<swmm:staffQueries>
			<xsl:attribute name="threshold"><xsl:value-of select="$Threshold"/></xsl:attribute>
			<swmm:search>
				<xsl:attribute name="returnType">person</xsl:attribute>
				<xsl:attribute name="returnAttribute"><xsl:value-of select="$returnAttribute"/></xsl:attribute>				
				<xsl:attribute name="searchAttribute"><xsl:value-of select="normalize-space($searchparam)"/></xsl:attribute>
				<xsl:attribute name="operator">equal</xsl:attribute>
				<xsl:attribute name="referenceValue"><xsl:value-of select="staff:parameter"/></xsl:attribute>
				<xsl:attribute name="referenceType">String</xsl:attribute>
			</swmm:search>
		</swmm:staffQueries>
	</xsl:template>
	<!-- End template PersonSearch -->
	
	
	<!-- Begin template GroupSearch -->
	<xsl:template name="GroupSearch">
		<xsl:variable name="searchparam">
			<xsl:if test="staff:parameter[@id='GroupID']!=''"><xsl:value-of select="$GS_GroupID"/></xsl:if>
          		<xsl:if test="staff:parameter[@id='Type']!=''"><xsl:value-of select="$GS_Type"/></xsl:if>
          		<xsl:if test="staff:parameter[@id='IndustryType']!=''"><xsl:value-of select="$GS_IndustryType"/></xsl:if>
          		<xsl:if test="staff:parameter[@id='BusinessType']!=''"><xsl:value-of select="$GS_BusinessType"/></xsl:if>
          		<xsl:if test="staff:parameter[@id='GeographicLocation']!=''"><xsl:value-of select="$GS_GeographicLocation"/></xsl:if>
          		<xsl:if test="staff:parameter[@id='Affiliates']!=''"><xsl:value-of select="$GS_Affiliates"/></xsl:if>
          		<xsl:if test="staff:parameter[@id='DisplayName']!=''"><xsl:value-of select="$GS_DisplayName"/></xsl:if>
          		<xsl:if test="staff:parameter[@id='Secretary']!=''"><xsl:value-of select="$GS_Secretary"/></xsl:if>
          		<xsl:if test="staff:parameter[@id='Assistant']!=''"><xsl:value-of select="$GS_Assistant"/></xsl:if>
          		<xsl:if test="staff:parameter[@id='Manager']!=''"><xsl:value-of select="$GS_Manager"/></xsl:if>
          		<xsl:if test="staff:parameter[@id='BusinessCategory']!=''"><xsl:value-of select="$GS_BusinessCategory"/></xsl:if>
          		<xsl:if test="staff:parameter[@id='ParentCompany']!=''"><xsl:value-of select="$GS_ParentCompany"/></xsl:if>
		</xsl:variable>
	
		<swmm:staffQueries>
			<xsl:attribute name="threshold"><xsl:value-of select="$Threshold"/></xsl:attribute>
			<swmm:intermediateResult>
				<xsl:attribute name="name">groupname</xsl:attribute>
				<swmm:search>
					<xsl:attribute name="returnType">group</xsl:attribute>
					<xsl:attribute name="returnAttribute"><xsl:value-of select="$DefaultGroupNameAttribute"/></xsl:attribute>					
					<xsl:attribute name="searchAttribute"><xsl:value-of select="normalize-space($searchparam)"/></xsl:attribute>
					<xsl:attribute name="operator">equal</xsl:attribute>
					<xsl:attribute name="referenceValue"><xsl:value-of select="normalize-space(staff:parameter)"/></xsl:attribute>
					<xsl:attribute name="referenceType">String</xsl:attribute>
				</swmm:search>
			</swmm:intermediateResult>
			<swmm:usersOfGroup>
				<xsl:attribute name="id"><xsl:value-of select="$DefaultGroupNameAttribute"/>=%groupname%<xsl:value-of select="$DefaultGroupNameSuffix"/></xsl:attribute>
				<xsl:attribute name="idType"><xsl:value-of select="$DefaultGroupIdType"/></xsl:attribute>
				<xsl:attribute name="recursive">yes</xsl:attribute>
				<xsl:attribute name="attribute"><xsl:value-of select="$returnAttribute"/></xsl:attribute>
			</swmm:usersOfGroup>
		</swmm:staffQueries>
	</xsl:template>
	<!-- End template GroupSearch -->
	
	
	<!-- Begin template NativeQuery -->
	<xsl:template name="NativeQuery">
	
		<swmm:staffQueries>

			<xsl:attribute name="threshold"><xsl:value-of select="$Threshold"/></xsl:attribute>
	
	      		<!-- Allow multiple Native Query templates-->
      			<xsl:choose>
        	
	        		<!-- Template 'search' -->
	        		<xsl:when test="staff:parameter[@id='QueryTemplate']='search'">
	        			
	        			<xsl:choose>
	        				<xsl:when test="staff:parameter[@id='AdditionalParameter4']='person'">
							<swmm:search>
								<xsl:attribute name="referenceValue"><xsl:value-of select="staff:parameter[@id='Query']"/></xsl:attribute>
								<xsl:attribute name="operator"><xsl:value-of select="staff:parameter[@id='AdditionalParameter1']"/></xsl:attribute>
								<xsl:attribute name="searchAttribute"><xsl:value-of select="staff:parameter[@id='AdditionalParameter2']"/></xsl:attribute>
								<xsl:attribute name="returnAttribute"><xsl:value-of select="staff:parameter[@id='AdditionalParameter3']"/></xsl:attribute>
								<xsl:attribute name="returnType"><xsl:value-of select="staff:parameter[@id='AdditionalParameter4']"/></xsl:attribute>
								
								<xsl:if test="staff:parameter[@id='AdditionalParameter5']!=''">
									<xsl:attribute name="searchBase">
										<xsl:value-of select="staff:parameter[@id='AdditionalParameter5']"/>
									</xsl:attribute>
								</xsl:if>								
		
								<xsl:attribute name="referenceType">String</xsl:attribute>
							</swmm:search>
						</xsl:when>
						
	        				<xsl:when test="staff:parameter[@id='AdditionalParameter4']='group'">
							<swmm:intermediateResult>
								<xsl:attribute name="name">groupDN</xsl:attribute>	        					        				
								<swmm:search>
									<xsl:attribute name="referenceValue"><xsl:value-of select="staff:parameter[@id='Query']"/></xsl:attribute>
									<xsl:attribute name="operator"><xsl:value-of select="staff:parameter[@id='AdditionalParameter1']"/></xsl:attribute>
									<xsl:attribute name="searchAttribute"><xsl:value-of select="staff:parameter[@id='AdditionalParameter2']"/></xsl:attribute>
									<xsl:attribute name="returnAttribute">_DN</xsl:attribute>
									<xsl:attribute name="returnType"><xsl:value-of select="staff:parameter[@id='AdditionalParameter4']"/></xsl:attribute>
									
									<xsl:if test="staff:parameter[@id='AdditionalParameter5']!=''">
										<xsl:attribute name="searchBase">
											<xsl:value-of select="staff:parameter[@id='AdditionalParameter5']"/>
										</xsl:attribute>
									</xsl:if>								
			
									<xsl:attribute name="referenceType">String</xsl:attribute>
								</swmm:search>
							</swmm:intermediateResult>

							<swmm:usersOfGroup>
								<xsl:attribute name="id">%groupDN%</xsl:attribute>
								<xsl:attribute name="idType">memberDN</xsl:attribute>
								<xsl:attribute name="recursive">no</xsl:attribute>
								<xsl:attribute name="attribute"><xsl:value-of select="staff:parameter[@id='AdditionalParameter3']"/></xsl:attribute>
							</swmm:usersOfGroup>																						
						</xsl:when>

	        				<xsl:when test="staff:parameter[@id='AdditionalParameter4']='groupRecursive'">

							<swmm:intermediateResult>
								<xsl:attribute name="name">groupDN</xsl:attribute>	        					        				
								<swmm:search>
									<xsl:attribute name="referenceValue"><xsl:value-of select="staff:parameter[@id='Query']"/></xsl:attribute>
									<xsl:attribute name="operator"><xsl:value-of select="staff:parameter[@id='AdditionalParameter1']"/></xsl:attribute>
									<xsl:attribute name="searchAttribute"><xsl:value-of select="staff:parameter[@id='AdditionalParameter2']"/></xsl:attribute>
									<xsl:attribute name="returnAttribute">_DN</xsl:attribute>
									<xsl:attribute name="returnType">group</xsl:attribute>
									<xsl:attribute name="referenceType">String</xsl:attribute>
								</swmm:search>
							</swmm:intermediateResult>
		
							<swmm:usersOfGroup>
								<xsl:attribute name="id">%groupDN%</xsl:attribute>
								<xsl:attribute name="idType">memberDN</xsl:attribute>
								<xsl:attribute name="recursive">yes</xsl:attribute>
								<xsl:attribute name="attribute"><xsl:value-of select="staff:parameter[@id='AdditionalParameter3']"/></xsl:attribute>
							</swmm:usersOfGroup>		

						</xsl:when>	

						<xsl:otherwise>
			          			<xsl:message terminate="no">ERROR: Native query template 'search' is only supported by the WMM XSL transformation with return types: person, group, groupRecursive. Set one of these as AdditionalParameter4.</xsl:message>
			        		</xsl:otherwise>	

					</xsl:choose>
						
				</xsl:when>			

				<!-- Template 'user' -->
				<xsl:when test="staff:parameter[@id='QueryTemplate']='user'">							
					<swmm:search>
						<xsl:attribute name="referenceValue"><xsl:value-of select="staff:parameter[@id='Query']"/></xsl:attribute>
						<xsl:attribute name="operator"><xsl:value-of select="staff:parameter[@id='AdditionalParameter1']"/></xsl:attribute>
						<xsl:attribute name="searchAttribute"><xsl:value-of select="staff:parameter[@id='AdditionalParameter2']"/></xsl:attribute>
						<xsl:attribute name="returnAttribute"><xsl:value-of select="staff:parameter[@id='AdditionalParameter3']"/></xsl:attribute>							
						<xsl:attribute name="returnType">person</xsl:attribute>
						<xsl:attribute name="referenceType">String</xsl:attribute>
					</swmm:search>
				</xsl:when>
					
				<!-- Template 'usersOfGroup' -->			
				<xsl:when test="staff:parameter[@id='QueryTemplate']='usersOfGroup'">
					<swmm:intermediateResult>
						<xsl:attribute name="name">groupDN</xsl:attribute>	        					        				
						<swmm:search>
							<xsl:attribute name="referenceValue"><xsl:value-of select="staff:parameter[@id='Query']"/></xsl:attribute>
							<xsl:attribute name="operator"><xsl:value-of select="staff:parameter[@id='AdditionalParameter1']"/></xsl:attribute>
							<xsl:attribute name="searchAttribute"><xsl:value-of select="staff:parameter[@id='AdditionalParameter2']"/></xsl:attribute>
							<xsl:attribute name="returnAttribute">_DN</xsl:attribute>
							<xsl:attribute name="returnType">group</xsl:attribute>
							<xsl:attribute name="referenceType">String</xsl:attribute>
						</swmm:search>
					</swmm:intermediateResult>

					<swmm:usersOfGroup>
						<xsl:attribute name="id">%groupDN%</xsl:attribute>
						<xsl:attribute name="idType">memberDN</xsl:attribute>
						<xsl:attribute name="recursive">no</xsl:attribute>
						<xsl:attribute name="attribute"><xsl:value-of select="staff:parameter[@id='AdditionalParameter3']"/></xsl:attribute>
					</swmm:usersOfGroup>		
				</xsl:when>						

				<xsl:otherwise>
	          			<xsl:message terminate="no">ERROR: Native query template '<xsl:value-of select="staff:parameter[@id='QueryTemplate']"/>' is not supported by the WMM XSL transformation. Supported values are: 'search','user','usersOfGroup'.</xsl:message>
	        		</xsl:otherwise>			
			
			</xsl:choose>
		
		</swmm:staffQueries>
						
	</xsl:template>
	<!-- End template NativeQuery -->
	
	
	<!-- Begin template Everybody -->
	<xsl:template name="Everybody">
		<swmm:staffQueries>
			<swmm:everybody/>
		</swmm:staffQueries>
	</xsl:template>
	<!-- End template Everybody -->
	
	
	<!-- Begin template Nobody -->
	<xsl:template name="Nobody">
		<swmm:staffQueries>
			<swmm:nobody/>
		</swmm:staffQueries>
	</xsl:template>
	<!-- End template Nobody -->
	
	<!-- Begin template Group -->
  	<xsl:template name="Group">
    		<xsl:variable name="GroupID">
      			<xsl:value-of select="staff:parameter[@id='GroupID']"/>
    		</xsl:variable>

    		<swmm:staffQueries>
      			<swmm:groupID>
        			<xsl:attribute name="name">
          				<xsl:value-of select="$GroupID"/>
        			</xsl:attribute>
      			</swmm:groupID>
    		</swmm:staffQueries>
  	</xsl:template>
	<!-- End template Group -->	

	<!-- Begin template EmailForUsersByUserID -->
  	<xsl:template name="EmailForUsersByUserID">
  		<swmm:staffQueries>
			<xsl:attribute name="threshold"><xsl:value-of select="$Threshold"/></xsl:attribute>	
			<xsl:variable name="Name0">
				<xsl:value-of select="staff:parameter[@id='UserID']"/>
			</xsl:variable>
			<xsl:variable name="Name1">
				<xsl:value-of select="staff:parameter[@id='AlternativeID1']"/>
			</xsl:variable>
			<xsl:variable name="Name2">
				<xsl:value-of select="staff:parameter[@id='AlternativeID2']"/>
			</xsl:variable>

			<xsl:call-template name="GetUserEmailByID">
				<xsl:with-param name="username">
					<xsl:value-of select="$Name0"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:if test="$Name1!=''">
				<xsl:call-template name="GetUserEmailByID">
					<xsl:with-param name="username">
						<xsl:value-of select="$Name1"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$Name2!=''">
				<xsl:call-template name="GetUserEmailByID">
					<xsl:with-param name="username">
						<xsl:value-of select="$Name2"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</swmm:staffQueries>
	</xsl:template>

	<xsl:template name="GetUserEmailByID">
		<xsl:param name="username">default</xsl:param>		
		<swmm:search>
			<xsl:attribute name="returnType">person</xsl:attribute>
			<xsl:attribute name="returnAttribute"><xsl:value-of select="$DefaultMailAttribute"/></xsl:attribute>
			<xsl:attribute name="searchAttribute"><xsl:value-of select="$DefaultUserSearchAttribute"/></xsl:attribute>
			<xsl:attribute name="operator">notNULL</xsl:attribute>
			<xsl:attribute name="referenceValue"><xsl:value-of select="$username"/></xsl:attribute>
			<xsl:attribute name="referenceType">String</xsl:attribute>
		</swmm:search>
		
	</xsl:template>
	<!-- End template EmailForUsersByUserID -->

	
</xsl:transform>
