/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ResourceBundle;
import symantec.itools.awt.ImagePanel;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.resources.ErrorsBundle;
import symantec.itools.util.GeneralUtils;
import symantec.itools.util.Timer;

public class InfoTipPanel
extends ImagePanel
implements Runnable,
Serializable {
    public static final int RIGHT_OF_COMPONENT = 0;
    public static final int LEFT_OF_COMPONENT = 1;
    public static final int ABOVE_COMPONENT = 2;
    public static final int BELOW_COMPONENT = 3;
    transient int scrollState = 3;
    int textLocation;
    static final int PIXEL_BUFFER = 10;
    static final int DX_PER_FRAME = 25;
    static final int DY_PER_FRAME = 17;
    static final int TIME_BETWEEN_FRAMES = 50;
    protected transient Thread textAnimationThread;
    protected transient Image offScreenImage;
    protected transient Image bufferedBgndImage;
    protected transient boolean callingAddInternally = false;
    protected transient boolean dontDrawText = false;
    protected transient int textWidth;
    protected transient int textHeight;
    protected transient int textAscent;
    protected transient int textDescent;
    protected Component myComponent;
    protected String text;
    protected boolean textScrollsIn = true;
    protected int textDelay;
    protected boolean highlightText = false;
    protected Color textColor;
    protected Color textHighlightColor;
    protected Timer delayTimer;
    protected Mouse myMouseListener;
    protected int extraHighlightWidth;
    protected int extraHighlightHeight;
    protected static final int SCROLLING_IN = 0;
    protected static final int DONE_SCROLLING_IN = 1;
    protected static final int SCROLLING_OUT = 2;
    protected static final int DONE_SCROLLING_OUT = 3;
    protected static final int WAITING_TO_SCROLL_IN = 4;
    protected transient ResourceBundle errors;
    private LocationVeto locationVeto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public InfoTipPanel() {
        this(null, "", 0, true, 0, false);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("symantec.itools.awt.InfoTipPanelBundle");
        this.setLayout(null);
        this.setSize(20, 40);
    }

    public InfoTipPanel(Component component, String text, int textLocation, boolean textScrollsIn, int textDelay, boolean highlightText) {
        this.myMouseListener = new Mouse();
        this.delayTimer = new Timer();
        if (this.delayTimer != null) {
            this.delayTimer.addActionListener(new Action());
        }
        super.setLayout(null);
        try {
            this.setHighlightText(highlightText);
            this.setTextHighlightColor(new Color(0xFFFF00));
            this.setTextColor(new Color(0));
            this.setTextScrollsIn(textScrollsIn);
            this.setTextDelay(textDelay);
            this.setText(text);
            this.setTextLocation(textLocation);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.setComponent(component);
    }

    public void setTextDelay(int newDelay) throws PropertyVetoException {
        if (this.textDelay != newDelay) {
            Integer oldTextDelay = new Integer(this.textDelay);
            Integer newTextDelay = new Integer(newDelay);
            this.vetos.fireVetoableChange("textDelay", oldTextDelay, newTextDelay);
            this.textDelay = newDelay;
            this.delayTimer.setDelay(this.textDelay);
            this.changes.firePropertyChange("textDelay", oldTextDelay, newTextDelay);
        }
    }

    public int getTextDelay() {
        return this.textDelay;
    }

    public void setTextScrollsIn(boolean newScroll) throws PropertyVetoException {
        if (this.textScrollsIn != newScroll) {
            Boolean oldTextScrollsIn = new Boolean(this.textScrollsIn);
            Boolean newTextScrollsIn = new Boolean(newScroll);
            this.vetos.fireVetoableChange("textScrollsIn", oldTextScrollsIn, newTextScrollsIn);
            this.stopScrolling();
            this.textScrollsIn = newScroll;
            this.changes.firePropertyChange("textScrollsIn", oldTextScrollsIn, newTextScrollsIn);
        }
    }

    public boolean getTextScrollsIn() {
        return this.textScrollsIn;
    }

    public void setTextLocation(int newLocation) throws PropertyVetoException {
        if (this.textLocation != newLocation) {
            Integer oldTextLocation = new Integer(this.textLocation);
            Integer newTextLocation = new Integer(newLocation);
            this.vetos.fireVetoableChange("textLocation", oldTextLocation, newTextLocation);
            this.stopScrolling();
            this.textLocation = newLocation;
            this.createOffScreenBuffers();
            this.repaint();
            this.changes.firePropertyChange("textLocation", oldTextLocation, newTextLocation);
        }
    }

    public int getTextLocation() {
        return this.textLocation;
    }

    public void setText(String newText) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.text, newText)) {
            String oldText = this.text;
            this.vetos.fireVetoableChange("text", oldText, newText);
            this.stopScrolling();
            this.text = newText;
            this.calculateTextAttributes();
            this.changes.firePropertyChange("text", oldText, newText);
        }
    }

    public String getText() {
        return new String(this.text);
    }

    public void setTextColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.textColor, color)) {
            Color oldValue = this.textColor;
            this.vetos.fireVetoableChange("textColor", oldValue, color);
            if (this.textAnimationThread != null) {
                this.textAnimationThread.suspend();
            }
            this.textColor = color;
            this.repaint();
            if (this.textAnimationThread != null) {
                this.textAnimationThread.resume();
            }
            this.changes.firePropertyChange("textColor", oldValue, color);
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextHighlightColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.textHighlightColor, color)) {
            Color oldValue = this.textHighlightColor;
            this.vetos.fireVetoableChange("textHighlightColor", oldValue, color);
            if (this.textAnimationThread != null) {
                this.textAnimationThread.suspend();
            }
            this.textHighlightColor = color;
            if (this.highlightText) {
                this.repaint();
            }
            if (this.textAnimationThread != null) {
                this.textAnimationThread.resume();
            }
            this.changes.firePropertyChange("textHighlightColor", oldValue, color);
        }
    }

    public Color getTextHighlightColor() {
        return this.textHighlightColor;
    }

    public void setHighlightText(boolean newValue) throws PropertyVetoException {
        if (this.highlightText != newValue) {
            this.stopScrolling();
            Boolean oldHighlightText = new Boolean(this.highlightText);
            Boolean newHighlightText = new Boolean(newValue);
            this.vetos.fireVetoableChange("highlightText", oldHighlightText, newHighlightText);
            this.highlightText = newValue;
            this.extraHighlightWidth = this.highlightText ? 6 : 0;
            this.extraHighlightHeight = this.highlightText ? 4 : 0;
            this.changes.firePropertyChange("highlightText", oldHighlightText, newHighlightText);
        }
    }

    public boolean getHighlightText() {
        return this.highlightText;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.stopScrolling();
        super.setBounds(x, y, width, height);
        this.createOffScreenBuffers();
    }

    public void setImageURL(URL url) throws PropertyVetoException {
        if (this.textAnimationThread != null) {
            this.textAnimationThread.suspend();
        }
        super.setImageURL(url);
        this.storeBackground();
        if (this.textAnimationThread != null) {
            this.textAnimationThread.resume();
        }
    }

    public void setStyle(int newStyle) throws PropertyVetoException {
        if (this.textAnimationThread != null) {
            this.textAnimationThread.suspend();
        }
        super.setStyle(newStyle);
        this.storeBackground();
        if (this.textAnimationThread != null) {
            this.textAnimationThread.resume();
        }
    }

    public void setComponent(Component comp) {
        block3: {
            this.removeAll();
            this.myComponent = comp;
            this.callingAddInternally = true;
            try {
                if (comp == null) break block3;
                super.add(this.myComponent);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.callingAddInternally = false;
                throw throwable;
            }
        }
        Object var3_2 = null;
        this.callingAddInternally = false;
        this.createOffScreenBuffers();
        if (this.myComponent != null) {
            this.myComponent.addMouseListener(this.myMouseListener);
        }
    }

    public Component getComponent() {
        return this.myComponent;
    }

    public synchronized void setFont(Font f) {
        this.stopScrolling();
        super.setFont(f);
        this.calculateTextAttributes();
        this.createOffScreenBuffers();
    }

    public Dimension getPreferredSize() {
        int preferredWidth = Math.max(this.getSize().width, this.myComponent == null ? 0 : this.myComponent.getSize().width);
        int preferredHeight = Math.max(this.getSize().height, this.myComponent == null ? 0 : this.myComponent.getSize().height);
        return new Dimension(preferredWidth, preferredHeight);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setLayout(LayoutManager mgr) {
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (!this.dontDrawText && this.scrollState == 1) {
            Point textPosition = this.getTextFinishingPoint();
            this.drawText(g, textPosition.x, textPosition.y);
        }
    }

    public synchronized void addNotify() {
        super.addNotify();
        try {
            this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        }
        catch (Throwable throwable) {
            this.errors = new ErrorsBundle();
        }
        this.calculateTextAttributes();
        this.createOffScreenBuffers();
        this.locationVeto = new LocationVeto();
        this.addTextLocationListener(this.locationVeto);
    }

    public synchronized void removeNotify() {
        this.stopScrolling();
        if (this.offScreenImage != null) {
            this.offScreenImage.flush();
            this.offScreenImage = null;
        }
        if (this.bufferedBgndImage != null) {
            this.bufferedBgndImage.flush();
            this.bufferedBgndImage = null;
        }
        this.removeTextLocationListener(this.locationVeto);
        this.locationVeto = null;
        super.removeNotify();
    }

    public void run() {
        if (this.text != null && this.validateOffScreenBuffers()) {
            switch (this.scrollState) {
                case 2: {
                    if (this.textScrollsIn) {
                        this.scrollText();
                        break;
                    }
                    this.popDownText();
                    break;
                }
                case 0: {
                    if (this.textScrollsIn) {
                        this.scrollText();
                        break;
                    }
                    this.popUpText();
                    break;
                }
            }
        }
        this.textAnimationThread = null;
    }

    public synchronized void remove(Component comp) {
        this.stopScrolling();
        super.remove(comp);
        if (comp == this.myComponent) {
            this.myComponent.removeMouseListener(this.myMouseListener);
            this.myComponent = null;
        }
    }

    public synchronized void removeAll() {
        this.stopScrolling();
        if (this.myComponent != null) {
            super.remove(this.myComponent);
        }
        this.myComponent = null;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetos.removeVetoableChangeListener(listener);
    }

    public synchronized void addTextLocationListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("textLocation", listener);
    }

    public synchronized void removeTextLocationListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("textLocation", listener);
    }

    public synchronized void addTextLocationListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("textLocation", listener);
    }

    public synchronized void removeTextLocationListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("textLocation", listener);
    }

    protected boolean isValidTextLocation(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    protected void drawText(Graphics g, int x, int y) {
        Color savedColor = g.getColor();
        if (this.highlightText) {
            g.setColor(this.textHighlightColor);
            Rectangle highlightBounds = this.getHighlightBounds(x, y);
            if (highlightBounds != null) {
                g.fillRect(highlightBounds.x, highlightBounds.y, highlightBounds.width, highlightBounds.height);
            }
            g.setColor(this.textColor);
            g.drawRect(highlightBounds.x, highlightBounds.y, highlightBounds.width - 1, highlightBounds.height - 1);
        }
        g.setColor(this.textColor);
        g.drawString(this.text, x, y);
        g.setColor(savedColor);
    }

    protected Rectangle getHighlightBounds(int textX, int textY) {
        if (this.textWidth > 0 && this.textHeight > 0) {
            return new Rectangle(textX - this.extraHighlightWidth / 2, textY - this.textAscent - this.extraHighlightHeight / 2, this.textWidth + this.extraHighlightWidth, this.textHeight + this.extraHighlightHeight);
        }
        return null;
    }

    protected void startScrolling(int newScrollState, boolean ignoreDelay) {
        this.delayTimer.stop();
        if (this.scrollState == 3 && newScrollState == 0 || this.scrollState == 4 && newScrollState == 0) {
            if (ignoreDelay || this.textDelay == 0) {
                this.scrollState = newScrollState;
                this.textAnimationThread = new Thread(this);
                this.textAnimationThread.start();
            } else {
                this.scrollState = 4;
                this.delayTimer.start();
            }
        } else if (this.scrollState == 1 && newScrollState == 2) {
            this.scrollState = newScrollState;
            this.textAnimationThread = new Thread(this);
            this.textAnimationThread.start();
        } else {
            this.scrollState = this.scrollState == 4 && newScrollState == 2 ? 3 : newScrollState;
        }
    }

    protected void stopScrolling() {
        this.delayTimer.stop();
        if (this.scrollState != 1) {
            this.scrollState = 3;
        }
        if (this.textAnimationThread != null) {
            this.textAnimationThread.stop();
            this.textAnimationThread = null;
            this.repaint();
        }
    }

    protected void popUpText() {
        this.drawNextFrame(this.getTextFinishingPoint());
    }

    protected void popDownText() {
        Rectangle bufferedBgndImageBounds;
        Graphics g = this.getGraphics();
        if (g != null && (bufferedBgndImageBounds = this.getBufferedBackgroundBounds()) != null) {
            g.drawImage(this.bufferedBgndImage, bufferedBgndImageBounds.x, bufferedBgndImageBounds.y, this);
            this.scrollState = 3;
        }
    }

    protected void scrollText() {
        Point currentTextLocation = this.scrollState == 0 ? this.getTextStartingPoint() : this.getTextFinishingPoint();
        while (this.scrollState != 1 && this.scrollState != 3) {
            currentTextLocation = this.scrollOneDirection(currentTextLocation);
        }
    }

    protected boolean validateOffScreenBuffers() {
        if (this.offScreenImage == null || this.bufferedBgndImage == null) {
            this.createOffScreenBuffers();
        } else {
            Rectangle correctBounds = this.getBufferedBackgroundBounds();
            if (correctBounds != null && (this.offScreenImage.getWidth(this) != correctBounds.width || this.offScreenImage.getHeight(this) != correctBounds.height)) {
                this.createOffScreenBuffers();
            }
        }
        return this.offScreenImage != null && this.bufferedBgndImage != null;
    }

    protected void storeBackground() {
        if (this.bufferedBgndImage != null) {
            Graphics buffer = this.bufferedBgndImage.getGraphics();
            Rectangle bufferBounds = this.getBufferedBackgroundBounds();
            if (buffer != null && bufferBounds != null) {
                buffer.translate(-bufferBounds.x, -bufferBounds.y);
                this.dontDrawText = true;
                try {
                    this.paint(buffer);
                }
                finally {
                    Object var4_3 = null;
                    this.dontDrawText = false;
                }
                buffer.translate(bufferBounds.x, bufferBounds.y);
            }
        }
    }

    protected Point scrollOneDirection(Point startingPoint) {
        Point currentPoint = startingPoint;
        int currentDirection = this.scrollState;
        while (this.scrollState == currentDirection) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            this.drawNextFrame(currentPoint);
        }
        return currentPoint;
    }

    protected void drawNextFrame(Point startingPoint) {
        Graphics g = this.getGraphics();
        if (g != null) {
            Graphics offScreenGraphics = this.offScreenImage.getGraphics();
            Rectangle bufferedBgndImageBounds = this.getBufferedBackgroundBounds();
            if (bufferedBgndImageBounds != null) {
                offScreenGraphics.drawImage(this.bufferedBgndImage, 0, 0, this);
                startingPoint.x += this.calculateDX(startingPoint);
                startingPoint.y += this.calculateDY(startingPoint);
                this.drawText(offScreenGraphics, startingPoint.x - bufferedBgndImageBounds.x, startingPoint.y - bufferedBgndImageBounds.y);
                g.drawImage(this.offScreenImage, bufferedBgndImageBounds.x, bufferedBgndImageBounds.y, this);
                this.updateDirection(startingPoint);
            }
        }
    }

    protected int calculateDX(Point startingPoint) {
        int dx = 0;
        Point destination = new Point();
        if (this.textLocation == 2 || this.textLocation == 3) {
            return 0;
        }
        switch (this.scrollState) {
            case 0: {
                destination = this.getTextFinishingPoint();
                if (this.atOrBeyondPoint(startingPoint, destination, 25)) {
                    dx = -(startingPoint.x - destination.x);
                    break;
                }
                dx = this.textLocation == 1 ? 25 : -25;
                break;
            }
            case 2: {
                destination = this.getTextStartingPoint();
                if (this.atOrBeyondPoint(startingPoint, destination, 25)) {
                    dx = destination.x - startingPoint.x;
                    break;
                }
                dx = this.textLocation == 1 ? -25 : 25;
                break;
            }
            case 1: 
            case 3: {
                dx = 0;
                break;
            }
        }
        return dx;
    }

    protected int calculateDY(Point startingPoint) {
        int dy = 0;
        if (this.textLocation == 0 || this.textLocation == 1) {
            return 0;
        }
        switch (this.scrollState) {
            case 0: {
                Point destination = this.getTextFinishingPoint();
                if (this.atOrBeyondPoint(startingPoint, destination, 17)) {
                    dy = -(startingPoint.y - destination.y);
                    break;
                }
                dy = this.textLocation == 3 ? -17 : 17;
                break;
            }
            case 2: {
                Point destination = this.getTextStartingPoint();
                if (this.atOrBeyondPoint(startingPoint, destination, 17)) {
                    dy = destination.y - startingPoint.y;
                    break;
                }
                dy = this.textLocation == 3 ? 17 : -17;
                break;
            }
            case 1: 
            case 3: {
                dy = 0;
                break;
            }
        }
        return dy;
    }

    protected void updateDirection(Point currentPoint) {
        switch (this.scrollState) {
            case 0: {
                if (!this.atOrBeyondPoint(currentPoint, this.getTextFinishingPoint(), 0)) break;
                this.scrollState = 1;
                break;
            }
            case 2: {
                if (!this.atOrBeyondPoint(currentPoint, this.getTextStartingPoint(), 0)) break;
                this.scrollState = 3;
                break;
            }
        }
    }

    protected boolean atOrBeyondPoint(Point currentLocation, Point point, int allowance) {
        if (currentLocation == null || point == null) {
            return false;
        }
        switch (this.textLocation) {
            case 0: {
                switch (this.scrollState) {
                    case 0: {
                        return currentLocation.x <= point.x + allowance;
                    }
                    case 2: {
                        return currentLocation.x >= point.x - allowance;
                    }
                }
            }
            case 1: {
                switch (this.scrollState) {
                    case 0: {
                        return currentLocation.x >= point.x - allowance;
                    }
                    case 2: {
                        return currentLocation.x <= point.x + allowance;
                    }
                }
            }
            case 2: {
                switch (this.scrollState) {
                    case 0: {
                        return currentLocation.y >= point.y - allowance;
                    }
                    case 2: {
                        return currentLocation.y <= point.y + allowance;
                    }
                }
            }
            case 3: {
                switch (this.scrollState) {
                    case 0: {
                        return currentLocation.y <= point.y + allowance;
                    }
                    case 2: {
                        return currentLocation.y >= point.y - allowance;
                    }
                }
            }
        }
        return false;
    }

    protected int getTextConstantYPos() {
        return this.myComponent.getLocation().y + (this.myComponent.getSize().height + this.textAscent) / 2;
    }

    protected int getTextConstantXPos() {
        return this.myComponent.getLocation().x + (this.myComponent.getSize().width - this.textWidth) / 2;
    }

    protected void calculateTextAttributes() {
        FontMetrics fm;
        if (this.text == null) {
            return;
        }
        Graphics g = this.getGraphics();
        if (g != null && (fm = g.getFontMetrics()) != null) {
            this.textAscent = fm.getAscent();
            this.textDescent = fm.getDescent();
            this.textHeight = this.textAscent + this.textDescent;
            this.textWidth = fm.stringWidth(this.text);
        }
    }

    protected Rectangle getBufferedBackgroundBounds() {
        if (this.myComponent != null) {
            if (this.textScrollsIn) {
                return this.getAreaAffectedByScroll();
            }
            return this.getAreaAffectedByPopup();
        }
        return null;
    }

    protected Rectangle getAreaAffectedByScroll() {
        int leftMostX = this.getBufferedBackgroundLeftMostX();
        int rightMostX = this.getBufferedBackgroundRightMostX();
        int topMostY = this.getBufferedBackgroundTopMostY();
        int bottomMostY = this.getBufferedBackgroundBottomMostY();
        if (rightMostX > leftMostX && topMostY < bottomMostY) {
            return new Rectangle(leftMostX - 1, topMostY - 1, rightMostX - leftMostX + 1, bottomMostY - topMostY + 1);
        }
        return null;
    }

    protected Rectangle getAreaAffectedByPopup() {
        int rightMostX = this.textLocation == 0 ? Math.min(this.getSize().width, this.getTextFinishingPoint().x + this.textWidth + (this.highlightText ? this.extraHighlightWidth / 2 : 0)) : this.getBufferedBackgroundRightMostX();
        int leftMostX = this.textLocation == 1 ? Math.max(0, this.getTextFinishingPoint().x - (this.highlightText ? this.extraHighlightWidth / 2 : 0)) : this.getBufferedBackgroundLeftMostX();
        int topMostY = this.textLocation == 2 ? Math.max(0, this.getTextFinishingPoint().y - this.textAscent - (this.highlightText ? this.extraHighlightHeight / 2 : 0)) : this.getBufferedBackgroundTopMostY();
        int bottomMostY = this.textLocation == 3 ? Math.min(this.getSize().height, this.getTextFinishingPoint().y + this.textDescent + (this.highlightText ? this.extraHighlightHeight / 2 : 0)) : this.getBufferedBackgroundBottomMostY();
        if (rightMostX > leftMostX && topMostY < bottomMostY) {
            return new Rectangle(leftMostX - 1, topMostY - 1, rightMostX - leftMostX + 1, bottomMostY - topMostY + 1);
        }
        return null;
    }

    protected int getBufferedBackgroundTopMostY() {
        int topMostY = 0;
        switch (this.textLocation) {
            case 0: 
            case 1: {
                topMostY = this.getTextConstantYPos() - this.textAscent - (this.highlightText ? this.extraHighlightHeight / 2 : 0);
                break;
            }
            case 2: {
                topMostY = 0;
                break;
            }
            case 3: {
                topMostY = this.myComponent.getLocation().y + this.myComponent.getSize().height + 10 - (this.highlightText ? this.extraHighlightHeight / 2 : 0);
                break;
            }
        }
        return topMostY;
    }

    protected int getBufferedBackgroundBottomMostY() {
        int bottomMostY = 0;
        switch (this.textLocation) {
            case 0: 
            case 1: {
                bottomMostY = this.getTextConstantYPos() + this.textDescent + (this.highlightText ? this.extraHighlightHeight / 2 : 0);
                break;
            }
            case 2: {
                bottomMostY = this.myComponent.getLocation().y - 10 + this.textDescent + (this.highlightText ? this.extraHighlightHeight / 2 : 0);
                break;
            }
            case 3: {
                bottomMostY = this.getSize().height;
                break;
            }
        }
        return bottomMostY;
    }

    protected int getBufferedBackgroundLeftMostX() {
        int xPos = 0;
        switch (this.textLocation) {
            case 0: {
                xPos = this.getTextFinishingPoint().x - (this.highlightText ? this.extraHighlightWidth / 2 : 0);
                break;
            }
            case 1: {
                xPos = 0;
                break;
            }
            case 2: 
            case 3: {
                xPos = this.getTextConstantXPos() - (this.highlightText ? this.extraHighlightWidth / 2 : 0);
                break;
            }
        }
        return xPos;
    }

    protected int getBufferedBackgroundRightMostX() {
        int xPos = 0;
        switch (this.textLocation) {
            case 0: {
                xPos = this.getSize().width;
                break;
            }
            case 1: {
                xPos = this.myComponent.getLocation().x - 10 + (this.highlightText ? this.extraHighlightWidth / 2 : 0);
                break;
            }
            case 2: 
            case 3: {
                xPos = this.getTextConstantXPos() + this.textWidth + (this.highlightText ? this.extraHighlightWidth / 2 : 0);
                break;
            }
        }
        return xPos;
    }

    protected Point getTextStartingPoint() {
        Point startingPoint = new Point(0, 0);
        switch (this.textLocation) {
            case 0: {
                startingPoint.x = this.getSize().width + (this.highlightText ? this.extraHighlightWidth / 2 : 0);
                startingPoint.y = this.getTextConstantYPos();
                break;
            }
            case 1: {
                startingPoint.x = -this.textWidth - (this.highlightText ? this.extraHighlightWidth / 2 : 0);
                startingPoint.y = this.getTextConstantYPos();
                break;
            }
            case 2: {
                startingPoint.x = this.getTextConstantXPos();
                startingPoint.y = -this.textDescent - (this.highlightText ? this.extraHighlightHeight / 2 : 0);
                break;
            }
            case 3: {
                startingPoint.x = this.getTextConstantXPos();
                startingPoint.y = this.getSize().height + this.textAscent + (this.highlightText ? this.extraHighlightHeight / 2 : 0);
                break;
            }
        }
        return startingPoint;
    }

    protected Point getTextFinishingPoint() {
        Point finishingPoint = new Point(0, 0);
        switch (this.textLocation) {
            case 0: {
                finishingPoint.x = this.myComponent.getLocation().x + this.myComponent.getSize().width + 10;
                finishingPoint.y = this.getTextConstantYPos();
                break;
            }
            case 1: {
                finishingPoint.x = this.myComponent.getLocation().x - 10 - this.textWidth;
                finishingPoint.y = this.getTextConstantYPos();
                break;
            }
            case 2: {
                finishingPoint.x = this.getTextConstantXPos();
                finishingPoint.y = this.myComponent.getLocation().y - 10;
                break;
            }
            case 3: {
                finishingPoint.x = this.getTextConstantXPos();
                finishingPoint.y = this.myComponent.getLocation().y + this.myComponent.getSize().height + 10 + this.textAscent;
                break;
            }
        }
        return finishingPoint;
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.callingAddInternally) {
            super.addImpl(comp, constraints, index);
            return;
        }
        this.setComponent(comp);
    }

    protected void createOffScreenBuffers() {
        Rectangle bufferedBgndImageBounds;
        if (this.bufferedBgndImage != null) {
            this.bufferedBgndImage.flush();
            this.bufferedBgndImage = null;
        }
        if (this.offScreenImage != null) {
            this.offScreenImage.flush();
            this.offScreenImage = null;
        }
        if ((bufferedBgndImageBounds = this.getBufferedBackgroundBounds()) != null) {
            this.bufferedBgndImage = this.createImage(bufferedBgndImageBounds.width, bufferedBgndImageBounds.height);
            this.offScreenImage = this.createImage(bufferedBgndImageBounds.width, bufferedBgndImageBounds.height);
        }
        this.storeBackground();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.scrollState = 3;
        this.calculateTextAttributes();
        this.createOffScreenBuffers();
    }

    class Mouse
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            InfoTipPanel.this.startScrolling(0, false);
        }

        public void mouseExited(MouseEvent e) {
            InfoTipPanel.this.startScrolling(2, false);
        }

        Mouse() {
            InfoTipPanel.this = InfoTipPanel.this;
        }
    }

    class Action
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            InfoTipPanel.this.startScrolling(0, true);
        }

        Action() {
            InfoTipPanel.this = InfoTipPanel.this;
        }
    }

    class LocationVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!InfoTipPanel.this.isValidTextLocation(i)) {
                throw new PropertyVetoException(String.valueOf(InfoTipPanel.this.errors.getString("InvalidTextLocation")) + i, e);
            }
        }

        LocationVeto() {
            InfoTipPanel.this = InfoTipPanel.this;
        }
    }
}

