/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import symantec.itools.awt.AlignStyle;
import symantec.itools.awt.ButtonBase;
import symantec.itools.awt.util.ColorUtils;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.resources.ErrorsBundle;
import symantec.itools.util.GeneralUtils;

public class LabelButton
extends ButtonBase
implements AlignStyle {
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_BOTTOM = 2;
    protected String sLabelButton;
    protected int vAlignStyle;
    protected int hAlignStyle;
    protected Color textColor;
    protected Color pressedTextColor;
    protected Color disabledTextColor;
    protected transient ResourceBundle errors;
    private HAVeto horizontalVeto;
    private VAVeto verticalVeto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public LabelButton() {
        this("", 1, 1, Color.black);
    }

    public LabelButton(String sText) {
        this(sText, 1, 1, Color.black);
    }

    public LabelButton(String sText, Color color) {
        this(sText, 1, 1, color);
    }

    public LabelButton(String sText, int alignStyle) {
        this(sText, alignStyle, 1, Color.black);
    }

    public LabelButton(String sText, int hAlignStyle, int vAlignStyle, Color color) {
        try {
            this.setText(sText);
            this.setTextColor(color);
            this.setAlignStyle(hAlignStyle);
            this.setVerticalAlignStyle(vAlignStyle);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void setAlignStyle(int style) throws PropertyVetoException {
        if (this.hAlignStyle != style) {
            Integer oldValue = new Integer(this.hAlignStyle);
            Integer newValue = new Integer(style);
            this.vetos.fireVetoableChange("AlignStyle", oldValue, newValue);
            this.hAlignStyle = style;
            this.repaint();
            this.changes.firePropertyChange("AlignStyle", oldValue, newValue);
        }
    }

    public int getAlignStyle() {
        return this.hAlignStyle;
    }

    public void setVerticalAlignStyle(int style) throws PropertyVetoException {
        if (this.vAlignStyle != style) {
            Integer oldValue = new Integer(this.vAlignStyle);
            Integer newValue = new Integer(style);
            this.vetos.fireVetoableChange("VerticalAlignStyle", oldValue, newValue);
            this.vAlignStyle = style;
            this.repaint();
            this.changes.firePropertyChange("VerticalAlignStyle", oldValue, newValue);
        }
    }

    public int getVerticalAlignStyle() {
        return this.vAlignStyle;
    }

    public void setText(String sText) throws PropertyVetoException {
        if (this.sLabelButton == null || !this.sLabelButton.equals(sText)) {
            String oldValue = this.sLabelButton == null ? null : new String(this.sLabelButton);
            this.vetos.fireVetoableChange("Text", oldValue, sText);
            this.sLabelButton = sText;
            this.repaint();
            this.changes.firePropertyChange("Text", oldValue, sText);
        }
    }

    public String getText() {
        return this.sLabelButton;
    }

    public void setTextColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.textColor, color)) {
            Color oldValue = this.textColor;
            this.vetos.fireVetoableChange("TextColor", oldValue, color);
            this.textColor = color;
            try {
                this.disabledTextColor = ColorUtils.lighten(this.textColor, 0.333);
                this.pressedTextColor = ColorUtils.darken(this.textColor, 0.25);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            this.repaint();
            this.changes.firePropertyChange("TextColor", oldValue, color);
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Dimension getPreferredSize() {
        if (this.isAdded) {
            Dimension s = this.size();
            Graphics g = this.getGraphics();
            FontMetrics fm = g.getFontMetrics();
            int labelWidth = 0;
            if (this.sLabelButton != null && !this.sLabelButton.equals("")) {
                labelWidth = fm.stringWidth(this.sLabelButton);
            }
            if (g != null) {
                g.dispose();
            }
            return new Dimension(labelWidth + this.bevel + this.bevel + 4, fm.getAscent() + fm.getDescent() + this.bevel + this.bevel + 4);
        }
        return super.getPreferredSize();
    }

    public synchronized void addNotify() {
        super.addNotify();
        try {
            this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        }
        catch (Throwable throwable) {
            this.errors = new ErrorsBundle();
        }
        if (this.horizontalVeto == null) {
            this.horizontalVeto = new HAVeto();
            this.addAlignStyleListener(this.horizontalVeto);
        }
        if (this.verticalVeto == null) {
            this.verticalVeto = new VAVeto();
            this.addVerticalAlignStyleListener(this.verticalVeto);
        }
    }

    public synchronized void removeNotify() {
        if (this.horizontalVeto != null) {
            this.removeAlignStyleListener(this.horizontalVeto);
            this.horizontalVeto = null;
        }
        if (this.verticalVeto != null) {
            this.removeVerticalAlignStyleListener(this.verticalVeto);
            this.verticalVeto = null;
        }
        super.removeNotify();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetos.removeVetoableChangeListener(listener);
    }

    public synchronized void addAlignStyleListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("AlignStyle", listener);
    }

    public synchronized void removeAlignStyleListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("AlignStyle", listener);
    }

    public synchronized void addAlignStyleListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("AlignStyle", listener);
    }

    public synchronized void removeAlignStyleListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("AlignStyle", listener);
    }

    public synchronized void addVerticalAlignStyleListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("VerticalAlignStyle", listener);
    }

    public synchronized void removeVerticalAlignStyleListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("VerticalAlignStyle", listener);
    }

    public synchronized void addVerticalAlignStyleListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("VerticalAlignStyle", listener);
    }

    public synchronized void removeVerticalAlignStyleListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("VerticalAlignStyle", listener);
    }

    protected boolean isValidHorizontalAlignStyle(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidVerticalAlignStyle(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected void updateButtonImage() {
        super.updateButtonImage();
        FontMetrics fm = this.buttonImageGraphics.getFontMetrics();
        int xPos = 0;
        int yPos = 0;
        int labelWidth = 0;
        Dimension s = this.size();
        if (this.sLabelButton != null && !this.sLabelButton.equals("")) {
            labelWidth = fm.stringWidth(this.sLabelButton);
        }
        Color tempColor = this.isEnabled() ? (this.pressed ? this.pressedTextColor : this.textColor) : this.disabledTextColor;
        switch (this.hAlignStyle) {
            case 0: {
                xPos = this.bevel + 2;
                break;
            }
            case 2: {
                xPos = s.width - 3 - this.bevel - labelWidth;
                break;
            }
            case 1: {
                xPos = s.width - labelWidth >> 1;
                break;
            }
        }
        switch (this.vAlignStyle) {
            case 0: {
                yPos = this.bevel + 2 + fm.getAscent();
                break;
            }
            case 2: {
                yPos = s.height - 3 - this.bevel - fm.getDescent();
                break;
            }
            case 1: {
                yPos = s.height + fm.getAscent() >> 1;
                break;
            }
        }
        this.buttonImageGraphics.setColor(tempColor);
        this.buttonImageGraphics.drawString(this.sLabelButton, xPos + this.pressedAdjustment, yPos + this.pressedAdjustment);
    }

    class HAVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!LabelButton.this.isValidHorizontalAlignStyle(i)) {
                throw new PropertyVetoException(String.valueOf(LabelButton.this.errors.getString("InvalidAlignStyle")) + i, e);
            }
        }

        HAVeto() {
            LabelButton.this = LabelButton.this;
        }
    }

    class VAVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!LabelButton.this.isValidVerticalAlignStyle(i)) {
                throw new PropertyVetoException(String.valueOf(LabelButton.this.errors.getString("InvalidVerticalAlignStyle")) + i, e);
            }
        }

        VAVeto() {
            LabelButton.this = LabelButton.this;
        }
    }
}

