/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.multimedia;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ResourceBundle;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.resources.ResBundle;
import symantec.itools.util.GeneralUtils;

public class ScrollingText
extends Canvas
implements Runnable {
    public static final int SCROLL_LEFT = 0;
    public static final int SCROLL_RIGHT = 1;
    protected int scrollDirection = 0;
    protected int scrollUnit = 10;
    protected int sleepTime = 150;
    protected Color hiliteColor = Color.red;
    protected String[] messageList;
    protected URL[] linkToList;
    protected String frame;
    protected transient AppletContext context;
    protected transient Thread scrollThread;
    protected transient boolean suspended = false;
    protected transient int textX;
    protected transient int textY;
    protected transient int textWidth;
    protected transient int textHeight;
    protected transient boolean isMouseOver = false;
    protected transient int lastMouseX;
    protected transient int lastMouseY;
    protected transient boolean wasMouseOverText = false;
    protected transient String wasStatusMessage = "";
    protected String currMessage;
    protected URL currLinkTo;
    protected int currIndex;
    protected transient Image textImage;
    private VetoableChangeSupport vetos;
    private PropertyChangeSupport changes;
    private Mouse mouse;
    private MouseMotion mouseMotion;

    public ScrollingText() {
        ResourceBundle res;
        try {
            res = ResourceBundle.getBundle("symantec.itools.resources.ResBundle");
        }
        catch (Throwable throwable) {
            res = new ResBundle();
        }
        this.messageList = new String[5];
        this.messageList[0] = res.getString("put");
        this.messageList[1] = res.getString("some");
        this.messageList[2] = res.getString("text");
        this.messageList[3] = res.getString("in");
        this.messageList[4] = res.getString("here");
        this.linkToList = new URL[0];
        this.frame = null;
        this.currMessage = "";
        this.currLinkTo = null;
        this.currIndex = -1;
        this.vetos = new VetoableChangeSupport(this);
        this.changes = new PropertyChangeSupport(this);
    }

    public void setScrollInterval(int speed) throws PropertyVetoException {
        if (speed < 30) {
            speed = 30;
        }
        if (speed != this.sleepTime) {
            Integer oldScrollIntervalInt = new Integer(this.sleepTime);
            Integer newScrollIntervalInt = new Integer(speed);
            this.vetos.fireVetoableChange("ScrollInterval", oldScrollIntervalInt, newScrollIntervalInt);
            this.sleepTime = speed;
            this.changes.firePropertyChange("ScrollInterval", oldScrollIntervalInt, newScrollIntervalInt);
        }
    }

    public int getScrollInterval() {
        return this.sleepTime;
    }

    public void setScrollUnit(int unit) throws PropertyVetoException {
        if (unit < 1) {
            unit = 1;
        }
        if (this.scrollUnit != unit) {
            Integer oldScrollUnitInt = new Integer(this.scrollUnit);
            Integer newScrollUnitInt = new Integer(unit);
            this.vetos.fireVetoableChange("ScrollUnit", oldScrollUnitInt, newScrollUnitInt);
            this.scrollUnit = unit;
            this.changes.firePropertyChange("ScrollUnit", oldScrollUnitInt, newScrollUnitInt);
        }
    }

    public int getScrollUnit() {
        return this.scrollUnit;
    }

    public void setScrollDirection(int dir) throws PropertyVetoException {
        if (dir != 0 && dir != 1) {
            dir = 1;
        }
        if (this.scrollDirection != dir) {
            Integer oldScrollDirectionInt = new Integer(this.scrollDirection);
            Integer newScrollDirectionInt = new Integer(dir);
            this.vetos.fireVetoableChange("ScrollDirection", oldScrollDirectionInt, newScrollDirectionInt);
            this.scrollDirection = dir;
            this.changes.firePropertyChange("ScrollDirection", oldScrollDirectionInt, newScrollDirectionInt);
        }
    }

    public int getScrollDirection() {
        return this.scrollDirection;
    }

    public void setHiliteColor(Color newHiliteColor) throws PropertyVetoException {
        if (!this.hiliteColor.equals(newHiliteColor)) {
            Color oldColor = this.hiliteColor;
            Color newColor = newHiliteColor;
            this.vetos.fireVetoableChange("HiliteColor", oldColor, newColor);
            this.hiliteColor = newHiliteColor;
            this.changes.firePropertyChange("HiliteColor", oldColor, newColor);
        }
    }

    public Color getHiliteColor() {
        return this.hiliteColor;
    }

    public void setMessageList(String[] list) throws PropertyVetoException {
        if (this.messageList != list) {
            String[] oldMessageList = this.messageList;
            String[] newMessageList = list;
            this.currIndex = 0;
            this.vetos.fireVetoableChange("MessageList", oldMessageList, newMessageList);
            this.messageList = list;
            this.changes.firePropertyChange("MessageList", oldMessageList, newMessageList);
            this.updateCurrentMessage(false);
        }
    }

    public String[] getMessageList() {
        return this.messageList;
    }

    public void setLinkToList(URL[] list) throws PropertyVetoException {
        if (this.linkToList != list) {
            URL[] oldLinkToList = this.linkToList;
            URL[] newLinkToList = list;
            this.currIndex = 0;
            this.vetos.fireVetoableChange("LinkToList", oldLinkToList, newLinkToList);
            this.linkToList = list;
            this.changes.firePropertyChange("LinkToList", oldLinkToList, newLinkToList);
            this.updateCurrentMessage(false);
        }
    }

    public URL[] getLinkToList() {
        return this.linkToList;
    }

    public void setFrame(String newFrame) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.frame, newFrame)) {
            String oldFrame = this.frame;
            this.vetos.fireVetoableChange("Frame", oldFrame, newFrame);
            this.frame = newFrame;
            this.changes.firePropertyChange("Frame", newFrame, newFrame);
        }
    }

    public String getFrame() {
        return this.frame;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.mouseMotion == null) {
            this.mouseMotion = new MouseMotion();
            this.addMouseMotionListener(this.mouseMotion);
        }
        this.scrollThread = new Thread(this);
        this.scrollThread.setPriority(1);
        this.scrollThread.start();
    }

    public synchronized void removeNotify() {
        if (this.scrollThread != null) {
            this.scrollThread.stop();
            this.scrollThread = null;
        }
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.mouseMotion != null) {
            this.removeMouseMotionListener(this.mouseMotion);
            this.mouseMotion = null;
        }
        super.removeNotify();
    }

    public void startScrollingText() {
        this.suspended = false;
        this.show();
    }

    public void stopScrollingText() {
        this.suspended = true;
    }

    public synchronized void show() {
        super.show();
        if (this.isVisible() && this.scrollThread != null) {
            this.scrollThread.setPriority(10);
            this.scrollThread.resume();
        }
    }

    public synchronized void hide() {
        super.hide();
        if (!this.isVisible() && this.scrollThread != null) {
            this.scrollThread.suspend();
        }
    }

    public void run() {
        this.createTextParams();
        while (true) {
            if (this.suspended) {
                continue;
            }
            this.nextPos();
            try {
                Thread.sleep(this.sleepTime);
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    protected void updateCurrentMessage(boolean next) {
        try {
            if (next) {
                ++this.currIndex;
            }
            if (this.currIndex >= this.messageList.length) {
                this.currIndex = 0;
            }
            this.currMessage = this.messageList[this.currIndex];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                this.currIndex = 0;
                this.currMessage = this.messageList[0];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                this.currMessage = "";
            }
        }
        this.currLinkTo = this.currIndex < this.linkToList.length ? this.linkToList[this.currIndex] : null;
        this.createTextParams();
    }

    protected synchronized void nextPos() {
        Dimension dim = this.size();
        if (this.scrollDirection == 0) {
            this.textX -= this.scrollUnit;
            if (this.textX + this.textWidth < 0) {
                this.updateCurrentMessage(true);
                this.textX = dim.width;
            }
        } else {
            this.textX += this.scrollUnit;
            if (this.textX > dim.width) {
                this.updateCurrentMessage(true);
                this.textX = -this.textWidth;
            }
        }
        this.repaint();
    }

    protected void createTextParams() {
        Font f = this.getFont();
        if (f != null) {
            FontMetrics fm = this.getFontMetrics(f);
            this.textHeight = fm.getHeight();
            Dimension dim = this.size();
            this.textX = dim.width;
            this.textY = (dim.height - this.textHeight >> 1) + fm.getAscent();
            this.textWidth = fm.stringWidth(this.currMessage);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    protected boolean isMouseOverText(int x, int y) {
        return this.isMouseOver && x >= this.textX && x <= this.textX + this.textWidth && y >= this.textY - this.textHeight && y <= this.textY;
    }

    public void paint(Graphics g) {
        Dimension dim = this.size();
        if (this.isImageInvalid()) {
            this.textImage = this.createImage(dim.width, dim.height);
            try {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(this.textImage, 0);
                tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
        }
        Graphics textGC = this.textImage.getGraphics();
        textGC.setColor(this.getBackground());
        textGC.fillRect(0, 0, dim.width, dim.height);
        textGC.setFont(this.getFont());
        boolean mouseOverText = this.isMouseOverText(this.lastMouseX, this.lastMouseY);
        if (mouseOverText != this.wasMouseOverText) {
            String newStatusMessage;
            if (this.context != null && !this.wasStatusMessage.equals(newStatusMessage = this.wasMouseOverText || this.currLinkTo == null ? "" : this.currLinkTo.toString())) {
                this.context.showStatus(newStatusMessage);
                this.wasStatusMessage = newStatusMessage;
            }
            this.wasMouseOverText = mouseOverText;
        }
        textGC.setColor(mouseOverText && this.currLinkTo != null ? this.hiliteColor : this.getForeground());
        textGC.drawString(this.currMessage, this.textX, this.textY);
        g.drawImage(this.textImage, 0, 0, this);
        if (textGC != null) {
            textGC.dispose();
        }
    }

    public void validate() {
        Container c = this.getParent();
        while (c != null) {
            if (c instanceof Applet) {
                this.setAppletContext(((Applet)c).getAppletContext());
                break;
            }
            c = c.getParent();
        }
    }

    protected void setAppletContext(AppletContext c) {
        this.context = c;
    }

    public synchronized void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.createTextParams();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    protected boolean isImageInvalid() {
        Dimension s = this.getSize();
        return this.textImage == null || s.width != this.textImage.getWidth(this) || s.height != this.textImage.getHeight(this);
    }

    class MouseMotion
    extends MouseMotionAdapter
    implements Serializable {
        public void mouseMoved(MouseEvent event) {
            ScrollingText.this.isMouseOver = true;
            ScrollingText.this.lastMouseX = event.getX();
            ScrollingText.this.lastMouseY = event.getY();
        }

        MouseMotion() {
            ScrollingText.this = ScrollingText.this;
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mouseExited(MouseEvent evt) {
            ScrollingText.this.isMouseOver = false;
        }

        public void mousePressed(MouseEvent evt) {
            if (ScrollingText.this.currLinkTo != null && ScrollingText.this.isMouseOverText(evt.getX(), evt.getY()) && ScrollingText.this.context != null) {
                if (ScrollingText.this.frame == null || ScrollingText.this.frame.length() == 0) {
                    ScrollingText.this.context.showDocument(ScrollingText.this.currLinkTo);
                } else {
                    ScrollingText.this.context.showDocument(ScrollingText.this.currLinkTo, ScrollingText.this.frame);
                }
            }
        }

        Mouse() {
            ScrollingText.this = ScrollingText.this;
        }
    }
}

