/**********************************************************************/
/*                                                                    */
/* (C) Copyright IBM Corp. 1994                                       */
/* All Rights Reserved                                                */
/* Licensed Materials - Property of IBM                               */
/*                                                                    */
/**********************************************************************/
/*--------------------------------------------------------------------*/
/* This file contains defines and typedefs for IMS Web Connection.    */
/*                                                                    */
/* History:                                                           */
/* 09/09/96   JEH  Created.                                           */
/*                                                                    */
/* 08/10/97   JEH  R210 Conversational processing                     */
/*                                                                    */
/*                 - Added enum TRANType                              */
/*                                                                    */
/* 03/19/98   JEH  PTM2338 - Add support for encryption exits.        */
/*                                                                    */
/* 05/05/98   JEH  PTM2398 - Add define for DAT file directory.       */
/*                                                                    */
/* 05/29/98  JEH   PTM2546 hwsdata to /var/tmp/imsweb for AIX.        */
/*                                                                    */
/* 06/12/98  JEH   PTM2617 VRM changes, phase 1.                      */
/*                                                                    */
/* 06/16/98  JEH  PTM2632 VRM changes for Net.Data.                   */
/*                                                                    */
/* 07/31/98  CLC  Feature2716 Add VRM for R2.1.1                      */
/*                                                                    */
/*--------------------------------------------------------------------*/

#ifndef HWS_INCLUDE
#define HWS_INCLUDE

/*--------------------------------------------------------------------*/
/* Commonly used include files...                                     */
/*--------------------------------------------------------------------*/
#ifndef HWS390
#include <malloc.h>
#endif

#include "hwsemsg.h"    /* Error message include file.                */

/*--------------------------------------------------------------------*/
/* Maximum and minimum length defines, etc.                           */
/*--------------------------------------------------------------------*/

#define  MAX_NUM_ERRORS        20
#define  ERRDATA_LEN           100
#define  MAX_LONG_STRING       10
#define  MAX_USHORT_STRING     5

/*--------------------------------------------------------------------*/
/* Defines for byte ordering for numeric data types.                  */
/*--------------------------------------------------------------------*/

#define  INTEL_ENDIAN         0x0001
#define  RISC_ENDIAN          0x0002
#define  SPARC_ENDIAN         0x0002
#define  S370_ENDIAN          0x0002

/*--------------------------------------------------------------------*/
/* Defines for exporting functions.  Compiler dependent ?????         */
/*--------------------------------------------------------------------*/
#ifdef HWSNT4
#define  DllExport            __declspec( dllexport )
#define  DllImport            __declspec( dllimport )
#define  LOCAL_ENDIAN   INTEL_ENDIAN
#endif

#ifdef HWSOS2
#define  DllExport
#define  DllImport
#define  LOCAL_ENDIAN   INTEL_ENDIAN
#endif

#ifdef HWSAIX
#define  DllExport
#define  DllImport
#define  _MAX_PATH 256
#define  LOCAL_ENDIAN   RISC_ENDIAN
#endif

#ifdef HWSSUN
#define  DllExport
#define  DllImport
#define  _MAX_PATH 256
#define  LOCAL_ENDIAN   SPARC_ENDIAN
#endif

#ifdef HWS390
#define  DllExport
#define  DllImport
#define  _MAX_PATH 256
#define  LOCAL_ENDIAN   S370_ENDIAN
#endif

#define  MAX_TIME_LEN         8     /* TIME system literal.           */
#define  MAX_DATE1_LEN        6     /* DATE1 system literal.          */
#define  MAX_DATE2_LEN        8     /* DATE2 system literal.          */
#define  MAX_DATE3_LEN        8     /* DATE3 system literal.          */
#define  MAX_DATE4_LEN        8     /* DATE4 system literal.          */


/*--------------------------------------------------------------------*/
/* Version, release, modification level information for internal      */
/* and external use.                                                  */
/*--------------------------------------------------------------------*/
typedef enum  {	HWS110, HWS210,
		HWS211}  IWebVers;    	/* Internal VRM type.    */

typedef enum  {HWSFMT1 }  IWebFmt;           /* IMS Web format level. */

typedef enum  { HWS_110 = 110, 
                HWS_210 = 210,
		HWS_211 = 211
              } HWSVers;                     /* External VRM type.    */

/*--------------------------------------------------------------------*/
/* Later... define HWSWEB210 in the build; e.g., -DHWSWEB210 (AIX)    */
/*--------------------------------------------------------------------*/
#ifndef HWSWEB211                                          /* 2716 */
#define HWSWEB211                                          /* 2716 */
#endif                                                     /* PTM2617 */

#ifdef HWSWEB211                                           /* 2716 */
#define HWSCURVRM HWS_211                                  /* 2716 */
#endif                                                     /* PTM2617 */

/*--------------------------------------------------------------------*/
/* MFS enums.                                                         */
/*--------------------------------------------------------------------*/
typedef enum  {HWSIN, HWSOUT} MSGType;       /* Message type.         */

typedef enum  {OPT1, OPT2, OPT3} MSGOption;  /* Message formatting    */
                                             /* options.              */

typedef enum  {NOCOND, MFLDNM, MFLDPP, SEGOFF} CONDType;
                                            /* COND= type for LPAGE.  */

/* The following enum provides input and output MFLD types...         */

typedef enum  {STANDARD,   /*---------------------------------------- */
                           /* Input:  use data from CGI program to    */
                           /*         format message field.  MFS      */
                           /*         source will be one of...        */
                           /*         - dfldname                      */
                           /*         - (dfldname,'literal')          */
                           /*                                         */
                           /*         have attribute with get/set     */
                           /*         methods                         */
                           /*                                         */
                           /*         input HTML has text entry field */
                           /*                                         */
                           /* Output: use data from message to format */
                           /*         attribute for CGI program.      */
                           /*         MFS source will be...           */
                           /*         - dfldname                      */
                           /*                                         */
                           /*         have attribute with get method  */
                           /*                                         */
                           /*         output HTML has message data    */
                           /*-----------------------------------------*/

               FLDLIT,     /*-----------------------------------------*/
                           /* Input:  use literal specified in MFS    */
                           /*         source to format message field. */
                           /*         MFS source will be...           */
                           /*         - 'literal'                     */
                           /*                                         */
                           /*         have attribute but no get/set   */
                           /*         methods                         */
                           /*                                         */
                           /*         not included in input HTML      */
                           /*                                         */
                           /* Output: not applicable.                 */
                           /*-----------------------------------------*/

                           /*-----------------------------------------*/
                           /* The following MFLDTypes are for output  */
                           /* only and indicate that the literal      */
                           /* specified in the MFS source be used to  */
                           /* format the attribute for the CGI        */
                           /* program.  No space for the literal is   */
                           /* allocated in the output message.  MFS   */
                           /* source will be...                       */
                           /*                                         */
               SLITLTNM,   /*         - (dfldname,LTNAME)             */
               SLITTIME,   /*         - (dfldname,TIME)               */
               SLITDAT1,   /*         - (dfldname,DATE1)              */
               SLITDAT2,   /*         - (dfldname,DATE2)              */
               SLITDAT3,   /*         - (dfldname,DATE3)              */
               SLITDAT4,   /*         - (dfldname,DATE4)              */
               SLITLPAG,   /*         - (dfldname,LPAGENO)            */
               DATALIT,    /*         - (dfldname,'literal')          */
                           /*                                         */
                           /*         have attribute with get method  */
                           /*                                         */
                           /*         output HTML has literal data    */
                           /*-----------------------------------------*/

               SCAFLD,     /*-----------------------------------------*/
                           /* Output: use data from message to format */
                           /*         attribute for CGI program.      */
                           /*         MFS source will be...           */
                           /*         - (,SCA)                        */
                           /*                                         */
                           /*         have attribute with get method  */
                           /*                                         */
                           /*         not included in output HTML     */
                           /*                                         */
                           /*         not converted                   */
                           /*                                         */
                           /* Input:  not applicable.                 */
                           /*-----------------------------------------*/

               NODFLD,     /*-----------------------------------------*/
                           /* Output: use data from message to format */
                           /*         "filler" attribute for CGI      */
                           /*         program. This type of attribute */
                           /*         may be commented out in the     */
                           /*         CGI program.  The MFS source    */
                           /*         will be...                      */
                           /*         - LTH only (no dfldname)        */
                           /*                                         */
                           /*         have attribute with get method  */
                           /*                                         */
                           /*         not included in output HTML     */
                           /*                                         */
                           /*         converted                       */
                           /*                                         */
                           /* Input:  set aside area in input message */
                           /*         and fill as indicated           */
                           /*                                         */
                           /*         have attribute with get/set     */
                           /*         methods                         */
                           /*                                         */
                           /*         not included in input HTML      */
                           /*-----------------------------------------*/
               SLITLTSQ,   /*         - (dfldname,LTSEQ)              */
               SLITLTMG    /*         - (dfldname,LTMSG)              */
               } MFLDType;

typedef enum  {HWSLEFT, HWSRIGHT} JUSTType; /* Field justification.         */

typedef enum  {HWSNONE,               /* FILL= was not specified      */
               HWSCHAR,               /* FILL= C'c'                   */
               HWSHEX,                /* FILL= X'hh'                  */
               HWSPT,                 /* FILL= PT for MSG TYPE=OUTPUT */
               HWSNULL} FILLType;     /* FILL= NULL                   */

typedef enum  {NO3270,                /* ATTR=NO                      */
               YES3270} A3270Type;    /* ATTR=YES                     */

typedef enum  {NOGRAPHIC,             /* GRAPHIC=NO                   */
               YESGRAPHIC}            /* GRAPHIC=YES                  */
                        GRAPHICType;

typedef enum  {HWSGE, HWSLE, HWSGT, HWSLT, HWSEQ, HWSNE} OPType;
                                      /* COND operations.             */

                                      /* Target platform-compiler     */
typedef enum                          /* for generated code.          */
              {NT_MSVCC,              /* NT-MS Visual C++             */
               NT_IBMVACC,            /* NT-IBM VisualAge C++         */
               OS2_IBMVACC,           /* OS/2-IBM VisualAge C++       */
               AIX_IBMCSET,           /* AIX-IBM C Set++              */
               SUN_SUNCPP,            /* SOLARIS-SUNSOFT C++          */
               OS390_MVSCPP} GENType; /* OS/390-IBM C++ for MVS/ESA   */

/*--------------------------------------------------------------------*/
/* Conversion enums, etc.                                             */
/*                                                                    */
/* Note: To add a new language, add a new enum symbol at the END of   */
/*       the CONVType enum, but before LASTLANG.  At the same time,   */
/*       initialize the corresponding entry in the LNG table in       */
/*       the constructor for the Conversion class (conversn.cpp).     */
/*--------------------------------------------------------------------*/
typedef enum  {ASCIIASCII,            /* No conversion.               */
               USENGLISH,             /* U.S. English.                */
               LATIN1,                /* Latin1 languages.            */
               LATIN2,                /* Latin1 languages.            */
               HEBREW,                /* Hebrew.                      */
               TURKISH,               /* Turkish.                     */
               GERMAN,                /* German                  @2263*/
               DEN_NRWAY,             /* Denmark/Norway          @2263*/
               FIN_SWDN,              /* Finland/Sweden          @2263*/
               ITALIAN,               /* Italian                 @2263*/
               SPANISH,               /* Spanish                 @2263*/
               UKENGLISH,             /* UK English              @2263*/
               FRENCH,                /* French                  @2263*/
               ICELANDIC,             /* Iceland                 @2263*/
//             JAPANLATIN,            /* Japanese-Latin1.             */
//             JAPANKATA,             /* Japanese-Katakana.           */
//             KOREAN,                /* Korean.                      */
               LASTLANG} CONVType;    /* Last language.               */

/*--------------------------------------------------------------------*/
/* Transaction output object types.                                   */
/*--------------------------------------------------------------------*/
typedef enum  {HWS_USER,               /* User defined.               */
               HWS_ERROUT,             /* HWSErrOut.                  */
               HWS_MO1,                /* DFSMO1.                     */
               HWS_MO2,                /* DFSMO2.                     */
               HWS_MO3,                /* DFSMO3.                     */
               HWS_MO4,                /* DFSMO4.                     */
               HWS_MO5,                /* DFSMO5.                     */
               HWS_DSPO1,              /* DFSDSPO1.                   */
               HWS_MOD_UNKNOWN } TOUTType; /* Unknown type.           */

/*--------------------------------------------------------------------*/
/* Added for conversational processing...                             */
/*--------------------------------------------------------------------*/
typedef enum  { CONV,       /* Transaction is conversational...       */
                            /* releases 2.1.0 and greater.            */
                NONCONV   } /* Transaction is non-conversational.     */
                            /* releases 1.1.0 and greater.            */
                TRANType;   /* Transaction type.                      */

typedef enum  { NONE,       /* None (no ACK/NACK required).           */
                CONFIRM   } /* Confirm (ACK/NACK message required     */
                            /* following each tran. output message).  */
                SYNCLevel;  /* Synchronization level.                 */

typedef enum  { PASSWORDTEXT,    /* Password encrypted to text.       */  /* PTM2338 */
                PASSWORDBINARY } /* Password encrypted to binary.     */  /* PTM2338 */
                PASSDATAType;    /* Type of user authentication data. */  /* PTM2338 */

/*--------------------------------------------------------------------*/
/* LPAGE COND= keyword                                                */
/*                                                                    */
/* Note: COND= can have mfldname | mfldname(pp) | segoffset           */
/*       If segoffset is used it is relative to 0 and must allow      */
/*       for LLZZ.  However, the data member "data" of a segment      */
/*       LLData object starts at the byte immediately following       */
/*       LLZZ.                                                        */
/*                                                                    */
/*       If pp is used, it is relative to 1.                          */
/*--------------------------------------------------------------------*/
typedef struct
{
   char        *MFLDName;             /* Name of MFLD to be tested.   */
   int         pp;                    /* Field or segment offset.     */
   OPType      op;                    /* Operation.                   */
   char        *value;                /* Literal to be tested.        */
}  Condition;

/*--------------------------------------------------------------------*/
/* The following typedef is temporary - until we find include for     */
/* Boolean.                                                           */
/*--------------------------------------------------------------------*/

typedef   int            HWSBool;
#define   HWSTrue        1;
#define   HWSFalse       0;


/*--------------------------------------------------------------------*/
/* The following macros are for development						      */
/*--------------------------------------------------------------------*/

#ifdef _DEBUG

#define _CRTDBG_MAP_ALLOC

#endif

/*--------------------------------------------------------------------*/
/* Defines relating to hidden HTML fields.                            */
/*--------------------------------------------------------------------*/

//#define MAX_HIDDEN_FLDS     12                  /* Maximum # hidden   */
/* PTM2295 */
#define MAX_HIDDEN_FLDS     11                  /* Maximum # hidden   */
                                                /* fields in HTML.    */
/* PTM2295 */
#define MAX_ND_HIDDEN_FLDS  MAX_HIDDEN_FLDS-1   /* Maximum # hidden   */
                                                /* field columns in   */
                                                /* Net.Data table.    */

/* Defines for names of hidden HTML fields.                           */

#define HIDN_CONVID           "ConvID"
#define HIDN_RUNAME           "RUName"
#define HIDN_DATETIME         "DateTime"
#define HIDN_MILLISECS        "Millisecs"
#define HIDN_LPAGENAME        "LPageName"
#define HIDN_HWSTERM          "HWSTERM"         /* Not included in    */
                                                /* in Net.Data table. */
/* DynInfo Fix... */
#define HIDN_HWSHOST          "HWSHOST"
#define HIDN_HWSPORT          "HWSPORT"
#define HIDN_HWSIMS           "HWSIMS"
#define HIDN_HWSUSER          "HWSUSER"
#define HIDN_HWSGROUP         "HWSGROUP"
/* PTM2295 */
//#define HIDN_HWSPASSWD        "HWSPASSWD"
/* PTM2295 */
/* DynInfo Fix... */

/* Defines for values of hidden fields.                               */

#define HWSTERM_CONT          "HWSCONT"         /* HWSTERM            */
#define HWSTERM_TERM          "HWSTERM"         /* HWSTERM            */

/* Defines for names of hidden field columns of Net.Data table.       */

#define COL_HIDN_CONVID       "ConvIDValue"
#define COL_HIDN_RUNAME       "RUNameValue"
#define COL_HIDN_DATETIME     "DateTimeValue"
#define COL_HIDN_MILLISECS    "MillisecsValue"
#define COL_HIDN_LPAGENAME    "LPageNameValue"
/* DynInfo Fix... */
#define COL_HIDN_HWSHOST      "HWSHOSTValue"
#define COL_HIDN_HWSPORT      "HWSPORTValue"
#define COL_HIDN_HWSIMS       "HWSIMSValue"
#define COL_HIDN_HWSUSER      "HWSUSERValue"
#define COL_HIDN_HWSGROUP     "HWSGROUPValue"
/* PTM2295 */
//#define COL_HIDN_HWSPASSWD    "HWSPASSWDValue"
/* PTM2295 */
/* DynInfo Fix... */

/*--------------------------------------------------------------------*/
/* Defines for DAT file directory.                                    */
/*--------------------------------------------------------------------*/
#define HWSDATA_DIR           "hwsdata"                    /* PTM2398 */
#define HWSTRACE_DIR          "trace"                      /* PTM2546 */
#define HWSDATA_PATH          "/var/tmp/imsweb"            /* PTM2546 */
#define HWSTRACE_PATH         "/var/tmp/imsweb"            /* PTM2546 */

#endif // HWS_INCLUDE

