/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

/* what: hwscmde.h, hwscmd, r210                  */
/* SCCS SID: 1.2              */
/* Extract time: 12/10/97          */
/* Last Updated time: 12/10/97     */

/*--------------------------------------------------------------------*/
/*                                                                    */
/* Change History:                                                    */
/*                                                                    */
/* 05/06/98  JEH  PTM2467  Clean up error messages for 2.1            */
/*                                                                    */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* HWSCMDE.H                                                          */
/* HWSCMD external return codes and messages.                         */
/*                                                                    */
/* Change History:                                                    */
/*                                                                    */
/* 09/15/97  Theresa Lai Created.                                     */
/*                                                                    */
/* 05/05/98  THL - fixed PTM 2398.                                    */
/*                 Renamed the conversation state (.DAT) file         */
/*                 directory from 'temp' to 'hwsdata'.                */
/* 06/08/98  THL - fixed PTM 2504 & 2523 (Ref. PTM2546).              */
/*                 hwsdata & trace to /var/tmp/imsweb for AIX.        */
/* 06/11/98  THL - fixed PTM 2612.                                    */
/*                 OS/390 - Heap storage control information was      */
/*                 damaged problem.                                   */
/*                 Changed the Explanation area for message 10001.    */   
/* 06/16/98  THL - fixed PTM 2624.                                    */
/*                 AIX & OS/390 - Added remarks for the creation of   */
/*                 'hwsdata' and 'trace' subdirectories.              */
/*--------------------------------------------------------------------*/

#ifndef HWSCMDE_H
#define HWSCMDE_H

/**********************************************************************/
/* HWSCMD Component External return codes and messages Definition     */
/* 10000 - 10500                                                      */
/**********************************************************************/

/*--------------------------------------------------------------------*/
/* HWSCMD general external return codes and messages:                 */
/* 10000 - 10200                                                      */
/*--------------------------------------------------------------------*/
#define  NO_HWSPATH                           10000
#define  NO_HWSPATH_S                         "HWSCMD: HWSPATH or the directory to which it points was not found."
// Explanation:  HWSPATH is used by IMS Web
//               to determine the location of IMS Web Runtime files.
//               Either the HWSPATH system variable or the directory to which it points
//               was not found.
// User Action:  This is most likely an installation error.
//               For OS/2, verify that the HWSPATH environment variable is set
//               to the path where IMS Web Runtime is installed.
//               For Windows NT, use REGEDIT to verify that the value of HWSPATH in the registry
//               is set to the path where IMS Web Runtime is installed.  For AIX and OS/390 IMS Web Runtime
//               is installed in /usr/lpp/imsweb.

#define  ERR_DATDIR_NOT_EXIST                 10001
#define  ERR_DATDIR_NOT_EXIST_S               "HWSCMD: The 'hwsdata' directory does not exist."
// Explanation:  An attempt to access the 'hwsdata' subdirectory of the IMS Web Runtime component installation directory
//               during processing of the HWSCMD DISPLAY CONV or EXIT commands failed.
//               The 'hwsdata' directory is created during the installation of
//               IMS Web Runtime component on Windows NT and OS/2 platforms only. 
//               It contains all the conversation state files.
//               Note: For AIX and OS/390, the 'imsweb' and 'imsweb/hwsdata' subdirectories,
//               if they do not exist, are created under /var/tmp directory 
//               with full access permission whenever the user
//               issues a HWSCMD DISPLAY or HWSCMD EXIT command. 
// User Action:  On Windows NT and OS/2, this usually happens when the user deletes or renames the 'hwsdata' 
//               directory.  This could also happen if the access permission for the 'hwsdata' directory
//               have been changed.  


#define  ERR_READ_DATDIR                      10002
#define  ERR_READ_DATDIR_S                    "HWSCMD: No active IMS Web conversations found."
// Explanation:  No conversation state files found in the 'hwsdata' subdirectory of the IMS Web Runtime component
//               installation directory.  This is the expected output of HWSCMD DISPLAY CONV ALL if you have
//               no active conversations.  This could also occur if the conversation state files for all
//               active conversations have been manually deleted.
// User Action:  No action required.


#define  DATFILE_NOT_FOUND                    10003
#define  DATFILE_NOT_FOUND_S                  "HWSCMD: Conversation state (convTokn.DAT) file not found."
// Explanation:  The conversation state file for the conversation identified by the convTokn specified in an
//               'HWSCMD DISPLAY CONV convTokn' or 'HWSCMD EXIT [CONV] convTokn' command was not
//               found in the 'hwsdata' subdirectory of the IMS Web Runtime component
//               installation directory.  This is the expected output of these commands if the convTokn specified
//               did not refer to an active conversation.
//               This could also occur if the conversation state file for this conversation
//               has been manually deleted.
// User Action:  If the above explanation applies, no action is required.
//               Otherwise, report the problem to your IMS support group.


#define  TIME_INTERVAL_NOT_MATCH              10004
#define  TIME_INTERVAL_NOT_MATCH_S            "HWSCMD: No conversation is older than the specified time interval "
// Explanation:  No conversation can be displayed or terminated because no active conversation is older than the
//               specified time interval.
// User Action:  No action required.



/*--------------------------------------------------------------------*/
/* External return codes & messages for HWSCMD TRACE command          */
/* 10201 - 10300                                                      */
/*--------------------------------------------------------------------*/
#define  BAD_TRACE_CREATE                   10201
#define  BAD_TRACE_CREATE_S                 "HWSCMD TRACE: Could not open a trace file for write."
// Explanation:  An attempt to open a new program_name.TMP file during processing of
//               command "HWSCMD TRACE ON program_name" failed.
// User Action:  This is most likely an installation error on Windows NT and OS/2.
//               For OS/2, verify that the HWSPATH environment variable is set
//               to the path where IMS Web Runtime is installed.
//               For Windows NT, use REGEDIT to verify that the value of HWSPATH in the registry
//               is set to the path where IMS Web Runtime is installed.  For AIX and OS/390 
//               IMS Web Runtime is installed in /usr/lpp/imsweb.
//               Note: For AIX and OS/390, the 'imsweb' and 'imsweb/trace' subdirectories,
//               if they do not exist, are created in /var/tmp with full access permission 
//               whenever the user issues a HWSCMD TRACE ON/OFF command.
//               Verify the existence of the directories and any temporary trace files 
//               and trace log files.
#define  BAD_TRACE_OPEN                     10202
#define  BAD_TRACE_OPEN_S                   "HWSCMD TRACE: Could not open existing trace file."
// Explanation:  An attempt to open an existing program_name.TMP file during processing of
//               command "HWSCMD TRACE OFF program_name" failed.
// User Action:  This is most likely an installation error on Windows NT and OS/2.
//               For OS/2, verify that the HWSPATH environment variable is set
//               to the path where IMS Web Runtime is installed.
//               For Windows NT, use REGEDIT to verify that the value of HWSPATH in the registry
//               is set to the path where IMS Web Runtime is installed.  For AIX and OS/390 IMS Web Runtime
//               is installed in /usr/lpp/imsweb.
//               Note: For AIX and OS/390, the 'imsweb' and 'imsweb/trace' subdirectories,
//               if they do not exist, are created in /var/tmp with full access permission 
//               whenever the user issues a HWSCMD TRACE ON/OFF command.
//               Verify the existence of the directories and any temporary trace files
//               and trace log files.
#define  BAD_TRACE_WRITE                    10203
#define  BAD_TRACE_WRITE_S                 "HWSCMD TRACE: Could not write 1st record to new trace file."
// Explanation:  An attempt to write the first or last record of a program_name.TMP file during
//               processing of command "HWSCMD TRACE ON|OFF program_name" failed.
// User Action:  This is most likely an installation error on Windows NT and OS/2.
//               For OS/2, verify that the HWSPATH environment variable is set
//               to the path where IMS Web Runtime is installed.
//               For Windows NT, use REGEDIT to verify that the value of HWSPATH in the registry
//               is set to the path where IMS Web Runtime is installed.  For AIX and OS/390 IMS Web Runtime
//               is installed in /usr/lpp/imsweb.
//               Note: For AIX and OS/390, the 'imsweb' and 'imsweb/trace' subdirectories,
//               if they do not exist, are created in /var/tmp with full access permission 
//               whenever the user issues a HWSCMD TRACE ON/OFF command.
//               Verify the existence of the directories and any temporary trace files
//               and trace log files.
#define  TRACE_NOT_ON                       10204
#define  TRACE_NOT_ON_S                     "HWSCMD TRACE: The IMS Web Server DLL trace is not ON."
// Explanation:  An attempt to turn off the IMS Web Server DLL trace failed for the specified CGI-BIN
//               program when IMS Web was unable to find the temporary trace file, program_name.TMP.
// User Action:  Turn the IMS Web Server DLL trace on, specifying the name of the CGI-BIN program.
#define  RENAME_FAILURE                     10205
#define  RENAME_FAILURE_S                   "HWSCMD TRACE: Unable to rename .TMP file to .LOG file."
// Explanation:  An attempt to rename a program_name.TMP file to program_name.LOG during processing
//               of command "HWSCMD TRACE OFF program_name" failed.
// User Action:  This is most likely an installation error on Windows NT and OS/2.
//               For OS/2, verify that the HWSPATH environment variable is set
//               to the path where IMS Web Runtime is installed.
//               For Windows NT, use REGEDIT to verify that the value of HWSPATH in the registry
//               is set to the path where IMS Web Runtime is installed.  For AIX and OS/390 IMS Web Runtime
//               is installed in /usr/lpp/imsweb.
//               Note: For AIX and OS/390, the 'imsweb' and 'imsweb/trace' subdirectories,
//               if they do not exist, are created in /var/tmp with full access permission 
//               whenever the user issues a HWSCMD TRACE ON/OFF command.
//               Verify the existence of the directories and any temporary trace files
//               and trace log files.
#define  BAD_LOG_OPEN                       10206
#define  BAD_LOG_OPEN_S                     "HWSCMD TRACE: Could not open existing trace log for write."
// Explanation:  An attempt to open an existing program_name.LOG file during processing of
//               command "HWSCMD TRACE OFF program_name" failed.
// User Action:  This is most likely an installation error on Windows NT and OS/2.
//               For OS/2, verify that the HWSPATH environment variable is set
//               to the path where IMS Web Runtime is installed.
//               For Windows NT, use REGEDIT to verify that the value of HWSPATH in the registry
//               is set to the path where IMS Web Runtime is installed.  For AIX and OS/390 IMS Web Runtime
//               is installed in /usr/lpp/imsweb.
//               Note: For AIX and OS/390, the 'imsweb' and 'imsweb/trace' subdirectories,
//               if they do not exist, are created in /var/tmp with full access permission 
//               whenever the user issues a HWSCMD TRACE ON/OFF command.
//               Verify the existence of the directories and any temporary trace files
//               and trace log files.
#define  LOG_WRITE_FAILURE                  10207
#define  LOG_WRITE_FAILURE_S                "HWSCMD TRACE: Could not append to trace log."
// Explanation:  An attempt to append to an existing program_name.LOG file during processing of
//               command "HWSCMD TRACE OFF program_name" failed.
// User Action:  This is most likely an installation error on Windows NT and OS/2.
//               For OS/2, verify that the HWSPATH environment variable is set
//               to the path where IMS Web Runtime is installed.
//               For Windows NT, use REGEDIT to verify that the value of HWSPATH in the registry
//               is set to the path where IMS Web Runtime is installed.  For AIX and OS/390 IMS Web Runtime
//               is installed in /usr/lpp/imsweb.
//               Note: For AIX and OS/390, the 'imsweb' and 'imsweb/trace' subdirectories,
//               if they do not exist, are created in /var/tmp with full access permission 
//               whenever the user issues a HWSCMD TRACE ON/OFF command.
//               Verify the existence of the directories and any temporary trace files
//               and trace log files.
#define  BAD_TRACEDIR_CREATE                10208
#define  BAD_TRACEDIR_CREATE_S              "HWSCMD TRACE: Could not create the trace subdirectory."
// Explanation:  An attempt to create the 'trace' subdirectory
//               during processing of command "HWSCMD TRACE ON program_name" failed.
// User Action:  This is most likely an installation error on Windows NT and OS/2.
//               For OS/2, verify that the HWSPATH environment variable is set
//               to the path where IMS Web Runtime is installed.
//               For Windows NT, use REGEDIT to verify that the value of HWSPATH in the registry
//               is set to the path where IMS Web Runtime is installed.  For AIX and OS/390 IMS Web Runtime
//               is installed in /usr/lpp/imsweb.
//               Note: For AIX and OS/390, the 'imsweb' and 'imsweb/trace' subdirectories,
//               if they do not exist, are created in /var/tmp with full access permission 
//               whenever the user issues a HWSCMD TRACE ON/OFF command.
//               Verify the existence of the directories and any temporary trace files
//               and trace log files.


/*--------------------------------------------------------------------*/
/* External return codes & messages for HWSCMD DISPLAY command        */
/* 10301 - 10400                                                      */
/*--------------------------------------------------------------------*/


/*--------------------------------------------------------------------*/
/* External return codes & messages for HWSCMD EXIT command           */
/* 10401 - 10500                                                      */
/*--------------------------------------------------------------------*/
#define  ERR_CONNECT_TO_HOST                  10401
#define  ERR_CONNECT_TO_HOST_S                "HWSCMD EXIT: Could not connect to the TCP/IP host."
// Explanation:  An attempt to connect to the TCP/IP host during processing of the command
//               "HWSCMD EXIT [CONV] convTokn", or
//               "HWSCMD EXIT [CONV] GTmmm" failed.
// User Action:  Make sure TCP/IP is functioning properly on the host and the workstation.
//               Otherwise, report the problem to your IMS support group if necessary.


#define  ERR_DEL_DATFILE                      10402
#define  ERR_DEL_DATFILE_S                    "HWSCMD EXIT: Could not delete the conversation state file for conversation "
// Explanation:  An attempt to delete the conversation state file under
//               the 'hwsdata' directory during processing of the command
//               "HWSCMD EXIT [CONV] convTokn".  This is most likely a sharing violation.
//               The conversation state file might be in use by an active CGI-Bin program or
//               Net.Data transaction DLL.  If this is the case, you must wait until the current iteration of
//               the conversation completes.  At this point, IMS Web still considers the conversaiton
//               to be active.
// User Action:  To end the conversation, delete the conversation state file manually.
//               If you have an orphaned CGI-Bin program, you may have to kill that
//               process in order to be able to delete the conversation state file.



#define  DEL_CONN_DAT_OK                      10403
#define  DEL_CONN_DAT_OK_S                    "HWSCMD EXIT: Terminate conversation successful for conversation "
// Explanation:  An 'Exit Conversation' request has been sent to the host for the conversation specified
//               in the 'HWSCMD EXIT [CONV] convTokn' or 'HWSCMD EXIT [CONV] GTmmm' command.  In addition,
//               the conversation state file(s) for the conversation(s) specified in the
//               'HWSCMD EXIT [CONV] convTokn' or 'HWSCMD EXIT [CONV] GTmmm' command
//               have been deleted from the 'hwsdata' directory.
// User Action:  Check the host console to verify that the conversation has been terminated.
//               Otherwise, no action required.



#endif


