/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

/**********************************************************************/
/* Change History:                                                    */
/*                                                                    */
/* 05/08/98  JEH  PTM2481 New OTMA msg format; LTERM override.        */
/*                                                                    */
/**********************************************************************/

#ifndef HWSECLTE_H
#define HWSECLTE_H

#include "hwsetcpi.h"
#include "hwsetcpe.h"
#include "hwseotmi.h"
#include "hwseotme.h"
#include "hwsecnvi.h"
#include "hwsecnve.h"

/*--------------------------------------------------------------------*/
/* IMSClient class external error messages.                           */
/* 2000 - 2099                                                        */
/* 2701 - 2704 (mapped from TcpOtma class)                            */
/* 2601 - 2602 (mapped from OtmaMsg class)                            */
/*--------------------------------------------------------------------*/

#define  HWSC_INSUFFICIENT_STORAGE               2001
#define  HWSC_INSUFFICIENT_STORAGE_S             "Insufficient storage."
// Explanation:  IMSClient was unable to obtain sufficient virtual storage.
// User Action:  Reduce the storage demands on your system.
#define  HWSC_INTERNAL_ERROR                     2002
#define  HWSC_INTERNAL_ERROR_S                   "Internal error."
// Explanation:  An internal error occurred in IMSClient.
// User Action:  Contact your IBM service representative.
#define  HWSC_INVALID_CLIENT_TYPE                2003
#define  HWSC_INVALID_CLIENT_TYPE_S              "The client type is invalid or not supported."
// Explanation:  The client type you provided to IMSClient's constructor is not a supported client type.
// User Action:  Check the documentation of the IMSClient class for a list of supported client types.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_INVALID_ITOC_OPTION                2004
#define  HWSC_INVALID_ITOC_OPTION_S              "The option name input to setStringOption or setByteOption is not valid for client type HWS_ITOC."
// Explanation:  The option name you provided to setStringOption or setByteOption is not a valid option for a client of
//               type HWS_ITOC, or you invoked setStringOption or setByteOption without providing an option name.
// User Action:  Check the documentation of the IMSClient class for a list of valid options for clients of type
//               HWS_ITOC.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_INVALID_ITOC_OPTIONV               2005
#define  HWSC_INVALID_ITOC_OPTIONV_S             "The option value input to setStringOption or setByteOption is not valid for client type HWS_ITOC."
// Explanation:  The option name you provided to setStringOption or setByteOption is valid, but the value is not.  Either
//               you did not specify the value, the length of the value was invalid, or the
//               value was not valid for the specified option.
// User Action:  Check the documentation of the IMSClient class for a list of valid options  and values for clients
//               of type HWS_ITOC.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_NO_DATA_TO_SEND                    2006
#define  HWSC_NO_DATA_TO_SEND_S                  "No transaction data to send to IMS."
// Explanation:  The pointer to the HWSSegments object is NULL.  There is no data to send to IMS.
// User Action:  Provide a non-NULL pointer for the HWSSegments object of the send method.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_NO_SEGS                            2007
#define  HWSC_NO_SEGS_S                          "No Segments in the input."
// Explanation:  No transaction input message could be produced from the request.
// User Action:  In order to execute an IMS transaction or command, the input message
//               must contain at least the trancode or command.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_CONV_ERROR                         2008
#define  HWSC_CONV_ERROR_S                       "Conversion failed."
// Explanation:  Conversion of text or endian data failed.
// User Action:  This is most likely an installation error.  Verify that the conversion tables
//               are correctly installed.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_NO_APPLDATA                        2009
#define  HWSC_NO_APPLDATA_S                      "No application data."
// Explanation:  No data was found in a segment of an IMS output message.
// User Action:  Additional information may be found by examining the values of the REASONMSG and REASONDIAG
//               options.  The value of the REASONDIAG option may consist of a set of error code - error
//               string pairs that provide additional diagnostic information.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_HOSTNAME_SET                   2010
#define  HWSC_BAD_HOSTNAME_SET_S                 "HOSTNAME cannot be changed after connect."
// Explanation:  You attempted to change the HOSTNAME option after a successful connection was established with the host."
// User Action:  If you wish to change an option that is associated with the host connection you must
//               disconnect from the host (invoke the disconnect method), change the option ( invoke the
//               setStringOption method), then reconnect to the host (invoke the connect method).
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_PORT_SET                       2011
#define  HWSC_BAD_PORT_SET_S                     "PORT cannot be changed after connect."
// Explanation:  You attempted to change the PORT option after a successful connection was established with the host."
// User Action:  If you wish to change an option that is associated with the host connection you must
//               disconnect from the host (invoke the disconnect method), change the option ( invoke the
//               setStringOption method), then reconnect to the host (invoke the connect method).
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_IMSNAME_SET                    2012
#define  HWSC_BAD_IMSNAME_SET_S                  "IMSNAME cannot be changed after connect."
// Explanation:  You attempted to change the IMSNAME option after a successful connection was established with the host."
// User Action:  If you wish to change an option that is associated with the host connection you must
//               disconnect from the host (invoke the disconnect method), change the option ( invoke the
//               setStringOption method), then reconnect to the host (invoke the connect method).
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_RUNAME_SET                     2013
#define  HWSC_BAD_RUNAME_SET_S                   "RUNAME cannot be changed after connect."
// Explanation:  You attempted to change the RUNAME option after a successful connection was established with the host."
// User Action:  If you wish to change an option that is associated with the host connection you must
//               disconnect from the host (invoke the disconnect method), change the option ( invoke the
//               setStringOption method), then reconnect to the host (invoke the connect method).
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_USERID_SET                     2014
#define  HWSC_BAD_USERID_SET_S                   "USERID cannot be changed after connect."
// Explanation:  You attempted to change the USERID option after a successful connection was established with the host."
// User Action:  If you wish to change an option that is associated with the host connection you must
//               disconnect from the host (invoke the disconnect method), change the option ( invoke the
//               setStringOption method), then reconnect to the host (invoke the connect method).
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_GROUP_SET                      2015
#define  HWSC_BAD_GROUP_SET_S                    "GROUP cannot be changed after connect."
// Explanation:  You attempted to change the GROUP option after a successful connection was established with the host."
// User Action:  If you wish to change an option that is associated with the host connection you must
//               disconnect from the host (invoke the disconnect method), change the option ( invoke the
//               setStringOption method), then reconnect to the host (invoke the connect method).
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_PASSWORD_SET                   2016
#define  HWSC_BAD_PASSWORD_SET_S                 "PASSWORD cannot be changed after connect."
// Explanation:  You attempted to change the PASSWORD option after a successful connection was established with the host."
// User Action:  If you wish to change an option that is associated with the host connection you must
//               disconnect from the host (invoke the disconnect method), change the option ( invoke the
//               setStringOption method), then reconnect to the host (invoke the connect method).
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_INVALID_CONNECT                    2017
#define  HWSC_INVALID_CONNECT_S                  "Required options not set prior to connect."
// Explanation:  You attempted to invoke the connect method before setting all the reqired options."
// User Action:  Refer to the documenation of the connect method for a list of the options that must be set prior to
//               invoking the connect method.  Set the missing options before invoking the connect method.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_CONNECT_STATE                  2018
#define  HWSC_BAD_CONNECT_STATE_S                "State of IMSClient object is invalid for invocation of connect method."
// Explanation:  The connect method may only be invoked following instantiation of an IMSClient object or
//               following a disconnect.  Prior invocation of any of the methods connect, send, receive, or
//               sendResponse is invalid.
// User Action:  Refer to the documentation for a description of the semantics of the IMSClient API.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_SEND_STATE                     2019
#define  HWSC_BAD_SEND_STATE_S                   "State of IMSClient object is invalid for invocation of send method."
// Explanation:  The send method may only be invoked following connect, receive, sendResponse, or exitConversation.
// User Action:  Refer to the documentation for a description of the semantics of the IMSClient API.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_MISSING_ITOC_OPTIONS               2020
#define  HWSC_MISSING_ITOC_OPTIONS_S             "One or more options requried for an IMSClient of type HWS_ITOC are missing."
// Explanation:  You attempted to invoke the send or sendResponse method without having all the required options set.
// User Action:  Refer to the documentation for a list of the required options for client of type HWS_ITOC.  Use the
//               setStringOption and setByteOption methods to set the missing options prior to the send or sendResponse method.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_RECEIVE_STATE                  2021
#define  HWSC_BAD_RECEIVE_STATE_S                "State of IMSClient object is invalid for invocation of send method."
// Explanation:  The receive method may only be invoked following send.
// User Action:  Refer to the documentation for a description of the semantics of the IMSClient API.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_NO_HOST_OBJECT                     2022
#define  HWSC_NO_HOST_OBJECT_S                   "Invalid host object for connect or disconnect."
// Explanation:  The connect or disconnect method could not find a vaild host object to use for the connection.
// User Action:  The IMSClient object was most likely constructed incorrectly.  Verify that a valid
//               HWSConverter instance was passed to the IMSClient constructor.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_SENDRESP_STATE                 2023
#define  HWSC_BAD_SENDRESP_STATE_S               "State of IMSClient object is invalid for invocation of sendResponse method."
// Explanation:  The sendResponse method may only be invoked following receive when the SYNCLEVEL option is CONFIRM.
// User Action:  Refer to the documentation for a description of the semantics of the IMSClient API.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_DISCONNECT_STATE               2024
#define  HWSC_BAD_DISCONNECT_STATE_S             "State of IMSClient object is invalid for invocation of disconnect method."
// Explanation:  The disconnect method may only be invoked following receive, connect, sendResponse, or exitConversation.
//               If the connection type is PERSISTENT, and a disconnect is attempted while a conversation is
//               in progress, the disconnect will be rejected.
// User Action:  Refer to the documentation for a description of the semantics of the IMSClient API.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_SYNCLEVEL_SET                  2025
#define  HWSC_BAD_SYNCLEVEL_SET_S                "The SYNCLEVEL option cannnot be changed between send and receive."
// Explanation:  The SYNCLEVEL option must be changed after a successful receive that follows a send.
// User Action:  Refer to the documentation for a description of the semantics of the IMSClient API.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_INVALID_ACK_TYPE                   2026
#define  HWSC_INVALID_ACK_TYPE_S                 "The acknowledgement type passed to the sendResponse method is invalid."
// Explanation:  The acknowledgement type you provided to sendResponse is not supported.
// User Action:  Check the documentation of the IMSClient class for valid acknowledgement types.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_OUT_OF_SYNCL                       2027
#define  HWSC_OUT_OF_SYNCL_S                     "Invalid message from host for SYNCLEVEL = CONFIRM."
// Explanation:  The IMSClient option indicates SYNCLEVEL = CONFIRM but the message returned by the host
//               indicates SYNCLEVEL = NONE.
// User Action:  Verify that all the options of the IMSClient object are correctly set.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_EXITCONV_STATE                 2028
#define  HWSC_BAD_EXITCONV_STATE_S               "State of IMSClient object is invalid for invocation of exitConversation method."
// Explanation:  The exitConversation method may only be invoked following connect, send, receive, or sendResponse.
// User Action:  Refer to the documentation for a description of the semantics of the IMSClient API.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_INVALID_RESPONSE_TYPE              2029
#define  HWSC_INVALID_RESPONSE_TYPE_S            "The response type is invalid or not supported."
// Explanation:  The response type you provided to IMSClient's sendResponse method is not a supported response type.
// User Action:  Check the documentation of the IMSClient class for a list of supported response types.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_INVALID_EXITC_TYPE                 2030
#define  HWSC_INVALID_EXITC_TYPE_S               "The client type is invalid or not supported."
// Explanation:  The exit type you provided to IMSClient's exitConversation is not a supported exit type.
// User Action:  Check the documentation of the IMSClient class for a list of supported exit types.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_PWDATATYPE_SET                 2031
#define  HWSC_BAD_PWDATATYPE_SET_S               "The PASSDATATYPE option cannnot be changed between send and receive."
// Explanation:  The PASSDATATYPE option must be changed after a successful receive that follows a send.
// User Action:  Refer to the documentation for a description of the semantics of the IMSClient API.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_BAD_LTERMOVER_SET                  2032
#define  HWSC_BAD_LTERMOVER_SET_S                "The LTERMOVERRIDE option cannnot be changed between send and receive."
// Explanation:  The LTERMOVERRIDE option must be changed after a successful receive that follows a send.
// User Action:  Refer to the documentation for a description of the semantics of the IMSClient API.
//               If you received this message from IMS Web, contact your IBM service representative.

#endif
