/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

/**********************************************************************/
/* Change History:                                                    */
/*                                                                    */
/* 05/05/98  JEH  PTM2398  Use hwspdata for DAT file directory.       */
/*                                                                    */
/* 05/06/98  JEH  PTM2467  Clean up error messages for 2.1.           */
/*                                                                    */
/**********************************************************************/
#ifndef HWSECSTE_H
#define HWSECSTE_H

/******************************************************************/
/* HWSConvState Class External Error Definition.                  */
/* 1080 - 1099                                                    */
/******************************************************************/


#define  NO_SUCH_FILE_2                1080
#define  NO_SUCH_FILE_2_S              "HWSConvState::HWSConvState>Unable to locate DAT file."
// Explanation: IMS Web was unable to find a file representing the conversation.
//              The conversation was most likely terminated by the HWSCMD EXIT command.
// User Action: Determine the reason the conversation was terminated.
#define  NO_SPACE_FOR_DAT_FILE         1082
#define  NO_SPACE_FOR_DAT_FILE_S       "HWSConvState::saveState>No space on drive for DAT file."
// Explanation: IMS Web attempted to start a conversation, but was unable to find
//              enough space to write the file representing the conversation.
// User Action: Files representing conversations are written to the hwsdata subdirectory
//              of IMS Web's installation directory.  Ensure that there is adequate
//              space in hwsdata before re-starting the conversation.
#define  NO_SPACE_FOR_DAT_FILE_2       1083
#define  NO_SPACE_FOR_DAT_FILE_2_S     "HWSConvState::updateState>No space on drive for DAT file."
// Explanation: IMS Web was unable to find enough space to write the file representing
//              the conversation while processing the conversation.
// User Action: Files representing conversations are written to the hwsdata subdirectory
//              of IMS Web's installation directory.  Ensure that there is adequate
//              space in hwsdata.
#define  PERMISSION_DENIED             1084
#define  PERMISSION_DENIED_S           "HWSConvState::updateState>Permission denied."
// Explanation: IMS Web was unable to access the file representing the conversation.
//              This is most likely due to termination of the conversation by the
//              command HWSCMD EXIT.
// User Action: Determine the reason the conversation was terminated, then re-start
//              the conversation.
#define  NO_SUCH_FILE                  1085
#define  NO_SUCH_FILE_S                "HWSConvState::updateState>Unable to locate DAT file."
// Explanation: IMS Web was unable to find a file representing the conversation.
//              The conversation was most likely terminated.
// User Action: Determine the reason the conversation was terminated, then re-start
//              the conversation.
#define  INVALID_STATE_OBJECT 	   	1086
#define  INVALID_STATE_OBJECT_S	   	"HWSConvState::deleteState>Can't determine DAT file to delete."
// Explanation: IMS Web was unable to determine name of file representing the conversation.
// User Action: The conversation may already have been terminated by the HWSCMD EXIT command.
#define  NO_SUCH_FILE_3		   	      1087
#define  NO_SUCH_FILE_3_S		         "HWSConvState::deleteState>Can't find DAT file to delete."
// Explanation: IMS Web was unable to find the file representing the conversation.
// User Action: The conversation may already have been terminated by the HWSCMD EXIT command.
#define  NO_STORAGE     	   	      1088
#define  NO_STORAGE_S    		         "HWSConvState::isInSync>Insufficient storage."
// Explanation:  Unable to obtain sufficient virtual storage.
// User Action:  Reduce the storage demands on your system.
 #endif
