/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
#ifndef HWSETCPI_H
#define HWSETCPI_H

/******************************************************************/
/* TcpOtma Component Internal Error Definition                    */
/* 9700 - 9799                                                    */
/******************************************************************/

#define COMI_NOTINIT       9701
#define COMI_NOTINIT_S     "TCPIP has not been initialized."

#define COMI_NODRTYPE      9702
#define COMI_NODRTYPE_S    "No data record of requested type."

#define COMI_NSPROT        9703
#define COMI_NSPROT_S      "Unsupported protocol."

#define COMI_WPROT         9704
#define COMI_WPROT_S       "Wrong type of protocol."

#define COMI_INPRO         9705
#define COMI_INPRO_S       "Connect already in progress."

#define COMI_SOCKINVAL     9706
#define COMI_SOCKINVAL_S   "An invalid socket is used."

#define COMI_ALRDYCON      9707
#define COMI_ALRDYCON_S    "The socket is already connected."

#define COMI_NOSOCK        9708
#define COMI_NOSOCK_S      "An invalid socket descriptor is used."

#define COMI_IRREL         9709
#define COMI_IRREL_S       "An error irrelevant to the current operation has returned."

#define COMI_ACCESS        9710
#define COMI_ACCESS_S      "Access denied."

#define COMI_NETDOWN       9711
#define COMI_NETDOWN_S     "The network subsystem has failed."

#define COMI_HOSTNOTFOUND  9712
#define COMI_HOSTNOTFOUND_S "Host not found."

#define COMI_SHOSTNOTFOUND 9713
#define COMI_SHOSTNOTFOUND_S "Host not found or server failed."

#define COMI_NRERROR       9714
#define COMI_NRERROR_S     "Non recoverable error occured."

#define COMI_BLOCKED       9715
#define COMI_BLOCKED_S     "The request is blocked by a blocking request."

#define COMI_NAMEINVAL     9716
#define COMI_NAMEINVAL_S   "Request has invalid name or namelen argument."

#define COMI_CANCELLED     9717
#define COMI_CANCELLED_S   "Request was canceled."

#define COMI_AFNS          9718
#define COMI_AFNS_S        "Specified address family is not supported."

#define COMI_NSD           9719
#define COMI_NSD_S         "No more Socket Descriptor available."

#define COMI_NBUF          9720
#define COMI_NBUF_S        "No buffer space available to create a socket."

#define COMI_WSNSAF        9721
#define COMI_WSNSAF_S      "Unsupported socket type."

#define COMI_ADRINUSE      9722
#define COMI_ADRINUSE_S    "The address is already in use."

#define COMI_ADRNOTAVL     9723
#define COMI_ADRNOTAVL_S   "The address is not available from local machine."

#define COMI_CONRJCT       9724
#define COMI_CONRJCT_S     "The connect request was rejected."

#define COMI_NETUNREACH    9725
#define COMI_NETUNREACH_S  "The network is not reachable at this time."

#define COMI_TIMEOUT       9726
#define COMI_TIMEOUT_S     "The request timed out."

#define COMI_WDBLOCK       9727
#define COMI_WDBLOCK_S     "The request can not be completed immediately."

#define COMI_DESTADDR      9728
#define COMI_DESTADDR_S    "Destination address required."

#define COMI_PROTNA        9729
#define COMI_PROTNA_S      "Protocol not available."

#define COMI_NOTCON        9730
#define COMI_NOTCON_S      "The socket is not connected."

#define COMI_OPNOTSUP      9731
#define COMI_OPNOTSUP_S    "MSG_OOB was specified, but the socket is not stream style."

#define COMI_MSGSIZE       9732
#define COMI_MSGSIZE_S     "The message is larger than the maximum supported."

#define COMI_SRSOCKINVAL   9733
#define COMI_SRSOCKINVAL_S "The socket has not been bound with bind or an unknown flag was specified."

#define COMI_BUFINVAL      9734
#define COMI_BUFINVAL_S    "The buf argument is not totally contained in a valid part of the user address space."

#define COMI_NETRST        9735
#define COMI_NETRST_S      "The connection has been broken due to the remote host resetting."

#define COMI_SRSOCKSD      9736
#define COMI_SRSOCKSD_S    "The socket has been shutdown."

#define COMI_SRSOCKABT     9737
#define COMI_SRSOCKABT_S   "Virtual circuit aborted due to timeout/other failure. Application close socket - not useable."  /* PTM2314 */

#define COMI_SRSOCKRST     9738
#define COMI_SRSOCKRST_S   "The virtual circuit was reset by the remote side executing a hard or abortive close."

#define COMI_NONESENT      9739
#define COMI_NONESENT_S    "TCPIP returned zero sent length."

#define COMI_NONERECV      9740
#define COMI_NONERECV_S    "TCPIP returned zero received length."

#define COMI_UNKNOWN       9741
#define COMI_UNKNOWN_S     "TCPIP returned an unknown error."

#define COMI_PFNS          9742
#define COMI_PFNS_S        "Protocol family is not supported."

#define COMI_DIRNEMPTY     9743
#define COMI_DIRNEMPTY_S   "Directory not empty."

#define COMI_REMOTE        9744
#define COMI_REMOTE_S      "Item is not local to host."

#define COMI_TOOMANYREFS   9745
#define COMI_TOOMANYREFS_S "Too many references : can't splice."

#define COMI_LOOP          9746
#define COMI_LOOP_S        "Too many levels of symbolic links."

#define COMI_NAMETOOLONG   9747
#define COMI_NAMETOOLONG_S "Filename too long."

#define COMI_USER          9748
#define COMI_USER_S        "Too many users."

#define COMI_DQUOT         9749
#define COMI_DQUOT_S       "Disk quota exceeded."

#define COMI_PROCLIM       9750
#define COMI_PROCLIM_S     "Too many processes."

#define COMI_MFILE         9751
#define COMI_MFILE_S       "Too many open files."

#define COMI_BADF          9752
#define COMI_BADF_S        "Bad file descriptor."

#define COMI_STALE         9753
#define COMI_STALE_S       "No file system."

#define COMI_DISCON        9754
#define COMI_DISCON_S      "Disconnected."

#define COMI_NODATA        9755
#define COMI_NODATA_S      "Valid name, no data record of requested type."

#define COMI_SYSNOTREADY   9756
#define COMI_SYSNOTREADY_S "System not ready."

#define COMI_VERNOTSUP     9757
#define COMI_VERNOTSUP_S   "Version not supported."

#define COMI_NOSRAVAIL     9758
#define COMI_NOSRAVAIL_S   "No stream resource; insufficient stream memory resources available."

#define COMI_NOLINK        9759
#define COMI_NOLINK_S      "The link has been severed."

#define COMI_PROTO         9760
#define COMI_PROTO_S       "A device specific protocol error occurred."

#define COMI_MULTIHOP      9761
#define COMI_MULTIHOP_S    "Multihop access to a remote resource is not allowed."

#define COMI_COMMSEND      9762
#define COMI_COMMSEND_S    "Communication error on send."

#define COMI_REMCHG        9763
#define COMI_REMCHG_S      "Remote address changed."

#define COMI_IBMBADCALL    9764
#define COMI_IBMBADCALL_S  "Bad socket-call constant found in the IUCV header."

#define COMI_IBMBADPARM    9765
#define COMI_IBMBADPARM_S  "Other IUCV header error, bad length, etc."

#define COMI_IBMSOCKOUTOFRANGE 9766
#define COMI_IBMSOCKOUTOFRANGE_S "Socket number out of range."

#define COMI_IBMSOCKINUSE  9767
#define COMI_IBMSOCKINUSE_S "Socket number already in use."

#define COMI_IBMIUCVERR    9768
#define COMI_IBMIUCVERR_S  "Request failed due to IUCV error."

#define COMI_IBMCONFLICT   9769
#define COMI_IBMCONFLICT_S "Conflicting call already outstanding on socket."

// SEND ERROR END

#endif
