/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

#ifndef OTMAMSG_HPP
#define OTMAMSG_HPP
/*--------------------------------------------------------------------*/
/*                                                                    */
/* Change History:                                                    */
/*                                                                    */
/* 08\19\97  JEH   R210 Conversational processing                     */
/*                                                                    */
/*                 - add set/getConvID, setConversation, and          */
/*                   isConversation.                                  */
/*                                                                    */
/* 03/26/98  JEH   PTM2338 Add encryption exit.                       */
/*                                                                    */
/* 05/11/98  JEH   PTM2481 New OTMA msg format; LTERM override.       */
/*                                                                    */
/*--------------------------------------------------------------------*/

#include "hws.h"
#include "hwsymsg.h"

class HWSError;
class HWSConverter;

class DllExport OtmaMsg {

  public:

   /*-----------------------------------------------------------------*/
   /* Public Methods                                                  */
   /*-----------------------------------------------------------------*/
   OtmaMsg( unsigned short maxDataSize,
            unsigned short segSeqNum,
            HWSConverter   *cObj );
   ~OtmaMsg();

   unsigned short SegSeqNumber;	// seq number if ChainState	
   int     last();
   void    setFirst();
   void    setMiddle();
   void    setLast();

   void     setApplData(char * data,unsigned short length);
   char     *getApplData();
   int      getApplDataLength();

   void     setDestName(char *);
   char     *getDestName();

   void     setLtermName(char *);
   char     *getLtermName();

   void     setMidName(char *);
   char     *getModName();

   void     setSecInfo(SecInfo *);

   unsigned short getExportSize();

   char     *export(HWSError *errObj);
   void     import(HWSError *errObj, char * buf);

   /*-----------------------------------------------------------------*/
   /* Added for release 2.1.0                                         */
   /*-----------------------------------------------------------------*/
   void     setConvID( void *cID );
   void     *getConvID();
   void     setConversation();
   HWSBool  isConversation();
   void     setMsgTypeDATA();

   void     setSyncLevel();
   HWSBool  getSyncLevel();
   void     buildACK( char *imsName );
   void     buildNACK( char *imsName );
   void     buildExitCommit( char *imsname, void *cID, char *ltermOver ); // PTM2481
   void     buildExitAbort( char *imsname, void *cID, char *ltermOver );  // PTM2481

   void     setPassTckt( char          *userID,            /* PTM2338 */
                         char          *pTckt,             /* PTM2338 */
                         char          *passDataType );    /* PTM2338 */
   void     setPersistentSocket();
   void     setNonPersistentSocket();


  private:

   /*-----------------------------------------------------------------*/
   /* Private Attributes                                              */
   /*-----------------------------------------------------------------*/
	unsigned short  maxDataSize;
	void		       *buffer;
	MCI_Seg		    *qMCISeg;
	STATE_TRN_Seg   *qTRNSeg;
	SEC_Seg		    *qSECSeg;
	USD_Seg		    *qUSDSeg;
	APP_Seg		    *qAPPSeg;
   int             imported;
   HWSConverter    *convObj;

   /*-----------------------------------------------------------------*/
   /* Private Methods                                                 */
   /*-----------------------------------------------------------------*/
   int    buildMCISeg( MCI_Seg *qMCISeg);
   int    buildTRNSeg( STATE_TRN_Seg *qTRNSeg);
   int    buildSECSeg( SEC_Seg *qSECSeg);
   int    buildUSDSeg( USD_Seg *qUSDSeg);
   void   convertMCISeg( HWSError *errObj, MCI_Seg *qMCISeg );
   void   convertTRNSeg( HWSError *errObj, STATE_TRN_Seg *qTRNSeg );
   void   convertSECSeg( HWSError *errObj, SEC_Seg *qSECSeg );
   void   convertUSDSeg( HWSError *errObj, USD_Seg *qUSDSeg );
   void   buildResponseMsg( char *imsName );
   void   buildExitMsg( char *imsName, void *cID, char *ltermOver ); // PTM2481

};

#endif
