<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/XSL/Transform/1.0"
                xmlns="http://www.w3.org/TR/REC-html40"
                result-ns="">

<xsl:template match="XMI">
  <xsl:apply-templates select="XMI.content/EOM"/>
</xsl:template>

<!--==================================================================-->
<!--  EOM                                                             -->
<!--==================================================================-->
<xsl:template match="EOM">
  <HTML>
     <HEAD>
        <TITLE> Model: <xsl:value-of select="@xmi.label"/> </TITLE>
        <BASE TARGET="view"/>
     </HEAD>
     <BODY>
       <H2> Model: <xsl:value-of select="@xmi.label"/> </H2>

    <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
      <TR>
        <TD BGCOLOR="6FB6E2" COLSPAN="1">
          <B> Files with: BO Interface </B>
        </TD>
      </TR>
    </TABLE>

    <xsl:if test="EOMContents.repository/Repository/Repository.allFiles/GeneratedFile[File.fileType/@xmi.value='IDL']">
      <xsl:apply-templates select="EOMContents.repository/Repository/Repository.allFiles/GeneratedFile/GeneratedFile.sourceSegment[ModuleSource[SourceSegment.nested[InterfaceSource[InterfaceSource.interface[BOInterface]]]]]">
        <xsl:sort select="@xmi.label"/>       
      </xsl:apply-templates>
    </xsl:if>

    <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
      <TR>
        <TD BGCOLOR="6FB6E2" COLSPAN="1">
          <B> Files with: DO Interface </B>
        </TD>
      </TR>
    </TABLE>

    <xsl:if test="EOMContents.repository/Repository/Repository.allFiles/GeneratedFile[File.fileType/@xmi.value='IDL']">
      <xsl:apply-templates select="EOMContents.repository/Repository/Repository.allFiles/GeneratedFile/GeneratedFile.sourceSegment[ModuleSource[SourceSegment.nested[InterfaceSource[InterfaceSource.interface[DOInterface]]]]]">
        <xsl:sort select="@xmi.label"/>       
      </xsl:apply-templates>
    </xsl:if>

    <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
      <TR>
        <TD BGCOLOR="6FB6E2" COLSPAN="1">
          <B> Files with: Other Interfaces </B>
        </TD>
      </TR>
    </TABLE>

    <xsl:for-each select="EOMContents.repository/Repository/Repository.allFiles/GeneratedFile[File.fileType/@xmi.value='IDL']">
      <xsl:sort select="@xmi.label"/>
      <xsl:if test="not(GeneratedFile.sourceSegment/ModuleSource/SourceSegment.nested/InterfaceSource/InterfaceSource.interface[DOInterface]) and 
  	            not(GeneratedFile.sourceSegment/ModuleSource/SourceSegment.nested/InterfaceSource/InterfaceSource.interface[BOInterface])">
        <xsl:apply-templates select="GeneratedFile.sourceSegment">
	</xsl:apply-templates>
      </xsl:if>
    </xsl:for-each>

     </BODY>
   </HTML>
</xsl:template>


<!--==================================================================-->
<!--  Repository.allFiles                                             -->
<!--==================================================================-->
<xsl:template match="GeneratedFile/GeneratedFile.sourceSegment">

    <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
      <TR>
        <TD COLSPAN="1">
          <B> File: </B>
	 <A href="view.html#{../@xmi.id}"> <xsl:value-of select="../@xmi.label"/> </A> 
        </TD>
      </TR>
    </TABLE>

    <!--==================== MODULE LIST ====================-->
    <xsl:if test="ModuleSource">
	    <A NAME="view.html#{@xmi.id}:modules"><!-- --></A>

	      <xsl:for-each select="ModuleSource">
	          <xsl:sort select="id(ModuleSource.module/Module/@xmi.idref)/@xmi.label"/>
		    <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
		      <TR>
		        <TD WIDTH="5%"></TD>
		        <TD WIDTH="95%">
		          <B> Module: </B>
			<A href="view.html#{ModuleSource.module/Module/@xmi.idref}"> <xsl:value-of select='id(ModuleSource.module/Module/@xmi.idref)/@xmi.label'/> </A> 
		        </TD>
		      </TR>
		    </TABLE>
  		  <!--==================== INTERFACE LIST ====================-->
		  <xsl:choose>

			<xsl:when test="SourceSegment.nested/InterfaceSource/InterfaceSource.interface/BOInterface">
			     <A NAME="{@xmi.id}:BOs"><!-- --></A> 
                             <xsl:for-each select="SourceSegment.nested/InterfaceSource/InterfaceSource.interface/BOInterface">
  			       <xsl:sort select="id(@xmi.idref)/@xmi.label"/>
			       <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
			         <TR>
			           <TD WIDTH="5%"></TD>
			           <TD WIDTH="5%"></TD>
			           <TD WIDTH="90%">
  				     <B> BO Interface:</B>  <A href="view.html#{@xmi.idref}"> <xsl:value-of select='id(@xmi.idref)/@xmi.label'/> </A>
			           </TD>
			         </TR>
			       </TABLE><BR/>
			     </xsl:for-each>
		        </xsl:when>

			<xsl:when test="SourceSegment.nested/InterfaceSource/InterfaceSource.interface/DOInterface">
			     <A NAME="{@xmi.id}:DOs"><!-- --></A> 
			     <xsl:for-each select="SourceSegment.nested/InterfaceSource/InterfaceSource.interface/DOInterface">
			       <xsl:sort select="id(@xmi.idref)/@xmi.label"/>
			       <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
			        <TR>
			          <TD WIDTH="5%"></TD>
			          <TD WIDTH="5%"></TD>
			          <TD WIDTH="90%">
				    <B> DO Interface:</B>  <A href="view.html#{@xmi.idref}"> <xsl:value-of select='id(@xmi.idref)/@xmi.label'/> </A>
			          </TD>
			        </TR>
			       </TABLE><BR/>
			     </xsl:for-each>
		        </xsl:when>

			<xsl:otherwise>
			  <BR/>
			</xsl:otherwise>
			  
		  </xsl:choose>

	      </xsl:for-each>
    </xsl:if>

</xsl:template>


</xsl:stylesheet>
