/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log;

import com.ibm.ivb.log.NlsInputStream;
import com.ibm.ivb.log.Progress;
import com.ibm.ivb.log.RecIterator;
import com.ibm.ivb.log.datamodel.LogRecMetadata;
import com.ibm.ivb.log.datamodel.XmlUtils;
import com.ibm.ivb.log.ui.LogBrowser;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class LogRecIterator
implements RecIterator {
    private static final String logRecSeperator = "--------------------";
    private static final String logFileEndMarker = "records found and printed";
    private static final String ComponentIdPrefix = "ComponentId:";
    private static final String ProcessIdPrefix = "ProcessId:";
    private static final String ThreadIdPrefix = "ThreadId:";
    private static final String FunctionNamePrefix = "FunctionName:";
    private static final String ProbeIdPrefix = "ProbeId:";
    private static final String SourceIdPrefix = "SourceId:";
    private static final String ManufacturerPrefix = "Manufacturer:";
    private static final String ProductPrefix = "Product:";
    private static final String VersionPrefix = "Version:";
    private static final String SomProcessTypePrefix = "SOMProcessType:";
    private static final String ServerNamePrefix = "ServerName:";
    private static final String ClientHostNamePrefix = "clientHostName:";
    private static final String ClientUserIdPrefix = "clienUserId:";
    private static final String TimeStampPrefix = "TimeStamp:";
    private static final String UnitOfWorkPrefix = "UnitOfWork:";
    private static final String SeverityPrefix = "Severity:";
    private static final String CategoryPrefix = "Category:";
    private static final String FormatWarningPrefix = "FormatWarning:";
    private static final String PrimaryMessagePrefix = "PrimaryMessage:";
    private static final String ExtendedMessagePrefix = "ExtendedMessage:";
    private static final String RawDataLenPrefix = "RawDataLen:";
    private static final String RawDataPrefix = "RawData:";
    private BufferedReader reader;
    private int recordCount;
    private boolean endOfFile = false;
    private String line = "";

    private BufferedReader convertToTextFile(String string) {
        BufferedReader bufferedReader = null;
        String string2 = "showlog " + string + " -debug";
        try {
            Process process = Runtime.getRuntime().exec(string2);
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = bufferedReader.readLine();
            if (string3.startsWith(logRecSeperator)) {
                return bufferedReader;
            }
            bufferedReader.close();
            inputStreamReader.close();
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int getTotalRecordCount(File file) throws IOException {
        long l = file.length();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        if (l > 50L) {
            bufferedReader.skip(l - 50L);
        }
        String string = bufferedReader.readLine();
        while (string != null) {
            this.line = string;
            string = bufferedReader.readLine();
        }
        int n = Integer.parseInt(new StringTokenizer(this.line).nextToken());
        return n;
    }

    private int getTotalRecordCountFromBinFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        NlsInputStream nlsInputStream = new NlsInputStream(fileInputStream);
        int n = 0;
        byte by = nlsInputStream.readByte();
        nlsInputStream.setEndian(by);
        nlsInputStream.readNlsShort();
        nlsInputStream.readNlsShort();
        n = nlsInputStream.skipBytes(12);
        int n2 = nlsInputStream.readNlsInt();
        fileInputStream.close();
        return n2;
    }

    public LogRecIterator(String string) throws IOException {
        int n = 0;
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException(LogBrowser.getLBString("ComIbmIvbLogMsgFileNotExist"));
        }
        if (string.endsWith("activity.log")) {
            n = this.getTotalRecordCountFromBinFile(file);
            this.reader = this.convertToTextFile(string);
        }
        if (this.reader == null) {
            FileReader fileReader = null;
            try {
                n = this.getTotalRecordCount(file);
                fileReader = new FileReader(file);
            }
            catch (Exception exception) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
                exception.printStackTrace(printWriter);
                printWriter.flush();
                String string2 = byteArrayOutputStream.toString();
                string2 = String.valueOf(string2) + LogBrowser.getLBString("ComIbmIvbLogMsgCannotOpenLogFile") + "\n";
                throw new IOException(string2);
            }
            this.reader = new BufferedReader(fileReader);
            String string3 = this.reader.readLine();
            if (!string3.startsWith(logRecSeperator)) {
                throw new IOException(LogBrowser.getLBString("ComIbmIvbLogMsgInvalLogFile"));
            }
        }
        Progress.start(n);
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public LogRecMetadata getNextRecord() {
        LogRecMetadata logRecMetadata = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "";
        Vector<String> vector = null;
        Vector<String> vector2 = null;
        Vector<String> vector3 = null;
        boolean bl = false;
        try {
            StringTokenizer stringTokenizer = null;
            string = this.reader.readLine();
            bl = false;
            while (string != null) {
                if (logRecMetadata == null) {
                    logRecMetadata = new LogRecMetadata();
                }
                if (string.startsWith(logRecSeperator) || string.indexOf(logFileEndMarker) != -1) {
                    ++this.recordCount;
                    if (!string.startsWith(logRecSeperator)) {
                        this.endOfFile = true;
                    }
                    if (this.endOfFile) {
                        Progress.done();
                    } else {
                        Progress.increment();
                    }
                    return logRecMetadata;
                }
                stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.startsWith(ComponentIdPrefix)) {
                        if (stringTokenizer.hasMoreTokens()) {
                            string3 = stringTokenizer.nextToken();
                            logRecMetadata.setComponentId(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(ProcessIdPrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setProcessId(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(ThreadIdPrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setThreadId(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(FunctionNamePrefix)) {
                        String string6 = "";
                        while (stringTokenizer.hasMoreTokens()) {
                            if (!string6.equals("")) {
                                string6 = String.valueOf(string6) + " ";
                            }
                            string6 = String.valueOf(string6) + stringTokenizer.nextToken();
                        }
                        if (string6.equals("")) {
                            string = this.reader.readLine();
                            if (string != null && !(string2 = (stringTokenizer = new StringTokenizer(string)).nextToken()).startsWith(ProbeIdPrefix)) {
                                string6 = string2;
                                while (stringTokenizer.hasMoreTokens()) {
                                    string6 = String.valueOf(string6) + " " + stringTokenizer.nextToken();
                                }
                                string = this.reader.readLine();
                            }
                        } else {
                            string = this.reader.readLine();
                        }
                        logRecMetadata.setFunctionName(string6);
                        continue;
                    }
                    if (string2.startsWith(ProbeIdPrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setProbeId(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(SourceIdPrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            if (stringTokenizer.hasMoreTokens()) {
                                string3 = String.valueOf(string3) + " " + stringTokenizer.nextToken();
                            }
                            logRecMetadata.setSourceId(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(ManufacturerPrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setManufacturer(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(ProductPrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setProduct(string.substring(string.indexOf(string3)));
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(VersionPrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setVersion(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(SomProcessTypePrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setSOMProcessType(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(ServerNamePrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setServerName(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(ClientHostNamePrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setClientHostName(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(ClientUserIdPrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setClientUserId(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(TimeStampPrefix)) {
                        string5 = "";
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            string5 = new String(string3);
                        }
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            string5 = String.valueOf(string5) + " " + string3;
                        }
                        logRecMetadata.setTimeStamp(string5);
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(UnitOfWorkPrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setUnitOfWork(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(SeverityPrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setSeverity(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(CategoryPrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setCategory(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(FormatWarningPrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setFormatWarning(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(PrimaryMessagePrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            string4 = string.substring(string.indexOf(string3));
                            if (vector3 == null) {
                                vector3 = new Vector<String>();
                                logRecMetadata.setPrimaryMessagev(vector3);
                            }
                            vector3.addElement(XmlUtils.stripUnwantedChar(string4));
                        }
                        if ((string = this.reader.readLine()) == null) continue;
                        stringTokenizer = new StringTokenizer(string);
                        string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                        while (string2 != null && !string2.startsWith(ExtendedMessagePrefix)) {
                            if (vector2 == null) {
                                vector2 = new Vector<String>();
                                logRecMetadata.setPrimaryMessagev(vector2);
                            }
                            vector2.addElement(XmlUtils.stripUnwantedChar(string));
                            string = this.reader.readLine();
                            if (string != null) {
                                stringTokenizer = new StringTokenizer(string);
                                if (stringTokenizer.hasMoreTokens()) {
                                    string2 = stringTokenizer.nextToken();
                                    continue;
                                }
                                string2 = "";
                                continue;
                            }
                            string2 = null;
                        }
                        continue;
                    }
                    if (string2.startsWith(ExtendedMessagePrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            string4 = string.substring(string.indexOf(string3));
                            logRecMetadata.setExtendedMessage(XmlUtils.stripUnwantedChar(string4));
                        }
                        if ((string = this.reader.readLine()) == null) continue;
                        stringTokenizer = new StringTokenizer(string);
                        string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                        while (string2 != null && !string2.startsWith(RawDataLenPrefix)) {
                            if (vector2 == null) {
                                vector2 = new Vector();
                                logRecMetadata.setExtendedMessagev(vector2);
                            }
                            vector2.addElement(XmlUtils.stripUnwantedChar(string));
                            string = this.reader.readLine();
                            if (string != null) {
                                stringTokenizer = new StringTokenizer(string);
                                if (stringTokenizer.hasMoreTokens()) {
                                    string2 = stringTokenizer.nextToken();
                                    continue;
                                }
                                string2 = "";
                                continue;
                            }
                            string2 = null;
                        }
                        continue;
                    }
                    if (string2.startsWith(RawDataLenPrefix)) {
                        if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("")) {
                            logRecMetadata.setRawDataLen(string3);
                        }
                        string = this.reader.readLine();
                        continue;
                    }
                    if (string2.startsWith(RawDataPrefix)) {
                        vector = new Vector<String>();
                        logRecMetadata.setRawDatav(vector);
                        while ((string = this.reader.readLine()) != null) {
                            if (string.startsWith(logRecSeperator) || string.indexOf(logFileEndMarker) != -1) {
                                if (!string.startsWith(logRecSeperator)) {
                                    this.endOfFile = true;
                                }
                                ++this.recordCount;
                                return logRecMetadata;
                            }
                            vector.addElement(string);
                        }
                        continue;
                    }
                    string = this.reader.readLine();
                    continue;
                }
                string = this.reader.readLine();
            }
            if (logRecMetadata != null) {
                ++this.recordCount;
            }
            Progress.done();
            return logRecMetadata;
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            String string7 = byteArrayOutputStream.toString();
            System.err.println(string7);
            System.err.flush();
            return null;
        }
    }

    public String toString() {
        return "LogRecIterator[recordCount=" + this.recordCount + ']';
    }
}

