/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log;

import com.ibm.ivb.log.Progress;
import com.ibm.ivb.log.TreeBuilder;
import com.ibm.ivb.log.datamodel.FilterRecMetadata;
import com.ibm.ivb.log.datamodel.LogFileMetadata;
import com.ibm.ivb.log.datamodel.LogRecMetadata;
import com.ibm.ivb.log.datamodel.XmlUtils;
import com.ibm.xml.parser.TXDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LogXml {
    public static Vector processFilterRecvNode(Element element, TreeBuilder treeBuilder) throws IOException {
        Vector<FilterRecMetadata> vector = null;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equalsIgnoreCase("filterrec")) {
                FilterRecMetadata filterRecMetadata = LogXml.processFilterRecNode((Element)node, treeBuilder);
                if (vector == null) {
                    vector = new Vector<FilterRecMetadata>();
                }
                vector.addElement(filterRecMetadata);
            }
            node = node.getNextSibling();
        }
        return vector;
    }

    public static FilterRecMetadata processFilterRecNode(Element element, TreeBuilder treeBuilder) throws IOException {
        FilterRecMetadata filterRecMetadata = new FilterRecMetadata();
        if (element.getAttribute("filtername") != null) {
            filterRecMetadata.setFilterName(new String(element.getAttribute("filtername")));
        }
        if (element.getAttribute("filtervalue") != null) {
            filterRecMetadata.setFilterValue(new String(element.getAttribute("filtervalue")));
        }
        if (element.getAttribute("timestamp") != null) {
            filterRecMetadata.setTimeStamp(new String(element.getAttribute("timestamp")));
        }
        if (element.getAttribute("severity") != null) {
            filterRecMetadata.setSeverity(new String(element.getAttribute("severity")));
        }
        if (treeBuilder != null) {
            treeBuilder.addRecordFilterNode(filterRecMetadata);
        }
        Node node = element.getFirstChild();
        while (node != null) {
            Vector vector;
            if (node.getNodeName().equalsIgnoreCase("logrecv") && (vector = LogXml.processLogRecvNode((Element)node, treeBuilder)) != null) {
                filterRecMetadata.setLogRecv(vector);
            }
            node = node.getNextSibling();
        }
        return filterRecMetadata;
    }

    public static Vector processLogRecvNode(Element element, TreeBuilder treeBuilder) throws IOException {
        Vector<LogRecMetadata> vector = null;
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equalsIgnoreCase("logrec")) {
                LogRecMetadata logRecMetadata = LogXml.processLogRecNode((Element)node);
                if (treeBuilder != null) {
                    treeBuilder.addRecordNode(logRecMetadata);
                }
                ++n;
                if (vector == null) {
                    vector = new Vector<LogRecMetadata>();
                }
                vector.addElement(logRecMetadata);
            }
            node = node.getNextSibling();
        }
        return vector;
    }

    public static LogRecMetadata processLogRecNode(Element element) {
        String string = null;
        LogRecMetadata logRecMetadata = new LogRecMetadata();
        string = element.getAttribute("recordid");
        if (string != null && !string.equals("")) {
            logRecMetadata.setRecordId(new String(string));
        }
        if ((string = element.getAttribute("componentid")) != null && !string.equals("")) {
            logRecMetadata.setComponentId(new String(string));
        }
        if ((string = element.getAttribute("processid")) != null && !string.equals("")) {
            logRecMetadata.setProcessId(new String(string));
        }
        if ((string = element.getAttribute("threadid")) != null && !string.equals("")) {
            logRecMetadata.setThreadId(new String(string));
        }
        if ((string = element.getAttribute("functionname")) != null && !string.equals("")) {
            logRecMetadata.setFunctionName(new String(string));
        }
        if ((string = element.getAttribute("probeid")) != null && !string.equals("")) {
            logRecMetadata.setProbeId(new String(string));
        }
        if ((string = element.getAttribute("sourceid")) != null && !string.equals("")) {
            logRecMetadata.setSourceId(new String(string));
        }
        if ((string = element.getAttribute("manufacturer")) != null && !string.equals("")) {
            logRecMetadata.setManufacturer(new String(string));
        }
        if ((string = element.getAttribute("product")) != null && !string.equals("")) {
            logRecMetadata.setProduct(new String(string));
        }
        if ((string = element.getAttribute("version")) != null && !string.equals("")) {
            logRecMetadata.setVersion(new String(string));
        }
        if ((string = element.getAttribute("somprocesstype")) != null && !string.equals("")) {
            logRecMetadata.setSOMProcessType(new String(string));
        }
        if ((string = element.getAttribute("servername")) != null && !string.equals("")) {
            logRecMetadata.setServerName(new String(string));
        }
        if ((string = element.getAttribute("clienthostname")) != null && !string.equals("")) {
            logRecMetadata.setClientHostName(new String(string));
        }
        if ((string = element.getAttribute("clientuserid")) != null && !string.equals("")) {
            logRecMetadata.setClientUserId(new String(string));
        }
        if ((string = element.getAttribute("timestamp")) != null && !string.equals("")) {
            logRecMetadata.setTimeStamp(new String(string));
        }
        if ((string = element.getAttribute("unitofwork")) != null && !string.equals("")) {
            logRecMetadata.setUnitOfWork(new String(string));
        }
        if ((string = element.getAttribute("severity")) != null && !string.equals("")) {
            logRecMetadata.setSeverity(new String(string));
        }
        if ((string = element.getAttribute("category")) != null && !string.equals("")) {
            logRecMetadata.setCategory(new String(string));
        }
        if ((string = element.getAttribute("formatwarning")) != null && !string.equals("")) {
            logRecMetadata.setFormatWarning(new String(string));
        }
        if ((string = element.getAttribute("processtype")) != null && !string.equals("")) {
            logRecMetadata.setProcessType(new String(string));
        }
        if ((string = element.getAttribute("primmsgid")) != null && !string.equals("")) {
            logRecMetadata.setPrimMsgId(new String(string));
        }
        if ((string = element.getAttribute("primmsgsetno")) != null && !string.equals("")) {
            logRecMetadata.setPrimMsgSetNo(new String(string));
        }
        if ((string = element.getAttribute("primmsgcat")) != null && !string.equals("")) {
            logRecMetadata.setPrimMsgCat(new String(string));
        }
        if (element.getAttribute("primarymessage") != null) {
            logRecMetadata.setPrimaryMessage(new String(element.getAttribute("primarymessage")));
        }
        if ((string = element.getAttribute("primmsgminorcode")) != null && !string.equals("")) {
            logRecMetadata.setPrimMsgMinorCode(new String(string));
        }
        if ((string = element.getAttribute("extendedmessage")) != null && !string.equals("")) {
            logRecMetadata.setExtendedMessage(new String(string));
        }
        if ((string = element.getAttribute("extmsgid")) != null && !string.equals("")) {
            logRecMetadata.setExtMsgId(new String(string));
        }
        if ((string = element.getAttribute("extmsgsetno")) != null && !string.equals("")) {
            logRecMetadata.setExtMsgSetNo(new String(string));
        }
        if ((string = element.getAttribute("extmsgcat")) != null && !string.equals("")) {
            logRecMetadata.setExtMsgCat(new String(string));
        }
        if ((string = element.getAttribute("extmsgRef")) != null && !string.equals("")) {
            logRecMetadata.setExtMsgRef(new String(string));
        }
        if ((string = element.getAttribute("orbtracestatus")) != null) {
            logRecMetadata.setOrbTraceStatus(new String(string));
        }
        if ((string = element.getAttribute("gpfstatus")) != null) {
            logRecMetadata.setGpfStatus(new String(string));
        }
        if ((string = element.getAttribute("symptomstatus")) != null && !string.equals("")) {
            logRecMetadata.setSymptomStatus(new String(string));
        }
        if ((string = element.getAttribute("rawdatalen")) != null && !string.equals("")) {
            logRecMetadata.setRawDataLen(new String(string));
        }
        Node node = element.getFirstChild();
        while (node != null) {
            Vector vector;
            if (node.getNodeName().equalsIgnoreCase("primarymessagev") && (vector = XmlUtils.processStringVecNode((Element)node)) != null) {
                logRecMetadata.setPrimaryMessagev(vector);
            }
            if (node.getNodeName().equalsIgnoreCase("extendedmessagev") && (vector = XmlUtils.processStringVecNode((Element)node)) != null) {
                logRecMetadata.setExtendedMessagev(vector);
            }
            if (node.getNodeName().equalsIgnoreCase("rawdatav") && (vector = XmlUtils.processStringVecNode((Element)node)) != null) {
                logRecMetadata.setRawDatav(vector);
            }
            if (node.getNodeName().equalsIgnoreCase("symptomv") && (vector = XmlUtils.processStringVecNode((Element)node)) != null) {
                logRecMetadata.setSymptomv(vector);
            }
            if (node.getNodeName().equalsIgnoreCase("orbtracedatav") && (vector = XmlUtils.processStringVecNode((Element)node)) != null) {
                logRecMetadata.setOrbTraceDatav(vector);
            }
            if (node.getNodeName().equalsIgnoreCase("gpfdatav") && (vector = XmlUtils.processStringVecNode((Element)node)) != null) {
                logRecMetadata.setGpfDatav(vector);
            }
            node = node.getNextSibling();
        }
        Progress.increment();
        return logRecMetadata;
    }

    public static LogFileMetadata genLogFileMetadata(TXDocument tXDocument, TreeBuilder treeBuilder) {
        try {
            String string;
            if (tXDocument != null && (string = tXDocument.getRootName()) != null && string.equalsIgnoreCase("logfile")) {
                LogFileMetadata logFileMetadata = new LogFileMetadata();
                Element element = tXDocument.getDocumentElement();
                if (element.getAttribute("filtername") != null) {
                    logFileMetadata.setFilterName(new String(element.getAttribute("filtername")));
                    treeBuilder.setFilterName(logFileMetadata.getFilterName());
                }
                if (element.getAttribute("totalrecords") != null) {
                    logFileMetadata.setTotalRecords(new String(element.getAttribute("totalrecords")));
                    Progress.start(Integer.parseInt(logFileMetadata.getTotalRecords()));
                }
                Node node = element.getFirstChild();
                while (node != null) {
                    Vector vector;
                    if (node.getNodeName().equalsIgnoreCase("logrecv") && (vector = LogXml.processLogRecvNode((Element)node, treeBuilder)) != null) {
                        logFileMetadata.setLogRecv(vector);
                    }
                    if (node.getNodeName().equalsIgnoreCase("filterrecv") && (vector = LogXml.processFilterRecvNode((Element)node, treeBuilder)) != null) {
                        logFileMetadata.setFilterRecv(vector);
                    }
                    node = node.getNextSibling();
                }
                Progress.done();
                return logFileMetadata;
            }
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            byteArrayOutputStream.toString();
            return null;
        }
        return null;
    }
}

