/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log;

import com.ibm.ivb.log.LogUtils;
import com.ibm.ivb.log.NonuiConstants;
import com.ibm.ivb.log.datamodel.LogRecMetadata;
import com.ibm.ivb.log.datamodel.RecMetadata;
import com.ibm.ivb.log.ui.LogBrowser;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Hashtable;

public class Record
implements NonuiConstants {
    public Hashtable analysisResults;
    public String RecName = "FunctionName";
    public String AltRecName = "PrimaryMessage";
    public String FilterName = "UnitOfWork";
    private static Field FilterNameField = null;
    private static Field RecNameField = null;
    private static Field AltRecNameField = null;
    private int severity = -1;
    private long timeStamp;
    public LogRecMetadata recdata;
    private Status status;
    private String text;
    private String recordName;
    private String analysisText;
    private String gpfText;
    private String uow;
    private String minorCodeUrl;

    public RecMetadata getRecordMetadata() {
        return this.recdata;
    }

    public int getSeverity() {
        String string;
        if (this.severity == -1 && (string = this.recdata.getSeverity()) != null) {
            this.severity = Integer.valueOf(string);
        }
        return this.severity;
    }

    public LogRecMetadata getLogRecMetadata() {
        return this.recdata;
    }

    public void setLogRecMetadata(LogRecMetadata logRecMetadata) {
        this.recdata = logRecMetadata;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        if (status.isHigherPriorityThan(this.status)) {
            this.status = status;
        }
    }

    public String getAnalysisResults(String string) {
        String string2 = (String)this.analysisResults.get(string);
        return string2;
    }

    public void setAnalysisResults(String string, String string2) {
        this.analysisResults.put(string, string2);
    }

    public Record(LogRecMetadata logRecMetadata) throws IOException {
        this.recdata = logRecMetadata;
        String string = this.recdata.getTimeStamp();
        this.timeStamp = LogUtils.toTimeStampVal(string);
        try {
            RecNameField = logRecMetadata.getClass().getField(this.RecName);
            AltRecNameField = logRecMetadata.getClass().getField(this.AltRecName);
            FilterNameField = logRecMetadata.getClass().getField(this.FilterName);
        }
        catch (Exception exception) {
            throw new IOException(String.valueOf(LogBrowser.getLBString("ComIbmIvbLogMsgInternalError")) + " 1");
        }
        this.analysisResults = new Hashtable();
        this.resetAnalysis();
    }

    public void resetAnalysis() {
        this.status = Status.unknown;
    }

    public void resetAdvanceAnalysis() {
        this.status = Status.unknown;
    }

    public void startAnalysis() {
        this.status = Status.mystery;
    }

    public String toString() {
        return this.getRecordName();
    }

    public String getRecordText() {
        if (this.text == null) {
            this.text = this.recdata.toString();
        }
        return this.text;
    }

    public String getRecordName() {
        block3: {
            if (this.recordName != null) break block3;
            try {
                String string = (String)RecNameField.get(this.recdata);
                if (string != null) {
                    this.recordName = String.valueOf(this.recdata.getRecordId()) + "_" + Record.prettifyFunctionName(string);
                    break block3;
                }
                this.recordName = String.valueOf(this.recdata.getRecordId()) + "_" + AltRecNameField.get(this.recdata);
            }
            catch (Exception exception) {
                System.err.println(String.valueOf(LogBrowser.getLBString("ComIbmIvbLogMsgInternalError")) + " 2");
                System.err.flush();
            }
        }
        return this.recordName;
    }

    public String getExtendedMessage() {
        return this.recdata.getExtendedMessage();
    }

    public String getPrimaryMessage() {
        return this.recdata.getPrimaryMessage();
    }

    public String getMinorCodeCheckText() {
        String string = this.recdata.getPrimaryMessage();
        string = String.valueOf(string) + this.recdata.getPrimaryMessagev().toString();
        return string;
    }

    public String getFilterValue() {
        if (this.uow == null) {
            try {
                this.uow = (String)FilterNameField.get(this.recdata);
            }
            catch (Exception exception) {
                System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgInvalRecFilterVal"));
                System.err.flush();
            }
            if (this.uow == null) {
                this.uow = "";
            }
        }
        return this.uow;
    }

    public String getUnitOfWork() {
        if (this.uow == null) {
            this.uow = this.recdata.getUnitOfWork();
            if (this.uow == null) {
                this.uow = "";
            }
        }
        return this.uow;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getTimeStampString() {
        return this.recdata.getTimeStamp();
    }

    public static String prettifyFunctionName(String string) {
        int n;
        int n2 = string.indexOf(40);
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        if ((n = string.lastIndexOf("::")) >= 0) {
            String string2 = string.substring(n + 2);
            String string3 = string.substring(0, n);
            return String.valueOf(string2) + " @ " + string3;
        }
        return string;
    }

    public static class Status {
        private static int priorityCounter;
        private static Hashtable statusMap;
        private int priority;
        private String name;
        public static final Status unknown;
        public static final Status mystery;
        public static final Status nothing;
        public static final Status cascade;
        public static final Status diagnosed;

        private Status(String string) {
            this.name = string;
            this.priority = priorityCounter++;
            statusMap.put(string, this);
        }

        public boolean isHigherPriorityThan(Status status) {
            return this.priority > status.priority;
        }

        public String toString() {
            return this.name;
        }

        public static Status fromString(String string) {
            return (Status)statusMap.get(string);
        }

        static {
            statusMap = new Hashtable();
            unknown = new Status("unknown");
            mystery = new Status("mystery");
            nothing = new Status("nothing");
            cascade = new Status("cascade");
            diagnosed = new Status("diagnosed");
        }
    }
}

