/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log;

import com.ibm.ivb.log.LogUtils;
import com.ibm.ivb.log.Record;
import com.ibm.ivb.log.datamodel.FilterRecMetadata;
import com.ibm.ivb.log.datamodel.LogRecMetadata;
import com.ibm.ivb.log.tree.RecordFilterNode;
import com.ibm.ivb.log.tree.RecordNode;
import com.ibm.ivb.log.tree.RootNode;
import java.io.IOException;

public class TreeBuilder {
    private RootNode root;
    private RecordFilterNode filternode;
    private String FilterName;
    private boolean initialBuild = true;
    private RecordFilterNode discardRecordFilterNode;

    public TreeBuilder(RootNode rootNode, String string) {
        this.root = rootNode;
        this.FilterName = string;
        this.root.setFilterName(string);
        if (this.root.getChildCount() > 0) {
            this.initialBuild = false;
        }
    }

    public void setFilterName(String string) {
        this.FilterName = string;
        this.root.setFilterName(string);
    }

    public void addRecordFilterNode(FilterRecMetadata filterRecMetadata) {
        String string = filterRecMetadata.getFilterValue();
        long l = LogUtils.toTimeStampVal(filterRecMetadata.getTimeStamp());
        int n = Integer.valueOf(filterRecMetadata.getSeverity());
        if (this.initialBuild) {
            this.filternode = new RecordFilterNode(string, l, filterRecMetadata.getTimeStamp());
            this.filternode.setSeverity(n);
            this.root.addRecordFilterNode(this.filternode);
            return;
        }
        this.filternode = this.root.getRecordFilterNode(string);
        if (this.filternode == null) {
            this.filternode = new RecordFilterNode(string, l, filterRecMetadata.getTimeStamp());
            this.filternode.setSeverity(n);
            this.root.insertRecordFilterNode(this.filternode);
            return;
        }
        if (l > this.filternode.getTimeStamp()) {
            this.filternode.setTimeStamp(l);
            this.filternode.setTimeStampString(filterRecMetadata.getTimeStamp());
        }
        if (n < this.filternode.getSeverity()) {
            this.filternode.setSeverity(n);
        }
    }

    public void addRecordNode(LogRecMetadata logRecMetadata) throws IOException {
        Record record = new Record(logRecMetadata);
        RecordNode recordNode = new RecordNode(record);
        if (this.initialBuild) {
            if (this.filternode != null) {
                this.filternode.addRecordNode(recordNode);
                return;
            }
            this.root.addRecordNode(recordNode);
            return;
        }
        if (this.FilterName == null || this.FilterName == "none") {
            this.root.addRecordNode(recordNode);
            return;
        }
        this.filternode = this.root.getRecordFilterNode(record.getFilterValue());
        if (this.filternode == null) {
            this.addRecord(record);
            return;
        }
        this.filternode.insertRecordNode(recordNode);
    }

    public void addRecord(Record record) {
        RecordNode recordNode = new RecordNode(record);
        if (this.FilterName == null || this.FilterName.equals("none")) {
            if (this.initialBuild) {
                this.root.addRecordNode(recordNode);
                return;
            }
            this.root.insertRecordNode(recordNode);
            return;
        }
        String string = record.getFilterValue();
        this.filternode = this.root.getRecordFilterNode(string);
        if (this.filternode == null) {
            this.filternode = new RecordFilterNode(string, record.getTimeStamp(), record.getTimeStampString());
            this.root.insertRecordFilterNode(this.filternode);
            this.filternode.setSeverity(record.getSeverity());
            this.filternode.addRecordNode(recordNode);
            return;
        }
        if (record.getTimeStamp() > this.filternode.getTimeStamp()) {
            this.filternode.setTimeStamp(record.getTimeStamp());
            this.filternode.setTimeStampString(record.getTimeStampString());
        }
        if (record.getSeverity() < this.filternode.getSeverity()) {
            this.filternode.setSeverity(record.getSeverity());
        }
        this.filternode.insertRecordNode(recordNode);
    }

    public void reorderRecordFilterNodes() {
        this.root.reorderRecordFilterNodes();
    }

    public void addRecordFilterNode(RecordFilterNode recordFilterNode) {
        this.filternode = recordFilterNode;
        this.root.addRecordFilterNode(recordFilterNode);
        this.discardRecordFilterNode = recordFilterNode;
    }

    public void addRecordNode(RecordNode recordNode) {
        Record record = recordNode.getRecord();
        String string = record.getFilterValue();
        this.filternode = this.root.getRecordFilterNode(string);
        if (this.filternode == null) {
            this.filternode = new RecordFilterNode(string, record.getTimeStamp(), record.getTimeStampString());
            this.root.insertRecordFilterNode(this.filternode);
            this.filternode.setSeverity(record.getSeverity());
            this.filternode.addRecordNode(recordNode);
            return;
        }
        if (this.filternode.equals(this.discardRecordFilterNode)) {
            return;
        }
        if (record.getTimeStamp() > this.filternode.getTimeStamp()) {
            this.filternode.setTimeStamp(record.getTimeStamp());
            this.filternode.setTimeStampString(record.getTimeStampString());
        }
        if (record.getSeverity() < this.filternode.getSeverity()) {
            this.filternode.setSeverity(record.getSeverity());
        }
        this.filternode.insertRecordNode(recordNode);
    }
}

