/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.tree;

import com.ibm.ivb.log.Record;
import com.ibm.ivb.log.tree.Node;
import com.ibm.ivb.log.tree.Visitor;
import java.util.Vector;

public abstract class ParentNode
extends Node {
    protected Vector children = new Vector();
    protected int childCount;
    protected int lastPos;

    public int getChildCount() {
        return this.childCount;
    }

    public Node getChild(int n) {
        return (Node)this.children.elementAt(n);
    }

    public int getIndexOfChild(Object object) {
        return ((Node)object).getIndex();
    }

    public boolean isLeaf() {
        return this.childCount == 0;
    }

    public void removeChildren() {
        this.childCount = 0;
        this.children.removeAllElements();
    }

    public int addChild(Node node) {
        node.setIndex(this.childCount);
        this.children.addElement(node);
        this.lastPos = this.childCount++;
        return this.lastPos;
    }

    public int insertChild(Node node) {
        int n = this.childCount;
        if (this.childCount == 0 || ((Node)this.children.elementAt(this.childCount - 1)).isSortLower(node)) {
            node.setIndex(this.childCount);
            this.children.addElement(node);
        } else {
            n = ((Node)this.children.elementAt(this.lastPos)).isSortLower(node) ? this.findChildPosition(node, this.lastPos, this.childCount - 1) : (node.isSortLower((Node)this.children.elementAt(0)) ? 0 : (this.lastPos == 0 ? 1 : this.findChildPosition(node, 0, this.lastPos)));
            node.setIndex(n);
            this.children.insertElementAt(node, n);
        }
        this.lastPos = n;
        ++this.childCount;
        return n;
    }

    public int findChildPosition(Node node, int n, int n2) {
        while (n2 != n + 1) {
            int n3 = (n + n2) / 2;
            if (((Node)this.children.elementAt(n3)).isSortLower(node)) {
                n = n3;
                continue;
            }
            n2 = n3;
        }
        return n2;
    }

    public abstract void addRecord(Record var1);

    public void visitChildren(Visitor visitor) {
        int n = 0;
        while (n < this.childCount) {
            ((Node)this.children.elementAt(n)).visit(visitor);
            ++n;
        }
    }
}

