/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.tree;

import com.ibm.ivb.log.Analyzer;
import com.ibm.ivb.log.AppModel;
import com.ibm.ivb.log.LogFile;
import com.ibm.ivb.log.Record;
import com.ibm.ivb.log.tree.LogTreeModel;
import com.ibm.ivb.log.tree.Node;
import com.ibm.ivb.log.tree.Severity;
import com.ibm.ivb.log.tree.Visitor;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class RecordNode
extends Node
implements Severity {
    private Record record;
    private boolean analysisDone = false;
    private boolean advanceAnalysisDone = false;

    public RecordNode(Record record) {
        this.record = record;
        this.setTimeStamp(record.getTimeStamp());
    }

    public boolean isSortLower(Node node) {
        return this.getTimeStamp() < node.getTimeStamp();
    }

    public String toString() {
        String string = null;
        if (string == null || string.length() == 0) {
            string = this.record.getRecordName();
        }
        if (string == null || string.length() == 0) {
            string = this.record.getExtendedMessage();
        }
        if (string == null || string.length() == 0) {
            string = this.record.getPrimaryMessage();
        }
        if (string == null || string.length() == 0) {
            string = "Severity " + this.record.getSeverity();
        }
        return string;
    }

    public int getSeverity() {
        return this.record.getSeverity();
    }

    public Record getRecord() {
        return this.record;
    }

    public void analyze() {
        this.record.setStatus(Record.Status.mystery);
        AppModel.getLogTreeModel();
        Hashtable hashtable = LogTreeModel.getAnalyzers();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ((Analyzer)enumeration.nextElement()).analyze(this.record);
        }
        this.analysisDone = true;
    }

    public void advanceAnalyze(String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            AppModel.getLogTreeModel();
            LogTreeModel.getAdvanceAnalyzer(string).setParameter(string2);
        }
        AppModel.getLogTreeModel();
        LogTreeModel.getAdvanceAnalyzer(string).analyze(this.record);
        this.advanceAnalysisDone = true;
    }

    public void resetAnalyze() {
        this.analysisDone = false;
        this.record.resetAnalysis();
    }

    public void resetAdvanceAnalyze() {
        this.advanceAnalysisDone = false;
        this.record.resetAdvanceAnalysis();
    }

    public String getAnalysisResult(String string) {
        return this.record.getAnalysisResults(string);
    }

    public String getText() {
        return this.record.getRecordText();
    }

    public void save(String string, String string2) throws IOException {
        LogFile logFile = new LogFile(this);
        if (string2.equals("xml")) {
            logFile.saveAsXML(string);
            return;
        }
        logFile.saveAsText(string);
    }

    public void visit(Visitor visitor) {
        visitor.visitRecordNode(this);
    }

    public boolean isAnalysisDone() {
        return this.analysisDone;
    }

    public boolean isAdvanceAnalysisDone() {
        return this.advanceAnalysisDone;
    }
}

