/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.Action;
import com.ibm.ivb.jface.Application;
import com.ibm.ivb.jface.BrowserFrame;
import com.ibm.ivb.jface.JFaceContext;
import com.ibm.ivb.jface.MenuComponentData;
import com.ibm.ivb.jface.MenuData;
import com.ibm.ivb.jface.MenuItemData;
import com.ibm.ivb.jface.ToolBarButtonData;
import com.ibm.ivb.jface.ToolBarContribution;
import com.ibm.ivb.jface.util.ImageUtil;
import com.ibm.ivb.log.AppModel;
import com.ibm.ivb.log.LogFile;
import com.ibm.ivb.log.constants.LBConstants;
import com.ibm.ivb.log.tree.Node;
import com.ibm.ivb.log.ui.FocusSensitiveAction;
import com.ibm.ivb.log.ui.HelpConstants;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.UIConstants;
import com.ibm.ivb.log.ui.util.FileHelper;
import com.ibm.ivb.log.ui.util.FindAndReplace;
import com.ibm.ivb.log.ui.util.GenericFileFilter;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.preview.filechooser.FileFilter;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class LBUtilities
implements LBConstants,
UIConstants,
TranslatableConstants,
HelpConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static String _htmlHelpDir = null;
    private static final String prefixForNoVabhelp = new String("file://");
    private static final String SAVE_TARGET_FILE_TYPE_XML = new String("xml");

    public static Icon loadIcon(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.ivb.log.ui.LogBrowser");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(String.valueOf(classNotFoundException) + "\nProgramming error -- images moved?");
        }
        return ImageUtil.loadIcon(clazz, (String)string);
    }

    public static Image loadImage(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.ivb.log.ui.LogBrowser");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(String.valueOf(classNotFoundException) + "\nProgramming error -- images moved?");
        }
        return ImageUtil.loadImage(clazz, (String)string);
    }

    public static void addAMenuItem(Application application, MenuData menuData, String string, String string2, Icon icon, Action action) {
        MenuItemData menuItemData = application.getMenuItemData(string);
        menuItemData.setActionCommand(string2);
        menuItemData.setIcon(icon);
        menuItemData.setAction(action);
        menuItemData.setShared(true);
        menuData.add((MenuComponentData)menuItemData);
    }

    public static void addAMenuItem(Application application, MenuData menuData, String string, Icon icon, FocusSensitiveAction focusSensitiveAction, JFaceContext jFaceContext) {
        LBUtilities.addAMenuItem(application, menuData, string, focusSensitiveAction.getActionCommand(), icon, focusSensitiveAction);
        jFaceContext.addFocusAction((Action)focusSensitiveAction);
    }

    public static void addAToolbarButton(Application application, ToolBarContribution toolBarContribution, String string, String string2, String string3, Icon icon, Action action) {
        ToolBarButtonData toolBarButtonData = new ToolBarButtonData(application.getString(string), false, icon, application.getString(string2));
        toolBarButtonData.setAction(action);
        toolBarButtonData.setShared(true);
        toolBarContribution.add(toolBarButtonData);
    }

    public static void addAToolbarButton(Application application, ToolBarContribution toolBarContribution, String string, String string2, Icon icon, FocusSensitiveAction focusSensitiveAction, JFaceContext jFaceContext) {
        LBUtilities.addAToolbarButton(application, toolBarContribution, string, string2, focusSensitiveAction.getActionCommand(), icon, focusSensitiveAction);
        jFaceContext.addFocusAction((Action)focusSensitiveAction);
    }

    public static BrowserFrame getBrowserFrame(Component component) {
        BrowserFrame browserFrame;
        try {
            Class<?> clazz = Class.forName("com.ibm.ivb.jface.BrowserFrame");
            browserFrame = (BrowserFrame)SwingUtilities.getAncestorOfClass(clazz, (Component)component);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(classNotFoundException);
            browserFrame = new BrowserFrame();
        }
        return browserFrame;
    }

    public static FileFilter getOpenLogFileFilter() {
        return new GenericFileFilter(new String[]{"xml", "txt"}, LogBrowser.getLBString("ComIbmIvbLogUiFileChooserFilterLogFiles"));
    }

    public static FileFilter getSaveLogTextFileFilter() {
        return new GenericFileFilter(new String[]{"txt"}, LogBrowser.getLBString("ComIbmIvbLogUiFileChooserFilterLogFiles"));
    }

    public static FileFilter getSaveLogXmlFileFilter() {
        return new GenericFileFilter(new String[]{"xml"}, LogBrowser.getLBString("ComIbmIvbLogUiFileChooserFilterLogFiles"));
    }

    public static FileFilter getMapFileFilter() {
        return new GenericFileFilter(new String[]{"map"}, LogBrowser.getLBString("ComIbmIvbLogUiFileChooserFilterMapFiles"));
    }

    public static String getAnalysisDocDirectory() {
        return "file://localhost:0/" + AppModel.getAppHome() + "/";
    }

    public static String getHelpDirectory() {
        if (_htmlHelpDir == null) {
            String string = AppModel.getVabHelp();
            _htmlHelpDir = string == null || string.trim().length() == 0 ? String.valueOf(prefixForNoVabhelp) + AppModel.getAppHome() + "/" : new String(string);
        }
        return _htmlHelpDir;
    }

    public static String getRelativeHelpPathName(String string) {
        String string2 = AppModel.getVabHelp();
        int n = -1;
        String string3 = string;
        if ((string2 == null || string2.trim().length() == 0) && (n = string.indexOf(prefixForNoVabhelp)) > -1) {
            n += prefixForNoVabhelp.length();
        }
        if (n > -1) {
            string3 = string.substring(n);
        }
        return string3;
    }

    public static boolean saveToFile(String string, Node node, JFrame jFrame) {
        boolean bl = false;
        try {
            String string2 = LBUtilities.getSaveTargetFileType(string);
            node.save(string, string2);
            bl = true;
        }
        catch (IOException iOException) {
            String string3 = LogBrowser.getLBString("ComIbmIvbLogUiMsgSaveLogFail");
            string3 = FindAndReplace.replace(string3, "%1", string);
            JOptionPane.showMessageDialog((Component)jFrame, (Object)(String.valueOf(string3) + "\n" + iOException), (String)LogBrowser.getLBString("ComIbmIvbLogUiTitleErrorMsgBox"), (int)0);
        }
        return bl;
    }

    public static boolean saveToFile(String string, Vector vector, JFrame jFrame) {
        boolean bl = false;
        try {
            String string2 = LBUtilities.getSaveTargetFileType(string);
            LogFile logFile = new LogFile(vector);
            if (string2.equals(SAVE_TARGET_FILE_TYPE_XML)) {
                logFile.saveAsXML(string);
            } else {
                logFile.saveAsText(string);
            }
            bl = true;
        }
        catch (IOException iOException) {
            String string3 = LogBrowser.getLBString("ComIbmIvbLogUiMsgSaveLogFail");
            string3 = FindAndReplace.replace(string3, "%1", string);
            JOptionPane.showMessageDialog((Component)jFrame, (Object)(String.valueOf(string3) + "\n" + iOException), (String)LogBrowser.getLBString("ComIbmIvbLogUiTitleErrorMsgBox"), (int)0);
        }
        return bl;
    }

    private static String getSaveTargetFileType(File file) {
        String string = FileHelper.getExtension(file);
        if (string != null) {
            return string;
        }
        return SAVE_TARGET_FILE_TYPE_XML;
    }

    private static String getSaveTargetFileType(String string) {
        String string2 = FileHelper.getExtension(string);
        if (string2 != null) {
            return string2;
        }
        return SAVE_TARGET_FILE_TYPE_XML;
    }

    public static boolean isClipboardEmpty() {
        JLabel jLabel = new JLabel();
        return jLabel.getToolkit().getSystemClipboard().getContents(jLabel) == null;
    }
}

