/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.LinkEvent;
import com.ibm.ivb.jface.Tool;
import com.ibm.ivb.log.ui.LBUtilities;
import com.ibm.ivb.log.ui.events.RefreshEditMenuEvent;
import com.sun.java.swing.text.JTextComponent;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class TextSelectionManager {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private JTextComponent text;
    private Tool tool;
    private static int selectionStart;
    private static int selectionEnd;

    public TextSelectionManager(JTextComponent jTextComponent, Tool tool) {
        this.text = jTextComponent;
        this.text.addKeyListener(new KeyMonitor());
        this.text.addMouseListener(new MouseMonitor());
        this.tool = tool;
    }

    public static int getSelectionStart() {
        return selectionStart;
    }

    public static int getSelectionEnd() {
        return selectionEnd;
    }

    public static boolean hasSelection() {
        return selectionEnd > selectionStart;
    }

    public static void clearRecord() {
        selectionStart = 0;
        selectionEnd = 0;
    }

    private void processSelectionChangeEvent(boolean bl) {
        LBUtilities.getBrowserFrame((Component)this.text).fireLinkEvent((LinkEvent)new RefreshEditMenuEvent(this.tool));
    }

    public String toString() {
        return "TextSelectionManager: selectionSatrt = " + Integer.toString(selectionStart) + "; " + "selectionEnd = " + Integer.toString(selectionEnd);
    }

    class KeyMonitor
    extends KeyAdapter {
        boolean hadSelection;

        public void keyPressed(KeyEvent keyEvent) {
            this.hadSelection = TextSelectionManager.hasSelection();
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (Character.getType(keyEvent.getKeyChar()) != 15) {
                selectionStart = TextSelectionManager.this.text.getCaretPosition();
                selectionEnd = selectionStart;
                if (this.hadSelection) {
                    TextSelectionManager.this.processSelectionChangeEvent(false);
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 8: 
                case 9: 
                case 10: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 127: {
                    selectionStart = TextSelectionManager.this.text.getCaretPosition();
                    selectionEnd = selectionStart;
                    if (!this.hadSelection) break;
                    TextSelectionManager.this.processSelectionChangeEvent(false);
                    return;
                }
            }
        }

        KeyMonitor() {
            TextSelectionManager.this = TextSelectionManager.this;
        }
    }

    class MouseMonitor
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                selectionStart = TextSelectionManager.this.text.getSelectionStart();
                selectionEnd = TextSelectionManager.this.text.getSelectionEnd();
            }
            if (mouseEvent.getClickCount() == 2) {
                TextSelectionManager.this.processSelectionChangeEvent(true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 1 || mouseEvent.isPopupTrigger() && TextSelectionManager.this.text.getSelectionEnd() > TextSelectionManager.this.text.getSelectionStart()) {
                selectionStart = TextSelectionManager.this.text.getSelectionStart();
                selectionEnd = TextSelectionManager.this.text.getSelectionEnd();
            }
            if (mouseEvent.getClickCount() == 1) {
                TextSelectionManager.this.processSelectionChangeEvent(selectionStart < selectionEnd);
            }
        }

        MouseMonitor() {
            TextSelectionManager.this = TextSelectionManager.this;
        }
    }
}

