/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.server.LoaderHandler;

public class RMIClassLoader {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static LoaderHandler handler = null;

    private RMIClassLoader() {
    }

    private static synchronized LoaderHandler getHandler() {
        if (handler == null) {
            try {
                Class clazz = Class.forName(String.valueOf(LoaderHandler.packagePrefix) + ".LoaderHandler");
                handler = (LoaderHandler)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new Error("No LoaderHandler present: " + exception);
            }
        }
        return handler;
    }

    public static Class loadClass(String string) throws MalformedURLException, ClassNotFoundException {
        return RMIClassLoader.getHandler().loadClass(string);
    }

    public static Class loadClass(URL uRL, String string) throws MalformedURLException, ClassNotFoundException {
        return RMIClassLoader.getHandler().loadClass(uRL, string);
    }

    public static Object getSecurityContext(ClassLoader classLoader) {
        return RMIClassLoader.getHandler().getSecurityContext(classLoader);
    }
}

