/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.server.LogStream;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.ServerRef;

public abstract class RemoteServer
extends RemoteObject {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static final long serialVersionUID = -4100238210092549637L;
    private static String logname = "RMI";
    private static LogStream log;

    protected RemoteServer() {
    }

    protected RemoteServer(RemoteRef remoteRef) {
        super(remoteRef);
    }

    public static String getClientHost() throws ServerNotActiveException {
        try {
            Class clazz = Class.forName(String.valueOf(RemoteRef.packagePrefix) + ".UnicastServerRef");
            ServerRef serverRef = (ServerRef)clazz.newInstance();
            return serverRef.getClientHost();
        }
        catch (ServerNotActiveException serverNotActiveException) {
            throw serverNotActiveException;
        }
        catch (Exception exception) {
            throw new ServerNotActiveException("Client host unobtainable: " + exception);
        }
    }

    public static void setLog(OutputStream outputStream) {
        if (outputStream == null) {
            log = null;
            return;
        }
        LogStream logStream = LogStream.log(logname);
        logStream.setOutputStream(outputStream);
        log = logStream;
    }

    public static PrintStream getLog() {
        return log;
    }

    static {
        try {
            log = Boolean.getBoolean("java.rmi.server.logCalls") ? LogStream.log(logname) : null;
        }
        catch (Exception exception) {}
    }
}

