/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.util.Hashtable;
import sun.security.provider.DSA;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;
import sun.security.provider.SHA;
import sun.security.x509.AlgIdDSA;

public class DSAKeyPairGenerator
extends KeyPairGenerator
implements java.security.interfaces.DSAKeyPairGenerator {
    private static Hashtable precomputedParams = new Hashtable();
    private int modlen;
    boolean generateNewParameters = false;
    private BigInteger presetP;
    private BigInteger presetQ;
    private BigInteger presetG;
    SecureRandom random;
    private SHA sha = new SHA();
    private static final BigInteger ONE;
    private static final BigInteger TWO;
    private static final BigInteger ZERO;
    private static int[] testXSeed;
    private int[] x_t = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};

    public DSAKeyPairGenerator() {
        super("DSA");
    }

    public void initialize(int n, SecureRandom secureRandom) {
        if (n < 512 || n > 1024 || n % 64 != 0) {
            throw new InvalidParameterException("Modulus size must range from 512 to 1024 and be a multiple of 64");
        }
        this.random = secureRandom;
        this.modlen = n;
        DSAParams dSAParams = null;
        if (!this.generateNewParameters) {
            Integer n2 = new Integer(n);
            dSAParams = (DSAParams)precomputedParams.get(n2);
        }
        if (dSAParams != null) {
            this.setParams(dSAParams);
        }
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
    }

    public void initialize(int n, boolean bl, SecureRandom secureRandom) throws InvalidParameterException {
        this.initialize(n, secureRandom);
        this.generateNewParameters = bl;
    }

    public void initialize(DSAParams dSAParams, SecureRandom secureRandom) throws InvalidParameterException {
        this.initialize(dSAParams.getP().bitLength(), secureRandom);
        this.setParams(dSAParams);
    }

    public KeyPair generateKeyPair() {
        if (this.presetP == null || this.presetQ == null || this.presetG == null || this.generateNewParameters) {
            BigInteger[] bigIntegerArray = this.generatePandQ(this.random, this.modlen);
            this.presetP = bigIntegerArray[0];
            this.presetQ = bigIntegerArray[1];
            this.presetG = this.generateG(this.presetP, this.presetQ);
        }
        return this.generateKeyPair(this.presetP, this.presetQ, this.presetG, this.random);
    }

    public KeyPair generateKeyPair(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, SecureRandom secureRandom) {
        BigInteger bigInteger4 = this.generateX(secureRandom, bigInteger2);
        BigInteger bigInteger5 = this.generateY(bigInteger4, bigInteger, bigInteger3);
        try {
            DSAPublicKey dSAPublicKey = new DSAPublicKey(bigInteger5, bigInteger, bigInteger2, bigInteger3);
            DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyPair keyPair = new KeyPair(dSAPublicKey, dSAPrivateKey);
            return keyPair;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
    }

    BigInteger[] generatePandQ(SecureRandom secureRandom, int n) {
        BigInteger[] bigIntegerArray = null;
        byte[] byArray = new byte[20];
        while (bigIntegerArray == null) {
            int n2 = 0;
            while (n2 < 20) {
                byArray[n2] = (byte)secureRandom.nextInt();
                ++n2;
            }
            bigIntegerArray = this.generatePandQ(byArray, n);
        }
        return bigIntegerArray;
    }

    private void xor(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = n;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[n]);
            ++n;
        }
    }

    private byte[] SHA(byte[] byArray) {
        this.sha.reset();
        return this.sha.digest(byArray);
    }

    private byte[] toByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        return byArray;
    }

    BigInteger[] generatePandQ(byte[] byArray, int n) {
        int n2 = byArray.length * 8;
        int n3 = (n - 1) / 160;
        int n4 = (n - 1) % 160;
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = TWO.pow(2 * n2);
        byte[] byArray2 = this.SHA(byArray);
        byte[] byArray3 = this.SHA(this.toByteArray(bigInteger.add(ONE).mod(bigInteger2)));
        this.xor(byArray2, byArray3);
        byte[] byArray4 = byArray2;
        byArray4[0] = (byte)(byArray4[0] | 0x80);
        byArray4[19] = (byte)(byArray4[19] | 1);
        BigInteger bigInteger3 = new BigInteger(1, byArray4);
        if (!bigInteger3.isProbablePrime(40)) {
            return null;
        }
        BigInteger[] bigIntegerArray = new BigInteger[n3 + 1];
        BigInteger bigInteger4 = TWO;
        int n5 = 0;
        while (n5 < 4096) {
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            BigInteger bigInteger7;
            int n6 = 0;
            while (n6 <= n3) {
                bigInteger7 = BigInteger.valueOf(n6);
                BigInteger bigInteger8 = bigInteger.add(bigInteger4).add(bigInteger7).mod(bigInteger2);
                bigIntegerArray[n6] = new BigInteger(1, this.SHA(this.toByteArray(bigInteger8)));
                ++n6;
            }
            bigInteger7 = bigIntegerArray[0];
            int n7 = 1;
            while (n7 < n3) {
                bigInteger7 = bigInteger7.add(bigIntegerArray[n7].multiply(TWO.pow(n7 * 160)));
                ++n7;
            }
            BigInteger bigInteger9 = (bigInteger7 = bigInteger7.add(bigIntegerArray[n3].mod(TWO.pow(n4)).multiply(TWO.pow(n3 * 160)))).add(bigInteger6 = TWO.pow(n - 1));
            BigInteger bigInteger10 = bigInteger9.subtract((bigInteger5 = bigInteger9.mod(bigInteger3.multiply(TWO))).subtract(ONE));
            if (bigInteger10.compareTo(bigInteger6) > -1 && bigInteger10.isProbablePrime(15)) {
                BigInteger[] bigIntegerArray2 = new BigInteger[]{bigInteger10, bigInteger3, bigInteger, BigInteger.valueOf(n5)};
                return bigIntegerArray2;
            }
            bigInteger4 = bigInteger4.add(BigInteger.valueOf(n3)).add(ONE);
            ++n5;
        }
        return null;
    }

    BigInteger generateG(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = ONE;
        BigInteger bigInteger4 = bigInteger.subtract(ONE).divide(bigInteger2);
        BigInteger bigInteger5 = ONE;
        while (bigInteger5.compareTo(TWO) < 0) {
            bigInteger5 = bigInteger3.modPow(bigInteger4, bigInteger);
            bigInteger3 = bigInteger3.add(ONE);
        }
        return bigInteger5;
    }

    private BigInteger generateX(SecureRandom secureRandom, BigInteger bigInteger) {
        int[] nArray;
        BigInteger bigInteger2 = null;
        do {
            nArray = new int[5];
            int n = 0;
            while (n < 5) {
                nArray[n] = secureRandom.nextInt();
                ++n;
            }
        } while ((bigInteger2 = this.generateX(nArray, bigInteger)).signum() <= 0 || bigInteger2.compareTo(bigInteger) >= 0);
        return bigInteger2;
    }

    BigInteger generateX(int[] nArray, BigInteger bigInteger) {
        int[] nArray2 = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
        int[] nArray3 = DSA.SHA_7(nArray, nArray2);
        byte[] byArray = new byte[nArray3.length * 4];
        int n = 0;
        while (n < nArray3.length) {
            int n2 = nArray3[n];
            int n3 = 0;
            while (n3 < 4) {
                byArray[n * 4 + n3] = (byte)(n2 >>> 24 - n3 * 8);
                ++n3;
            }
            ++n;
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray).mod(bigInteger);
        return bigInteger2;
    }

    BigInteger generateY(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger, bigInteger2);
        return bigInteger4;
    }

    private void setParams(DSAParams dSAParams) {
        this.presetP = dSAParams.getP();
        this.presetQ = dSAParams.getQ();
        this.presetG = dSAParams.getG();
    }

    static {
        BigInteger bigInteger = new BigInteger("fca682ce8e12caba26efccf7110e526db078b05edecbcd1eb4a208f3ae1617ae01f35b91a47e6df63413c5e12ed0899bcd132acd50d99151bdc43ee737592e17", 16);
        BigInteger bigInteger2 = new BigInteger("962eddcc369cba8ebb260ee6b6a126d9346e38c5", 16);
        BigInteger bigInteger3 = new BigInteger("678471b27a9cf44ee91a49c5147db1a9aaf244f05a434d6486931d2d14271b9e35030b71fd73da179069b32e2935630e1c2062354d0da20a6c416e50be794ca4", 16);
        BigInteger bigInteger4 = new BigInteger("e9e642599d355f37c97ffd3567120b8e25c9cd43e927b3a9670fbec5d890141922d2c3b3ad2480093799869d1e846aab49fab0ad26d2ce6a22219d470bce7d777d4a21fbe9c270b57f607002f3cef8393694cf45ee3688c11a8c56ab127a3daf", 16);
        BigInteger bigInteger5 = new BigInteger("9cdbd84c9f1ac2f38d0f80f42ab952e7338bf511", 16);
        BigInteger bigInteger6 = new BigInteger("30470ad5a005fb14ce2d9dcd87e38bc7d1b1c5facbaecbe95f190aa7a31d23c4dbbcbe06174544401a5b2c020965d8c2bd2171d3668445771f74ba084d2029d83c1c158547f3a9f1a2715be23d51ae4d3e5a1f6a7064f316933a346d3f529252", 16);
        BigInteger bigInteger7 = new BigInteger("fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c7", 16);
        BigInteger bigInteger8 = new BigInteger("9760508f15230bccb292b982a2eb840bf0581cf5", 16);
        BigInteger bigInteger9 = new BigInteger("f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a", 16);
        try {
            AlgIdDSA algIdDSA = new AlgIdDSA(bigInteger, bigInteger2, bigInteger3);
            AlgIdDSA algIdDSA2 = new AlgIdDSA(bigInteger4, bigInteger5, bigInteger6);
            AlgIdDSA algIdDSA3 = new AlgIdDSA(bigInteger7, bigInteger8, bigInteger9);
            precomputedParams.put(new Integer(512), algIdDSA);
            precomputedParams.put(new Integer(768), algIdDSA2);
            precomputedParams.put(new Integer(1024), algIdDSA3);
        }
        catch (Exception exception) {
            throw new InternalError("initializing precomputed algorithm parameters for Sun DSA");
        }
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
        ZERO = BigInteger.valueOf(0L);
        testXSeed = new int[]{-1123902530, 2136053259, -811672789, 1643147023, -346408778};
    }
}

