/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.security.util.Debug;

public final class AccessController {
    private static boolean disableSecurity = false;

    private AccessController() {
    }

    public static Object doPrivileged(PrivilegedAction privilegedAction) {
        if (disableSecurity) {
            try {
                return privilegedAction.run();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return AccessController.doPrivileged1(privilegedAction);
    }

    private static native Object doPrivileged1(PrivilegedAction var0);

    public static Object doPrivileged(PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        if (disableSecurity) {
            try {
                return privilegedAction.run();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return AccessController.doPrivileged1(privilegedAction, accessControlContext);
    }

    private static native Object doPrivileged1(PrivilegedAction var0, AccessControlContext var1);

    public static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        if (disableSecurity) {
            try {
                return privilegedExceptionAction.run();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return AccessController.doPrivileged1(privilegedExceptionAction);
    }

    private static native Object doPrivileged1(PrivilegedExceptionAction var0) throws PrivilegedActionException;

    public static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        if (disableSecurity) {
            try {
                return privilegedExceptionAction.run();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return AccessController.doPrivileged1(privilegedExceptionAction, accessControlContext);
    }

    private static native Object doPrivileged1(PrivilegedExceptionAction var0, AccessControlContext var1) throws PrivilegedActionException;

    private static native AccessControlContext getStackAccessControlContext();

    static native AccessControlContext getInheritedAccessControlContext();

    public static AccessControlContext getContext() {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            return new AccessControlContext(null, true);
        }
        return accessControlContext.optimize();
    }

    public static void checkPermission(Permission permission) throws AccessControlException {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            Debug debug = AccessControlContext.getDebug();
            if (debug != null) {
                if (Debug.isOn("stack")) {
                    Thread.currentThread();
                    Thread.dumpStack();
                }
                if (Debug.isOn("domain")) {
                    debug.println("domain (context is null)");
                }
                debug.println("access allowed " + permission);
            }
            return;
        }
        AccessControlContext accessControlContext2 = accessControlContext.optimize();
        accessControlContext2.checkPermission(permission);
    }
}

