/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcCallableStatement;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcDatabaseMetaData;
import sun.jdbc.odbc.JdbcOdbcDriverInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPreparedStatement;
import sun.jdbc.odbc.JdbcOdbcStatement;
import sun.jdbc.odbc.JdbcOdbcTracer;
import sun.jdbc.odbc.JdbcOdbcTypeInfo;

public class JdbcOdbcConnection
extends JdbcOdbcObject
implements JdbcOdbcConnectionInterface {
    protected JdbcOdbc OdbcApi;
    protected JdbcOdbcDriverInterface myDriver;
    protected long hEnv;
    protected long hDbc;
    protected SQLWarning lastWarning;
    protected boolean closed;
    protected String URL;
    protected int odbcVer;
    protected Hashtable typeInfo;
    public WeakHashMap statements;
    protected Hashtable batchStatements;
    protected short rsTypeFO;
    protected short rsTypeSI;
    protected short rsTypeSS;
    protected short rsTypeBest;
    protected int rsBlockSize;
    protected int batchInStatements;
    protected int batchInProcedures;
    protected int batchInPrepares;
    private boolean freeStmtsFromConnectionOnly;
    protected JdbcOdbcTracer tracer = new JdbcOdbcTracer();

    public JdbcOdbcConnection(JdbcOdbc jdbcOdbc, long l, JdbcOdbcDriverInterface jdbcOdbcDriverInterface) {
        this.OdbcApi = jdbcOdbc;
        this.tracer = this.OdbcApi.getTracer();
        this.myDriver = jdbcOdbcDriverInterface;
        this.hEnv = l;
        this.hDbc = 0L;
        this.URL = null;
        this.lastWarning = null;
        this.closed = true;
        this.freeStmtsFromConnectionOnly = false;
    }

    protected void finalize() {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Connection.finalize " + this);
        }
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void initialize(String string, Properties properties, int n) throws SQLException {
        int n2;
        String string2;
        String string3 = "";
        String string4 = "";
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = "";
        if (this.closed) {
            this.hDbc = this.myDriver.allocConnection(this.hEnv);
        }
        if (n > 0) {
            this.setLoginTimeout(n);
        }
        if ((string2 = properties.getProperty("odbcRowSetSize")) != null) {
            this.setResultSetBlockSize(string2);
        }
        this.OdbcApi.charSet = properties.getProperty("charSet", System.getProperty("file.encoding"));
        String string9 = properties.getProperty("licfile", "");
        String string10 = properties.getProperty("licpwd", "");
        String string11 = properties.getProperty("user", "");
        String string12 = properties.getProperty("password", "");
        String string13 = null;
        string13 = string.indexOf("DRIVER") != -1 || string.indexOf("Driver") != -1 || string.indexOf("driver") != -1 ? string : "DSN=" + string;
        StringTokenizer stringTokenizer = new StringTokenizer(string13, ";", false);
        if (stringTokenizer.countTokens() > 1) {
            n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                ++n2;
                String string14 = stringTokenizer.nextToken();
                if (string14.startsWith("user")) {
                    string5 = string14;
                    continue;
                }
                if (string14.startsWith("password")) {
                    string6 = string14;
                    continue;
                }
                if (string14.startsWith("odbcRowSetSize")) {
                    string7 = string14;
                    continue;
                }
                if (n2 > 1) {
                    string4 = string4 + ";" + string14;
                    continue;
                }
                string4 = string4 + string14;
            }
        } else {
            string4 = string13;
        }
        string3 = string4;
        try {
            StringBuffer stringBuffer;
            int n3;
            if (string11.equals("") && string5 != null) {
                string8 = string5;
                String string15 = string5.substring(4);
                if (!string15.equals("")) {
                    if (string3.indexOf("UID=") == -1) {
                        string3 = string3 + ";UID" + string15;
                    } else {
                        int n4 = string3.indexOf("UID=");
                        n3 = string3.indexOf(";", n4);
                        stringBuffer = new StringBuffer(string3);
                        stringBuffer.replace(n4, n3, "UID=" + string15);
                        string3 = stringBuffer.toString();
                    }
                }
            } else if (!string11.equals("")) {
                if (string3.indexOf("UID=") == -1) {
                    string3 = string3 + ";UID=" + string11;
                } else {
                    n2 = string3.indexOf("UID=");
                    int n5 = string3.indexOf(";", n2);
                    StringBuffer stringBuffer2 = new StringBuffer(string3);
                    stringBuffer2.replace(n2, n5, "UID=" + string11);
                    string3 = stringBuffer2.toString();
                }
            }
            if (string12.equals("") && string6 != null) {
                string8 = string6;
                String string16 = string6.substring(8);
                if (string3.indexOf("UID=") != -1) {
                    if (string3.indexOf("PWD=") == -1) {
                        string3 = string3 + ";PWD" + string16;
                    } else {
                        int n6 = string3.indexOf("PWD=");
                        n3 = string3.indexOf(";", n6);
                        stringBuffer = new StringBuffer(string3);
                        stringBuffer.replace(n6, n3, "PWD=" + string16);
                        string3 = stringBuffer.toString();
                    }
                }
            } else if (!string12.equals("") && string3.indexOf("UID=") != -1) {
                if (string3.indexOf("PWD=") == -1) {
                    string3 = string3 + ";PWD=" + string12;
                } else {
                    int n7 = string3.indexOf("PWD=");
                    int n8 = string3.indexOf(";", n7);
                    StringBuffer stringBuffer3 = new StringBuffer(string3);
                    stringBuffer3.replace(n7, n8, "PWD=" + string12);
                    string3 = stringBuffer3.toString();
                }
            }
            if (string2 == null && string7 != null) {
                string8 = string7;
                String string17 = string7.substring(15);
                this.setResultSetBlockSize(string17);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new SQLException("invalid property values [" + string8 + "]");
        }
        try {
            this.OdbcApi.SQLDriverConnect(this.hDbc, string3);
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        catch (SQLException sQLException) {
            this.myDriver.closeConnection(this.hDbc);
            throw sQLException;
        }
        this.closed = false;
        if (string9 != null) {
            // empty if block
        }
        if (string10 != null) {
            // empty if block
        }
        this.statements = new WeakHashMap();
        this.batchStatements = new Hashtable();
        DatabaseMetaData databaseMetaData = this.getMetaData();
        this.OdbcApi.odbcDriverName = databaseMetaData.getDriverName() + " " + databaseMetaData.getDriverVersion();
        if (this.tracer.isTracing()) {
            this.tracer.trace("Driver name:    " + databaseMetaData.getDriverName());
            this.tracer.trace("Driver version: " + databaseMetaData.getDriverVersion());
        } else {
            databaseMetaData = null;
        }
        this.buildTypeInfo();
        this.checkScrollCursorSupport();
        this.checkBatchUpdateSupport();
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.createStatement");
        }
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        JdbcOdbcStatement jdbcOdbcStatement = new JdbcOdbcStatement(this);
        jdbcOdbcStatement.initialize(this.OdbcApi, this.hDbc, l, null, n, n2);
        jdbcOdbcStatement.setBlockCursorSize(this.rsBlockSize);
        this.registerStatement(jdbcOdbcStatement);
        return jdbcOdbcStatement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.prepareStatement (" + string + ")");
        }
        JdbcOdbcPreparedStatement jdbcOdbcPreparedStatement = null;
        SQLWarning sQLWarning = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        jdbcOdbcPreparedStatement = new JdbcOdbcPreparedStatement(this);
        jdbcOdbcPreparedStatement.initialize(this.OdbcApi, this.hDbc, l, this.typeInfo, n, n2);
        try {
            this.OdbcApi.SQLPrepare(l, string);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcPreparedStatement.close();
            throw sQLException;
        }
        jdbcOdbcPreparedStatement.initBoundParam();
        jdbcOdbcPreparedStatement.setWarning(sQLWarning);
        jdbcOdbcPreparedStatement.setBlockCursorSize(this.rsBlockSize);
        jdbcOdbcPreparedStatement.setSql(string);
        this.registerStatement(jdbcOdbcPreparedStatement);
        return jdbcOdbcPreparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.prepareCall (" + string + ")");
        }
        JdbcOdbcCallableStatement jdbcOdbcCallableStatement = null;
        SQLWarning sQLWarning = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        jdbcOdbcCallableStatement = new JdbcOdbcCallableStatement(this);
        jdbcOdbcCallableStatement.initialize(this.OdbcApi, this.hDbc, l, this.typeInfo, n, n2);
        try {
            this.OdbcApi.SQLPrepare(l, string);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcCallableStatement.close();
            throw sQLException;
        }
        jdbcOdbcCallableStatement.initBoundParam();
        jdbcOdbcCallableStatement.setWarning(sQLWarning);
        jdbcOdbcCallableStatement.setBlockCursorSize(this.rsBlockSize);
        jdbcOdbcCallableStatement.setSql(string);
        this.registerStatement(jdbcOdbcCallableStatement);
        return jdbcOdbcCallableStatement;
    }

    public String nativeSQL(String string) throws SQLException {
        String string2;
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.nativeSQL (" + string + ")");
        }
        try {
            string2 = this.OdbcApi.SQLNativeSql(this.hDbc, string);
        }
        catch (SQLException sQLException) {
            string2 = string;
        }
        return string2;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.setAutoCommit (" + bl + ")");
        }
        int n = 1;
        this.validateConnection();
        if (!bl) {
            n = 0;
        }
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)102, n);
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.getAutoCommit");
        }
        boolean bl = false;
        this.validateConnection();
        int n = (int)this.OdbcApi.SQLGetConnectOption(this.hDbc, (short)102);
        if (n == 1) {
            bl = true;
        }
        return bl;
    }

    public void commit() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.commit");
        }
        this.validateConnection();
        this.OdbcApi.SQLTransact(this.hEnv, this.hDbc, (short)0);
    }

    public void rollback() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.rollback");
        }
        this.validateConnection();
        this.OdbcApi.SQLTransact(this.hEnv, this.hDbc, (short)1);
    }

    public void close() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.close");
        }
        this.setFreeStmtsFromConnectionOnly();
        this.closeAllStatements();
        this.batchStatements = null;
        if (!this.closed) {
            this.myDriver.disconnect(this.hDbc);
            this.myDriver.closeConnection(this.hDbc);
        }
        this.closed = true;
        this.URL = null;
    }

    public boolean isFreeStmtsFromConnectionOnly() {
        return this.freeStmtsFromConnectionOnly;
    }

    public void setFreeStmtsFromConnectionOnly() {
        this.freeStmtsFromConnectionOnly = true;
    }

    public void setFreeStmtsFromAnyWhere() {
        this.freeStmtsFromConnectionOnly = false;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.getMetaData");
        }
        this.validateConnection();
        JdbcOdbcDatabaseMetaData jdbcOdbcDatabaseMetaData = new JdbcOdbcDatabaseMetaData(this.OdbcApi, this);
        return jdbcOdbcDatabaseMetaData;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        block4: {
            if (this.tracer.isTracing()) {
                this.tracer.trace("*Connection.setReadOnly (" + bl + ")");
            }
            int n = 0;
            this.validateConnection();
            if (bl) {
                n = 1;
            }
            try {
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)101, n);
            }
            catch (SQLException sQLException) {
                if (!this.tracer.isTracing()) break block4;
                this.tracer.trace("setReadOnly exception ignored");
            }
        }
    }

    public boolean isReadOnly() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.isReadOnly");
        }
        boolean bl = false;
        this.validateConnection();
        int n = (int)this.OdbcApi.SQLGetConnectOption(this.hDbc, (short)101);
        if (n == 1) {
            bl = true;
        }
        return bl;
    }

    public void setCatalog(String string) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.setCatalog (" + string + ")");
        }
        this.validateConnection();
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)109, string);
    }

    public String getCatalog() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.getCatalog");
        }
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoString(this.hDbc, (short)16);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.setTransactionIsolation (" + n + ")");
        }
        this.validateConnection();
        switch (n) {
            case 0: {
                this.setAutoCommit(true);
                break;
            }
            case 1: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 1);
                break;
            }
            case 2: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 2);
                break;
            }
            case 4: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 4);
                break;
            }
            case 8: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 8);
                break;
            }
            default: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, n);
            }
        }
    }

    public void setLicenseFile(String string) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.setLicenseFile (" + string + ")");
        }
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)1041, string);
    }

    public void setLicensePassword(String string) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.setPassword (" + string + ")");
        }
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)1042, string);
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.getTransactionIsolation");
        }
        int n = 0;
        this.validateConnection();
        int n2 = (int)this.OdbcApi.SQLGetConnectOption(this.hDbc, (short)108);
        switch (n2) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 8: {
                n = 8;
                break;
            }
            default: {
                n = n2;
            }
        }
        return n;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.getWarnings");
        }
        return this.lastWarning;
    }

    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    public void validateConnection() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is closed");
        }
    }

    public long getHDBC() {
        return this.hDbc;
    }

    public void setURL(String string) {
        this.URL = string;
    }

    public String getURL() {
        return this.URL;
    }

    protected void setLoginTimeout(int n) throws SQLException {
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)103, n);
    }

    public int getODBCVer() {
        if (this.odbcVer == 0) {
            String string;
            try {
                string = this.OdbcApi.SQLGetInfoString(this.hDbc, (short)10);
            }
            catch (SQLException sQLException) {
                string = "-1";
            }
            Integer n = new Integer(string.substring(0, 2));
            this.odbcVer = n;
        }
        return this.odbcVer;
    }

    protected void checkBatchUpdateSupport() {
        this.batchInStatements = -1;
        this.batchInProcedures = -1;
        this.batchInPrepares = -1;
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            n = this.OdbcApi.SQLGetInfo(this.hDbc, (short)121);
            if ((n & 2) > 0) {
                bl = true;
            }
            if ((n & 8) > 0) {
                bl2 = true;
            }
            if (((n2 = this.OdbcApi.SQLGetInfo(this.hDbc, (short)120)) & 4) > 0) {
                this.batchInStatements = 4;
                this.batchInProcedures = 4;
            } else {
                if (bl && (n2 & 2) > 0) {
                    this.batchInStatements = 2;
                }
                if (bl2 && (n2 & 1) > 0) {
                    this.batchInProcedures = 1;
                }
            }
            n = this.OdbcApi.SQLGetInfo(this.hDbc, (short)153);
            if ((n & 1) > 0) {
                bl3 = true;
                this.batchInPrepares = 1;
            }
        }
        catch (SQLException sQLException) {
            this.batchInStatements = -1;
            this.batchInProcedures = -1;
            this.batchInPrepares = -1;
        }
    }

    public int getBatchRowCountFlag(int n) {
        switch (n) {
            case 1: {
                return this.batchInStatements;
            }
            case 2: {
                return this.batchInPrepares;
            }
            case 3: {
                return this.batchInProcedures;
            }
        }
        return -1;
    }

    public void checkScrollCursorSupport() throws SQLException {
        short s = -1;
        int n = 0;
        int n2 = this.OdbcApi.SQLGetInfo(this.hDbc, (short)44);
        this.rsTypeFO = (short)-1;
        this.rsTypeSI = (short)-1;
        this.rsTypeSS = (short)-1;
        if ((n2 & 1) != 0) {
            this.rsTypeFO = 0;
        }
        if ((n2 & 0x10) != 0) {
            this.rsTypeSI = (short)3;
        }
        if ((n2 & 0x10) != 0 && ((n = this.getOdbcCursorAttr2(s = 3)) & 0x40) != 0) {
            this.rsTypeSS = s;
        }
        if ((n2 & 2) != 0 || (n2 & 8) != 0) {
            s = 1;
            n = this.getOdbcCursorAttr2(s);
            if ((n & 0x40) != 0) {
                this.rsTypeSS = s;
            } else {
                this.rsTypeSI = s;
            }
        }
        if ((n2 & 4) != 0 && ((n = this.getOdbcCursorAttr2(s = 2)) & 0x40) != 0) {
            this.rsTypeSS = s;
        }
        this.rsTypeBest = s;
        if (this.rsTypeBest == -1) {
            this.rsTypeBest = this.rsTypeSS;
        }
        if (this.rsTypeBest == -1) {
            this.rsTypeBest = this.rsTypeSI;
        }
        if (this.rsTypeBest == -1) {
            this.rsTypeBest = this.rsTypeFO;
        }
    }

    public short getBestOdbcCursorType() {
        return this.rsTypeBest;
    }

    public short getOdbcCursorType(int n) {
        short s = -1;
        switch (n) {
            case 1003: {
                s = this.rsTypeFO;
                break;
            }
            case 1004: {
                s = this.rsTypeSI;
                break;
            }
            case 1005: {
                s = this.rsTypeSS;
            }
        }
        return s;
    }

    public short getOdbcConcurrency(int n) {
        switch (n) {
            case 1007: {
                return 1;
            }
            case 1008: {
                return 2;
            }
        }
        return 1;
    }

    public int getOdbcCursorAttr2(short s) throws SQLException {
        short s2 = 0;
        switch (s) {
            case 0: {
                s2 = 147;
                break;
            }
            case 3: {
                s2 = 168;
                break;
            }
            case 1: {
                s2 = 151;
                break;
            }
            case 2: {
                s2 = 145;
            }
        }
        try {
            return this.OdbcApi.SQLGetInfo(this.hDbc, s2);
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public Map getTypeMap() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected void buildTypeInfo() throws SQLException {
        this.typeInfo = new Hashtable();
        if (this.tracer.isTracing()) {
            this.tracer.trace("Caching SQL type information");
        }
        ResultSet resultSet = this.getMetaData().getTypeInfo();
        boolean bl = resultSet.next();
        while (bl) {
            String string = resultSet.getString(1);
            int n = resultSet.getInt(2);
            if (this.typeInfo.get(new Integer(n)) == null) {
                JdbcOdbcTypeInfo jdbcOdbcTypeInfo = new JdbcOdbcTypeInfo();
                jdbcOdbcTypeInfo.setName(string);
                jdbcOdbcTypeInfo.setPrec(resultSet.getInt(3));
                this.typeInfo.put(new Integer(n), jdbcOdbcTypeInfo);
            }
            bl = resultSet.next();
        }
        resultSet.close();
    }

    protected void registerStatement(Statement statement) {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Registering Statement " + statement);
        }
        this.statements.put(statement, "");
    }

    public void deregisterStatement(Statement statement) {
        if (this.statements.get(statement) != null) {
            if (this.tracer.isTracing()) {
                this.tracer.trace("deregistering Statement " + statement);
            }
            this.statements.remove(statement);
        }
    }

    public void closeAllStatements() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("" + this.statements.size() + " Statement(s) to close");
        }
        if (this.statements.size() == 0) {
            return;
        }
        Set set = this.statements.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                Statement statement = (Statement)iterator.next();
                statement.close();
            }
            catch (Exception exception) {
                set = this.statements.keySet();
                iterator = set.iterator();
            }
        }
        this.batchStatements.clear();
    }

    public void setBatchVector(Vector vector, Statement statement) {
        int n = -1;
        if (this.tracer.isTracing()) {
            this.tracer.trace("setBatchVector " + statement);
        }
        this.batchStatements.put(statement, vector);
    }

    public Vector getBatchVector(Statement statement) {
        if (this.tracer.isTracing()) {
            this.tracer.trace("getBatchVector " + statement);
        }
        return (Vector)this.batchStatements.get(statement);
    }

    public synchronized void removeBatchVector(Statement statement) {
        if (this.tracer.isTracing()) {
            this.tracer.trace("removeBatchVector " + statement);
        }
        this.batchStatements.remove(statement);
    }

    protected void setResultSetBlockSize(String string) throws SQLException {
        this.rsBlockSize = 10;
        if (string != null) {
            string.trim();
            if (!string.equals("")) {
                try {
                    int n = new Integer(string);
                    if (n > 0) {
                        this.rsBlockSize = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("invalid property value: [odbcRowSetSize=" + string + "]");
                }
            }
        }
    }

    public void setHoldability(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

