/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hursley.devtools;

import com.ibm.hursley.devtools.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;

public class TraceViewer
extends Frame
implements Runnable,
WindowListener {
    private static final String sccsid = "%Z% %W%  %E% %U%";
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1997     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TextArea ta;
    private BufferedReader traceReader;
    private Thread thread;

    public TraceViewer() {
        super("Trace Console");
        this.setLayout(new BorderLayout());
        this.ta = new TextArea(30, 80);
        this.add((Component)this.ta, "Center");
        this.pack();
        ((Component)this).setSize(new Dimension(600, 400));
        this.addWindowListener(this);
        ((Component)this).setVisible(true);
    }

    public void grabTraceOutput() {
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream();
        try {
            pipedOutputStream.connect(pipedInputStream);
        }
        catch (IOException iOException) {
            this.ta.append("Unable to connect to trace stream." + iOException);
        }
        InputStreamReader inputStreamReader = new InputStreamReader(pipedInputStream);
        this.traceReader = new BufferedReader(inputStreamReader);
        Trace.setTraceStream(new PrintWriter(pipedOutputStream, true));
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void run() {
        try {
            while (true) {
                String string = this.traceReader.readLine();
                this.ta.append(String.valueOf(string) + "\n");
            }
        }
        catch (IOException iOException) {
            this.ta.append("Unable to read any further trace output.\n");
            return;
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        Thread thread = this.thread;
        synchronized (thread) {
            this.thread.stop();
            return;
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

