/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp;

import com.ibm.lex.lapapp.ConfirmDialog;
import com.ibm.lex.lapapp.ImagePanel;
import com.ibm.lex.lapapp.LAP;
import com.ibm.lex.lapapp.LAPConstants;
import com.ibm.lex.lapapp.License;
import com.ibm.lex.lapapp.LicenseAcceptanceProcess;
import com.ibm.lex.lapapp.TextPrinter;
import com.ibm.lex.lapapp.resource.LAPResources;
import com.ibm.lex.lapapp.resource.SupportedLanguages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JLAP
extends JFrame {
    private JDialog dialog;
    private JPanel topPanel;
    private JTextArea heading;
    private LAP lap;
    private LicenseAcceptanceProcess licenseAcceptanceProcess;
    private int winX = 0;
    private int winY = 0;
    private int winWidth;
    private int winHeight;
    private int xCenter;
    private int yCenter;
    private int dialogWidth = 500;
    private int dialogHeight = 400;
    private int dialogX;
    private int dialogY;
    private Color winColor = LAPConstants.WIN_COLOR;
    private Font lapFont;
    private int fontStyle = 0;
    private int fontSize;
    private boolean controlFontSize;
    private Color dialogColor = LAPConstants.LAP_COLOR;
    private LAPResources lapResources;
    private LicenseAcceptanceProcess model;
    private Image logoImage;
    protected String logoFileName = "logo.gif";
    private JPanel controlPanel;
    private JButton acceptButton;
    private JButton declineButton;
    private boolean noControll;
    private JButton printButton;
    private boolean printable;
    private JButton languageButton;
    protected String languageButName = "language";
    protected String acceptButName = "accept";
    protected String declineButName = "decline";
    protected String printButName = "print";
    protected String yesButName = "yes";
    protected String noButName = "no";
    private JTextArea laView;
    private String[] textLines;
    private JPanel laPanel;
    private ConfirmDialog declinedDlg;
    private JDialog dlg;

    public JLAP() {
    }

    public JLAP(LAP lAP) {
        try {
            this.lap = lAP;
            this.showMe();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    private void applicationStatusChanged(int n) {
        switch (n) {
            case 91: {
                String string = this.getLAPTitle();
                this.setTitle(string);
                if (this.dialog.isVisible()) {
                    this.dialog.repaint();
                } else {
                    ((Component)this).setVisible(true);
                    ((Component)this.dialog).setVisible(true);
                }
                this.dialog.repaint();
                break;
            }
            case 9: {
                this.exitLAP(9);
                break;
            }
            case 3: {
                this.exitLAP(3);
                break;
            }
            default: {
                this.exitLAP(n);
            }
        }
    }

    public String[] breakText(int n, int n2, String[] stringArray, Locale locale) {
        Object object;
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = stringArray[n4];
            BreakIterator breakIterator = BreakIterator.getLineInstance(locale);
            if (object == null) {
                object = " ";
            }
            breakIterator.setText((String)object);
            int n5 = breakIterator.first();
            int n6 = breakIterator.next();
            int n7 = 0;
            StringBuffer stringBuffer = new StringBuffer("");
            int n8 = 0;
            while (n6 != -1) {
                String string = ((String)object).substring(n5, n6);
                n8 = string.length() * n2;
                if (n7 + n8 > n) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = new StringBuffer(string);
                    n7 = n8;
                } else {
                    stringBuffer.append(string);
                    n7 += n8;
                }
                n5 = n6;
                n6 = breakIterator.next();
            }
            vector.addElement(stringBuffer.toString());
            ++n4;
        }
        vector.trimToSize();
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public void showMe() {
        this.parseParameters();
        String string = System.getProperty("os.name");
        String string2 = Locale.getDefault().toString();
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        }
        if ((string.equalsIgnoreCase("aix") || string.equalsIgnoreCase("linux")) && string2.equalsIgnoreCase("ja")) {
            this.controlFontSize = false;
        }
        this.setTitle(this.getLAPTitle());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        }
        if ((string.equalsIgnoreCase("aix") || string.equalsIgnoreCase("linux")) && string2.equalsIgnoreCase("ja")) {
            this.controlFontSize = false;
        }
        try {
            ((Frame)this).setIconImage(this.getImage("icon.gif"));
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Null pointer in getting icon image");
        }
        this.controlFontSize = true;
        if (this.controlFontSize) {
            try {
                this.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
            }
            catch (NullPointerException nullPointerException) {
                System.out.println(nullPointerException.toString());
            }
        }
        this.getContentPane().setBackground(this.winColor);
        ((Component)this).setLocation(this.winX, this.winY);
        ((Component)this).setSize(this.winWidth, this.winHeight);
        if (this.winWidth > 0 && this.winHeight > 0) {
            ((Component)this).setVisible(true);
        }
        this.dialog = new JDialog((Frame)this, true);
        this.dialog.getContentPane().setBackground(this.dialogColor);
        ((Component)this.dialog).setLocation(this.dialogX - 10, this.dialogY - 10);
        ((Component)this.dialog).setSize(this.dialogWidth, this.dialogHeight);
        this.dialog.setTitle(this.getLAPTitle());
        this.dialog.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        this.dialog.setDefaultCloseOperation(0);
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        JComponent jComponent = null;
        JPanel jPanel = new JPanel();
        this.logoImage = this.lap.getLicenseAcceptanceProcess().getLAPResources().getImage(this.logoFileName);
        if (this.logoImage != null) {
            jComponent = new ImagePanel(this.logoImage);
        }
        jComponent.setBackground(this.dialogColor);
        this.topPanel.setBackground(this.dialogColor);
        this.topPanel.add((Component)jComponent, "East");
        this.heading = new JTextArea();
        this.heading.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText(1));
        this.heading.setLineWrap(true);
        this.heading.setWrapStyleWord(true);
        this.heading.setBackground(this.dialogColor);
        this.heading.setEditable(false);
        this.heading.setMargin(new Insets(0, 20, 25, 10));
        this.heading.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        this.heading.addKeyListener(new LabelTabHandler());
        this.topPanel.add((Component)this.heading, "Center");
        this.laPanel = new JPanel();
        this.laPanel.setBackground(this.dialogColor);
        this.laView = new JTextArea("");
        this.laView.setBackground(this.dialogColor);
        this.laView.setEditable(false);
        this.laView.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        this.laView.addKeyListener(new TextTabHandler());
        this.laView.setLineWrap(true);
        this.laView.setWrapStyleWord(true);
        this.laView.setText(this.getLicenseAgreement());
        JScrollPane jScrollPane = new JScrollPane(this.laView);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(this.dialogWidth * 9 / 10, this.dialogHeight / 2));
        jScrollPane.setBorder(jScrollPane.getBorder());
        this.laPanel.add(jScrollPane);
        this.controlPanel = new JPanel();
        if (!this.noControll) {
            this.acceptButton = new JButton();
            this.acceptButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText(13));
            this.acceptButton.setBackground(this.dialogColor);
            this.acceptButton.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
            this.acceptButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JLAP.this.onAccept();
                }
            });
            this.declineButton = new JButton();
            this.declineButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText(14));
            this.declineButton.setBackground(this.dialogColor);
            this.declineButton.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
            this.declineButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JLAP.this.onDecline();
                }
            });
            JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(this.dialogColor);
            jPanel2.add(this.acceptButton);
            jPanel2.add(this.declineButton);
            if (this.lap.getLicenseAcceptanceProcess().isMultiLanguage()) {
                this.languageButton = new JButton();
                this.setLocale(this.lap.getLicenseAcceptanceProcess().nextLocale());
                this.lap.getLicenseAcceptanceProcess().getLAPResources().setLocale(this.getLocale());
                this.languageButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText(12));
                this.setLocale(this.lap.getLicenseAcceptanceProcess().nextLocale());
                this.lap.getLicenseAcceptanceProcess().getLAPResources().setLocale(this.getLocale());
                this.languageButton.setBackground(this.dialogColor);
                this.languageButton.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
                this.languageButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JLAP.this.onLanguage();
                    }
                });
                this.controlPanel.add(this.languageButton);
            }
            this.controlPanel.add(jPanel2);
            if (this.printable) {
                this.printButton = new JButton();
                this.printButton.setText(this.printButName);
                this.printButton.setBackground(this.dialogColor);
                this.printButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JLAP.this.onPrint();
                    }
                });
                this.controlPanel.add(this.printButton);
            }
        }
        this.controlPanel.setBackground(this.dialogColor);
        this.dialog.getContentPane().add((Component)this.laPanel, "Center");
        this.dialog.getContentPane().add((Component)this.topPanel, "North");
        this.dialog.getContentPane().add((Component)this.controlPanel, "South");
        ((Component)this.dialog).setLocation(this.dialogX, this.dialogY);
        ((Component)this.dialog).setVisible(true);
    }

    private int getFontSize() {
        if (this.fontSize > 0) {
            return this.fontSize;
        }
        return this.lap.getLicenseAcceptanceProcess().getLAPResources().getFontSize();
    }

    public Image getImage(String string) {
        return this.getLAPResources().getImage(string);
    }

    private String getLanguageLabel() {
        return "View in " + this.lap.getLicenseAcceptanceProcess().getNextLocale().getDisplayLanguage(LAPConstants.DEFAULT_LOCALE);
    }

    private LAPResources getLAPResources() {
        return this.lap.getLicenseAcceptanceProcess().getLAPResources();
    }

    public String getLAPTitle() {
        return this.getLAPResources().getText(0);
    }

    private License getLicense() {
        return this.lap.getLicenseAcceptanceProcess().getLicense();
    }

    private String getLicenseAgreement() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("");
        this.textLines = this.lap.getLicenseAcceptanceProcess().getLicenseAgreement(this.getLocale());
        int n = 0;
        while (n < this.textLines.length) {
            stringBuffer.append(this.textLines[n]);
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String[] getLicenseAgreement(Locale locale) {
        return this.lap.getLicenseAcceptanceProcess().getLicenseAgreement(locale);
    }

    public int getStatus() {
        return this.lap.getLicenseAcceptanceProcess().getStatus();
    }

    private SupportedLanguages getSupportedLanguages() {
        return this.lap.getLicenseAcceptanceProcess().getSupportedLanguages();
    }

    public boolean licenseIsValid() {
        return this.getLicense().licenseExists(this.getSupportedLanguages().getSupportedLocales());
    }

    public static void main(String[] stringArray) {
        LAP lAP = new LAP(stringArray);
    }

    public void onAccept() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.dlg == null || !this.dlg.isVisible()) {
            this.lap.getLicenseAcceptanceProcess().setStatus(9);
        }
        if (this.dlg != null && this.dlg.isVisible()) {
            this.dlg.toFront();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onDecline() {
        String[] stringArray = this.lap.getLicenseAcceptanceProcess().getLAPResources().getMessage(31);
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = string + stringArray[n];
            string = string + "\n\n";
            ++n;
        }
        Object[] objectArray = new JButton[]{new JButton(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText(16)), new JButton(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText(17))};
        objectArray[0].setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        objectArray[1].setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        objectArray[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JLAP.this.dlg.dispose();
                JLAP.this.dlg = null;
                JLAP.this.lap.getLicenseAcceptanceProcess().setStatus(3);
            }
        });
        objectArray[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JLAP.this.dlg.dispose();
                JLAP.this.dlg = null;
            }
        });
        JPanel jPanel = new JPanel();
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        jTextArea.setBackground(jPanel.getBackground());
        JOptionPane jOptionPane = new JOptionPane(jTextArea, -1, 0, null, objectArray);
        jOptionPane.setPreferredSize(new Dimension(this.dialogWidth * 4 / 5, this.dialogHeight * 3 / 4));
        jOptionPane.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        this.dlg = jOptionPane.createDialog(this, this.lap.getLicenseAcceptanceProcess().getLAPResources().getText(0));
        this.dlg.getContentPane().setLayout(new FlowLayout());
        this.dlg.setFont(new Font(this.lap.getfontName(), this.fontStyle, this.getFontSize()));
        this.dlg.setModal(true);
        this.dlg.show();
        Object object = jOptionPane.getValue();
        if (object != null) {
            // empty if block
        }
        if (object == null) {
            object = new Integer(1);
        } else if (!object.equals(new Integer(1)) && object.equals(new Integer(0))) {
            this.dlg.dispose();
            this.dlg = null;
            this.lap.getLicenseAcceptanceProcess().setStatus(3);
        }
    }

    private void onLanguage() {
        this.laView.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), this.getFontSize()));
        this.setLocale(this.lap.getLicenseAcceptanceProcess().nextLocale());
        this.lap.getLicenseAcceptanceProcess().getLAPResources().setLocale(this.getLocale());
        this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), this.getFontSize()));
        this.laView.setText(this.getLicenseAgreement());
        this.heading.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText(1));
        this.acceptButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText(13));
        this.declineButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText(14));
        this.setLocale(this.lap.getLicenseAcceptanceProcess().nextLocale());
        this.lap.getLicenseAcceptanceProcess().getLAPResources().setLocale(this.getLocale());
        this.languageButton.setText(this.lap.getLicenseAcceptanceProcess().getLAPResources().getText(12));
        this.setLocale(this.lap.getLicenseAcceptanceProcess().nextLocale());
        this.lap.getLicenseAcceptanceProcess().getLAPResources().setLocale(this.getLocale());
        this.lap.getLicenseAcceptanceProcess().setStatus(91);
        this.laView.setCaretPosition(0);
        this.laView.setCursor(Cursor.getPredefinedCursor(0));
        this.laPanel.revalidate();
        this.topPanel.revalidate();
        this.controlPanel.revalidate();
        this.dialog.setTitle(this.getTitle());
        this.setTitle(this.getTitle());
        this.repaint();
    }

    private void onPrint() {
        TextPrinter textPrinter = new TextPrinter(this.textLines, this.dialog, this.lap.getLicenseAcceptanceProcess(), this.lap.getLicenseAcceptanceProcess().getLAPResources(), this.controlFontSize, this.acceptButton, this.getFont(), ((Component)this).getBackground(), this.getToolkit().getScreenSize(), this.getBounds());
        textPrinter.setMargin(1.0, 1.0, 1.0, 1.0);
        textPrinter.print();
    }

    private void parseParameters() {
        int n;
        int n2;
        Object object;
        Toolkit toolkit = this.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.winWidth = dimension.width;
        this.winHeight = dimension.height;
        this.xCenter = this.winWidth / 2;
        this.yCenter = this.winHeight / 2;
        if (this.lap.getwinStyle().equals("0")) {
            this.winX = this.winWidth / 2;
            this.winY = this.winHeight / 2;
            this.winWidth = 0;
            this.winHeight = 0;
        } else if (this.lap.getwinStyle().equals("2")) {
            object = this.getInsets();
            this.winX = -((Insets)object).left;
            this.winY = -((Insets)object).top;
            this.winWidth = this.winWidth + ((Insets)object).left + ((Insets)object).right;
            this.winHeight = this.winHeight + ((Insets)object).top + ((Insets)object).bottom;
        }
        if (this.lap.getdialogSizeString() != null) {
            object = new StringTokenizer(this.lap.getdialogSizeString(), ";");
            try {
                n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
                n = Integer.parseInt(((StringTokenizer)object).nextToken());
                if (n2 > 0 && n2 <= dimension.width && n > 0 && n <= dimension.height) {
                    this.dialogWidth = n2;
                    this.dialogHeight = n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dialogX = (dimension.width - this.dialogWidth) / 2;
        this.dialogY = (dimension.height - this.dialogHeight) / 2;
        if (this.lap.getwinColorString() != null) {
            object = new StringTokenizer(this.lap.getwinColorString(), ";");
            try {
                n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
                n = Integer.parseInt(((StringTokenizer)object).nextToken());
                int n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
                this.winColor = new Color(n2, n, n3);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
        if (this.lap.getfontStyleString() != null) {
            this.fontStyle = this.lap.getfontStyleString().toLowerCase(Locale.ENGLISH).equals("plain") ? 0 : (this.lap.getfontStyleString().toLowerCase(Locale.ENGLISH).equals("italic") ? 2 : (this.lap.getfontStyleString().toLowerCase(Locale.ENGLISH).equals("bold") ? 1 : 0));
        }
        if (this.lap.getfontSizeString() != null) {
            try {
                int n4 = Integer.parseInt(this.lap.getfontSizeString());
                if (n4 > 0) {
                    this.fontSize = n4;
                    this.lapFont = new Font(this.lap.getfontName(), this.fontStyle, this.fontSize);
                }
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
    }

    public void setStatus(int n) {
        this.lap.getLicenseAcceptanceProcess().setStatus(n);
    }

    private void exitLAP(int n) {
        if (this.lap.getbShowExitCode()) {
            System.out.println("Exited with: " + n);
        } else if (n != 3 && n != 9) {
            System.out.println("Exited with: " + n);
        }
        System.exit(n);
    }

    public class TextTabHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9) {
                if ((keyEvent.getModifiers() & 1) != 0) {
                    JLAP.this.heading.requestFocus();
                } else if (JLAP.this.printable) {
                    JLAP.this.printButton.requestFocus();
                } else {
                    JLAP.this.acceptButton.requestFocus();
                }
            } else {
                super.keyPressed(keyEvent);
            }
        }
    }

    public class LabelTabHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9) {
                if ((keyEvent.getModifiers() & 1) != 0) {
                    JLAP.this.declineButton.requestFocus();
                } else {
                    JLAP.this.laView.requestFocus();
                }
            } else {
                super.keyPressed(keyEvent);
            }
        }
    }
}

