/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp.resource;

import com.ibm.lex.lapapp.resource.SupportedLanguages;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;

public class LAPResources {
    private String laPath;
    private URL laURL;
    private Locale locale;
    private ResourceBundle resBundle;
    public static final int TITLE = 0;
    public static final int HEADING = 1;
    public static final int FOOTING = 2;
    public static final int LICENSE = 3;
    public static final int LANGUAGE = 12;
    public static final int ACCEPT = 13;
    public static final int DECLINE = 14;
    public static final int PRINT = 15;
    public static final int YES = 16;
    public static final int NO = 17;
    public static final int ACCEPTED_URL = 20;
    public static final int DECLINED_URL = 21;
    public static final int CONFIRM_MESSAGE = 31;
    public static final int CLILANGMSG = 40;
    public static final int CLILANG2MSG = 41;
    public static final int CLIMSG1 = 42;
    public static final int CLIMSG2 = 43;
    public static final int CLICONTMSG = 44;
    public static final int CLICFMMSG = 45;
    public static final int CLIACCMSG = 46;
    public static final int ASSUMED_FONT_WIDTH = 47;
    public static final int ASSUMED_FONT_HEIGHT = 48;
    public static final int PRINT_ERROR_MSGS = 49;
    static final String LANGUAGE_KEY = "language";
    static final String TITLE_KEY = "title";
    static final String HEADING_KEY = "heading";
    static final String FOOTING_KEY = "footing";
    static final String ACCEPT_KEY = "accept";
    static final String DECLINE_KEY = "decline";
    static final String PRINT_KEY = "print";
    static final String YES_KEY = "yes";
    static final String NO_KEY = "no";
    static final String ACCEPTED_URL_KEY = "url.accepted";
    static final String DECLINED_URL_KEY = "url.declined";
    static final String FONT_SIZE_KEY = "fontSize";
    static final String CONFIRM_MESSAGE_KEY = "declinedMessage";
    static final String CONFIRM_MSG_A_KEY = "declinedMsgA";
    static final String CONFIRM_MSG_B_KEY = "declinedMsgB";
    static final String CLILANGMSG_KEY = "clilangmsg";
    static final String CLILANG2MSG_KEY = "clilang2msg";
    static final String CLIMSG1_KEY = "climsg1";
    static final String CLIMSG2_KEY = "climsg2";
    static final String CLICONTMSG_KEY = "clicontmsg";
    static final String CLICFMMSG_KEY = "clicfmmsg";
    static final String CLIACCMSG_KEY = "cliaccmsg";
    static final String ASSUMED_FONT_WIDTH_KEY = "assumedFontWidth";
    static final String ASSUMED_FONT_HEIGHT_KEY = "assumedFontHeight";
    static final String PRINT_ERROR_MSG_KEY = "printError";
    static final String PRINT_ERROR_MSG_KEY_A = "printErrorA";
    static final String PRINT_ERROR_MSG_KEY_B = "printErrorB";
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. YEAR     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public LAPResources(String string) {
        this.laPath = string;
        this.init();
    }

    public LAPResources(URL uRL) {
        this.laURL = uRL;
        this.init();
    }

    public int getFontSize() {
        return Integer.parseInt(this.getText(FONT_SIZE_KEY));
    }

    public Image getImage(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = null;
        try {
            if (this.laPath != null) {
                String string2 = this.laPath + File.separator + string;
                image = toolkit.createImage(string2);
            } else if (this.laURL != null) {
                URL uRL = new URL(this.laURL, string);
                image = toolkit.getImage(uRL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return image;
    }

    public Image getImage(String string, ImageObserver imageObserver) {
        Image image = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            if (this.laPath != null) {
                String string2 = this.laPath + File.separator + string;
                image = toolkit.getImage(string2);
                toolkit.prepareImage(image, -1, -1, imageObserver);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return image;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String[] getMessage(int n) {
        switch (n) {
            case 31: {
                return this.getTexts(CONFIRM_MESSAGE_KEY);
            }
            case 49: {
                return this.getTexts(PRINT_ERROR_MSG_KEY);
            }
        }
        return null;
    }

    public String getText(int n) {
        switch (n) {
            case 0: {
                return this.getText(TITLE_KEY);
            }
            case 1: {
                return this.getText(HEADING_KEY);
            }
            case 2: {
                return this.getText(FOOTING_KEY);
            }
            case 13: {
                return this.getText(ACCEPT_KEY);
            }
            case 14: {
                return this.getText(DECLINE_KEY);
            }
            case 15: {
                return this.getText(PRINT_KEY);
            }
            case 16: {
                return this.getText(YES_KEY);
            }
            case 17: {
                return this.getText(NO_KEY);
            }
            case 40: {
                return this.getText(CLILANGMSG_KEY);
            }
            case 41: {
                return this.getText(CLILANG2MSG_KEY);
            }
            case 42: {
                return this.getText(CLIMSG1_KEY);
            }
            case 43: {
                return this.getText(CLIMSG2_KEY);
            }
            case 44: {
                return this.getText(CLICONTMSG_KEY);
            }
            case 45: {
                return this.getText(CLICFMMSG_KEY);
            }
            case 46: {
                return this.getText(CLIACCMSG_KEY);
            }
            case 47: {
                return this.getText(ASSUMED_FONT_WIDTH_KEY);
            }
            case 48: {
                return this.getText(ASSUMED_FONT_HEIGHT_KEY);
            }
            case 12: {
                return this.getText(LANGUAGE_KEY);
            }
        }
        return null;
    }

    private String getText(String string) {
        if (this.resBundle == null) {
            this.resBundle = ResourceBundle.getBundle("com.ibm.lex.lapapp.resource.Resource", this.locale);
        }
        return this.resBundle.getString(string);
    }

    private String[] getTexts(String string) {
        if (string.equals(CONFIRM_MESSAGE_KEY)) {
            String[] stringArray = new String[]{this.getText(CONFIRM_MSG_A_KEY), "", this.getText(CONFIRM_MSG_B_KEY)};
            return stringArray;
        }
        if (string.equals(PRINT_ERROR_MSG_KEY)) {
            String[] stringArray = new String[]{this.getText(PRINT_ERROR_MSG_KEY_A), "", this.getText(PRINT_ERROR_MSG_KEY_B)};
            return stringArray;
        }
        return null;
    }

    private void init() {
        this.locale = SupportedLanguages.DEFAULT_LANGUAGE;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.resBundle = null;
    }
}

