/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class DBCS_Encoder
extends IBMCharsetEncoder {
    private final short[] index;
    private final String[] data;
    private final int convertType;
    private final char[] singleMap;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    DBCS_Encoder(Charset charset, short[] sArray, String[] stringArray, char[] cArray, byte by, byte[] byArray) {
        super(charset, 2.0f, 4.0f);
        this.index = sArray;
        this.data = stringArray;
        this.singleMap = by == 2 ? new char[0] : (char[])(cArray != null && cArray.length % 3 == 0 ? cArray : null);
        this.convertType = by;
        if (byArray != null) {
            this.replaceWith(byArray);
        }
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (byArray.length == 1 && byArray[0] >= 0) {
            return true;
        }
        return super.isLegalReplacement(byArray);
    }

    public boolean canEncode(char c) {
        char c2 = this.convSingle(c);
        if (c2 != '\uffff') {
            return true;
        }
        int n = this.index[c >> 8] << 8;
        c2 = this.data[n >> 12].charAt((n & 0xFFF) + (c & 0xFF));
        return this.convertType != 1 && (c2 != '\u0000' || c == '\u0000');
    }

    private final char convSingle(char c) {
        if (this.singleMap == null) {
            return c < '\u0080' ? c : (char)'\uffff';
        }
        int n = this.singleMap.length;
        for (int i = 0; i < n; i += 3) {
            if (c > this.singleMap[i + 1] || c < this.singleMap[i]) continue;
            return (char)(this.singleMap[i + 2] + c - this.singleMap[i]);
        }
        return '\uffff';
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
            char c = cArray[n];
            if (Surrogate.is(c)) {
                if (this.sgp.parse(c, cArray, n, n2) < 0) {
                    coderResult = this.sgp.error();
                    break;
                }
                coderResult = this.sgp.unmappableResult();
                break;
            }
            char c2 = this.convSingle(c);
            int n5 = 1;
            if (c2 == '\uffff') {
                c2 = this.getValue(c);
                if (c2 >= '\u0100') {
                    n5 = 2;
                } else {
                    coderResult = CoderResult.unmappableForLength(1);
                    break;
                }
            }
            if (n4 - n3 < n5) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            if (n5 > 1) {
                byArray[n3++] = (byte)(c2 >> 8);
            }
            byArray[n3++] = (byte)c2;
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                int n2 = 1;
                char c2 = this.convSingle(c);
                if (this.convertType != 1) {
                    if (c2 == '\uffff') {
                        c2 = this.getValue(c);
                        if (c2 < '\u0100') {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                        n2 = 2;
                    }
                } else if (c2 == '\uffff') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (byteBuffer.remaining() < n2) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (n2 > 1) {
                    byteBuffer.put((byte)(c2 >> 8));
                }
                byteBuffer.put((byte)c2);
                ++n;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected char getValue(char c) {
        int n = this.index[c >> 8] << 8;
        return this.data[n >> 12].charAt((n & 0xFFF) + (c & 0xFF));
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (this.convertType != 1 && charBuffer.hasArray() && byteBuffer.hasArray() && !UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

