/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

class ISO2022_Decoder
extends CharsetDecoder {
    static final byte ISO_ESC = 27;
    static final byte ISO_SI = 15;
    static final byte ISO_SO = 14;
    static final byte ISO_SS2 = 78;
    static final byte ISO_SS3 = 79;
    static final byte MSB = -128;
    static final char REPLACE_CHAR = '\ufffd';
    static final char NO_CHAR = '\uffff';
    private static final int DATA = 0;
    private static final int ONEDATA = 1;
    private static final int ESCAPE = 2;
    private static final int ESC_DBCS = 3;
    private static final int ESC_LEFT = 4;
    private static final int ESC_RIGHT = 5;
    private static final int ESC_UNKNOWN = 6;
    private static final int ESC_DOCS = 7;
    private static final int UTF8 = 8;
    private static final int NSCS = 9;
    public static final int[] utfState = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 4, 1};
    public static final int[] utfStateMask = new int[]{0, 0, 31, 15, 7};
    static final B2C_ISO2022 asciiConv = new B2C_ISO2022("ASCII", 1, false);
    static final B2C_ISO2022 iso1Conv = new B2C_ISO2022("ISO-8859-1", 1, true);
    static final B2C_ISO2022 defConv = new B2C_ISO2022();
    B2C_ISO2022 b2c;
    B2C_ISO2022[] b2cG = new B2C_ISO2022[4];
    B2C_ISO2022 baseConv = null;
    int state;
    int level;
    boolean eightbit = false;
    boolean iso1right = false;
    int nscslen;
    int nscsbytes;
    int namelen;
    B2C_ISO2022 nscsb2c;
    byte[] nscsCharset;
    boolean nscsCharsetFound;

    protected ISO2022_Decoder(Charset charset, String string) {
        super(charset, 1.0f, 1.0f);
        if ("JP".equals(string)) {
            this.baseConv = new B2C_ISO2022("JIS0208", 2, false);
        } else if ("KR".equals(string)) {
            this.baseConv = new B2C_ISO2022("KSC5601", 2, true);
        } else if ("CN".equals(string)) {
            this.baseConv = new B2C_ISO2022("EUC_TW", 2, true);
        } else if ("CN_GB".equals(string)) {
            this.baseConv = new B2C_ISO2022("GB2312", 2, true);
        } else if ("CT".equals(string)) {
            this.eightbit = true;
            this.iso1right = true;
        }
        this.implReset();
    }

    protected void implReset() {
        this.state = 0;
        this.level = 0;
        this.b2c = asciiConv;
        this.b2cG[0] = asciiConv;
        this.b2cG[1] = this.iso1right ? iso1Conv : defConv;
        this.b2cG[2] = defConv;
        this.b2cG[3] = defConv;
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = 0;
        int n2 = 0;
        int n3 = 65535;
        if (this.state != 1 && this.state != 8 && this.state != 9) {
            this.state = 0;
        }
        CoderResult coderResult = CoderResult.UNDERFLOW;
        while (byteBuffer.hasRemaining()) {
            int n4 = byteBuffer.get() & 0xFF;
            char c = '\uffff';
            if (!this.eightbit && (n4 & 0xFFFFFF80) != 0 && this.state != 8 && this.state != 9) {
                if (this.state == 0 || this.state == 1) {
                    n2 = n3 == 65535 ? 1 : 2;
                }
                byteBuffer.position(byteBuffer.position() - n2);
                return CoderResult.malformedForLength(n2);
            }
            block0 : switch (this.state) {
                case 8: {
                    int n5;
                    int n6 = byteBuffer.position() - 1;
                    if (n4 == 27) {
                        if (byteBuffer.remaining() < 2) {
                            byteBuffer.position(n6);
                            return CoderResult.UNDERFLOW;
                        }
                        if (byteBuffer.get() == 37 && byteBuffer.get() == 64) {
                            this.state = 0;
                            n3 = 65535;
                            break;
                        }
                        this.state = 0;
                        n3 = 65535;
                        byteBuffer.position(n6);
                        break;
                    }
                    int n7 = 0;
                    if (n4 < 128) {
                        n7 = n4;
                    } else {
                        n5 = utfState[n4 >> 3 & 0xF];
                        if (n5 == 1) {
                            byteBuffer.position(n6);
                            return CoderResult.malformedForLength(1);
                        }
                        if (byteBuffer.remaining() < n5 - 1) {
                            byteBuffer.position(n6);
                            return CoderResult.UNDERFLOW;
                        }
                        n7 = n4 & utfStateMask[n5];
                        while (--n5 > 0) {
                            n7 <<= 6;
                            n7 |= byteBuffer.get() & 0x3F;
                        }
                    }
                    if (n7 <= 65535) {
                        if (charBuffer.remaining() < 1) {
                            byteBuffer.position(n6);
                            return CoderResult.OVERFLOW;
                        }
                        charBuffer.put((char)n7);
                        break;
                    }
                    if (charBuffer.remaining() < 2) {
                        byteBuffer.position(n6);
                        return CoderResult.OVERFLOW;
                    }
                    charBuffer.put((char)((n7 - 65536) / 1024 + 55296));
                    charBuffer.put((char)((n7 - 65536) % 1024 + 56320));
                    break;
                }
                case 0: 
                case 1: {
                    if (n4 < 32) {
                        if (this.state == 1 || n3 != 65535) {
                            byteBuffer.position(byteBuffer.position() - 1);
                            return CoderResult.malformedForLength(1);
                        }
                        if (n4 == 27) {
                            this.state = 2;
                            n2 = 1;
                            break;
                        }
                        if (!this.eightbit) {
                            if (n4 == 15) {
                                this.b2c = this.b2cG[0];
                                this.level = 0;
                                break;
                            }
                            if (n4 == 14) {
                                this.b2c = this.b2cG[1];
                                this.level = 1;
                                break;
                            }
                        }
                    }
                    if (this.eightbit) {
                        if (n4 == 155) {
                            this.state = 6;
                            n2 = 1;
                            break;
                        }
                        if (this.state == 0 && (n4 >> 7 & 1) != this.level) {
                            if (n3 != 65535) {
                                byteBuffer.position(byteBuffer.position() - 1);
                                return CoderResult.malformedForLength(1);
                            }
                            if ((n4 & 0xFFFFFF80) != 0) {
                                this.b2c = this.b2cG[1];
                                this.level = 1;
                            } else {
                                this.b2c = this.b2cG[0];
                                this.level = 0;
                            }
                        }
                    }
                    if ((c = (char)this.b2c.getUnicode(n3, n4)) != '\uffff') {
                        if (c == '\ufffd') {
                            byteBuffer.position(byteBuffer.position() - this.b2c.datalen);
                            return CoderResult.unmappableForLength(this.b2c.datalen);
                        }
                        if (!charBuffer.hasRemaining()) {
                            byteBuffer.position(byteBuffer.position() - this.b2c.datalen);
                            return CoderResult.OVERFLOW;
                        }
                        charBuffer.put(c);
                        if (this.state == 1) {
                            this.state = 0;
                            this.b2c = this.b2cG[this.level];
                        }
                        n3 = 65535;
                        break;
                    }
                    n3 = this.b2c.oldData(n3, n4);
                    break;
                }
                case 2: {
                    ++n2;
                    switch (n4) {
                        case 36: {
                            n = 0;
                            this.state = 3;
                            break block0;
                        }
                        case 40: {
                            n = 0;
                            this.state = 4;
                            break block0;
                        }
                        case 41: {
                            n = 1;
                            this.state = 4;
                            break block0;
                        }
                        case 45: {
                            n = 1;
                            this.state = 5;
                            break block0;
                        }
                        case 46: {
                            n = 2;
                            this.state = 5;
                            break block0;
                        }
                        case 47: {
                            n = 3;
                            this.state = 5;
                            break block0;
                        }
                        case 78: {
                            this.b2c = this.b2cG[2];
                            n3 = 65535;
                            this.state = 1;
                            break block0;
                        }
                        case 79: {
                            this.b2c = this.b2cG[3];
                            n3 = 65535;
                            this.state = 1;
                            break block0;
                        }
                        case 37: {
                            this.state = 7;
                            break block0;
                        }
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 38: 
                        case 39: 
                        case 42: 
                        case 43: 
                        case 44: {
                            this.state = 6;
                            break block0;
                        }
                    }
                    n3 = 65535;
                    this.state = 0;
                    break;
                }
                case 7: {
                    int n5;
                    ++n2;
                    if (n4 >= 32 && n4 <= 47) break;
                    n3 = 65535;
                    switch (n4) {
                        case 48: {
                            n5 = byteBuffer.position();
                            boolean bl = true;
                            byte[] byArray = new byte[]{0, 0, 85, 84, 70, 45, 56, 2};
                            for (int i = 0; i < byArray.length; ++i) {
                                byte by = byteBuffer.get();
                                if (byArray[i] == 0 || by == byArray[i]) continue;
                                bl = false;
                            }
                            if (bl) {
                                this.state = 8;
                                n2 = 0;
                                break block0;
                            }
                            byteBuffer.position(n5);
                            this.state = 0;
                            break block0;
                        }
                        case 49: {
                            this.state = 9;
                            this.nscslen = 1;
                            this.nscsbytes = -1;
                            break block0;
                        }
                        case 50: {
                            this.state = 9;
                            this.nscslen = 2;
                            this.nscsbytes = -1;
                            break block0;
                        }
                        case 71: {
                            this.state = 8;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 9: {
                    if (this.nscsbytes < 0) {
                        if (!byteBuffer.hasRemaining()) {
                            byteBuffer.position(byteBuffer.position() - 1);
                            return CoderResult.UNDERFLOW;
                        }
                        this.nscsbytes = (n4 & 0x7F) * 128 + (byteBuffer.get() & 0x7F);
                        if (this.nscsCharset == null) {
                            this.nscsCharset = new byte[256];
                        }
                        this.namelen = 0;
                    } else {
                        if (!this.nscsCharsetFound) {
                            if (n4 == 2) {
                                this.nscsCharsetFound = true;
                                this.nscsb2c = new B2C_ISO2022(new String(this.nscsCharset, 0, this.namelen), this.nscslen);
                            } else if (this.namelen < 256) {
                                this.nscsCharset[this.namelen++] = (byte)n4;
                            }
                        } else {
                            c = this.nscsb2c.getUnicode(n3, n4);
                            if (c != '\uffff') {
                                if (c == '\ufffd') {
                                    byteBuffer.position(byteBuffer.position() - this.nscsb2c.datalen);
                                    return CoderResult.unmappableForLength(this.nscsb2c.datalen);
                                }
                                if (!charBuffer.hasRemaining()) {
                                    byteBuffer.position(byteBuffer.position() - this.nscsb2c.datalen);
                                    return CoderResult.OVERFLOW;
                                }
                                charBuffer.put(c);
                                n3 = 65535;
                            } else {
                                n3 = this.nscsb2c.oldData(n3, n4);
                            }
                        }
                        --this.nscsbytes;
                    }
                    if (this.nscsbytes != 0) break;
                    n3 = 65535;
                    this.state = 0;
                    this.nscsCharsetFound = false;
                    this.nscsb2c = null;
                    break;
                }
                case 6: {
                    ++n2;
                    if (n4 >= 32 && n4 <= 47) break;
                    n3 = 65535;
                    this.state = 0;
                    break;
                }
                case 3: {
                    ++n2;
                    if (n4 <= 47 && n4 >= 32) {
                        if (n4 < 40 || n4 > 43) break;
                        n = n4 - 40;
                        break;
                    }
                    switch (n4) {
                        case 64: 
                        case 66: {
                            this.b2cG[n] = new B2C_ISO2022("JIS0208", 2, null, false, this.baseConv);
                            break;
                        }
                        case 65: {
                            this.b2cG[n] = new B2C_ISO2022("GB2312", 2, null, true, this.baseConv);
                            break;
                        }
                        case 67: {
                            this.b2cG[n] = new B2C_ISO2022("KSC5601", 2, null, true, this.baseConv);
                            break;
                        }
                        case 68: {
                            this.b2cG[n] = new B2C_ISO2022("JIS0212", 2, null, true, this.baseConv);
                            break;
                        }
                        case 71: {
                            this.b2cG[n] = new B2C_ISO2022("EUC_TW", 2, null, true, this.baseConv);
                            break;
                        }
                        case 72: {
                            this.b2cG[n] = new B2C_ISO2022("EUC_TW", 2, new byte[]{-114, -94}, true, this.baseConv);
                            break;
                        }
                        case 73: {
                            this.b2cG[n] = new B2C_ISO2022("EUC_TW", 2, new byte[]{-114, -93}, true, this.baseConv);
                            break;
                        }
                        default: {
                            this.b2cG[n] = new B2C_ISO2022();
                        }
                    }
                    if (n == this.level) {
                        this.b2c = this.b2cG[n];
                    }
                    n3 = 65535;
                    this.state = 0;
                    break;
                }
                case 4: {
                    if (n4 == 66) {
                        this.b2cG[n] = new B2C_ISO2022("ASCII", 1, false);
                    } else if (n4 == 73) {
                        this.b2cG[n] = new B2C_ISO2022("JIS0201", 1, true);
                    } else if (n4 == 74) {
                        this.b2cG[n] = new B2C_ISO2022("JIS8", 1, false);
                    } else {
                        if (n4 >= 32 && n4 <= 47) {
                            ++n2;
                            break;
                        }
                        this.b2cG[n] = new B2C_ISO2022("ASCII", 1, false);
                    }
                    if (n == this.level) {
                        this.b2c = this.b2cG[n];
                    }
                    n3 = 65535;
                    this.state = 0;
                    break;
                }
                case 5: {
                    ++n2;
                    if (n4 >= 32 && n4 <= 47) break;
                    switch (n4) {
                        case 65: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_1", 1, true);
                            break;
                        }
                        case 66: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_2", 1, true);
                            break;
                        }
                        case 67: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_3", 1, true);
                            break;
                        }
                        case 68: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_4", 1, true);
                            break;
                        }
                        case 70: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_7", 1, true);
                            break;
                        }
                        case 71: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_6", 1, true);
                            break;
                        }
                        case 72: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_8", 1, true);
                            break;
                        }
                        case 76: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_5", 1, true);
                            break;
                        }
                        case 77: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_9", 1, true);
                            break;
                        }
                        case 84: {
                            this.b2cG[n] = new B2C_ISO2022("TIS620", 1, true);
                            break;
                        }
                        case 86: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_10", 1, true);
                            break;
                        }
                        case 89: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_13", 1, true);
                            break;
                        }
                        case 95: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_14", 1, true);
                            break;
                        }
                        case 98: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_15", 1, true);
                            break;
                        }
                        case 102: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_16", 1, true);
                            break;
                        }
                        default: {
                            this.b2cG[n] = new B2C_ISO2022("ISO8859_1", 1, true);
                        }
                    }
                    if (n == this.level) {
                        this.b2c = this.b2cG[n];
                    }
                    n3 = 65535;
                    this.state = 0;
                }
            }
        }
        if (8 == this.state) {
            n2 = 0;
            n3 = 65535;
        }
        if (this.state == 0 || this.state == 1) {
            n2 = n3 == 65535 ? 0 : 1;
        } else if (this.state == 9) {
            int n8 = n2 = n3 == 65535 ? 0 : 1;
            if (n2 == 1) {
                ++this.nscsbytes;
            }
        }
        byteBuffer.position(byteBuffer.position() - n2);
        return CoderResult.UNDERFLOW;
    }

    static class B2C_ISO2022 {
        CharsetDecoder b2c;
        int type;
        String name;
        int datalen;
        int dflen;
        boolean msb;
        boolean nomsb;
        byte[] front;
        byte[] inByte;
        ByteBuffer ibb;
        char[] outChar;
        CharBuffer ocb;
        private static final int ASCII = 0;
        private static final int DEFAULT = 1;
        private static final int JIS8 = 2;
        private static final int G1 = 3;

        B2C_ISO2022() {
            this.name = "DEFAULT";
            this.datalen = 1;
            this.type = 1;
        }

        B2C_ISO2022(String string, int n, boolean bl) {
            this(string, n, null, bl, null);
        }

        B2C_ISO2022(String string, int n) {
            this(string, n, null, false, null);
            this.nomsb = true;
        }

        B2C_ISO2022(String string, int n, byte[] byArray, boolean bl, B2C_ISO2022 b2C_ISO2022) {
            this.name = string;
            this.datalen = n;
            this.dflen = n;
            this.front = byArray;
            if (byArray != null) {
                this.dflen += byArray.length;
            }
            this.msb = bl;
            this.nomsb = false;
            if (string.equals("ASCII")) {
                this.type = 1;
            } else if (string.equals("JIS8")) {
                this.type = 2;
            } else {
                if (b2C_ISO2022 != null && b2C_ISO2022.b2c != null && string.equals(b2C_ISO2022.name)) {
                    this.b2c = b2C_ISO2022.b2c;
                } else {
                    try {
                        Charset charset = Charset.forName(string);
                        this.b2c = charset.newDecoder();
                    }
                    catch (Exception exception) {
                        this.type = 1;
                    }
                }
                this.type = 3;
                this.inByte = new byte[this.dflen];
                this.ibb = ByteBuffer.wrap(this.inByte);
            }
            this.outChar = new char[4];
            this.ocb = CharBuffer.wrap(this.outChar);
        }

        char getUnicode(int n, int n2) {
            switch (this.type) {
                case 0: 
                case 1: {
                    return (char)n2;
                }
                case 2: {
                    if (n2 == 92) {
                        return '\u00a5';
                    }
                    if (n2 == 126) {
                        return '\u203e';
                    }
                    return (char)n2;
                }
                case 3: {
                    if (!this.nomsb) {
                        if (this.msb) {
                            n2 |= 0xFFFFFF80;
                            n |= 0x80;
                        } else {
                            n2 &= 0x7F;
                        }
                    }
                    if (this.datalen == 1) {
                        this.inByte[0] = (byte)n2;
                    } else {
                        if (n == 65535) {
                            return '\uffff';
                        }
                        if (this.front != null) {
                            for (int i = 0; i < this.front.length; ++i) {
                                this.inByte[i] = this.front[i];
                            }
                            this.inByte[i] = (byte)n;
                            this.inByte[i + 1] = (byte)n2;
                        } else {
                            this.inByte[0] = (byte)n;
                            this.inByte[1] = (byte)n2;
                        }
                    }
                    try {
                        this.ibb.position(0);
                        this.ocb.position(0);
                        this.b2c.reset();
                        this.b2c.decode(this.ibb, this.ocb, true);
                        this.b2c.flush(this.ocb);
                    }
                    catch (Exception exception) {
                        this.outChar[0] = 65533;
                    }
                    return this.outChar[0];
                }
            }
            return '\ufffd';
        }

        int oldData(int n, int n2) {
            if (this.datalen < 2) {
                return 65535;
            }
            return n2 & (this.nomsb ? 255 : 127);
        }
    }
}

