/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthArrowButton;
import com.sun.java.swing.plaf.gtk.SynthComboPopup;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLabelUI;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import sun.awt.AppContext;

class SynthComboBoxUI
extends ComboBoxUI
implements SynthUI,
LazyActionMap.Loader {
    private SynthStyle style;
    protected JComboBox comboBox;
    protected boolean hasFocus = false;
    private boolean isTableCellEditor = false;
    private static final String IS_TABLE_CELL_EDITOR = "JComboBox.isTableCellEditor";
    protected JList listBox;
    protected CellRendererPane currentValuePane = new CellRendererPane();
    protected SynthComboPopup popup;
    protected Component editor;
    protected JButton arrowButton;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected PropertyChangeListener propertyChangeListener;
    private FocusListener editorFocusListener;
    private ActionListener editorActionListener;
    protected ItemListener itemListener;
    protected MouseListener popupMouseListener;
    protected MouseMotionListener popupMouseMotionListener;
    protected KeyListener popupKeyListener;
    protected ListDataListener listDataListener;
    protected boolean isMinimumSizeDirty = true;
    protected Dimension cachedMinimumSize = new Dimension(0, 0);
    private boolean isDisplaySizeDirty = true;
    private Dimension cachedDisplaySize = new Dimension(0, 0);
    private static final Object COMBO_UI_LIST_CELL_RENDERER_KEY = new StringBuffer("DefaultListCellRendererKey");
    static Action homeAction = new NavigationalAction(36);
    static Action endAction = new NavigationalAction(35);
    static Action pgUpAction = new NavigationalAction(33);
    static Action pgDownAction = new NavigationalAction(34);
    static /* synthetic */ Class class$java$lang$String;

    SynthComboBoxUI() {
    }

    private static ListCellRenderer getDefaultListCellRenderer() {
        ListCellRenderer listCellRenderer = (ListCellRenderer)AppContext.getAppContext().get(COMBO_UI_LIST_CELL_RENDERER_KEY);
        if (listCellRenderer == null) {
            listCellRenderer = new DefaultListCellRenderer();
            AppContext.getAppContext().put(COMBO_UI_LIST_CELL_RENDERER_KEY, new DefaultListCellRenderer());
        }
        return listCellRenderer;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        this.isMinimumSizeDirty = true;
        this.comboBox = (JComboBox)jComponent;
        this.popup = this.createPopup();
        this.popup.setName("ComboPopup.popup");
        this.installDefaults();
        this.listBox = this.popup.getList();
        Boolean bl = (Boolean)jComponent.getClientProperty(IS_TABLE_CELL_EDITOR);
        if (bl != null) {
            boolean bl2 = this.isTableCellEditor = bl.equals(Boolean.TRUE);
        }
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(this.createRenderer());
        }
        if (this.comboBox.getEditor() == null || this.comboBox.getEditor() instanceof UIResource) {
            this.comboBox.setEditor(this.createEditor());
        }
        this.installListeners();
        this.installComponents();
        this.comboBox.setLayout(this.createLayoutManager());
        this.comboBox.setRequestFocusEnabled(true);
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.setPopupVisible(this.comboBox, false);
        this.popup.uninstallingUI();
        this.uninstallKeyboardActions();
        this.comboBox.setLayout(null);
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(null);
        }
        if (this.comboBox.getEditor() == null || this.comboBox.getEditor() instanceof UIResource) {
            this.comboBox.setEditor(null);
        }
        this.keyListener = null;
        this.focusListener = null;
        this.listDataListener = null;
        this.propertyChangeListener = null;
        this.editorActionListener = null;
        this.editorFocusListener = null;
        this.popup = null;
        this.listBox = null;
        this.comboBox = null;
    }

    protected void installDefaults() {
        this.fetchStyle(this.comboBox);
    }

    private void fetchStyle(JComboBox jComboBox) {
        SynthContext synthContext = this.getContext(jComboBox, 1);
        this.popup.setBackground(Color.WHITE);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected void installListeners() {
        this.itemListener = this.createItemListener();
        if (this.itemListener != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.comboBox.addKeyListener(this.keyListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.comboBox.addFocusListener(this.focusListener);
        }
        if ((this.popupMouseListener = this.popup.getMouseListener()) != null) {
            this.comboBox.addMouseListener(this.popupMouseListener);
        }
        if ((this.popupMouseMotionListener = this.popup.getMouseMotionListener()) != null) {
            this.comboBox.addMouseMotionListener(this.popupMouseMotionListener);
        }
        if ((this.popupKeyListener = this.popup.getKeyListener()) != null) {
            this.comboBox.addKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && (this.listDataListener = this.createListDataListener()) != null) {
            this.comboBox.getModel().addListDataListener(this.listDataListener);
        }
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.comboBox, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        if (this.keyListener != null) {
            this.comboBox.removeKeyListener(this.keyListener);
        }
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.focusListener != null) {
            this.comboBox.removeFocusListener(this.focusListener);
        }
        if (this.popupMouseListener != null) {
            this.comboBox.removeMouseListener(this.popupMouseListener);
        }
        if (this.popupMouseMotionListener != null) {
            this.comboBox.removeMouseMotionListener(this.popupMouseMotionListener);
        }
        if (this.popupKeyListener != null) {
            this.comboBox.removeKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && this.listDataListener != null) {
            this.comboBox.getModel().removeListDataListener(this.listDataListener);
        }
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    protected SynthComboPopup createPopup() {
        SynthComboPopup synthComboPopup = new SynthComboPopup(this.comboBox);
        synthComboPopup.getAccessibleContext().setAccessibleParent(this.comboBox);
        return synthComboPopup;
    }

    protected KeyListener createKeyListener() {
        return new NoSelectKeyHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    protected ItemListener createItemListener() {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager();
    }

    protected ListCellRenderer createRenderer() {
        return new SynthComboBoxRenderer();
    }

    protected ComboBoxEditor createEditor() {
        return new SynthComboBoxEditor();
    }

    private void updateToolTipTextForChildren() {
        Component[] componentArray = this.comboBox.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JComponent)) continue;
            ((JComponent)componentArray[i]).setToolTipText(this.comboBox.getToolTipText());
        }
    }

    protected void installComponents() {
        this.arrowButton = this.createArrowButton();
        this.comboBox.add(this.arrowButton);
        if (this.arrowButton != null) {
            this.configureArrowButton();
        }
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    protected void uninstallComponents() {
        if (this.arrowButton != null) {
            this.unconfigureArrowButton();
        }
        if (this.editor != null) {
            this.unconfigureEditor();
        }
        this.comboBox.removeAll();
        this.arrowButton = null;
    }

    public void addEditor() {
        this.removeEditor();
        this.editor = this.comboBox.getEditor().getEditorComponent();
        if (this.editor != null) {
            this.configureEditor();
            this.comboBox.add(this.editor);
        }
    }

    public void removeEditor() {
        if (this.editor != null) {
            this.unconfigureEditor();
            this.comboBox.remove(this.editor);
            this.editor = null;
        }
    }

    protected void configureEditor() {
        AccessibleContext accessibleContext;
        this.editor.setEnabled(this.comboBox.isEnabled());
        this.editor.setFont(this.comboBox.getFont());
        if (this.editor instanceof Accessible && (accessibleContext = ((Accessible)((Object)this.editor)).getAccessibleContext()) != null) {
            accessibleContext.setAccessibleParent(this.comboBox);
        }
        if (this.focusListener != null) {
            this.editor.addFocusListener(this.focusListener);
        }
        if (this.editorFocusListener == null) {
            this.editorFocusListener = new EditorFocusListener();
        }
        this.editor.addFocusListener(this.editorFocusListener);
        if (this.editorActionListener == null) {
            this.editorActionListener = new EditorActionListener();
        }
        this.comboBox.getEditor().addActionListener(this.editorActionListener);
        this.comboBox.configureEditor(this.comboBox.getEditor(), this.comboBox.getSelectedItem());
    }

    protected void unconfigureEditor() {
        if (this.focusListener != null) {
            this.editor.removeFocusListener(this.focusListener);
        }
        if (this.editorFocusListener != null) {
            this.editor.removeFocusListener(this.editorFocusListener);
        }
        if (this.editorActionListener != null) {
            this.comboBox.getEditor().removeActionListener(this.editorActionListener);
        }
    }

    public void configureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.setName("ComboBox.arrowButton");
            this.arrowButton.setEnabled(this.comboBox.isEnabled());
            this.arrowButton.setRequestFocusEnabled(false);
            this.arrowButton.addMouseListener(this.popup.getMouseListener());
            this.arrowButton.addMouseMotionListener(this.popup.getMouseMotionListener());
            this.arrowButton.resetKeyboardActions();
        }
    }

    public void unconfigureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.removeMouseListener(this.popup.getMouseListener());
            this.arrowButton.removeMouseMotionListener(this.popup.getMouseMotionListener());
        }
    }

    protected JButton createArrowButton() {
        return new SynthArrowButton(5);
    }

    public boolean isPopupVisible(JComboBox jComboBox) {
        return this.popup.isVisible();
    }

    public void setPopupVisible(JComboBox jComboBox, boolean bl) {
        if (bl) {
            this.popup.show();
        } else {
            this.popup.hide();
        }
    }

    public boolean isFocusTraversable(JComboBox jComboBox) {
        return !this.comboBox.isEditable();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValue(graphics, rectangle, this.hasFocus);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = this.getDisplaySize();
        Insets insets = this.getInsets();
        dimension.height += insets.top + insets.bottom;
        int n = dimension.height - (insets.top + insets.bottom);
        dimension.width += insets.left + insets.right + n;
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(dimension);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public int getAccessibleChildrenCount(JComponent jComponent) {
        if (this.comboBox.isEditable()) {
            return 2;
        }
        return 1;
    }

    public Accessible getAccessibleChild(JComponent jComponent, int n) {
        switch (n) {
            case 0: {
                if (!(this.popup instanceof Accessible)) break;
                AccessibleContext accessibleContext = this.popup.getAccessibleContext();
                accessibleContext.setAccessibleParent(this.comboBox);
                return this.popup;
            }
            case 1: {
                if (!this.comboBox.isEditable() || !(this.editor instanceof Accessible)) break;
                AccessibleContext accessibleContext = ((Accessible)((Object)this.editor)).getAccessibleContext();
                accessibleContext.setAccessibleParent(this.comboBox);
                return (Accessible)((Object)this.editor);
            }
        }
        return null;
    }

    protected boolean isNavigationKey(int n) {
        return n == 38 || n == 40 || n == KeyStroke.getKeyStroke("KP_UP").getKeyCode() || n == KeyStroke.getKeyStroke("KP_DOWN").getKeyCode();
    }

    protected void selectNextPossibleValue() {
        int n = this.listBox.getSelectedIndex();
        if (n < this.comboBox.getModel().getSize() - 1) {
            this.listBox.setSelectedIndex(n + 1);
            this.listBox.ensureIndexIsVisible(n + 1);
            this.comboBox.repaint();
        }
    }

    protected void selectPreviousPossibleValue() {
        int n = this.listBox.getSelectedIndex();
        if (n > 0) {
            this.listBox.setSelectedIndex(n - 1);
            this.listBox.ensureIndexIsVisible(n - 1);
            this.comboBox.repaint();
        }
    }

    protected void toggleOpenClose() {
        this.setPopupVisible(this.comboBox, !this.isPopupVisible(this.comboBox));
    }

    protected Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int n3 = n2 - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            n3 = this.arrowButton.getWidth();
        }
        if (SynthLookAndFeel.isLeftToRight(this.comboBox)) {
            return new Rectangle(insets.left, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + n3, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
    }

    protected Insets getInsets() {
        return this.comboBox.getInsets();
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        Component component = bl && !this.isPopupVisible(this.comboBox) ? listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false) : listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        boolean bl2 = false;
        if (component instanceof JPanel) {
            bl2 = true;
        }
        if (component instanceof UIResource) {
            component.setName("ComboBox.renderer");
            this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl2);
        } else {
            this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl2);
        }
    }

    void repaintCurrentValue() {
        Rectangle rectangle = this.rectangleForCurrentValue();
        this.comboBox.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected Dimension getDefaultSize() {
        Dimension dimension = this.getSizeForComponent(SynthComboBoxUI.getDefaultListCellRenderer().getListCellRendererComponent(this.listBox, " ", -1, false, false));
        return new Dimension(dimension.width, dimension.height);
    }

    protected Dimension getDisplaySize() {
        Object object;
        Object object2;
        if (!this.isDisplaySizeDirty) {
            return new Dimension(this.cachedDisplaySize);
        }
        Dimension dimension = new Dimension();
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (listCellRenderer == null) {
            listCellRenderer = new DefaultListCellRenderer();
        }
        if ((object2 = this.comboBox.getPrototypeDisplayValue()) != null) {
            dimension = this.getSizeForComponent(listCellRenderer.getListCellRendererComponent(this.listBox, object2, -1, false, false));
        } else {
            object = this.comboBox.getModel();
            int n = object.getSize();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    Dimension dimension2 = this.getSizeForComponent(listCellRenderer.getListCellRendererComponent(this.listBox, object.getElementAt(i), -1, false, false));
                    dimension.width = Math.max(dimension.width, dimension2.width);
                    dimension.height = Math.max(dimension.height, dimension2.height);
                }
            } else {
                dimension = this.getDefaultSize();
                if (this.comboBox.isEditable()) {
                    dimension.width = 100;
                }
            }
        }
        if (this.comboBox.isEditable()) {
            object = this.editor.getPreferredSize();
            dimension.width = Math.max(dimension.width, ((Dimension)object).width);
            dimension.height = Math.max(dimension.height, ((Dimension)object).height);
        }
        this.cachedDisplaySize.setSize(dimension.width, dimension.height);
        this.isDisplaySizeDirty = false;
        return dimension;
    }

    private Dimension getSizeForComponent(Component component) {
        this.currentValuePane.add(component);
        component.setFont(this.comboBox.getFont());
        Dimension dimension = component.getPreferredSize();
        this.currentValuePane.remove(component);
        return dimension;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, inputMap);
        LazyActionMap.installLazyActionMap(this.comboBox, this);
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            SynthContext synthContext = this.getContext(this.comboBox, 1);
            InputMap inputMap = (InputMap)synthContext.getStyle().get(synthContext, "ComboBox.ancestorInputMap");
            synthContext.dispose();
            return inputMap;
        }
        return null;
    }

    public void loadActionMap(JComponent jComponent, ActionMap actionMap) {
        actionMap.put("hidePopup", new HidePopupAction());
        actionMap.put("pageDownPassThrough", pgDownAction);
        actionMap.put("pageUpPassThrough", pgUpAction);
        actionMap.put("homePassThrough", homeAction);
        actionMap.put("endPassThrough", endAction);
        actionMap.put("selectNext", new DownAction());
        actionMap.put("togglePopup", new AltAction());
        actionMap.put("spacePopup", new SpaceAction());
        actionMap.put("selectPrevious", new UpAction());
        actionMap.put("enterPressed", new EnterAction());
    }

    boolean isTableCellEditor() {
        return this.isTableCellEditor;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, null);
        SwingUtilities.replaceUIActionMap(this.comboBox, null);
    }

    private static class SynthComboBoxEditor
    implements ComboBoxEditor,
    UIResource {
        protected JTextField editor = new JTextField("", 9);
        private Object oldValue;

        public SynthComboBoxEditor() {
            this.editor.setName("ComboBox.textField");
        }

        public Component getEditorComponent() {
            return this.editor;
        }

        public void setItem(Object object) {
            String string;
            if (object != null) {
                string = object.toString();
                this.oldValue = object;
            } else {
                string = "";
            }
            if (!string.equals(this.editor.getText())) {
                this.editor.setText(string);
            }
        }

        public Object getItem() {
            Object object = this.editor.getText();
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                if (object.equals(this.oldValue.toString())) {
                    return this.oldValue;
                }
                Class<?> clazz = this.oldValue.getClass();
                try {
                    Method method = clazz.getMethod("valueOf", class$java$lang$String == null ? (class$java$lang$String = SynthComboBoxUI.class$("java.lang.String")) : class$java$lang$String);
                    object = method.invoke(this.oldValue, this.editor.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object;
        }

        public void selectAll() {
            this.editor.selectAll();
            this.editor.requestFocus();
        }

        public void addActionListener(ActionListener actionListener) {
            this.editor.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.editor.removeActionListener(actionListener);
        }
    }

    static class SynthComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public SynthComboBoxRenderer() {
            this.setName("ComboBox.renderer");
            this.setText(" ");
            ((SynthLabelUI)this.getUI()).forceFetchStyle(this);
        }

        public void addNotify() {
            String string = this.getName();
            this.setName("ComboBox.renderer");
            super.addNotify();
            this.setName(string);
        }

        public boolean isOpaque() {
            return true;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.rendererx");
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setFont(jList.getFont());
            if (object instanceof Icon) {
                this.setIcon((Icon)object);
                this.setText("");
            } else {
                String string;
                String string2 = string = object == null ? " " : object.toString();
                if ("".equals(string)) {
                    string = " ";
                }
                this.setText(string);
            }
            return this;
        }
    }

    class EditorActionListener
    implements ActionListener {
        EditorActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action action;
            ActionMap actionMap;
            Object object = SynthComboBoxUI.this.comboBox.getEditor().getItem();
            if (object != null && object.equals(SynthComboBoxUI.this.comboBox.getSelectedItem()) && (actionMap = SynthComboBoxUI.this.comboBox.getActionMap()) != null && (action = actionMap.get("enterPressed")) != null) {
                action.actionPerformed(new ActionEvent(SynthComboBoxUI.this.comboBox, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getModifiers()));
            }
            if (SynthComboBoxUI.this.isPopupVisible(SynthComboBoxUI.this.comboBox)) {
                SynthComboBoxUI.this.comboBox.setSelectedIndex(SynthComboBoxUI.this.listBox.getSelectedIndex());
            }
        }
    }

    class EditorFocusListener
    extends FocusAdapter {
        EditorFocusListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            ComboBoxEditor comboBoxEditor = SynthComboBoxUI.this.comboBox.getEditor();
            Object object = comboBoxEditor.getItem();
            if (!focusEvent.isTemporary() && object != null && !object.equals(SynthComboBoxUI.this.comboBox.getSelectedItem())) {
                SynthComboBoxUI.this.comboBox.actionPerformed(new ActionEvent(comboBoxEditor, 0, "", EventQueue.getMostRecentEventTime(), 0));
            }
        }
    }

    static class UpAction
    extends AbstractAction {
        UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SynthComboBoxUI synthComboBoxUI;
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled() && (synthComboBoxUI = (SynthComboBoxUI)jComboBox.getUI()).isPopupVisible(jComboBox)) {
                synthComboBoxUI.selectPreviousPossibleValue();
            }
        }
    }

    static class SpaceAction
    extends AltAction {
        SpaceAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (!jComboBox.isEditable()) {
                super.actionPerformed(actionEvent);
            }
        }
    }

    static class AltAction
    extends AbstractAction {
        AltAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled()) {
                SynthComboBoxUI synthComboBoxUI = (SynthComboBoxUI)jComboBox.getUI();
                if (synthComboBoxUI.isTableCellEditor()) {
                    jComboBox.setSelectedIndex(synthComboBoxUI.popup.getList().getSelectedIndex());
                } else {
                    jComboBox.setPopupVisible(!jComboBox.isPopupVisible());
                }
            }
        }
    }

    static class EnterAction
    extends AbstractAction {
        EnterAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (!jComboBox.isEnabled()) {
                return;
            }
            SynthComboBoxUI synthComboBoxUI = (SynthComboBoxUI)jComboBox.getUI();
            if (synthComboBoxUI.isTableCellEditor()) {
                jComboBox.setSelectedIndex(synthComboBoxUI.popup.getList().getSelectedIndex());
            } else if (jComboBox.isPopupVisible()) {
                jComboBox.setPopupVisible(false);
                jComboBox.setSelectedIndex(synthComboBoxUI.popup.getList().getSelectedIndex());
            } else {
                JRootPane jRootPane = SwingUtilities.getRootPane(jComboBox);
                if (jRootPane != null) {
                    Action action;
                    Object object;
                    InputMap inputMap = jRootPane.getInputMap(2);
                    ActionMap actionMap = jRootPane.getActionMap();
                    if (inputMap != null && actionMap != null && (object = inputMap.get(KeyStroke.getKeyStroke(10, 0))) != null && (action = actionMap.get(object)) != null) {
                        action.actionPerformed(actionEvent);
                    }
                }
            }
        }
    }

    static class DownAction
    extends AbstractAction {
        DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled() && jComboBox.isShowing()) {
                if (jComboBox.isPopupVisible()) {
                    SynthComboBoxUI synthComboBoxUI = (SynthComboBoxUI)jComboBox.getUI();
                    synthComboBoxUI.selectNextPossibleValue();
                } else {
                    jComboBox.setPopupVisible(true);
                }
            }
        }
    }

    static class NavigationalAction
    extends AbstractAction {
        int keyCode;

        NavigationalAction(int n) {
            this.keyCode = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            int n = this.getNextIndex(jComboBox);
            if (n >= 0 && n < jComboBox.getItemCount()) {
                jComboBox.setSelectedIndex(n);
            }
        }

        int getNextIndex(JComboBox jComboBox) {
            switch (this.keyCode) {
                case 33: {
                    int n = jComboBox.getMaximumRowCount();
                    int n2 = jComboBox.getSelectedIndex() - n;
                    return n2 < 0 ? 0 : n2;
                }
                case 34: {
                    int n = jComboBox.getMaximumRowCount();
                    int n3 = jComboBox.getSelectedIndex() + n;
                    int n4 = jComboBox.getItemCount();
                    return n3 < n4 ? n3 : n4 - 1;
                }
                case 36: {
                    return 0;
                }
                case 35: {
                    return jComboBox.getItemCount() - 1;
                }
            }
            return jComboBox.getSelectedIndex();
        }
    }

    class HidePopupAction
    extends AbstractAction {
        HidePopupAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled()) {
                jComboBox.firePopupMenuCanceled();
                jComboBox.setPopupVisible(false);
            }
        }

        public boolean isEnabled() {
            return SynthComboBoxUI.this.comboBox.isPopupVisible();
        }
    }

    class ComboBoxLayoutManager
    implements LayoutManager {
        ComboBoxLayoutManager() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            return container.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            return container.getMinimumSize();
        }

        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            Insets insets = SynthComboBoxUI.this.getInsets();
            int n3 = n2 - (insets.top + insets.bottom);
            if (SynthComboBoxUI.this.arrowButton != null) {
                if (SynthLookAndFeel.isLeftToRight(jComboBox)) {
                    SynthComboBoxUI.this.arrowButton.setBounds(n - (insets.right + n3), insets.top, n3, n3);
                } else {
                    SynthComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, n3, n3);
                }
            }
            if (SynthComboBoxUI.this.editor != null) {
                Rectangle rectangle = SynthComboBoxUI.this.rectangleForCurrentValue();
                SynthComboBoxUI.this.editor.setBounds(rectangle);
            }
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JComboBox jComboBox = (JComboBox)propertyChangeEvent.getSource();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthComboBoxUI.this.fetchStyle(jComboBox);
            }
            if (string.equals("model")) {
                ComboBoxModel comboBoxModel = (ComboBoxModel)propertyChangeEvent.getNewValue();
                ComboBoxModel comboBoxModel2 = (ComboBoxModel)propertyChangeEvent.getOldValue();
                if (comboBoxModel2 != null && SynthComboBoxUI.this.listDataListener != null) {
                    comboBoxModel2.removeListDataListener(SynthComboBoxUI.this.listDataListener);
                }
                if (comboBoxModel != null && SynthComboBoxUI.this.listDataListener != null) {
                    comboBoxModel.addListDataListener(SynthComboBoxUI.this.listDataListener);
                }
                if (SynthComboBoxUI.this.editor != null) {
                    jComboBox.configureEditor(jComboBox.getEditor(), jComboBox.getSelectedItem());
                }
                SynthComboBoxUI.this.isMinimumSizeDirty = true;
                SynthComboBoxUI.this.isDisplaySizeDirty = true;
                jComboBox.revalidate();
                jComboBox.repaint();
            } else if (string.equals("editor") && jComboBox.isEditable()) {
                SynthComboBoxUI.this.addEditor();
                jComboBox.revalidate();
            } else if (string.equals("editable")) {
                if (jComboBox.isEditable()) {
                    jComboBox.setRequestFocusEnabled(false);
                    SynthComboBoxUI.this.addEditor();
                } else {
                    jComboBox.setRequestFocusEnabled(true);
                    SynthComboBoxUI.this.removeEditor();
                }
                SynthComboBoxUI.this.updateToolTipTextForChildren();
                jComboBox.revalidate();
            } else if (string.equals("enabled")) {
                boolean bl = jComboBox.isEnabled();
                if (SynthComboBoxUI.this.editor != null) {
                    SynthComboBoxUI.this.editor.setEnabled(bl);
                }
                if (SynthComboBoxUI.this.arrowButton != null) {
                    SynthComboBoxUI.this.arrowButton.setEnabled(bl);
                }
                jComboBox.repaint();
            } else if (string.equals("maximumRowCount")) {
                if (SynthComboBoxUI.this.isPopupVisible(jComboBox)) {
                    SynthComboBoxUI.this.setPopupVisible(jComboBox, false);
                    SynthComboBoxUI.this.setPopupVisible(jComboBox, true);
                }
            } else if (string.equals("font")) {
                SynthComboBoxUI.this.listBox.setFont(jComboBox.getFont());
                if (SynthComboBoxUI.this.editor != null) {
                    SynthComboBoxUI.this.editor.setFont(jComboBox.getFont());
                }
                SynthComboBoxUI.this.isMinimumSizeDirty = true;
                jComboBox.validate();
            } else if (string.equals("ToolTipText")) {
                SynthComboBoxUI.this.updateToolTipTextForChildren();
            } else if (string.equals(SynthComboBoxUI.IS_TABLE_CELL_EDITOR)) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                SynthComboBoxUI.this.isTableCellEditor = bl.equals(Boolean.TRUE);
            } else if (string.equals("prototypeDisplayValue")) {
                SynthComboBoxUI.this.isMinimumSizeDirty = true;
                SynthComboBoxUI.this.isDisplaySizeDirty = true;
                jComboBox.revalidate();
            } else if (string.equals("renderer")) {
                SynthComboBoxUI.this.isMinimumSizeDirty = true;
                SynthComboBoxUI.this.isDisplaySizeDirty = true;
                jComboBox.revalidate();
            }
        }
    }

    class ItemHandler
    implements ItemListener {
        ItemHandler() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }

    class ListDataHandler
    implements ListDataListener {
        ListDataHandler() {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            if (listDataEvent.getIndex0() != -1 || listDataEvent.getIndex1() != -1) {
                SynthComboBoxUI.this.isMinimumSizeDirty = true;
                SynthComboBoxUI.this.comboBox.revalidate();
            }
            if (SynthComboBoxUI.this.comboBox.isEditable() && SynthComboBoxUI.this.editor != null) {
                SynthComboBoxUI.this.comboBox.configureEditor(SynthComboBoxUI.this.comboBox.getEditor(), SynthComboBoxUI.this.comboBox.getSelectedItem());
            }
            SynthComboBoxUI.this.comboBox.repaint();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            SynthComboBoxUI.this.isDisplaySizeDirty = true;
            this.contentsChanged(listDataEvent);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            SynthComboBoxUI.this.isDisplaySizeDirty = true;
            this.contentsChanged(listDataEvent);
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            AccessibleContext accessibleContext;
            SynthComboBoxUI.this.hasFocus = true;
            SynthComboBoxUI.this.comboBox.repaint();
            if (SynthComboBoxUI.this.comboBox.isEditable() && SynthComboBoxUI.this.editor != null) {
                SynthComboBoxUI.this.editor.requestFocus();
            }
            if (SynthComboBoxUI.this.comboBox instanceof Accessible && (accessibleContext = SynthComboBoxUI.this.comboBox.getAccessibleContext()) != null) {
                accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            AccessibleContext accessibleContext;
            SynthComboBoxUI.this.hasFocus = false;
            if (!focusEvent.isTemporary() && SynthComboBoxUI.this.comboBox.isLightWeightPopupEnabled()) {
                SynthComboBoxUI.this.setPopupVisible(SynthComboBoxUI.this.comboBox, false);
            }
            SynthComboBoxUI.this.comboBox.repaint();
            if (SynthComboBoxUI.this.comboBox instanceof Accessible && (accessibleContext = SynthComboBoxUI.this.comboBox.getAccessibleContext()) != null) {
                accessibleContext.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }
    }

    private class NoSelectKeyHandler
    extends KeyAdapter {
        private NoSelectKeyHandler() {
        }

        private int selectionForKey(char c) {
            String string;
            int n;
            int n2;
            int n3 = -1;
            Object object = SynthComboBoxUI.this.listBox.getSelectedValue();
            ListModel listModel = SynthComboBoxUI.this.listBox.getModel();
            if (object != null) {
                n2 = listModel.getSize();
                for (n = 0; n < n2; ++n) {
                    if (object != listModel.getElementAt(n)) continue;
                    n3 = n;
                    break;
                }
            }
            String string2 = ("" + c).toLowerCase();
            c = string2.charAt(0);
            n2 = listModel.getSize();
            for (n = ++n3; n < n2; ++n) {
                if (listModel.getElementAt(n) == null || listModel.getElementAt(n).toString() == null || (string = listModel.getElementAt(n).toString().toLowerCase()).length() <= 0 || string.charAt(0) != c) continue;
                return n;
            }
            for (n = 0; n < n3; ++n) {
                if (listModel.getElementAt(n) == null || listModel.getElementAt(n).toString() == null || (string = listModel.getElementAt(n).toString().toLowerCase()).length() <= 0 || string.charAt(0) != c) continue;
                return n;
            }
            return -1;
        }

        private boolean selectWithKeyCharNoAction(char c) {
            int n = this.selectionForKey(c);
            if (n != -1) {
                SynthComboBoxUI.this.comboBox.setPopupVisible(true);
                SynthComboBoxUI.this.listBox.setSelectedIndex(n);
                SynthComboBoxUI.this.listBox.ensureIndexIsVisible(n);
                return true;
            }
            return false;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (SynthComboBoxUI.this.comboBox.isEnabled() && !SynthComboBoxUI.this.isNavigationKey(keyEvent.getKeyCode()) && this.isTypeAheadKey(keyEvent)) {
                if (SynthComboBoxUI.this.comboBox.getKeySelectionManager() != null) {
                    if (SynthComboBoxUI.this.comboBox.selectWithKeyChar(keyEvent.getKeyChar())) {
                        keyEvent.consume();
                    }
                } else if (this.selectWithKeyCharNoAction(keyEvent.getKeyChar())) {
                    keyEvent.consume();
                }
            }
        }

        boolean isTypeAheadKey(KeyEvent keyEvent) {
            return !keyEvent.isAltDown() && !keyEvent.isControlDown() && !keyEvent.isMetaDown();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (SynthComboBoxUI.this.comboBox.isEnabled() && !SynthComboBoxUI.this.isNavigationKey(keyEvent.getKeyCode()) && this.isTypeAheadKey(keyEvent) && SynthComboBoxUI.this.comboBox.selectWithKeyChar(keyEvent.getKeyChar())) {
                keyEvent.consume();
            }
        }

        boolean isTypeAheadKey(KeyEvent keyEvent) {
            return !keyEvent.isAltDown() && !keyEvent.isControlDown() && !keyEvent.isMetaDown();
        }
    }
}

