/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public class WritableRaster
extends Raster {
    protected WritableRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected WritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected WritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, WritableRaster writableRaster) {
        super(sampleModel, dataBuffer, rectangle, point, writableRaster);
    }

    public WritableRaster getWritableParent() {
        return (WritableRaster)this.parent;
    }

    public WritableRaster createWritableTranslatedChild(int n, int n2) {
        return this.createWritableChild(this.minX, this.minY, this.width, this.height, n, n2, null);
    }

    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("parentX lies outside raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("parentY lies outside raster");
        }
        if (n + n3 < n || n + n3 > this.width + this.minX) {
            throw new RasterFormatException("(parentX + width) is outside raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.height + this.minY) {
            throw new RasterFormatException("(parentY + height) is outside raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        return new WritableRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    public void setDataElements(int n, int n2, Object object) {
        this.sampleModel.setDataElements(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, object, this.dataBuffer);
    }

    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = n + raster.getMinX();
        int n4 = n2 + raster.getMinY();
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        if (n3 < this.minX || n4 < this.minY || n3 + n5 > this.minX + this.width || n4 + n6 > this.minY + this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = raster.getMinX();
        int n8 = raster.getMinY();
        Object object = null;
        for (int i = 0; i < n6; ++i) {
            object = raster.getDataElements(n7, n8 + i, n5, 1, object);
            this.setDataElements(n3, n4 + i, n5, 1, object);
        }
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        this.sampleModel.setDataElements(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, object, this.dataBuffer);
    }

    public void setRect(Raster raster) {
        this.setRect(0, 0, raster);
    }

    public void setRect(int n, int n2, Raster raster) {
        int n3;
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        int n8 = n + n6;
        int n9 = n2 + n7;
        if (n8 < this.minX) {
            n3 = this.minX - n8;
            n4 -= n3;
            n6 += n3;
            n8 = this.minX;
        }
        if (n9 < this.minY) {
            n3 = this.minY - n9;
            n5 -= n3;
            n7 += n3;
            n9 = this.minY;
        }
        if (n8 + n4 > this.minX + this.width) {
            n4 = this.minX + this.width - n8;
        }
        if (n9 + n5 > this.minY + this.height) {
            n5 = this.minY + this.height - n9;
        }
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        switch (raster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = null;
                for (int i = 0; i < n5; ++i) {
                    nArray = raster.getPixels(n6, n7 + i, n4, 1, nArray);
                    this.setPixels(n8, n9 + i, n4, 1, nArray);
                }
                break;
            }
            case 4: {
                float[] fArray = null;
                for (int i = 0; i < n5; ++i) {
                    fArray = raster.getPixels(n6, n7 + i, n4, 1, fArray);
                    this.setPixels(n8, n9 + i, n4, 1, fArray);
                }
                break;
            }
            case 5: {
                double[] dArray = null;
                for (int i = 0; i < n5; ++i) {
                    dArray = raster.getPixels(n6, n7 + i, n4, 1, dArray);
                    this.setPixels(n8, n9 + i, n4, 1, dArray);
                }
                break;
            }
        }
    }

    public void setPixel(int n, int n2, int[] nArray) {
        this.sampleModel.setPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, nArray, this.dataBuffer);
    }

    public void setPixel(int n, int n2, float[] fArray) {
        this.sampleModel.setPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public void setPixel(int n, int n2, double[] dArray) {
        this.sampleModel.setPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray) {
        this.sampleModel.setPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, nArray, this.dataBuffer);
    }

    public void setPixels(int n, int n2, int n3, int n4, float[] fArray) {
        this.sampleModel.setPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, fArray, this.dataBuffer);
    }

    public void setPixels(int n, int n2, int n3, int n4, double[] dArray) {
        this.sampleModel.setPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, dArray, this.dataBuffer);
    }

    public void setSample(int n, int n2, int n3, int n4) {
        this.sampleModel.setSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, this.dataBuffer);
    }

    public void setSample(int n, int n2, int n3, float f) {
        this.sampleModel.setSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, f, this.dataBuffer);
    }

    public void setSample(int n, int n2, int n3, double d) {
        this.sampleModel.setSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, d, this.dataBuffer);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this.sampleModel.setSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, nArray, this.dataBuffer);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        this.sampleModel.setSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, fArray, this.dataBuffer);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        this.sampleModel.setSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, dArray, this.dataBuffer);
    }
}

