/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

class MimeType
implements Serializable,
Cloneable {
    private String[] myPieces;
    private transient String myStringValue = null;
    private transient ParameterMapEntrySet myEntrySet = null;
    private transient ParameterMap myParameterMap = null;
    private static final int TOKEN_LEXEME = 0;
    private static final int QUOTED_STRING_LEXEME = 1;
    private static final int TSPECIAL_LEXEME = 2;
    private static final int EOF_LEXEME = 3;
    private static final int ILLEGAL_LEXEME = 4;

    public MimeType(String string) {
        this.parse(string);
    }

    public String getMimeType() {
        return this.getStringValue();
    }

    public String getMediaType() {
        return this.myPieces[0];
    }

    public String getMediaSubtype() {
        return this.myPieces[1];
    }

    public Map getParameterMap() {
        if (this.myParameterMap == null) {
            this.myParameterMap = new ParameterMap();
        }
        return this.myParameterMap;
    }

    public String toString() {
        return this.getStringValue();
    }

    public int hashCode() {
        return this.getStringValue().hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof MimeType && this.getStringValue().equals(((MimeType)object).getStringValue());
    }

    private String getStringValue() {
        if (this.myStringValue == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.myPieces[0]);
            stringBuffer.append('/');
            stringBuffer.append(this.myPieces[1]);
            int n = this.myPieces.length;
            for (int i = 2; i < n; i += 2) {
                stringBuffer.append(';');
                stringBuffer.append(' ');
                stringBuffer.append(this.myPieces[i]);
                stringBuffer.append('=');
                stringBuffer.append(MimeType.addQuotes(this.myPieces[i + 1]));
            }
            this.myStringValue = stringBuffer.toString();
        }
        return this.myStringValue;
    }

    private static String toUnicodeLowerCase(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = Character.toLowerCase(string.charAt(i));
        }
        return new String(cArray);
    }

    private static String removeBackslashes(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                c = string.charAt(++i);
            }
            cArray[n2++] = c;
        }
        return new String(cArray, 0, n2);
    }

    private static String addQuotes(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 2);
        stringBuffer.append('\"');
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private void parse(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        LexicalAnalyzer lexicalAnalyzer = new LexicalAnalyzer(string);
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        boolean bl2 = false;
        if (lexicalAnalyzer.getLexemeType() != 0) {
            throw new IllegalArgumentException();
        }
        String string2 = MimeType.toUnicodeLowerCase(lexicalAnalyzer.getLexeme());
        vector.add(string2);
        lexicalAnalyzer.nextLexeme();
        bl = string2.equals("text");
        if (lexicalAnalyzer.getLexemeType() != 2 || lexicalAnalyzer.getLexemeFirstCharacter() != '/') {
            throw new IllegalArgumentException();
        }
        lexicalAnalyzer.nextLexeme();
        if (lexicalAnalyzer.getLexemeType() == 0) {
            vector.add(MimeType.toUnicodeLowerCase(lexicalAnalyzer.getLexeme()));
            lexicalAnalyzer.nextLexeme();
        } else {
            throw new IllegalArgumentException();
        }
        while (lexicalAnalyzer.getLexemeType() == 2 && lexicalAnalyzer.getLexemeFirstCharacter() == ';') {
            lexicalAnalyzer.nextLexeme();
            if (lexicalAnalyzer.getLexemeType() != 0) {
                throw new IllegalArgumentException();
            }
            string2 = MimeType.toUnicodeLowerCase(lexicalAnalyzer.getLexeme());
            vector.add(string2);
            lexicalAnalyzer.nextLexeme();
            bl2 = string2.equals("charset");
            if (lexicalAnalyzer.getLexemeType() != 2 || lexicalAnalyzer.getLexemeFirstCharacter() != '=') {
                throw new IllegalArgumentException();
            }
            lexicalAnalyzer.nextLexeme();
            if (lexicalAnalyzer.getLexemeType() == 0) {
                string2 = lexicalAnalyzer.getLexeme();
                vector.add(bl && bl2 ? MimeType.toUnicodeLowerCase(string2) : string2);
                lexicalAnalyzer.nextLexeme();
                continue;
            }
            if (lexicalAnalyzer.getLexemeType() == 1) {
                string2 = MimeType.removeBackslashes(lexicalAnalyzer.getLexeme());
                vector.add(bl && bl2 ? MimeType.toUnicodeLowerCase(string2) : string2);
                lexicalAnalyzer.nextLexeme();
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (lexicalAnalyzer.getLexemeType() != 3) {
            throw new IllegalArgumentException();
        }
        int n = vector.size();
        this.myPieces = vector.toArray(new String[n]);
        for (int i = 4; i < n; i += 2) {
            int n2;
            for (n2 = 2; n2 < i && this.myPieces[n2].compareTo(this.myPieces[i]) <= 0; n2 += 2) {
            }
            while (n2 < i) {
                String string3 = this.myPieces[n2];
                this.myPieces[n2] = this.myPieces[i];
                this.myPieces[i] = string3;
                string3 = this.myPieces[n2 + 1];
                this.myPieces[n2 + 1] = this.myPieces[i + 1];
                this.myPieces[i + 1] = string3;
                n2 += 2;
            }
        }
    }

    private static class LexicalAnalyzer {
        protected String mySource;
        protected int mySourceLength;
        protected int myCurrentIndex;
        protected int myLexemeType;
        protected int myLexemeBeginIndex;
        protected int myLexemeEndIndex;

        public LexicalAnalyzer(String string) {
            this.mySource = string;
            this.mySourceLength = string.length();
            this.myCurrentIndex = 0;
            this.nextLexeme();
        }

        public int getLexemeType() {
            return this.myLexemeType;
        }

        public String getLexeme() {
            return this.myLexemeBeginIndex >= this.mySourceLength ? null : this.mySource.substring(this.myLexemeBeginIndex, this.myLexemeEndIndex);
        }

        public char getLexemeFirstCharacter() {
            return this.myLexemeBeginIndex >= this.mySourceLength ? (char)'\u0000' : this.mySource.charAt(this.myLexemeBeginIndex);
        }

        public void nextLexeme() {
            int n = 0;
            int n2 = 0;
            while (n >= 0) {
                switch (n) {
                    case 0: {
                        char c;
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 3;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            n = -1;
                            break;
                        }
                        if (Character.isWhitespace(c = this.mySource.charAt(this.myCurrentIndex++))) {
                            n = 0;
                            break;
                        }
                        if (c == '\"') {
                            this.myLexemeType = 1;
                            this.myLexemeBeginIndex = this.myCurrentIndex;
                            n = 1;
                            break;
                        }
                        if (c == '(') {
                            ++n2;
                            n = 3;
                            break;
                        }
                        if (c == '/' || c == ';' || c == '=' || c == ')' || c == '<' || c == '>' || c == '@' || c == ',' || c == ':' || c == '\\' || c == '[' || c == ']' || c == '?') {
                            this.myLexemeType = 2;
                            this.myLexemeBeginIndex = this.myCurrentIndex - 1;
                            this.myLexemeEndIndex = this.myCurrentIndex;
                            n = -1;
                            break;
                        }
                        this.myLexemeType = 0;
                        this.myLexemeBeginIndex = this.myCurrentIndex - 1;
                        n = 5;
                        break;
                    }
                    case 1: {
                        char c;
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 4;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            n = -1;
                            break;
                        }
                        if ((c = this.mySource.charAt(this.myCurrentIndex++)) == '\"') {
                            this.myLexemeEndIndex = this.myCurrentIndex - 1;
                            n = -1;
                            break;
                        }
                        if (c == '\\') {
                            n = 2;
                            break;
                        }
                        n = 1;
                        break;
                    }
                    case 2: {
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 4;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            n = -1;
                            break;
                        }
                        ++this.myCurrentIndex;
                        n = 1;
                        break;
                    }
                    case 3: {
                        char c;
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 4;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            n = -1;
                            break;
                        }
                        if ((c = this.mySource.charAt(this.myCurrentIndex++)) == '(') {
                            ++n2;
                            n = 3;
                            break;
                        }
                        if (c == ')') {
                            n = --n2 == 0 ? 0 : 3;
                            break;
                        }
                        if (c == '\\') {
                            n = 4;
                            break;
                        }
                        n = 3;
                        break;
                    }
                    case 4: {
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 4;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            n = -1;
                            break;
                        }
                        ++this.myCurrentIndex;
                        n = 3;
                        break;
                    }
                    case 5: {
                        char c;
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeEndIndex = this.myCurrentIndex;
                            n = -1;
                            break;
                        }
                        if (Character.isWhitespace(c = this.mySource.charAt(this.myCurrentIndex++))) {
                            this.myLexemeEndIndex = this.myCurrentIndex - 1;
                            n = -1;
                            break;
                        }
                        if (c == '\"' || c == '(' || c == '/' || c == ';' || c == '=' || c == ')' || c == '<' || c == '>' || c == '@' || c == ',' || c == ':' || c == '\\' || c == '[' || c == ']' || c == '?') {
                            this.myLexemeEndIndex = --this.myCurrentIndex;
                            n = -1;
                            break;
                        }
                        n = 5;
                    }
                }
            }
        }
    }

    private class ParameterMap
    extends AbstractMap {
        private ParameterMap() {
        }

        public Set entrySet() {
            if (MimeType.this.myEntrySet == null) {
                MimeType.this.myEntrySet = new ParameterMapEntrySet();
            }
            return MimeType.this.myEntrySet;
        }
    }

    private class ParameterMapEntrySet
    extends AbstractSet {
        private ParameterMapEntrySet() {
        }

        public Iterator iterator() {
            return new ParameterMapEntrySetIterator();
        }

        public int size() {
            return (MimeType.this.myPieces.length - 2) / 2;
        }
    }

    private class ParameterMapEntrySetIterator
    implements Iterator {
        private int myIndex = 2;

        private ParameterMapEntrySetIterator() {
        }

        public boolean hasNext() {
            return this.myIndex < MimeType.this.myPieces.length;
        }

        public Object next() {
            if (this.hasNext()) {
                ParameterMapEntry parameterMapEntry = new ParameterMapEntry(this.myIndex);
                this.myIndex += 2;
                return parameterMapEntry;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ParameterMapEntry
    implements Map.Entry {
        private int myIndex;

        public ParameterMapEntry(int n) {
            this.myIndex = n;
        }

        public Object getKey() {
            return MimeType.this.myPieces[this.myIndex];
        }

        public Object getValue() {
            return MimeType.this.myPieces[this.myIndex + 1];
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            return object != null && object instanceof Map.Entry && this.getKey().equals(((Map.Entry)object).getKey()) && this.getValue().equals(((Map.Entry)object).getValue());
        }

        public int hashCode() {
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }
    }
}

