/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractSpinnerModel;

public class SpinnerListModel
extends AbstractSpinnerModel
implements Serializable {
    private List list;
    private int index;

    public SpinnerListModel(List list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("SpinnerListModel(List) expects non-null non-empty List");
        }
        this.list = list;
        this.index = 0;
    }

    public SpinnerListModel(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("SpinnerListModel(Object[]) expects non-null non-empty Object[]");
        }
        this.list = Arrays.asList(objectArray);
        this.index = 0;
    }

    public SpinnerListModel() {
        this(new Object[]{"empty"});
    }

    public List getList() {
        return this.list;
    }

    public void setList(List list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("invalid list");
        }
        if (!((Object)list).equals(this.list)) {
            this.list = list;
            this.index = 0;
            this.fireStateChanged();
        }
    }

    public Object getValue() {
        return this.list.get(this.index);
    }

    public void setValue(Object object) {
        int n = this.list.indexOf(object);
        if (n == -1) {
            throw new IllegalArgumentException("invalid sequence element");
        }
        if (n != this.index) {
            this.index = n;
            this.fireStateChanged();
        }
    }

    public Object getNextValue() {
        return this.index >= this.list.size() - 1 ? null : this.list.get(this.index + 1);
    }

    public Object getPreviousValue() {
        return this.index <= 0 ? null : this.list.get(this.index - 1);
    }

    Object findNextMatch(String string) {
        int n = this.list.size();
        if (n == 0) {
            return null;
        }
        int n2 = this.index;
        do {
            Object e;
            String string2;
            if ((string2 = (e = this.list.get(n2)).toString()) == null || !string2.startsWith(string)) continue;
            return e;
        } while ((n2 = (n2 + 1) % n) != this.index);
        return null;
    }
}

