/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalScrollButton
extends BasicArrowButton {
    private static Color shadowColor;
    private static Color highlightColor;
    private boolean isFreeStanding = false;
    private int buttonWidth;

    public MetalScrollButton(int n, int n2, boolean bl) {
        super(n);
        shadowColor = UIManager.getColor("ScrollBar.darkShadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        this.buttonWidth = n2;
        this.isFreeStanding = bl;
    }

    public void setFreeStanding(boolean bl) {
        this.isFreeStanding = bl;
    }

    public void paint(Graphics graphics) {
        boolean bl = MetalUtils.isLeftToRight(this);
        boolean bl2 = this.getParent().isEnabled();
        ColorUIResource colorUIResource = bl2 ? MetalLookAndFeel.getControlInfo() : MetalLookAndFeel.getControlDisabled();
        boolean bl3 = this.getModel().isPressed();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n;
        int n4 = n2;
        int n5 = (n2 + 1) / 4;
        int n6 = (n2 + 1) / 2;
        if (bl3) {
            graphics.setColor(MetalLookAndFeel.getControlShadow());
        } else {
            graphics.setColor(this.getBackground());
        }
        graphics.fillRect(0, 0, n, n2);
        if (this.getDirection() == 1) {
            if (!this.isFreeStanding) {
                ++n2;
                graphics.translate(0, -1);
                if (!bl) {
                    ++n;
                    graphics.translate(-1, 0);
                } else {
                    n += 2;
                }
            }
            graphics.setColor(colorUIResource);
            int n7 = (n4 + 1 - n5) / 2;
            int n8 = n3 / 2;
            for (int i = 0; i < n5; ++i) {
                graphics.drawLine(n8 - i, n7 + i, n8 + i + 1, n7 + i);
            }
            if (bl2) {
                graphics.setColor(highlightColor);
                if (!bl3) {
                    graphics.drawLine(1, 1, n - 3, 1);
                    graphics.drawLine(1, 1, 1, n2 - 1);
                }
                graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, n - 2, 0);
                graphics.drawLine(0, 0, 0, n2 - 1);
                graphics.drawLine(n - 2, 2, n - 2, n2 - 1);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, 0, n, n2 + 1);
            }
            if (!this.isFreeStanding) {
                --n2;
                graphics.translate(0, 1);
                if (!bl) {
                    --n;
                    graphics.translate(1, 0);
                } else {
                    n -= 2;
                }
            }
        } else if (this.getDirection() == 5) {
            if (!this.isFreeStanding) {
                ++n2;
                if (!bl) {
                    ++n;
                    graphics.translate(-1, 0);
                } else {
                    n += 2;
                }
            }
            graphics.setColor(colorUIResource);
            int n9 = (n4 + 1 - n5) / 2 + n5 - 1;
            int n10 = n3 / 2;
            for (int i = 0; i < n5; ++i) {
                graphics.drawLine(n10 - i, n9 - i, n10 + i + 1, n9 - i);
            }
            if (bl2) {
                graphics.setColor(highlightColor);
                if (!bl3) {
                    graphics.drawLine(1, 0, n - 3, 0);
                    graphics.drawLine(1, 0, 1, n2 - 3);
                }
                graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
                graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, 0, n2 - 2);
                graphics.drawLine(n - 2, 0, n - 2, n2 - 2);
                graphics.drawLine(2, n2 - 2, n - 2, n2 - 2);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, -1, n, n2 + 1);
            }
            if (!this.isFreeStanding) {
                --n2;
                if (!bl) {
                    --n;
                    graphics.translate(1, 0);
                } else {
                    n -= 2;
                }
            }
        } else if (this.getDirection() == 3) {
            if (!this.isFreeStanding) {
                n2 += 2;
                ++n;
            }
            graphics.setColor(colorUIResource);
            int n11 = (n3 + 1 - n5) / 2 + n5 - 1;
            int n12 = n4 / 2;
            for (int i = 0; i < n5; ++i) {
                graphics.drawLine(n11 - i, n12 - i, n11 - i, n12 + i + 1);
            }
            if (bl2) {
                graphics.setColor(highlightColor);
                if (!bl3) {
                    graphics.drawLine(0, 1, n - 3, 1);
                    graphics.drawLine(0, 1, 0, n2 - 3);
                }
                graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
                graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, n - 2, 0);
                graphics.drawLine(n - 2, 2, n - 2, n2 - 2);
                graphics.drawLine(0, n2 - 2, n - 2, n2 - 2);
            } else {
                MetalUtils.drawDisabledBorder(graphics, -1, 0, n + 1, n2);
            }
            if (!this.isFreeStanding) {
                n2 -= 2;
                --n;
            }
        } else if (this.getDirection() == 7) {
            if (!this.isFreeStanding) {
                n2 += 2;
                ++n;
                graphics.translate(-1, 0);
            }
            graphics.setColor(colorUIResource);
            int n13 = (n3 + 1 - n5) / 2;
            int n14 = n4 / 2;
            for (int i = 0; i < n5; ++i) {
                graphics.drawLine(n13 + i, n14 - i, n13 + i, n14 + i + 1);
            }
            if (bl2) {
                graphics.setColor(highlightColor);
                if (!bl3) {
                    graphics.drawLine(1, 1, n - 1, 1);
                    graphics.drawLine(1, 1, 1, n2 - 3);
                }
                graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, n - 1, 0);
                graphics.drawLine(0, 0, 0, n2 - 2);
                graphics.drawLine(2, n2 - 2, n - 1, n2 - 2);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, 0, n + 1, n2);
            }
            if (!this.isFreeStanding) {
                n2 -= 2;
                --n;
                graphics.translate(1, 0);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.getDirection() == 1) {
            return new Dimension(this.buttonWidth, this.buttonWidth - 2);
        }
        if (this.getDirection() == 5) {
            return new Dimension(this.buttonWidth, this.buttonWidth - (this.isFreeStanding ? 1 : 2));
        }
        if (this.getDirection() == 3) {
            return new Dimension(this.buttonWidth - (this.isFreeStanding ? 1 : 2), this.buttonWidth);
        }
        if (this.getDirection() == 7) {
            return new Dimension(this.buttonWidth - 2, this.buttonWidth);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }
}

