/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Hashtable;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.PixelStore;
import sun.awt.image.PixelStore32;
import sun.awt.image.PixelStore8;
import sun.security.action.LoadLibraryAction;

public class JPEGImageDecoder
extends ImageDecoder {
    private static ColorModel RGBcolormodel;
    private static ColorModel ARGBcolormodel;
    private static ColorModel Graycolormodel;
    private static final Class InputStreamClass;
    private ColorModel colormodel;
    PixelStore store;
    Hashtable props = new Hashtable();
    private static final int hintflags = 22;

    private static native void initIDs(Class var0);

    private native void readImage(InputStream var1, byte[] var2) throws ImageFormatException, IOException;

    public JPEGImageDecoder(InputStreamImageSource inputStreamImageSource, InputStream inputStream) {
        super(inputStreamImageSource, inputStream);
    }

    public synchronized boolean catchupConsumer(InputStreamImageSource inputStreamImageSource, ImageConsumer imageConsumer) {
        return this.store == null || this.store.replay(inputStreamImageSource, imageConsumer);
    }

    public synchronized void makeStore(int n, int n2, boolean bl) {
        this.store = bl ? new PixelStore8(n, n2) : new PixelStore32(n, n2);
    }

    private static void error(String string) throws ImageFormatException {
        throw new ImageFormatException(string);
    }

    public boolean sendHeaderInfo(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        this.setDimensions(n, n2);
        this.makeStore(n, n2, bl);
        this.setProperties(this.props);
        this.store.setProperties(this.props);
        this.colormodel = bl ? Graycolormodel : (bl2 ? ARGBcolormodel : RGBcolormodel);
        this.setColorModel(this.colormodel);
        this.store.setColorModel(this.colormodel);
        int n3 = 22;
        if (!bl3) {
            n3 |= 8;
        }
        this.setHints(22);
        this.store.setHints(22);
        this.headerComplete();
        return true;
    }

    public boolean sendPixels(int[] nArray, int n) {
        int n2 = this.setPixels(0, n, nArray.length, 1, this.colormodel, nArray, 0, nArray.length);
        if (n2 > 0) {
            this.store.setPixels(0, n, nArray.length, 1, nArray, 0, nArray.length);
        } else {
            this.aborted = true;
        }
        return !this.aborted;
    }

    public boolean sendPixels(byte[] byArray, int n) {
        int n2 = this.setPixels(0, n, byArray.length, 1, this.colormodel, byArray, 0, byArray.length);
        if (n2 > 0) {
            this.store.setPixels(0, n, byArray.length, 1, byArray, 0, byArray.length);
        } else {
            this.aborted = true;
        }
        return !this.aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceImage() throws IOException, ImageFormatException {
        try {
            this.readImage(this.input, new byte[1024]);
            if (!this.aborted) {
                this.store.imageComplete();
                if (this.store.getBitState() != 2) {
                    this.source.setPixelStore(this, this.store);
                }
                this.imageComplete(3, true);
            }
        }
        catch (IOException iOException) {
            if (!this.aborted) {
                throw iOException;
            }
        }
        finally {
            this.close();
        }
    }

    static {
        InputStreamClass = InputStream.class;
        AccessController.doPrivileged(new LoadLibraryAction("jpeg"));
        JPEGImageDecoder.initIDs(InputStreamClass);
        RGBcolormodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        ARGBcolormodel = ColorModel.getRGBdefault();
        byte[] byArray = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray[i] = (byte)i;
        }
        Graycolormodel = new IndexColorModel(8, 256, byArray, byArray, byArray);
    }
}

