/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.AuthorizationData;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.TicketFlags;
import com.ibm.security.krb5.internal.TransitedEncoding;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;

public class EncTicketPart {
    private TicketFlags a;
    private EncryptionKey b;
    private Realm c;
    private PrincipalName d;
    private TransitedEncoding e;
    private KerberosTime f;
    private KerberosTime g;
    private KerberosTime h;
    private KerberosTime i;
    private HostAddresses j;
    private AuthorizationData k;

    public EncTicketPart(TicketFlags ticketFlags, EncryptionKey encryptionKey, Realm realm, PrincipalName principalName, TransitedEncoding transitedEncoding, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, HostAddresses hostAddresses, AuthorizationData authorizationData) {
        this.a = ticketFlags;
        this.b = encryptionKey;
        this.c = realm;
        this.d = principalName;
        this.e = transitedEncoding;
        this.f = kerberosTime;
        this.g = kerberosTime2;
        this.h = kerberosTime3;
        this.i = kerberosTime4;
        this.j = hostAddresses;
        this.k = authorizationData;
    }

    public EncTicketPart(byte[] byArray) throws Asn1Exception, KrbException, IOException {
        this.a(new DerValue(byArray));
    }

    public EncTicketPart(DerValue derValue) throws Asn1Exception, KrbException, IOException {
        this.a(derValue);
    }

    private static String a(byte[] byArray, int n2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] >> 4 & 0xF;
            int n4 = byArray[i2] & 0xF;
            stringBuffer.append(Integer.toHexString(n3));
            stringBuffer.append(Integer.toHexString(n4));
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private void a(DerValue derValue) throws Asn1Exception, IOException, RealmException {
        this.i = null;
        this.j = null;
        this.k = null;
        if ((derValue.getTag() & 0x1F) != 3 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.a = TicketFlags.parse(derValue2.getData(), (byte)0, false);
        this.b = EncryptionKey.parse(derValue2.getData(), (byte)1, false);
        this.c = Realm.parse(derValue2.getData(), (byte)2, false);
        this.d = PrincipalName.parse(derValue2.getData(), (byte)3, false);
        this.e = TransitedEncoding.parse(derValue2.getData(), (byte)4, false);
        this.f = KerberosTime.parse(derValue2.getData(), (byte)5, false);
        this.g = KerberosTime.parse(derValue2.getData(), (byte)6, true);
        this.h = KerberosTime.parse(derValue2.getData(), (byte)7, false);
        if (derValue2.getData().available() > 0) {
            this.i = KerberosTime.parse(derValue2.getData(), (byte)8, true);
        }
        if (derValue2.getData().available() > 0) {
            this.j = HostAddresses.parse(derValue2.getData(), (byte)9, true);
        }
        if (derValue2.getData().available() > 0) {
            this.k = AuthorizationData.parse(derValue2.getData(), (byte)10, true);
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.a.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.b.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.c.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.d.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.e.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.f.asn1Encode());
        if (this.g != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)6), this.g.asn1Encode());
        }
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)7), this.h.asn1Encode());
        if (this.i != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)8), this.i.asn1Encode());
        }
        if (this.j != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)9), this.j.asn1Encode());
        }
        if (this.k != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)10), this.k.asn1Encode());
        }
        derOutputStream2.write((byte)48, derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.write(DerValue.createTag((byte)64, (boolean)true, (byte)3), derOutputStream2);
        return derOutputStream.toByteArray();
    }

    public TicketFlags getTicketFlags() {
        return this.a;
    }

    public EncryptionKey getEncryptionKey() {
        return this.b;
    }

    public Realm getClientRealm() {
        return this.c;
    }

    public PrincipalName getClient() {
        return this.d;
    }

    public TransitedEncoding getTransitedEncoding() {
        return this.e;
    }

    public KerberosTime getAuthTime() {
        return this.f;
    }

    public KerberosTime getStartTime() {
        return this.g;
    }

    public KerberosTime getEndTime() {
        return this.h;
    }

    public KerberosTime getRenewableTillTime() {
        return this.i;
    }

    public HostAddresses getClientAddresses() {
        return this.j;
    }

    public AuthorizationData getAuthzData() {
        return this.k;
    }
}

