/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.BitArray;
import com.ibm.security.util.ByteArrayLexOrder;
import com.ibm.security.util.ByteArrayTagOrder;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.util.UTFUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;

public final class DerOutputStream
extends ByteArrayOutputStream
implements DerEncoder {
    private static ByteArrayLexOrder lexOrder = new ByteArrayLexOrder();
    private static ByteArrayTagOrder tagOrder = new ByteArrayTagOrder();

    public DerOutputStream(int n) {
        super(n);
    }

    public DerOutputStream() {
    }

    public void write(byte by, byte[] byArray) throws IOException {
        this.write(by);
        this.putLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte by, DerOutputStream derOutputStream) throws IOException {
        this.write(by);
        this.putLength(derOutputStream.count);
        this.write(derOutputStream.buf, 0, derOutputStream.count);
    }

    public void writeImplicit(byte by, DerOutputStream derOutputStream) throws IOException {
        this.write(by);
        this.write(derOutputStream.buf, 1, derOutputStream.count - 1);
    }

    public void putDerValue(DerValue derValue) throws IOException {
        derValue.encode(this);
    }

    public void putBoolean(boolean bl) throws IOException {
        this.write(1);
        this.putLength(1);
        if (bl) {
            this.write(255);
        } else {
            this.write(0);
        }
    }

    public void putSignedInt(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[4];
        int n3 = 0;
        byArray[3] = (byte)(n & 0xFF);
        byArray[2] = (byte)((n & 0xFF00) >>> 8);
        byArray[1] = (byte)((n & 0xFF0000) >>> 16);
        byArray[0] = (byte)((n & 0xFF000000) >>> 24);
        if (byArray[0] != 0) {
            for (n2 = 0; n2 < 3 && byArray[n2] == -1 && (byArray[n2 + 1] & 0xFFFFFF80) == -128; ++n2) {
                ++n3;
            }
        } else if (byArray[0] == 0) {
            for (n2 = 0; n2 < 3 && byArray[n2] == 0 && (byArray[n2 + 1] & 0xFFFFFF80) == 0; ++n2) {
                ++n3;
            }
        }
        byte[] byArray2 = new byte[4 - n3];
        for (n2 = 0; n2 < 4 - n3; ++n2) {
            byArray2[n2] = byArray[n2 + n3];
        }
        this.write(2);
        this.putLength(byArray2.length);
        this.write(byArray2, 0, byArray2.length);
    }

    public void putInteger(BigInteger bigInteger) throws IOException {
        this.write(2);
        this.putBigInteger(bigInteger);
    }

    public void putEnumerated(BigInteger bigInteger) throws IOException {
        this.write(10);
        this.putBigInteger(bigInteger);
    }

    private void putBigInteger(BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        this.putLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void putInteger(Integer n) throws IOException {
        this.putInteger((int)n);
    }

    public void putInteger(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[4];
        int n3 = 0;
        byArray[3] = (byte)(n & 0xFF);
        byArray[2] = (byte)((n & 0xFF00) >>> 8);
        byArray[1] = (byte)((n & 0xFF0000) >>> 16);
        byArray[0] = (byte)((n & 0xFF000000) >>> 24);
        if (byArray[0] == 255) {
            for (n2 = 0; n2 < 3 && byArray[n2] == 255 && (byArray[n2 + 1] & 0x80) == 128; ++n2) {
                ++n3;
            }
        } else if (byArray[0] == 0) {
            for (n2 = 0; n2 < 3 && byArray[n2] == 0 && (byArray[n2 + 1] & 0x80) == 0; ++n2) {
                ++n3;
            }
        }
        this.write(2);
        this.putLength(4 - n3);
        for (n2 = n3; n2 < 4; ++n2) {
            this.write(byArray[n2]);
        }
    }

    public void putBitString(byte[] byArray) throws IOException {
        this.write(3);
        this.putLength(byArray.length + 1);
        this.write(0);
        this.write(byArray);
    }

    public void putUnalignedBitString(BitArray bitArray) throws IOException {
        byte[] byArray = bitArray.toByteArray();
        this.write(3);
        this.putLength(byArray.length + 1);
        this.write(byArray.length * 8 - bitArray.length());
        this.write(byArray);
    }

    public void putOctetString(byte[] byArray) throws IOException {
        this.write((byte)4, byArray);
    }

    public void putNull() throws IOException {
        this.write(5);
        this.putLength(0);
    }

    public void putOID(ObjectIdentifier objectIdentifier) throws IOException {
        objectIdentifier.encode(this);
    }

    public void putSequence(DerValue[] derValueArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        for (int i = 0; i < derValueArray.length; ++i) {
            derValueArray[i].encode(derOutputStream);
        }
        this.write((byte)48, derOutputStream);
    }

    public void putSet(DerValue[] derValueArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        for (int i = 0; i < derValueArray.length; ++i) {
            derValueArray[i].encode(derOutputStream);
        }
        this.write((byte)49, derOutputStream);
    }

    public void putOrderedSetOf(byte by, DerEncoder[] derEncoderArray) throws IOException {
        this.putOrderedSet(by, derEncoderArray, (Comparator)lexOrder);
    }

    public void putOrderedSet(byte by, DerEncoder[] derEncoderArray) throws IOException {
        this.putOrderedSet(by, derEncoderArray, (Comparator)tagOrder);
    }

    private void putOrderedSet(byte by, DerEncoder[] derEncoderArray, Comparator comparator) throws IOException {
        DerOutputStream[] derOutputStreamArray = new DerOutputStream[derEncoderArray.length];
        for (int i = 0; i < derEncoderArray.length; ++i) {
            derOutputStreamArray[i] = new DerOutputStream();
            derEncoderArray[i].derEncode(derOutputStreamArray[i]);
        }
        byte[][] byArrayArray = new byte[derOutputStreamArray.length][];
        for (int i = 0; i < derOutputStreamArray.length; ++i) {
            byArrayArray[i] = derOutputStreamArray[i].toByteArray();
        }
        Arrays.sort(byArrayArray, comparator);
        DerOutputStream derOutputStream = new DerOutputStream();
        for (int i = 0; i < derOutputStreamArray.length; ++i) {
            derOutputStream.write(byArrayArray[i]);
        }
        this.write(by, derOutputStream);
    }

    public void putOrderedSetOf(byte by, DerValue[] derValueArray) throws IOException {
        this.putOrderedSet(by, derValueArray, (Comparator)lexOrder);
    }

    private void putOrderedSet(byte by, DerValue[] derValueArray, Comparator comparator) throws IOException {
        byte[][] byArrayArray = new byte[derValueArray.length][];
        for (int i = 0; i < derValueArray.length; ++i) {
            byArrayArray[i] = derValueArray[i].toByteArray();
        }
        Arrays.sort(byArrayArray, comparator);
        DerOutputStream derOutputStream = new DerOutputStream();
        for (int i = 0; i < derValueArray.length; ++i) {
            derOutputStream.write(byArrayArray[i]);
        }
        this.write(by, derOutputStream);
    }

    public void putPrintableString(String string) throws IOException {
        this.write(19);
        this.putLength(string.length());
        for (int i = 0; i < string.length(); ++i) {
            this.write((byte)string.charAt(i));
        }
    }

    public void putPrintableString(char[] cArray) throws IOException {
        this.write(19);
        this.putLength(cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            this.write((byte)cArray[i]);
        }
    }

    public void putVisibleString(String string) throws IOException {
        this.write(26);
        this.putLength(string.length());
        for (int i = 0; i < string.length(); ++i) {
            this.write((byte)string.charAt(i));
        }
    }

    public void putIA5String(String string) throws IOException {
        this.write(22);
        this.putLength(string.length());
        for (int i = 0; i < string.length(); ++i) {
            this.write((byte)string.charAt(i));
        }
    }

    public void putGeneralString(String string) throws IOException {
        this.write(27);
        this.putLength(string.length());
        for (int i = 0; i < string.length(); ++i) {
            this.write((byte)string.charAt(i));
        }
    }

    public void putBMPString(byte[] byArray) throws IOException {
        this.write(30);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putUTF8String(String string) throws IOException {
        this.write(12);
        byte[] byArray = UTFUtils.toUTF(string);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putUniverString(String string) throws IOException {
        this.write(28);
        byte[] byArray = UTFUtils.toUniv(string);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putBMPString(String string) throws IOException {
        this.write(30);
        if (string == null) {
            this.putLength(0);
        } else {
            this.putLength(string.length() * 2);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            this.write((byte)(c >>> 8));
            this.write((byte)(c & 0xFF));
        }
    }

    public void putUTCTime(Date date) throws IOException {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        String string = "yyMMddHHmmss'Z'";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(timeZone);
        byte[] byArray = null;
        try {
            byArray = simpleDateFormat.format(date).getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = simpleDateFormat.format(date).getBytes();
        }
        this.write(23);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putGeneralizedTime(Date date) throws IOException {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        String string = "yyyyMMddHHmmss'Z'";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(timeZone);
        byte[] byArray = null;
        try {
            byArray = simpleDateFormat.format(date).getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = simpleDateFormat.format(date).getBytes();
        }
        this.write(24);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putLength(int n) throws IOException {
        if (n < 128) {
            this.write((byte)n);
        } else if (n < 256) {
            this.write(-127);
            this.write((byte)n);
        } else if (n < 65536) {
            this.write(-126);
            this.write((byte)(n >> 8));
            this.write((byte)n);
        } else if (n < 0x1000000) {
            this.write(-125);
            this.write((byte)(n >> 16));
            this.write((byte)(n >> 8));
            this.write((byte)n);
        } else {
            this.write(-124);
            this.write((byte)(n >> 24));
            this.write((byte)(n >> 16));
            this.write((byte)(n >> 8));
            this.write((byte)n);
        }
    }

    public void putTag(byte by, boolean bl, byte by2) {
        byte by3 = (byte)(by | by2);
        if (bl) {
            by3 = (byte)(by3 | 0x20);
        }
        this.write(by3);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }

    public void putNamedBitString(BitArray bitArray) throws IOException {
        byte[] byArray = bitArray.toByteArray();
        int n = bitArray.length();
        while (--n >= 0 && !bitArray.get(n)) {
        }
        this.write(3);
        if (n++ < 0) {
            this.putLength(1);
            this.write(0);
        } else {
            int n2 = (n + 7) / 8;
            this.putLength(n2 + 1);
            this.write(n2 * 8 - n);
            this.write(byArray, 0, n2);
        }
    }
}

