/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.validator;

import com.ibm.security.validator.SimpleValidator;
import com.ibm.security.validator.ValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class EndEntityChecker {
    private static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    private static final String OID_EKU_TLS_SERVER = "1.3.6.1.5.5.7.3.1";
    private static final String OID_EKU_TLS_CLIENT = "1.3.6.1.5.5.7.3.2";
    private static final String OID_EKU_CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    private static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    private static final String NSCT_SSL_CLIENT = "ssl_client";
    private static final String NSCT_SSL_SERVER = "ssl_server";
    private static final String NSCT_CODE_SIGNING = "object_signing";
    private static final int KU_SIGNATURE = 0;
    private static final int KU_KEY_ENCIPHERMENT = 2;
    private static final Collection KU_SERVER_SIGNATURE = Arrays.asList("DHE_DSS", "DHE_RSA", "RSA_EXPORT", "UNKNOWN");
    private static final Collection KU_SERVER_ENCRYPTION = Arrays.asList("RSA");
    private final String variant;
    private final String type;

    private EndEntityChecker(String string, String string2) {
        this.type = string;
        this.variant = string2;
    }

    static EndEntityChecker getInstance(String string, String string2) {
        return new EndEntityChecker(string, string2);
    }

    void check(X509Certificate x509Certificate, Object object) throws CertificateException {
        if (this.variant.equals("generic")) {
            return;
        }
        if (this.variant.equals("tls server")) {
            this.checkTLSServer(x509Certificate, (String)object);
        } else if (this.variant.equals("tls client")) {
            this.checkTLSClient(x509Certificate);
        } else if (this.variant.equals("code signing")) {
            this.checkCodeSigning(x509Certificate);
        } else if (this.variant.equals("jce signing")) {
            this.checkCodeSigning(x509Certificate);
        } else {
            throw new CertificateException("Unknown variant: " + this.variant);
        }
    }

    private Set getCriticalExtensions(X509Certificate x509Certificate) {
        Set set = x509Certificate.getCriticalExtensionOIDs();
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    private void checkRemainingExtensions(Set set) throws CertificateException {
        set.remove("2.5.29.19");
        if (!set.isEmpty()) {
            throw new CertificateException("Certificate contains unsupported critical extensions: " + set);
        }
    }

    private boolean checkEKU(X509Certificate x509Certificate, Set set, String string) throws CertificateException {
        if (this.type.equals("Simple") && !set.contains(OID_EXTENDED_KEY_USAGE)) {
            return true;
        }
        List<String> list = x509Certificate.getExtendedKeyUsage();
        if (list == null) {
            return true;
        }
        return list.contains(string) || list.contains(OID_EKU_ANY_USAGE);
    }

    private boolean checkKeyUsage(X509Certificate x509Certificate, int n) throws CertificateException {
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray == null) {
            return true;
        }
        return blArray.length > n && blArray[n];
    }

    private void checkTLSClient(X509Certificate x509Certificate) throws CertificateException {
        Set set = this.getCriticalExtensions(x509Certificate);
        if (!this.checkKeyUsage(x509Certificate, 0)) {
            throw new ValidatorException("KeyUsage does not allow digital signatures", ValidatorException.T_EE_EXTENSIONS, x509Certificate);
        }
        if (!this.checkEKU(x509Certificate, set, OID_EKU_TLS_CLIENT)) {
            throw new ValidatorException("Extended key usage does not permit use for TLS client authentication", ValidatorException.T_EE_EXTENSIONS, x509Certificate);
        }
        if (!SimpleValidator.getNetscapeCertTypeBit(x509Certificate, NSCT_SSL_CLIENT)) {
            throw new ValidatorException("Netscape cert type does not permit use for SSL client", ValidatorException.T_EE_EXTENSIONS, x509Certificate);
        }
        set.remove("2.5.29.15");
        set.remove(OID_EXTENDED_KEY_USAGE);
        set.remove("2.16.840.1.113730.1.1");
        this.checkRemainingExtensions(set);
    }

    private void checkTLSServer(X509Certificate x509Certificate, String string) throws CertificateException {
        Set set = this.getCriticalExtensions(x509Certificate);
        if (KU_SERVER_ENCRYPTION.contains(string)) {
            if (!this.checkKeyUsage(x509Certificate, 2)) {
                throw new ValidatorException("KeyUsage does not allow key encipherment", ValidatorException.T_EE_EXTENSIONS, x509Certificate);
            }
        } else if (KU_SERVER_SIGNATURE.contains(string)) {
            if (!this.checkKeyUsage(x509Certificate, 0)) {
                throw new ValidatorException("KeyUsage does not allow digital signatures", ValidatorException.T_EE_EXTENSIONS, x509Certificate);
            }
        } else {
            throw new CertificateException("Unknown authType: " + string);
        }
        if (!this.checkEKU(x509Certificate, set, OID_EKU_TLS_SERVER)) {
            throw new ValidatorException("Extended key usage does not permit use for TLS server authentication", ValidatorException.T_EE_EXTENSIONS, x509Certificate);
        }
        if (!SimpleValidator.getNetscapeCertTypeBit(x509Certificate, NSCT_SSL_SERVER)) {
            throw new ValidatorException("Netscape cert type does not permit use for SSL server", ValidatorException.T_EE_EXTENSIONS, x509Certificate);
        }
        set.remove("2.5.29.15");
        set.remove(OID_EXTENDED_KEY_USAGE);
        set.remove("2.16.840.1.113730.1.1");
        this.checkRemainingExtensions(set);
    }

    private void checkCodeSigning(X509Certificate x509Certificate) throws CertificateException {
        Set set = this.getCriticalExtensions(x509Certificate);
        if (!this.checkKeyUsage(x509Certificate, 0)) {
            throw new ValidatorException("KeyUsage does not allow digital signatures", ValidatorException.T_EE_EXTENSIONS, x509Certificate);
        }
        if (!this.checkEKU(x509Certificate, set, OID_EKU_CODE_SIGNING)) {
            throw new ValidatorException("Extended key usage does not permit use for code signing", ValidatorException.T_EE_EXTENSIONS, x509Certificate);
        }
        if (!this.variant.equals("jce signing")) {
            if (!SimpleValidator.getNetscapeCertTypeBit(x509Certificate, NSCT_CODE_SIGNING)) {
                throw new ValidatorException("Netscape cert type does not permit use for code signing", ValidatorException.T_EE_EXTENSIONS, x509Certificate);
            }
            set.remove("2.16.840.1.113730.1.1");
        }
        set.remove("2.5.29.15");
        set.remove(OID_EXTENDED_KEY_USAGE);
        this.checkRemainingExtensions(set);
    }
}

