/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.ObjectIdentifier;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public final class OIDMap {
    private static final String ROOT = "x509.info.extensions";
    private static final String AUTH_KEY_IDENTIFIER = "x509.info.extensions.AuthorityKeyIdentifier";
    private static final String SUB_KEY_IDENTIFIER = "x509.info.extensions.SubjectKeyIdentifier";
    private static final String KEY_USAGE = "x509.info.extensions.KeyUsage";
    private static final String PRIVATE_KEY_USAGE = "x509.info.extensions.PrivateKeyUsage";
    private static final String POLICY_MAPPINGS = "x509.info.extensions.PolicyMappings";
    private static final String SUB_ALT_NAME = "x509.info.extensions.SubjectAlternativeName";
    private static final String ISSUER_ALT_NAME = "x509.info.extensions.IssuerAlternativeName";
    private static final String BASIC_CONSTRAINTS = "x509.info.extensions.BasicConstraints";
    private static final String NAME_CONSTRAINTS = "x509.info.extensions.NameConstraints";
    private static final String POLICY_CONSTRAINTS = "x509.info.extensions.PolicyConstraints";
    private static final String CRL_NUMBER = "x509.info.extensions.CRLNumber";
    private static final String CRL_REASON = "x509.info.extensions.CRLReasonCode";
    private static final String CRL_DISTRIBUTION_POINTS = "x509.info.extensions.CRLDistributionPoints";
    private static final String ISSUING_DISTRIBUTION_POINT = "x509.info.extensions.IssuingDistributionPoint";
    private static final String NETSCAPE_CERT = "x509.info.extensions.NetscapeCertType";
    private static final String DELTA_CRL_INDICATOR = "x509.info.extensions.DeltaCRLIndicator";
    private static final String HOLD_INSTRUCTION_CODE = "x509.info.extensions.HoldInstructionCode";
    private static final String INVALIDITY_DATE = "x509.info.extensions.InvalidityDate";
    private static final String CERTIFICATE_ISSUER = "x509.info.extensions.CertificateIssuer";
    private static final String SUBJECT_DIRECTORY_ATTRIBUTES = "x509.info.extensions.SubjectDirectoryAttributes";
    private static final String CERTIFICATE_POLICIES = "x509.info.extensions.CertificatePolicies";
    private static final String EXT_KEY_USAGE = "x509.info.extensions.ExtKeyUsage";
    private static final String INHIBIT_ANY_POLICY = "x509.info.extensions.InhibitAnyPolicy";
    private static final String AUTHORITY_INFO_ACCESS = "x509.info.extensions.AuthorityInfoAccess";
    private static final Hashtable oid2Name = new Hashtable(15);
    private static final Hashtable name2OID = new Hashtable(15);
    private static final Hashtable name2Class = new Hashtable(15);
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.OIDMap";

    private static void loadNamesDefault(Properties properties) {
        if (debug != null) {
            debug.entry(40960L, (Object)className, "loadNamesDefault", properties);
        }
        properties.put(SUBJECT_DIRECTORY_ATTRIBUTES, "2.5.29.9");
        properties.put(SUB_KEY_IDENTIFIER, "2.5.29.14");
        properties.put(KEY_USAGE, "2.5.29.15");
        properties.put(PRIVATE_KEY_USAGE, "2.5.29.16");
        properties.put(SUB_ALT_NAME, "2.5.29.17");
        properties.put(ISSUER_ALT_NAME, "2.5.29.18");
        properties.put(BASIC_CONSTRAINTS, "2.5.29.19");
        properties.put(CRL_NUMBER, "2.5.29.20");
        properties.put(CRL_REASON, "2.5.29.21");
        properties.put(HOLD_INSTRUCTION_CODE, "2.5.29.23");
        properties.put(INVALIDITY_DATE, "2.5.29.24");
        properties.put(DELTA_CRL_INDICATOR, "2.5.29.27");
        properties.put(ISSUING_DISTRIBUTION_POINT, "2.5.29.28");
        properties.put(CERTIFICATE_ISSUER, "2.5.29.29");
        properties.put(NAME_CONSTRAINTS, "2.5.29.30");
        properties.put(CRL_DISTRIBUTION_POINTS, "2.5.29.31");
        properties.put(CERTIFICATE_POLICIES, "2.5.29.32");
        properties.put(POLICY_MAPPINGS, "2.5.29.33");
        properties.put(AUTH_KEY_IDENTIFIER, "2.5.29.35");
        properties.put(POLICY_CONSTRAINTS, "2.5.29.36");
        properties.put(EXT_KEY_USAGE, "2.5.29.37");
        properties.put(INHIBIT_ANY_POLICY, "2.5.29.54");
        properties.put(NETSCAPE_CERT, "2.16.840.1.113730.1.1");
        properties.put(AUTHORITY_INFO_ACCESS, "1.3.6.1.5.5.7.1.1");
        if (debug != null) {
            debug.exit(8192L, className, "loadNamesDefault");
        }
    }

    private static void loadClassDefault(Properties properties) {
        if (debug != null) {
            debug.entry(40960L, (Object)className, "loadClassDefault", properties);
        }
        properties.put(AUTH_KEY_IDENTIFIER, "com.ibm.security.x509.AuthorityKeyIdentifierExtension");
        properties.put(SUB_KEY_IDENTIFIER, "com.ibm.security.x509.SubjectKeyIdentifierExtension");
        properties.put(KEY_USAGE, "com.ibm.security.x509.KeyUsageExtension");
        properties.put(PRIVATE_KEY_USAGE, "com.ibm.security.x509.PrivateKeyUsageExtension");
        properties.put(POLICY_MAPPINGS, "com.ibm.security.x509.PolicyMappingsExtension");
        properties.put(SUB_ALT_NAME, "com.ibm.security.x509.SubjectAlternativeNameExtension");
        properties.put(ISSUER_ALT_NAME, "com.ibm.security.x509.IssuerAlternativeNameExtension");
        properties.put(BASIC_CONSTRAINTS, "com.ibm.security.x509.BasicConstraintsExtension");
        properties.put(NAME_CONSTRAINTS, "com.ibm.security.x509.NameConstraintsExtension");
        properties.put(POLICY_CONSTRAINTS, "com.ibm.security.x509.PolicyConstraintsExtension");
        properties.put(CRL_NUMBER, "com.ibm.security.x509.CRLNumberExtension");
        properties.put(CRL_REASON, "com.ibm.security.x509.CRLReasonCodeExtension");
        properties.put(CRL_DISTRIBUTION_POINTS, "com.ibm.security.x509.CRLDistributionPointsExtension");
        properties.put(ISSUING_DISTRIBUTION_POINT, "com.ibm.security.x509.IssuingDistributionPointExtension");
        properties.put(NETSCAPE_CERT, "com.ibm.security.x509.NetscapeCertTypeExtension");
        properties.put(DELTA_CRL_INDICATOR, "com.ibm.security.x509.DeltaCRLIndicatorExtension");
        properties.put(HOLD_INSTRUCTION_CODE, "com.ibm.security.x509.HoldInstructionCodeExtension");
        properties.put(INVALIDITY_DATE, "com.ibm.security.x509.InvalidityDateExtension");
        properties.put(CERTIFICATE_ISSUER, "com.ibm.security.x509.CertificateIssuerExtension");
        properties.put(SUBJECT_DIRECTORY_ATTRIBUTES, "com.ibm.security.x509.SubjectDirectoryAttributesExtension");
        properties.put(CERTIFICATE_POLICIES, "com.ibm.security.x509.CertificatePoliciesExtension");
        properties.put(EXT_KEY_USAGE, "com.ibm.security.x509.ExtKeyUsageExtension");
        properties.put(INHIBIT_ANY_POLICY, "com.ibm.security.x509.InhibitAnyPolicyExtension");
        properties.put(AUTHORITY_INFO_ACCESS, "com.ibm.security.x509.AuthorityInfoAccessExtension");
        if (debug != null) {
            debug.exit(40960L, className, "loadClassDefault");
        }
    }

    private static void loadNames() {
        if (debug != null) {
            debug.entry(40960L, className, "loadNames");
        }
        Properties properties = new Properties();
        OIDMap.loadNamesDefault(properties);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            ObjectIdentifier objectIdentifier = null;
            try {
                objectIdentifier = new ObjectIdentifier(string2);
            }
            catch (Exception exception) {
                objectIdentifier = null;
            }
            name2OID.put(string, objectIdentifier);
            oid2Name.put(objectIdentifier, string);
        }
        if (debug != null) {
            debug.exit(40960L, className, "loadNames");
        }
    }

    private static void loadClasses() {
        if (debug != null) {
            debug.entry(40960L, className, "loadClasses");
        }
        Properties properties = new Properties();
        OIDMap.loadClassDefault(properties);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            name2Class.put(string, string2);
        }
        if (debug != null) {
            debug.exit(40960L, className, "loadClasses");
        }
    }

    public static void addAttribute(String string, String string2, String string3) throws CertificateException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{string, string2, string3};
            debug.entry(49152L, (Object)string, "addAttribute", objectArray);
        }
        objectArray = null;
        try {
            objectArray = new ObjectIdentifier(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (oid2Name.get(objectArray) != null) {
            if (debug != null) {
                debug.text(49152L, string, "addAttribute", "Object identifier already exists");
            }
            throw new CertificateException("Object identifier already exists");
        }
        if (name2OID.get(string3) != null) {
            if (debug != null) {
                debug.text(49152L, string, "addAttribute", "Name already exists");
            }
            throw new CertificateException("Name already exists");
        }
        if (name2Class.get(string) != null) {
            if (debug != null) {
                debug.text(49152L, string, "addAttribute", "Class already exists");
            }
            throw new CertificateException("Class already exists");
        }
        oid2Name.put(objectArray, string3);
        name2OID.put(string3, objectArray);
        name2Class.put(string3, string);
        if (debug != null) {
            debug.exit(49152L, string, "addAttribute");
        }
    }

    public static String getName(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getName", objectIdentifier);
            debug.exit(16384L, (Object)className, "getName", (String)oid2Name.get(objectIdentifier));
        }
        return (String)oid2Name.get(objectIdentifier);
    }

    public static ObjectIdentifier getOID(String string) {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "getOID", string);
            debug.exit(49152L, (Object)className, "getOID", (ObjectIdentifier)name2OID.get(string));
        }
        return (ObjectIdentifier)name2OID.get(string);
    }

    public static Class getClass(String string) throws CertificateException {
        String string2;
        if (debug != null) {
            debug.entry(49152L, (Object)className, "getClass", string);
        }
        if ((string2 = (String)name2Class.get(string)) == null) {
            if (debug != null) {
                debug.exit(49152L, (Object)string2, "getClass_1", null);
            }
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            if (debug != null) {
                debug.exit(49152L, (Object)string2, "getClass_2", clazz);
            }
            return clazz;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(49152L, string2, "getClass", exception);
            }
            throw new CertificateException("Error instantiating class for " + string + " " + exception.toString());
        }
    }

    public static Class getClass(ObjectIdentifier objectIdentifier) throws CertificateException {
        String string;
        if (debug != null) {
            debug.entry(49152L, (Object)className, "getClass", objectIdentifier);
        }
        if ((string = OIDMap.getName(objectIdentifier)) == null) {
            if (debug != null) {
                debug.exit(49152L, (Object)className, "getClass_1", null);
            }
            return null;
        }
        String string2 = (String)name2Class.get(string);
        if (string2 == null) {
            if (debug != null) {
                debug.exit(49152L, (Object)string2, "getClass_2", null);
            }
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            if (debug != null) {
                debug.exit(49152L, (Object)string2, "getClass_3", clazz);
            }
            return clazz;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(49152L, string2, "getClass", exception);
            }
            throw new CertificateException("Error instantiating class for " + string + " " + exception.toString());
        }
    }

    static {
        OIDMap.loadNames();
        OIDMap.loadClasses();
    }
}

