/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.AlgorithmStatus;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.RSAPrivateCrtKey;
import com.ibm.crypto.fips.provider.RSAPrivateKey;
import com.ibm.crypto.fips.provider.RSAPublicKey;
import com.ibm.crypto.fips.provider.SelfTest;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class RSAKeyFactory
extends KeyFactorySpi
implements AlgorithmStatus {
    public boolean isFipsApproved() {
        return true;
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(keySpec);
        }
        throw new FIPSRuntimeException();
    }

    protected PublicKey a(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
                return new RSAPublicKey(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException(RSAKeyFactory.a("\u0002\u001asP\u00039\u001bbR\u001a*\u0000w\u0000\u0018.\r2S\u0003.\u0017{F\u001a(\u0015fI\u001c%"));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(RSAKeyFactory.a("\u0002\u001asP\u00039\u001bbR\u001a*\u0000w\u0000\u0018.\r2S\u0003.\u0017{F\u001a(\u0015fI\u001c%N2") + invalidKeyException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.b(keySpec);
        }
        throw new FIPSRuntimeException();
    }

    protected PrivateKey b(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPrivateKeySpec) {
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
                return new RSAPrivateKey(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                try {
                    return new RSAPrivateCrtKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
                catch (InvalidKeyException invalidKeyException) {
                    return new RSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
            }
            throw new InvalidKeySpecException(RSAKeyFactory.a("\u0002\u001asP\u00039\u001bbR\u001a*\u0000w\u0000\u0018.\r2S\u0003.\u0017{F\u001a(\u0015fI\u001c%"));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(RSAKeyFactory.a("\u0002\u001asP\u00039\u001bbR\u001a*\u0000w\u0000\u0018.\r2S\u0003.\u0017{F\u001a(\u0015fI\u001c%N2") + invalidKeyException.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(key, clazz);
        }
        throw new FIPSRuntimeException();
    }

    protected KeySpec a(Key key, Class clazz) throws InvalidKeySpecException {
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                Class<?> clazz2 = Class.forName(RSAKeyFactory.a("!\u0015dA]8\u0011qU\u0001\"\u0000k\u000e\u0000;\u0011q\u000e!\u00185BU\u0011'\u001dqk\u00162'bE\u0010"));
                Class<?> clazz3 = Class.forName(RSAKeyFactory.a("!\u0015dA]8\u0011qU\u0001\"\u0000k\u000e\u0000;\u0011q\u000e+~D+e\u001d(\u001bvE\u0017\u0000\u0011ks\u0003.\u0017"));
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
                    return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(RSAKeyFactory.a("\u0002\u001asP\u00039\u001bbR\u001a*\u0000w\u0000\u0018.\r2S\u0003.\u0017{F\u001a(\u0015fI\u001c%"));
            }
            if (key instanceof java.security.interfaces.RSAPrivateCrtKey) {
                Class<?> clazz4 = Class.forName(RSAKeyFactory.a("!\u0015dA]8\u0011qU\u0001\"\u0000k\u000e\u0000;\u0011q\u000e!\u00185BR\u001a=\u0015fE09\u0000YE\n\u0018\u0004wC"));
                Class<?> clazz5 = Class.forName(RSAKeyFactory.a("!\u0015dA]8\u0011qU\u0001\"\u0000k\u000e\u0000;\u0011q\u000e#\u00007A\u00186%\u0017}D\u0016/?wY ;\u0011q"));
                if (clazz4.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateCrtKey rSAPrivateCrtKey = (java.security.interfaces.RSAPrivateCrtKey)key;
                    return new RSAPrivateKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPrivateExponent());
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(RSAKeyFactory.a("\u0002\u001asP\u00039\u001bbR\u001a*\u0000w\u0000\u0018.\r2S\u0003.\u0017{F\u001a(\u0015fI\u001c%"));
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                Class<?> clazz6 = Class.forName(RSAKeyFactory.a("!\u0015dA]8\u0011qU\u0001\"\u0000k\u000e\u0000;\u0011q\u000e!\u00185BR\u001a=\u0015fE8.\rAP\u0016("));
                Class<?> clazz7 = Class.forName(RSAKeyFactory.a("!\u0015dA]8\u0011qU\u0001\"\u0000k\u000e\u0000;\u0011q\u000e#\u00007A\u00186%\u0017}D\u0016/?wY ;\u0011q"));
                if (clazz6.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
                    return new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
                }
                if (clazz7.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(RSAKeyFactory.a("\u0002\u001asP\u00039\u001bbR\u001a*\u0000w\u0000\u0018.\r2S\u0003.\u0017{F\u001a(\u0015fI\u001c%"));
            }
            throw new InvalidKeySpecException(RSAKeyFactory.a("\u0002\u001asP\u00039\u001bbR\u001a*\u0000w\u0000\u0018.\r2T\n;\u0011"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException(RSAKeyFactory.a("\u001e\u001aaU\u0003;\u001b`T\u0016/TyE\nk\u0007bE\u0010\"\u0012{C\u0012?\u001d}NIk") + classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException(RSAKeyFactory.a("\u0000\u0011k\u0000\u0004*\u00072N\u0006'\u0018"));
        }
        if (key instanceof java.security.interfaces.RSAPublicKey || key instanceof java.security.interfaces.RSAPrivateCrtKey || key instanceof java.security.interfaces.RSAPrivateKey) {
            return key;
        }
        throw new InvalidKeyException(RSAKeyFactory.a("\u0000\u0011k\u0000\u0004*\u00072N\u0006'\u0018"));
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 75;
                        break;
                    }
                    case 1: {
                        n5 = 116;
                        break;
                    }
                    case 2: {
                        n5 = 18;
                        break;
                    }
                    case 3: {
                        n5 = 32;
                        break;
                    }
                    default: {
                        n5 = 115;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

