/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.DvFileReader;
import com.ibm.jvm.dump.sdff.SDFFDump;
import java.io.IOException;

public class ElfHeader
extends SDFFDump {
    long endian;
    long wordLength;
    long type;
    long machine;
    long version;
    long entry;
    long programHeaderOffset;
    long sectionHeaderOffset;
    long flags;
    long elfHeaderSize;
    long programHeaderEntrySize;
    long numProgramHeaders;
    long sectionHeaderEntrySize;
    long numSectionHeaders;
    long stringTable;

    ElfHeader(DvFileReader dvFileReader) throws IOException {
        dvFileReader.setPos(16L);
        this.type = dvFileReader.readHalf();
        this.machine = dvFileReader.readHalf();
        this.version = dvFileReader.readWord();
        this.entry = dvFileReader.readAddress();
        this.programHeaderOffset = dvFileReader.readAddress();
        this.sectionHeaderOffset = dvFileReader.readAddress();
        this.flags = dvFileReader.readWord();
        this.elfHeaderSize = dvFileReader.readHalf();
        this.programHeaderEntrySize = dvFileReader.readHalf();
        this.numProgramHeaders = dvFileReader.readHalf();
        this.sectionHeaderEntrySize = dvFileReader.readHalf();
        this.numSectionHeaders = dvFileReader.readHalf();
        this.stringTable = dvFileReader.readHalf();
        system = 3;
        this.setArchitecture(dvFileReader.wordLength, dvFileReader.endType);
        subsystem = 10;
        switch ((int)this.machine) {
            case 3: {
                processor = 1;
                break;
            }
            case 20: {
                processor = 2;
                break;
            }
            case 21: {
                processor = 2;
                break;
            }
            case 2: {
                processor = -1;
                break;
            }
            case 9: {
                processor = -1;
                break;
            }
            default: {
                processor = -1;
            }
        }
    }

    void dump() throws IOException {
        DvUtils.trace("ELF Header Info", 2, false);
        DvUtils.trace("Type = " + this.type, 2, false);
        DvUtils.trace("Machine = " + this.machine, 2, false);
        DvUtils.trace("Version = " + this.version, 2, false);
        DvUtils.trace("Entry = " + this.entry, 2, false);
        DvUtils.trace("ProgramHeaderOffset = " + Long.toHexString(this.programHeaderOffset), 2, false);
        DvUtils.trace("SectionHeaderOffset = " + this.sectionHeaderOffset, 2, false);
        DvUtils.trace("Flags = " + Long.toHexString(this.flags), 2, false);
        DvUtils.trace("EHSize = " + Long.toHexString(this.elfHeaderSize), 2, false);
        DvUtils.trace("ProgramHeaderEntrySize = " + Long.toHexString(this.programHeaderEntrySize), 2, false);
        DvUtils.trace("NumProgramHeaders = " + this.numProgramHeaders, 2, false);
        DvUtils.trace("SectionHeaderEntrySize = " + Long.toHexString(this.sectionHeaderEntrySize), 2, false);
        DvUtils.trace("NumSectionHeaders = " + this.numSectionHeaders, 2, false);
        DvUtils.trace("StringTable = " + Long.toHexString(this.stringTable), 2, false);
    }
}

