/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.CompareVisitor;
import com.ibm.jvm.findroots.Heapdump;
import com.ibm.jvm.findroots.PrintBase;
import com.ibm.jvm.findroots.SimpleGraph;
import com.ibm.jvm.findroots.VertexClass;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;

public class Condense
extends PrintBase {
    Hashtable classTable = new Hashtable();
    VertexClass[] classes;
    SimpleGraph inverse = new SimpleGraph();
    String outputFilename;

    public static void main(String[] stringArray) {
        Condense condense = new Condense();
        verbose = true;
        condense.start(stringArray, "Condense");
    }

    String[] options() {
        return new String[]{"-o <filename>"};
    }

    String[] optionDescriptions() {
        return new String[]{"\tSpecify filename for the new .phd file"};
    }

    public boolean parseOption(String string, String string2) {
        if ("-o".equals(string)) {
            this.outputFilename = string2;
            return true;
        }
        return super.parseOption(string, string2);
    }

    void printInfo() {
        this.log("about to parse file");
    }

    protected void parseStart() {
        if (this.outputFilename == null) {
            System.err.println("you must supply the -o option");
            this.usage();
        }
    }

    protected void parseEnd() {
        int n;
        super.parseEnd();
        this.log("finished parsing");
        this.inverse = this.graph.inverse(this.inverse);
        this.log("done inverse");
        BitSet bitSet = new BitSet();
        Enumeration enumeration = this.classTable.elements();
        while (enumeration.hasMoreElements()) {
            VertexClass vertexClass = (VertexClass)enumeration.nextElement();
            if (vertexClass.type != 1) continue;
            this.log("found class " + vertexClass.name + " with " + vertexClass.ids.size() + " objects");
            BitSet bitSet2 = new BitSet();
            for (int i = 0; i < vertexClass.ids.size(); ++i) {
                if (bitSet2.get(i)) continue;
                int n2 = vertexClass.ids.get(i);
                for (int j = i + 1; j < vertexClass.ids.size(); ++j) {
                    if (bitSet2.get(j)) continue;
                    int n3 = vertexClass.ids.get(j);
                    Condense.Assert(n2 != n3);
                    if (!this.compare(n2, n3)) continue;
                    bitSet2.set(j);
                    int n4 = this.graph.getSize(n2);
                    int n5 = this.graph.getSize(n3);
                    this.graph.setSize(n2, n4 + n5);
                    this.log("found match between " + Condense.hex(n2) + " and " + Condense.hex(n3) + " adding " + n5 + " gives " + (n4 + n5));
                    bitSet.set(this.ids.indexOf(n3));
                }
            }
        }
        this.log("create new .phd file");
        try {
            this.dump = new Heapdump(this.outputFilename, true);
        }
        catch (Exception exception) {
            throw new Error("uh oh");
        }
        for (n = 0; n < this.strings.size(); ++n) {
            this.dump.stringDump(this.getString(n));
        }
        block12: for (n = 0; n < this.ids.size(); ++n) {
            if (bitSet.get(n)) continue;
            int n6 = this.ids.get(n);
            int n7 = this.indexes.get(n);
            switch (this.type(n)) {
                case 1: {
                    this.dump.objectDump(n6, n7, 0, this.graph.getSize(n6), this.graph.getReferences(n6));
                    continue block12;
                }
                case 2: {
                    this.dump.classDump(n6, n7, 0, this.graph.getSize(n6), this.graph.getReferences(n6));
                    continue block12;
                }
                case 3: {
                    this.dump.primitiveArrayDump(n6, n7, 0, this.graph.getSize(n6));
                    continue block12;
                }
                case 4: {
                    this.dump.objectArrayDump(n6, n7, 0, this.graph.getSize(n6), this.graph.getReferences(n6));
                    continue block12;
                }
                default: {
                    Condense.Assert(false);
                }
            }
        }
        this.dump.close();
        this.log("finished!");
    }

    VertexClass getVertexClass(int n) {
        int n2 = this.ids.indexOf(n);
        Condense.Assert(n2 != -1);
        VertexClass vertexClass = this.classes[n2];
        Condense.Assert(vertexClass != null);
        return vertexClass;
    }

    boolean compare(int n, int n2) {
        CompareVisitor compareVisitor = new CompareVisitor(){

            public boolean continueSearch(int n, int n2) {
                return n != n2;
            }

            public boolean compare(int n, int n2) {
                int n3 = Condense.this.graph.vertexIds.get(n);
                int n4 = Condense.this.graph.vertexIds.get(n2);
                return Condense.this.getVertexClass(n3) == Condense.this.getVertexClass(n4);
            }
        };
        boolean bl = this.graph.dfsCompare(compareVisitor, n, n2);
        boolean bl2 = this.inverse.dfsCompare(compareVisitor, n, n2);
        return bl && bl2;
    }
}

