/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;
import javax.security.cert.CertPath;

public class CertPathValidatorException
extends GeneralSecurityException {
    static final long serialVersionUID = -3760325148835389548L;
    private int index = -1;
    private CertPath certPath;
    private Throwable ie;

    public CertPathValidatorException() {
        this(null, null);
    }

    public CertPathValidatorException(String string) {
        this(string, null);
    }

    public CertPathValidatorException(Throwable throwable) {
        this(null, throwable);
    }

    public CertPathValidatorException(String string, Throwable throwable) {
        super(string);
        this.ie = throwable;
    }

    public CertPathValidatorException(String string, Throwable throwable, CertPath certPath, int n) {
        this(string, throwable);
        if (n < -1 || certPath != null && n >= certPath.getCertificates().size()) {
            throw new IndexOutOfBoundsException("Index of the certificate in specified CertPath is out of bound");
        }
        if (certPath == null && n != -1) {
            throw new IllegalArgumentException();
        }
        this.certPath = certPath;
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public Throwable getCause() {
        return this.ie;
    }

    public String toString() {
        if (this.ie == null) {
            return super.toString();
        }
        return super.toString() + "\nInternal exception - " + this.ie.toString();
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.ie != null) {
            this.ie.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.ie != null) {
            this.ie.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.ie != null) {
            this.ie.printStackTrace(printWriter);
        }
    }

    public String getMessage() {
        return super.getMessage();
    }
}

