/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;

class MemoryCache {
    private static final float LOAD_FACTOR = 0.75f;
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private final LinkedHashMap cacheMap;
    private final int maxSize;
    private final int lifetime;
    private final ReferenceQueue queue;

    public MemoryCache(int n, int n2) {
        this.maxSize = n;
        this.lifetime = n2 * 1000;
        this.queue = new ReferenceQueue();
        int n3 = (int)((float)n / 0.75f) + 1;
        this.cacheMap = new LinkedHashMap(n3, 0.75f, true);
    }

    private void processQueue() {
        int n;
        int n2 = this.cacheMap.size();
        SoftValue softValue = null;
        while ((softValue = (SoftValue)this.queue.poll()) != null) {
            SoftReference softReference;
            Object object = softValue.key;
            if (object == null || (softReference = (SoftReference)this.cacheMap.remove(object)) == null || softValue == softReference) continue;
            this.cacheMap.put(object, softReference);
        }
        if (debug != null && n2 != (n = this.cacheMap.size())) {
            System.out.println("CERTPATH: Cache size is reduced from " + n2 + " to " + n + " entries");
        }
    }

    private void expungeExpiredEntries() {
        this.processQueue();
        if (this.lifetime == 0) {
            return;
        }
        int n = 0;
        long l = System.currentTimeMillis();
        Iterator iterator = this.cacheMap.values().iterator();
        while (iterator.hasNext()) {
            SoftValue softValue = (SoftValue)iterator.next();
            if (softValue.isValid(l)) continue;
            iterator.remove();
            ++n;
        }
        if (debug != null && n != 0) {
            System.out.println("CERTPATH: Removed " + n + " expired entries, remaining " + this.cacheMap.size());
        }
    }

    public synchronized int size() {
        this.expungeExpiredEntries();
        return this.cacheMap.size();
    }

    public synchronized void clear() {
        Iterator iterator = this.cacheMap.values().iterator();
        while (iterator.hasNext()) {
            SoftValue softValue = (SoftValue)iterator.next();
            softValue.clear();
        }
        while (this.queue.poll() != null) {
        }
        this.cacheMap.clear();
    }

    public synchronized void put(Object object, Object object2) {
        if (this.lifetime > 0) {
            this.processQueue();
            long l = System.currentTimeMillis() + (long)this.lifetime;
            SoftValue softValue = new SoftValue(object, object2, l, this.queue);
            SoftValue softValue2 = this.cacheMap.put(object, softValue);
            if (softValue2 != null) {
                softValue2.clear();
                return;
            }
            if (this.cacheMap.size() > this.maxSize) {
                this.expungeExpiredEntries();
                if (this.cacheMap.size() > this.maxSize) {
                    Iterator iterator = this.cacheMap.values().iterator();
                    SoftValue softValue3 = (SoftValue)iterator.next();
                    if (debug != null) {
                        System.out.println("CERTPATH: ** Overflow removal " + softValue3.key + " | " + softValue3.get());
                    }
                    iterator.remove();
                    softValue3.clear();
                }
            }
        }
    }

    public synchronized Object get(Object object) {
        long l;
        this.processQueue();
        SoftValue softValue = (SoftValue)this.cacheMap.get(object);
        if (softValue == null) {
            return null;
        }
        long l2 = l = this.lifetime == 0 ? 0L : System.currentTimeMillis();
        if (!softValue.isValid(l)) {
            this.cacheMap.remove(object);
            return null;
        }
        return softValue.get();
    }

    public synchronized void remove(Object object) {
        this.processQueue();
        SoftValue softValue = (SoftValue)this.cacheMap.remove(object);
        if (softValue != null) {
            softValue.clear();
        }
    }

    private static class SoftValue
    extends SoftReference {
        private Object key;
        private long expirationTime;

        SoftValue(Object object, Object object2, long l, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
            this.expirationTime = l;
        }

        public boolean isValid(long l) {
            boolean bl;
            boolean bl2 = bl = l <= this.expirationTime && this.get() != null;
            if (!bl) {
                this.clear();
            }
            return bl;
        }

        public void clear() {
            super.clear();
            this.key = null;
            this.expirationTime = -1L;
        }
    }
}

