/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import com.ibm.crypto.pkcs11.provider.PKCS11DSAPrivateKey;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Date;

final class DSAPKCS11PrivateKey
extends PrivateKeyInfo
implements PKCS11DSAPrivateKey,
Serializable {
    private PKCS11Object object = null;
    private PKCS11Session session = null;
    private PKCS11Session[] allSessions = null;
    private String label = null;
    private Integer keyType = PKCS11Object.DSA;
    private byte[] ID = null;
    private byte[] subject = null;
    private boolean isSensitive = false;
    private Boolean isDecrypt = null;
    private Boolean isSign = null;
    private BigInteger prime = null;
    private BigInteger subprime = null;
    private BigInteger base = null;
    private BigInteger value = null;
    private int slotID;

    public DSAPKCS11PrivateKey(int n, PKCS11Object pKCS11Object, PKCS11Session pKCS11Session, PKCS11Session[] pKCS11SessionArray, String string, byte[] byArray, byte[] byArray2, Boolean bl, Boolean bl2) throws InvalidKeyException {
        this.slotID = n;
        this.object = pKCS11Object;
        this.session = pKCS11Session;
        this.allSessions = pKCS11SessionArray;
        if (string != null) {
            this.label = string;
        }
        if (byArray != null) {
            this.ID = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.ID, 0, byArray.length);
        }
        if (byArray2 != null) {
            this.subject = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.subject, 0, byArray2.length);
        }
        if (bl != null) {
            this.isDecrypt = new Boolean(bl);
        }
        if (bl2 != null) {
            this.isSign = new Boolean(bl2);
        }
        this.isSensitive = true;
    }

    public DSAPKCS11PrivateKey(int n, PKCS11Object pKCS11Object, PKCS11Session pKCS11Session, PKCS11Session[] pKCS11SessionArray, String string, byte[] byArray, byte[] byArray2, Boolean bl, Boolean bl2, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this(n, pKCS11Object, pKCS11Session, pKCS11SessionArray, string, byArray, byArray2, bl, bl2);
        if (bigInteger != null) {
            this.prime = new BigInteger(bigInteger.toByteArray());
        }
        if (bigInteger2 != null) {
            this.subprime = new BigInteger(bigInteger2.toByteArray());
        }
        if (bigInteger3 != null) {
            this.base = new BigInteger(bigInteger3.toByteArray());
        }
        if (bigInteger4 != null) {
            this.value = new BigInteger(bigInteger4.toByteArray());
        }
        this.algid = new AlgIdDSA(bigInteger, bigInteger2, bigInteger3);
        if (this.value != null) {
            try {
                this.key = new DerValue(2, this.value.toByteArray()).toByteArray();
                this.encode();
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("could not DER encode x: " + iOException.getMessage());
            }
        }
    }

    public DSAPKCS11PrivateKey(PKCS11Object pKCS11Object, PKCS11Session pKCS11Session, PKCS11Session[] pKCS11SessionArray, byte[] byArray) throws InvalidKeyException {
        this.object = pKCS11Object;
        this.session = pKCS11Session;
        this.allSessions = pKCS11SessionArray;
        if (byArray == null) {
            throw new InvalidKeyException("ID must be specified");
        }
        this.ID = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.ID, 0, byArray.length);
        this.label = null;
        this.subject = null;
        this.isDecrypt = null;
        this.isSign = null;
        this.isSensitive = true;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public Boolean getAlwaysSensitive() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Integer getAuthPinFlags() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public BigInteger getBase() {
        return this.base;
    }

    public Boolean getDecrypt() {
        return this.isDecrypt;
    }

    public Boolean getDerive() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Date getEndDate() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Boolean getExtractable() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public String getFormat() {
        if (!this.isSensitive) {
            return "PKCS#8";
        }
        return "PKCS#11";
    }

    public byte[] getID() {
        return (byte[])this.ID.clone();
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getLocal() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Boolean getModifiable() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Boolean getNeverExtractable() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public PKCS11Session[] getOpenSessions() {
        return this.allSessions;
    }

    public BigInteger getPrime() {
        return this.prime;
    }

    public Boolean getPrivate() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Boolean getSecondaryAuth() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Boolean getSensitive() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public PKCS11Session getSession() {
        return this.session;
    }

    public Boolean getSign() {
        return this.isSign;
    }

    public Boolean getSignRecover() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public int getSlotID() {
        return this.slotID;
    }

    public Date getStartDate() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public byte[] getSubject() {
        if (this.subject == null) {
            return null;
        }
        return (byte[])this.subject.clone();
    }

    public BigInteger getSubprime() {
        return this.subprime;
    }

    public Boolean getToken() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Boolean getUnwrap() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public BigInteger getValue() {
        return this.value;
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        return pKCS11Object.getAttributeValue(n);
    }

    protected void parseKeyBits() throws IOException {
        if (this.object != null) {
            if (((Boolean)this.getValue(this.object, 259)).equals(Boolean.TRUE)) {
                throw new IOException("This key cannot be revealed");
            }
            if (((Boolean)this.getValue(this.object, 354)).equals(Boolean.TRUE)) {
                throw new IOException("This key cannot be extracted");
            }
        }
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.value = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    public String toString() {
        String string = "IBMPKCS11";
        String string2 = String.valueOf(string) + " DSA Private Key: ";
        if (this.label != null) {
            string2 = String.valueOf(string2) + "\n label: " + this.label;
        }
        if (this.ID != null) {
            string2 = String.valueOf(string2) + "\n ID: " + new String(this.ID);
        }
        if (this.subject != null) {
            string2 = String.valueOf(string2) + "\n subject: " + new String(this.subject);
        }
        if (this.isDecrypt != null) {
            string2 = String.valueOf(string2) + "\n decrypt: " + this.isDecrypt;
        }
        if (this.isSign != null) {
            string2 = String.valueOf(string2) + "\n sign: " + this.isSign;
        }
        if (this.prime != null) {
            string2 = String.valueOf(string2) + "\n prime: " + this.prime.toString();
        }
        if (this.subprime != null) {
            string2 = String.valueOf(string2) + "\n subprime: " + this.subprime.toString();
        }
        if (this.base != null) {
            string2 = String.valueOf(string2) + "\n base: " + this.base.toString();
        }
        if (this.value != null) {
            string2 = String.valueOf(string2) + "\n value: " + this.value.toString();
        }
        return string2;
    }
}

