/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import com.ibm.crypto.pkcs11.provider.DSAPKCS11PrivateKey;
import com.ibm.crypto.pkcs11.provider.PKCS11DSAPrivateKey;
import com.ibm.crypto.pkcs11.provider.PKCS11Key;
import com.ibm.crypto.pkcs11.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11.provider.PKCS11RSAPrivateKey;
import com.ibm.crypto.pkcs11.provider.RSAPKCS11PrivateKey;
import com.ibm.crypto.pkcs11.provider.RSAPKCS11PublicKey;
import com.ibm.pkcs11.PKCS11;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.pkcs11.PKCS11Slot;
import com.ibm.pkcs11.nat.NativePKCS11;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public final class PKCS11KeyStore
extends KeyStoreSpi {
    private static boolean debug = false;
    private boolean libInitialized = false;
    private String dllName = null;
    private static int pkcs11LibCount = 0;
    private static Date returnDate = new Date(0L);
    private PKCS11 pkcs11 = null;
    private PKCS11Session[] openSessions = null;
    private PKCS11Slot[] tokenSlots = null;
    private PKCS11Slot tokenSlot = null;
    private int slotIndex = 0;
    private Hashtable entries = new Hashtable();

    private boolean bytesEquals(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private PKCS11Object createCertObject(PKCS11Session pKCS11Session, String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, BigInteger bigInteger) throws KeyStoreException {
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 128;
        nArray[5] = 258;
        nArray[6] = 257;
        nArray[7] = 130;
        nArray[8] = 17;
        nArray[9] = 129;
        int[] nArray2 = nArray;
        Object[] objectArray = new Object[]{PKCS11Object.CERTIFICATE, Boolean.TRUE, Boolean.FALSE, string, PKCS11Object.X_509, byArray3, byArray2, bigInteger.toByteArray(), byArray, byArray4};
        PKCS11Object pKCS11Object = null;
        if (pKCS11Session != null) {
            try {
                pKCS11Object = pKCS11Session.createObject(nArray2, objectArray);
                return pKCS11Object;
            }
            catch (Exception exception) {
                throw new KeyStoreException("Cannot store certificate: " + exception.getMessage());
            }
        }
        boolean bl = false;
        int n = 0;
        String string2 = "";
        while (!bl) {
            if (n >= this.openSessions.length) {
                throw new KeyStoreException("Cannot store certificate: " + string2);
            }
            try {
                pKCS11Object = this.openSessions[n].createObject(nArray2, objectArray);
                bl = true;
                return pKCS11Object;
            }
            catch (Exception exception) {
                string2 = String.valueOf(string2) + n + "." + exception.getMessage() + " ";
                ++n;
            }
        }
        return null;
    }

    private PKCS11PrivateKey createPrivateKeyObject(String string, Key key, char[] cArray) throws KeyStoreException {
        if (key instanceof PKCS11RSAPrivateKey) {
            PKCS11RSAPrivateKey pKCS11RSAPrivateKey = (PKCS11RSAPrivateKey)key;
            if (pKCS11RSAPrivateKey.getObject() != null) {
                PKCS11Object pKCS11Object = pKCS11RSAPrivateKey.getObject();
                int[] nArray = new int[]{1, 2, 3, 257};
                Object[] objectArray = new Object[]{Boolean.TRUE, Boolean.TRUE, string, pKCS11RSAPrivateKey.getSubject()};
                PKCS11Object pKCS11Object2 = null;
                try {
                    if (((Boolean)this.getValue(pKCS11Object, 1)).equals(Boolean.TRUE)) {
                        pKCS11Object2 = pKCS11Object;
                        return new RSAPKCS11PrivateKey(this.slotIndex, pKCS11Object2, pKCS11RSAPrivateKey.getSession(), pKCS11RSAPrivateKey.getOpenSessions(), string, pKCS11RSAPrivateKey.getID(), pKCS11RSAPrivateKey.getSubject(), pKCS11RSAPrivateKey.getDecrypt(), pKCS11RSAPrivateKey.getSign());
                    }
                    pKCS11Object2 = pKCS11Object.copy(nArray, objectArray);
                    return new RSAPKCS11PrivateKey(this.slotIndex, pKCS11Object2, pKCS11RSAPrivateKey.getSession(), this.openSessions, string, pKCS11RSAPrivateKey.getID(), pKCS11RSAPrivateKey.getSubject(), pKCS11RSAPrivateKey.getDecrypt(), pKCS11RSAPrivateKey.getSign(), pKCS11RSAPrivateKey.getModulus(), pKCS11RSAPrivateKey.getPublicExponent(), pKCS11RSAPrivateKey.getPrivateExponent(), pKCS11RSAPrivateKey.getPrime1(), pKCS11RSAPrivateKey.getPrime2(), pKCS11RSAPrivateKey.getExponent1(), pKCS11RSAPrivateKey.getExponent2(), pKCS11RSAPrivateKey.getCoefficient());
                }
                catch (PKCS11Exception pKCS11Exception) {
                    if (pKCS11Object2 != null) {
                        pKCS11Object2.destroy();
                    }
                    throw new KeyStoreException(pKCS11Exception.getMessage());
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new KeyStoreException(invalidKeyException.getMessage());
                }
            }
            int[] nArray = new int[20];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 256;
            nArray[5] = 257;
            nArray[6] = 258;
            nArray[7] = 264;
            nArray[8] = 265;
            nArray[9] = 288;
            nArray[10] = 291;
            nArray[11] = 261;
            nArray[12] = 268;
            nArray[13] = 259;
            nArray[14] = 296;
            nArray[15] = 290;
            nArray[16] = 292;
            nArray[17] = 293;
            nArray[18] = 294;
            nArray[19] = 295;
            int[] nArray2 = nArray;
            Object[] objectArray = new Object[]{PKCS11Object.PRIVATE_KEY, Boolean.TRUE, Boolean.TRUE, string, PKCS11Object.RSA, pKCS11RSAPrivateKey.getSubject(), pKCS11RSAPrivateKey.getID(), Boolean.TRUE, Boolean.TRUE, pKCS11RSAPrivateKey.getModulus(), pKCS11RSAPrivateKey.getPrivateExponent(), Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, pKCS11RSAPrivateKey.getCoefficient(), pKCS11RSAPrivateKey.getPublicExponent(), pKCS11RSAPrivateKey.getPrime1(), pKCS11RSAPrivateKey.getPrime2(), pKCS11RSAPrivateKey.getExponent1(), pKCS11RSAPrivateKey.getExponent2()};
            PKCS11Object pKCS11Object = null;
            boolean bl = false;
            int n = 0;
            String string2 = "";
            while (!bl) {
                if (n >= this.openSessions.length) {
                    throw new KeyStoreException("Cannot store key: " + string2);
                }
                try {
                    pKCS11Object = this.openSessions[n].createObject(nArray2, objectArray);
                    bl = true;
                }
                catch (Exception exception) {
                    if (pKCS11Object != null) {
                        pKCS11Object.destroy();
                    }
                    string2 = String.valueOf(string2) + n + "." + exception.getMessage() + " ";
                    ++n;
                }
            }
            RSAPKCS11PrivateKey rSAPKCS11PrivateKey = null;
            try {
                rSAPKCS11PrivateKey = new RSAPKCS11PrivateKey(this.slotIndex, pKCS11Object, this.openSessions[n], this.openSessions, string, pKCS11RSAPrivateKey.getID(), pKCS11RSAPrivateKey.getSubject(), pKCS11RSAPrivateKey.getDecrypt(), pKCS11RSAPrivateKey.getSign(), pKCS11RSAPrivateKey.getModulus(), pKCS11RSAPrivateKey.getPublicExponent(), pKCS11RSAPrivateKey.getPrivateExponent(), pKCS11RSAPrivateKey.getPrime1(), pKCS11RSAPrivateKey.getPrime2(), pKCS11RSAPrivateKey.getExponent1(), pKCS11RSAPrivateKey.getExponent2(), pKCS11RSAPrivateKey.getCoefficient());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new KeyStoreException(invalidKeyException.getMessage());
            }
            return rSAPKCS11PrivateKey;
        }
        if (key instanceof PKCS11DSAPrivateKey) {
            PKCS11DSAPrivateKey pKCS11DSAPrivateKey = (PKCS11DSAPrivateKey)key;
            if (pKCS11DSAPrivateKey.getObject() != null) {
                PKCS11Object pKCS11Object = pKCS11DSAPrivateKey.getObject();
                int[] nArray = new int[]{1, 2, 3, 257};
                Object[] objectArray = new Object[]{Boolean.TRUE, Boolean.TRUE, string, pKCS11DSAPrivateKey.getSubject()};
                PKCS11Object pKCS11Object3 = null;
                try {
                    if (((Boolean)this.getValue(pKCS11Object, 1)).equals(Boolean.TRUE)) {
                        pKCS11Object3 = pKCS11Object;
                        return new DSAPKCS11PrivateKey(this.slotIndex, pKCS11Object3, pKCS11DSAPrivateKey.getSession(), pKCS11DSAPrivateKey.getOpenSessions(), string, pKCS11DSAPrivateKey.getID(), pKCS11DSAPrivateKey.getSubject(), pKCS11DSAPrivateKey.getDecrypt(), pKCS11DSAPrivateKey.getSign());
                    }
                    pKCS11Object3 = pKCS11Object.copy(nArray, objectArray);
                    return new DSAPKCS11PrivateKey(this.slotIndex, pKCS11Object3, pKCS11DSAPrivateKey.getSession(), this.openSessions, string, pKCS11DSAPrivateKey.getID(), pKCS11DSAPrivateKey.getSubject(), pKCS11DSAPrivateKey.getDecrypt(), pKCS11DSAPrivateKey.getSign(), pKCS11DSAPrivateKey.getPrime(), pKCS11DSAPrivateKey.getSubprime(), pKCS11DSAPrivateKey.getBase(), pKCS11DSAPrivateKey.getValue());
                }
                catch (PKCS11Exception pKCS11Exception) {
                    if (pKCS11Object3 != null) {
                        pKCS11Object3.destroy();
                    }
                    throw new KeyStoreException(pKCS11Exception.getMessage());
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new KeyStoreException(invalidKeyException.getMessage());
                }
            }
            int[] nArray = new int[16];
            nArray[0] = 17;
            nArray[2] = 1;
            nArray[3] = 2;
            nArray[4] = 3;
            nArray[5] = 256;
            nArray[6] = 257;
            nArray[7] = 258;
            nArray[8] = 264;
            nArray[9] = 265;
            nArray[10] = 306;
            nArray[11] = 305;
            nArray[12] = 304;
            nArray[13] = 261;
            nArray[14] = 268;
            nArray[15] = 259;
            int[] nArray3 = nArray;
            Object[] objectArray = new Object[]{pKCS11DSAPrivateKey.getValue().toByteArray(), PKCS11Object.PRIVATE_KEY, Boolean.TRUE, Boolean.TRUE, string, PKCS11Object.DSA, pKCS11DSAPrivateKey.getID(), pKCS11DSAPrivateKey.getID(), Boolean.TRUE, Boolean.TRUE, pKCS11DSAPrivateKey.getBase(), pKCS11DSAPrivateKey.getSubprime(), pKCS11DSAPrivateKey.getPrime(), Boolean.TRUE, Boolean.FALSE, Boolean.FALSE};
            PKCS11Object pKCS11Object = null;
            boolean bl = false;
            int n = 0;
            String string3 = "";
            while (!bl) {
                if (n >= this.openSessions.length) {
                    throw new KeyStoreException("Cannot store key: " + string3);
                }
                try {
                    pKCS11Object = this.openSessions[n].createObject(nArray3, objectArray);
                    bl = true;
                }
                catch (Exception exception) {
                    string3 = String.valueOf(string3) + n + "." + exception.getMessage() + " ";
                    ++n;
                }
            }
            DSAPKCS11PrivateKey dSAPKCS11PrivateKey = null;
            try {
                dSAPKCS11PrivateKey = new DSAPKCS11PrivateKey(this.slotIndex, pKCS11Object, this.openSessions[n], this.openSessions, string, pKCS11DSAPrivateKey.getID(), pKCS11DSAPrivateKey.getSubject(), pKCS11DSAPrivateKey.getDecrypt(), pKCS11DSAPrivateKey.getSign(), pKCS11DSAPrivateKey.getPrime(), pKCS11DSAPrivateKey.getSubprime(), pKCS11DSAPrivateKey.getBase(), pKCS11DSAPrivateKey.getValue());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new KeyStoreException(invalidKeyException.getMessage());
            }
            return dSAPKCS11PrivateKey;
        }
        throw new KeyStoreException("Invalid key type: " + key);
    }

    private PKCS11PrivateKey createPrivateKeyObject(String string, int[] nArray, Object[] objectArray, byte[] byArray, boolean bl) throws KeyStoreException {
        PKCS11Object pKCS11Object = null;
        boolean bl2 = false;
        int n = 0;
        String string2 = "";
        while (!bl2) {
            if (n >= this.openSessions.length) {
                throw new KeyStoreException("Cannot store key: " + string2);
            }
            try {
                pKCS11Object = this.openSessions[n].createObject(nArray, objectArray);
                bl2 = true;
            }
            catch (Exception exception) {
                if (pKCS11Object != null) {
                    pKCS11Object.destroy();
                }
                string2 = String.valueOf(string2) + n + "." + exception.getMessage() + " ";
                ++n;
            }
        }
        if (bl) {
            RSAPKCS11PrivateKey rSAPKCS11PrivateKey = null;
            try {
                rSAPKCS11PrivateKey = new RSAPKCS11PrivateKey(this.slotIndex, pKCS11Object, this.openSessions[n], this.openSessions, string, byArray, null, Boolean.TRUE, Boolean.TRUE, null, null, null, null, null, null, null, null);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new KeyStoreException(invalidKeyException.getMessage());
            }
            return rSAPKCS11PrivateKey;
        }
        DSAPKCS11PrivateKey dSAPKCS11PrivateKey = null;
        try {
            dSAPKCS11PrivateKey = new DSAPKCS11PrivateKey(this.slotIndex, pKCS11Object, this.openSessions[n], this.openSessions, string, byArray, null, Boolean.TRUE, Boolean.TRUE);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyStoreException(invalidKeyException.getMessage());
        }
        return dSAPKCS11PrivateKey;
    }

    public Enumeration engineAliases() {
        return this.entries.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(string.toLowerCase());
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            if (this.engineIsKeyEntry(string)) {
                PrivateKeyEntry privateKeyEntry = (PrivateKeyEntry)this.entries.get(string.toLowerCase());
                ((PKCS11Key)privateKeyEntry.key).getObject().destroy();
                PKCS11Object[] pKCS11ObjectArray = privateKeyEntry.certObjects;
                int n = 0;
                while (n < pKCS11ObjectArray.length) {
                    if (pKCS11ObjectArray[n] != null) {
                        pKCS11ObjectArray[n].destroy();
                    }
                    ++n;
                }
            } else if (this.engineIsCertificateEntry(string)) {
                TrustedCertEntry trustedCertEntry = (TrustedCertEntry)this.entries.get(string.toLowerCase());
                trustedCertEntry.certObject.destroy();
            }
            this.entries.remove(string.toLowerCase());
        }
    }

    public Certificate engineGetCertificate(String string) {
        Certificate certificate = null;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof TrustedCertEntry) {
                certificate = ((TrustedCertEntry)v).cert;
            } else if (v instanceof PrivateKeyEntry && ((PrivateKeyEntry)v).chain != null) {
                certificate = ((PrivateKeyEntry)v).chain[0];
            }
        }
        return certificate;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            Object v = this.entries.get(string);
            if (v instanceof TrustedCertEntry) {
                certificate2 = ((TrustedCertEntry)v).cert;
            } else {
                if (!(v instanceof PrivateKeyEntry) || ((PrivateKeyEntry)v).chain == null) continue;
                certificate2 = ((PrivateKeyEntry)v).chain[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Certificate[] certificateArray = null;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof PrivateKeyEntry && ((PrivateKeyEntry)v).chain != null) {
            certificateArray = (Certificate[])((PrivateKeyEntry)v).chain.clone();
        }
        return certificateArray;
    }

    public Date engineGetCreationDate(String string) {
        return returnDate;
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (string == null) {
            try {
                return new RSAPKCS11PublicKey(0, null, null, this.openSessions, null, null, null, null, null);
            }
            catch (InvalidKeyException invalidKeyException) {
                return null;
            }
        }
        Object v = this.entries.get(string.toLowerCase());
        if (v instanceof PrivateKeyEntry) {
            return ((PrivateKeyEntry)v).key;
        }
        return null;
    }

    public boolean engineIsCertificateEntry(String string) {
        boolean bl = false;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof TrustedCertEntry) {
            bl = true;
        }
        return bl;
    }

    public boolean engineIsKeyEntry(String string) {
        boolean bl = false;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof PrivateKeyEntry) {
            bl = true;
        }
        return bl;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object;
            File file;
            if (debug) {
                System.out.println("P1");
            }
            InputStreamReader inputStreamReader = null;
            try {
                inputStreamReader = new InputStreamReader(inputStream, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                inputStreamReader = new InputStreamReader(inputStream);
            }
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            if (debug) {
                System.out.println("P2");
            }
            String string = bufferedReader.readLine();
            if (this.dllName != null & this.libInitialized) {
                if (this.dllName.equals(string.trim())) {
                    Object var4_7 = null;
                    return;
                }
            } else {
                this.dllName = string.trim();
            }
            String string2 = null;
            int n = 0;
            if (string.toLowerCase().indexOf(".dll") < 0) {
                if (string.toLowerCase().indexOf(".so") < 0) {
                    throw new IOException("Invalid library name");
                }
                if (debug) {
                    System.out.println("P3");
                }
                if ((n = string.toLowerCase().indexOf(".so:") + 3) > 2) {
                    string2 = string.substring(0, n);
                    try {
                        this.slotIndex = Integer.valueOf(string.substring(n + 1, string.length()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Invalid slot number");
                    }
                } else {
                    n = string.toLowerCase().indexOf(".so64:") + 3;
                    if (n > 2) {
                        string2 = string.substring(0, n += 2);
                        try {
                            this.slotIndex = Integer.valueOf(string.substring(n + 1, string.length()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IOException("Invalid slot number");
                        }
                    } else {
                        string2 = string;
                    }
                }
                file = new File(string2);
                object = file.getName();
                if (object != null && ((String)object).toLowerCase().startsWith("lib")) {
                    string2 = String.valueOf(file.getParent()) + File.separator + ((String)object).substring(3);
                }
                if (string2.toLowerCase().endsWith(".so")) {
                    string2 = string2.substring(0, string2.length() - 3);
                }
            } else {
                if (debug) {
                    System.out.println("P4");
                }
                if ((n = string.toLowerCase().indexOf(".dll:") + 4) > 3) {
                    string2 = string.substring(0, n);
                    try {
                        this.slotIndex = Integer.valueOf(string.substring(n + 1, string.length()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Invalid slot number");
                    }
                } else {
                    string2 = string;
                }
                if (string2.toLowerCase().endsWith(".dll")) {
                    string2 = string2.substring(0, string2.length() - 4);
                }
            }
            try {
                this.pkcs11 = new NativePKCS11(string2);
            }
            catch (PKCS11Exception pKCS11Exception) {
                throw new IOException("Invalid dll name : " + string2);
            }
            if (debug) {
                System.out.println("P5");
            }
            if (!this.libInitialized) {
                this.pkcs11.libInitialize();
                this.libInitialized = true;
            }
            try {
                this.pkcs11.libInitialize();
            }
            catch (PKCS11Exception pKCS11Exception) {}
            this.tokenSlots = this.pkcs11.getSlotList(true);
            if (this.slotIndex < 0 || this.slotIndex > this.tokenSlots.length - 1) {
                throw new IOException("Invalid slot number : " + this.slotIndex);
            }
            this.tokenSlot = this.tokenSlots[this.slotIndex];
            this.tokenSlots = new PKCS11Slot[1];
            this.tokenSlots[0] = this.tokenSlot;
            file = null;
            object = null;
            this.openSessions = new PKCS11Session[this.tokenSlots.length];
            CertificateFactory certificateFactory = null;
            try {
                certificateFactory = CertificateFactory.getInstance("X509", "IBMPKCS11");
            }
            catch (Exception exception) {}
            int n2 = 0;
            while (n2 < this.tokenSlots.length) {
                Object object2;
                Object object3;
                Object object4;
                String string3;
                Object object5;
                Object object6;
                int n3;
                Object object7;
                try {
                    this.openSessions[n2] = this.tokenSlots[n2].openSession(6, null, null);
                }
                catch (Exception exception) {
                    throw new IOException("slot " + this.slotIndex + " is read only");
                }
                Vector<File> vector = new Vector<File>();
                Vector<File> vector2 = new Vector<File>();
                try {
                    if (cArray == null) {
                        this.openSessions[n2].login(false, null);
                    } else {
                        this.openSessions[n2].login(false, (Object)new String(cArray));
                    }
                }
                catch (Exception exception) {
                    throw new IOException("cannot login to slot " + this.slotIndex + " : " + exception.getMessage());
                }
                this.openSessions[n2].findObjectsInit(null, null);
                while ((file = this.openSessions[n2].findObject()) != null) {
                    object = this.getValue((PKCS11Object)file, 1);
                    if (object == null || !((Boolean)object).equals(Boolean.TRUE)) continue;
                    object = this.getValue((PKCS11Object)file, 0);
                    if (object != null && ((Integer)object).equals(PKCS11Object.PRIVATE_KEY)) {
                        vector.add(file);
                        continue;
                    }
                    if (object == null || !((Integer)object).equals(PKCS11Object.CERTIFICATE)) continue;
                    vector2.add(file);
                }
                String string4 = "privateKey";
                int n4 = 0;
                int n5 = 0;
                if (vector.size() > 0) {
                    object7 = vector.elements();
                    n3 = 0;
                    while (object7.hasMoreElements()) {
                        Object object8;
                        int n6;
                        Object object9;
                        X500Name x500Name;
                        PrivateKeyEntry privateKeyEntry;
                        Object object10;
                        Object object11;
                        Object[] objectArray;
                        object6 = (PKCS11Object)object7.nextElement();
                        String string5 = (String)this.getValue((PKCS11Object)object6, 3);
                        object5 = (byte[])this.getValue((PKCS11Object)object6, 258);
                        string3 = "e";
                        int n7 = 0;
                        if (object5 == null) continue;
                        object4 = new String((byte[])object5);
                        int n8 = vector2.size();
                        object3 = vector2.elements();
                        PKCS11Object pKCS11Object = null;
                        object2 = new Vector<PKCS11Object>();
                        int n9 = 0;
                        while (n9 < n8) {
                            pKCS11Object = (PKCS11Object)object3.nextElement();
                            objectArray = (byte[])this.getValue(pKCS11Object, 258);
                            if (objectArray != null && this.bytesEquals((byte[])object5, (byte[])objectArray)) {
                                ((Vector)object2).add(pKCS11Object);
                                ++n7;
                            }
                            ++n9;
                        }
                        if (((Vector)object2).size() <= 0) continue;
                        objectArray = new CertObject[n7];
                        Hashtable hashtable2 = new Hashtable();
                        int n10 = ((Vector)object2).size();
                        Enumeration enumeration = ((Vector)object2).elements();
                        PKCS11Object pKCS11Object2 = null;
                        CertObject certObject = null;
                        int n11 = 0;
                        while (n11 < n7) {
                            certObject = new CertObject();
                            pKCS11Object2 = (PKCS11Object)enumeration.nextElement();
                            vector2.remove(pKCS11Object2);
                            object11 = (byte[])this.getValue(pKCS11Object2, 17);
                            object10 = new ByteArrayInputStream((byte[])object11);
                            certObject.cert = (X509Certificate)certificateFactory.generateCertificate((InputStream)object10);
                            certObject.certObject = pKCS11Object2;
                            objectArray[n11] = certObject;
                            ++n11;
                        }
                        if (n7 != 1) {
                            int n12 = -1;
                            object10 = new Hashtable();
                            privateKeyEntry = null;
                            x500Name = null;
                            object9 = null;
                            n6 = 0;
                            while (n6 < objectArray.length) {
                                privateKeyEntry = (X500Name)objectArray[n6].cert.getSubjectDN();
                                if (privateKeyEntry.equals(x500Name = (X500Name)objectArray[n6].cert.getIssuerDN())) {
                                    n12 = n6;
                                    object9 = privateKeyEntry;
                                }
                                if (((Hashtable)object10).get(privateKeyEntry.toString().toLowerCase()) != null) {
                                    ((Hashtable)object10).remove(privateKeyEntry.toString());
                                } else {
                                    ((Hashtable)object10).put(privateKeyEntry.toString().toLowerCase(), new Integer(n6));
                                }
                                if (((Hashtable)object10).get(x500Name.toString()) != null) {
                                    ((Hashtable)object10).remove(x500Name.toString());
                                } else {
                                    ((Hashtable)object10).put(x500Name.toString().toLowerCase(), new Integer(n6));
                                }
                                ++n6;
                            }
                            ((Hashtable)object10).remove(object9.toString().toLowerCase());
                            Object k = ((Hashtable)object10).keys().nextElement();
                            object8 = ((Hashtable)object10).get((String)k);
                            n12 = (Integer)((Hashtable)object10).get((String)((Hashtable)object10).keys().nextElement());
                            ((Hashtable)object10).clear();
                            CertObject certObject2 = objectArray[0];
                            objectArray[0] = objectArray[n12];
                            objectArray[n12] = certObject2;
                            int n13 = 0;
                            while (n13 < objectArray.length) {
                                x500Name = (X500Name)objectArray[n13].cert.getIssuerDN();
                                boolean bl = false;
                                int n14 = 1;
                                while (!bl && n14 < n13) {
                                    if (x500Name.equals((Object)objectArray[n14].cert.getSubjectDN())) {
                                        bl = true;
                                        certObject2 = objectArray[n14];
                                        objectArray[n14] = objectArray[n13];
                                        objectArray[n13] = objectArray[n14];
                                        continue;
                                    }
                                    ++n14;
                                }
                                ++n13;
                            }
                        }
                        object11 = (Integer)this.getValue((PKCS11Object)object6, 256);
                        object10 = null;
                        if (((Integer)object11).equals(PKCS11Object.RSA)) {
                            try {
                                object10 = new RSAPKCS11PrivateKey(this.slotIndex, (PKCS11Object)object6, this.openSessions[n2], this.openSessions, (String)this.getValue((PKCS11Object)object6, 3), (byte[])this.getValue((PKCS11Object)object6, 258), (byte[])this.getValue((PKCS11Object)object6, 257), (Boolean)this.getValue((PKCS11Object)object6, 261), (Boolean)this.getValue((PKCS11Object)object6, 264), (BigInteger)this.getValue((PKCS11Object)object6, 288), (BigInteger)this.getValue((PKCS11Object)object6, 290), (BigInteger)this.getValue((PKCS11Object)object6, 291), (BigInteger)this.getValue((PKCS11Object)object6, 292), (BigInteger)this.getValue((PKCS11Object)object6, 293), (BigInteger)this.getValue((PKCS11Object)object6, 294), (BigInteger)this.getValue((PKCS11Object)object6, 295), (BigInteger)this.getValue((PKCS11Object)object6, 296));
                            }
                            catch (Exception exception) {
                                try {
                                    object10 = new RSAPKCS11PrivateKey(this.slotIndex, (PKCS11Object)object6, this.openSessions[n2], this.openSessions, (String)this.getValue((PKCS11Object)object6, 3), (byte[])this.getValue((PKCS11Object)object6, 258), (byte[])this.getValue((PKCS11Object)object6, 257), (Boolean)this.getValue((PKCS11Object)object6, 261), (Boolean)this.getValue((PKCS11Object)object6, 264));
                                }
                                catch (InvalidKeyException invalidKeyException) {}
                            }
                        } else {
                            if (!((Integer)object11).equals(PKCS11Object.DSA)) continue;
                            try {
                                object10 = new DSAPKCS11PrivateKey(this.slotIndex, (PKCS11Object)object6, this.openSessions[n2], this.openSessions, (String)this.getValue((PKCS11Object)object6, 3), (byte[])this.getValue((PKCS11Object)object6, 258), (byte[])this.getValue((PKCS11Object)object6, 257), (Boolean)this.getValue((PKCS11Object)object6, 261), (Boolean)this.getValue((PKCS11Object)object6, 264), (BigInteger)this.getValue((PKCS11Object)object6, 304), (BigInteger)this.getValue((PKCS11Object)object6, 305), (BigInteger)this.getValue((PKCS11Object)object6, 306), new BigInteger(1, (byte[])this.getValue((PKCS11Object)object6, 17)));
                            }
                            catch (Exception exception) {
                                try {
                                    object10 = new DSAPKCS11PrivateKey(this.slotIndex, (PKCS11Object)object6, this.openSessions[n2], this.openSessions, (String)this.getValue((PKCS11Object)object6, 3), (byte[])this.getValue((PKCS11Object)object6, 258), (byte[])this.getValue((PKCS11Object)object6, 257), (Boolean)this.getValue((PKCS11Object)object6, 261), (Boolean)this.getValue((PKCS11Object)object6, 264));
                                }
                                catch (InvalidKeyException invalidKeyException) {}
                            }
                        }
                        privateKeyEntry = new PrivateKeyEntry();
                        privateKeyEntry.key = object10;
                        x500Name = new Certificate[objectArray.length];
                        object9 = new PKCS11Object[objectArray.length];
                        n6 = 0;
                        while (n6 < objectArray.length) {
                            x500Name[n6] = objectArray[n6].cert;
                            object9[n6] = objectArray[n6].certObject;
                            ++n6;
                        }
                        privateKeyEntry.chain = x500Name;
                        privateKeyEntry.certObjects = object9;
                        if (string5 != null) {
                            if (this.entries.get(string5) == null) {
                                this.entries.put(string5.toLowerCase(), privateKeyEntry);
                                continue;
                            }
                            boolean bl = false;
                            while (!bl) {
                                object8 = String.valueOf(string5) + n5;
                                if (this.entries.get(object8) == null) {
                                    this.entries.put(((String)object8).toLowerCase(), privateKeyEntry);
                                    bl = true;
                                    continue;
                                }
                                ++n5;
                            }
                            continue;
                        }
                        boolean bl = false;
                        while (!bl) {
                            object8 = String.valueOf(string4) + n4;
                            if (!this.entries.containsKey(object8)) {
                                this.entries.put(((String)object8).toLowerCase(), privateKeyEntry);
                                bl = true;
                                continue;
                            }
                            ++n4;
                        }
                    }
                }
                vector.removeAllElements();
                object7 = "cert";
                n4 = 0;
                if (vector2.size() > 0) {
                    n3 = vector2.size();
                    object6 = vector2.elements();
                    int n15 = 0;
                    while (n15 < n3) {
                        block94: {
                            object5 = null;
                            try {
                                object5 = (PKCS11Object)object6.nextElement();
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                n15 = n3;
                                break block94;
                            }
                            string3 = (String)this.getValue((PKCS11Object)object5, 3);
                            byte[] byArray = (byte[])this.getValue((PKCS11Object)object5, 258);
                            object4 = null;
                            try {
                                object4 = (byte[])this.getValue((PKCS11Object)object5, 17);
                            }
                            catch (Exception exception) {}
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object4);
                            object3 = new TrustedCertEntry();
                            ((TrustedCertEntry)object3).cert = certificateFactory.generateCertificate(byteArrayInputStream);
                            ((TrustedCertEntry)object3).certObject = (PKCS11Object)object5;
                            if (string3 != null) {
                                this.entries.put(string3.toLowerCase(), object3);
                            } else {
                                boolean bl = false;
                                while (!bl) {
                                    object2 = String.valueOf(object7) + n4;
                                    if (!this.entries.containsKey(object2)) {
                                        this.entries.put(((String)object2).toLowerCase(), object3);
                                        bl = true;
                                        continue;
                                    }
                                    ++n4;
                                }
                            }
                        }
                        ++n15;
                    }
                    vector2.removeAllElements();
                }
                n3 = 0;
                while (n3 < this.openSessions.length) {
                    try {
                        this.openSessions[n3].findObjectsFinal();
                    }
                    catch (Exception exception) {}
                    ++n3;
                }
                ++n2;
            }
        }
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object;
            Object v = this.entries.get(string.toLowerCase());
            if (v != null && v instanceof PrivateKeyEntry) {
                throw new KeyStoreException("Cannot overwrite own certificate");
            }
            PKCS11Object pKCS11Object = null;
            if (certificate instanceof X509Certificate) {
                Object object2;
                object = null;
                byte[] byArray = null;
                try {
                    byArray = string.getBytes("8859_1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = string.getBytes();
                }
                byte[] byArray2 = null;
                BigInteger bigInteger = null;
                DerOutputStream derOutputStream = null;
                if (byArray.length > 20) {
                    object2 = new byte[20];
                    System.arraycopy(byArray, 0, object2, 0, 20);
                    byArray = object2;
                }
                try {
                    object2 = CertificateFactory.getInstance("X509", "IBMPKCS11");
                    if (certificate instanceof X509CertImpl) {
                        X509CertImpl x509CertImpl = (X509CertImpl)certificate;
                        derOutputStream = new DerOutputStream();
                        ((X500Name)x509CertImpl.getSubjectDN()).encode(derOutputStream);
                        object = derOutputStream.toByteArray();
                        derOutputStream = new DerOutputStream();
                        ((X500Name)x509CertImpl.getIssuerDN()).encode(derOutputStream);
                        byArray2 = derOutputStream.toByteArray();
                        bigInteger = x509CertImpl.getSerialNumber();
                        pKCS11Object = this.createCertObject(null, string, x509CertImpl.getEncoded(), (byte[])object, byArray, byArray2, bigInteger);
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certificate.getEncoded());
                    X509CertImpl x509CertImpl = (X509CertImpl)((CertificateFactory)object2).generateCertificate(byteArrayInputStream);
                    derOutputStream = new DerOutputStream();
                    ((X500Name)x509CertImpl.getSubjectDN()).encode(derOutputStream);
                    object = derOutputStream.toByteArray();
                    derOutputStream = new DerOutputStream();
                    ((X500Name)x509CertImpl.getIssuerDN()).encode(derOutputStream);
                    bigInteger = x509CertImpl.getSerialNumber();
                    pKCS11Object = this.createCertObject(null, string, x509CertImpl.getEncoded(), (byte[])object, byArray, byArray2, bigInteger);
                }
                catch (Exception exception) {
                    throw new KeyStoreException("Cannot store certificat :" + exception.getMessage());
                }
            } else {
                throw new KeyStoreException("Unsupported certificate type. Only X509 certificate is supported");
            }
            object = new TrustedCertEntry();
            object.cert = certificate;
            object.certObject = pKCS11Object;
            this.entries.put(string.toLowerCase(), object);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void engineSetKeyEntry(String var1_1, Key var2_2, char[] var3_3, Certificate[] var4_4) throws KeyStoreException {
        var5_5 = this.entries;
        synchronized (var5_5) {
            block31: {
                block32: {
                    if (this.engineIsKeyEntry(var1_1)) {
                        var7_6 = (PrivateKeyEntry)this.entries.get(var1_1.toLowerCase());
                        var8_7 /* !! */  = var7_6.certObjects;
                        var9_9 = 0;
                        while (var9_9 < var8_7 /* !! */ .length) {
                            if (var8_7 /* !! */ [var9_9] != null) {
                                var8_7 /* !! */ [var9_9].destroy();
                            }
                            ++var9_9;
                        }
                        if (var2_2 instanceof PKCS11PrivateKey) {
                            var10_11 = (PKCS11PrivateKey)var7_6.key;
                            if (((PKCS11PrivateKey)var2_2).getObject() != var10_11.getObject() && var10_11.getObject() != null) {
                                var10_11.getObject().destroy();
                            }
                        }
                    } else if (this.engineIsCertificateEntry(var1_1)) {
                        var7_6 = (TrustedCertEntry)this.entries.get(var1_1.toLowerCase());
                        var7_6.certObject.destroy();
                    }
                    var7_6 = null;
                    try {
                        var7_6 = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11");
                    }
                    catch (Exception var8_8) {
                        throw new KeyStoreException(var8_8.toString());
                    }
                    var8_7 /* !! */  = (PKCS11Object[])new byte[20];
                    var7_6.nextBytes((byte[])var8_7 /* !! */ );
                    var9_10 = new PrivateKeyEntry();
                    var10_11 = null;
                    if (var2_2 instanceof PKCS11PrivateKey) {
                        var10_11 = this.createPrivateKeyObject(var1_1, var2_2, var3_3);
                    } else if (var2_2 instanceof RSAPrivateCrtKey) {
                        var11_12 = (RSAPrivateCrtKey)var2_2;
                        v0 = new int[18];
                        v0[1] = 1;
                        v0[2] = 2;
                        v0[3] = 3;
                        v0[4] = 256;
                        v0[5] = 258;
                        v0[6] = 264;
                        v0[7] = 265;
                        v0[8] = 288;
                        v0[9] = 291;
                        v0[10] = 261;
                        v0[11] = 268;
                        v0[12] = 296;
                        v0[13] = 290;
                        v0[14] = 292;
                        v0[15] = 293;
                        v0[16] = 294;
                        v0[17] = 295;
                        var12_13 = v0;
                        var13_15 = new Object[]{PKCS11Object.PRIVATE_KEY, Boolean.TRUE, Boolean.TRUE, var1_1, PKCS11Object.RSA, var8_7 /* !! */ , Boolean.TRUE, Boolean.TRUE, var11_12.getModulus(), var11_12.getPrivateExponent(), Boolean.TRUE, Boolean.FALSE, var11_12.getCrtCoefficient(), var11_12.getPublicExponent(), var11_12.getPrimeP(), var11_12.getPrimeQ(), var11_12.getPrimeExponentP(), var11_12.getPrimeExponentQ()};
                        var10_11 = this.createPrivateKeyObject(var1_1, (int[])var12_13, var13_15, (byte[])var8_7 /* !! */ , true);
                    } else if (var2_2 instanceof RSAPrivateKey) {
                        var11_12 = (RSAPrivateCrtKey)var2_2;
                        v1 = new int[13];
                        v1[1] = 1;
                        v1[2] = 2;
                        v1[3] = 3;
                        v1[4] = 256;
                        v1[5] = 258;
                        v1[6] = 264;
                        v1[7] = 265;
                        v1[8] = 261;
                        v1[9] = 268;
                        v1[10] = 259;
                        v1[11] = 288;
                        v1[12] = 291;
                        var12_13 = v1;
                        var13_15 = new Object[]{PKCS11Object.PRIVATE_KEY, Boolean.TRUE, Boolean.TRUE, var1_1, PKCS11Object.RSA, var8_7 /* !! */ , Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, var11_12.getModulus(), var11_12.getPrivateExponent()};
                        var10_11 = this.createPrivateKeyObject(var1_1, (int[])var12_13, var13_15, (byte[])var8_7 /* !! */ , true);
                    } else if (var2_2 instanceof DSAPrivateKey) {
                        var11_12 = (DSAPrivateKey)var2_2;
                        v2 = new int[12];
                        v2[0] = 17;
                        v2[2] = 1;
                        v2[3] = 2;
                        v2[4] = 3;
                        v2[5] = 256;
                        v2[6] = 258;
                        v2[7] = 264;
                        v2[8] = 259;
                        v2[9] = 304;
                        v2[10] = 305;
                        v2[11] = 306;
                        var12_13 = v2;
                        var13_15 = new Object[]{var11_12.getX().toByteArray(), PKCS11Object.PRIVATE_KEY, Boolean.TRUE, Boolean.TRUE, var1_1, PKCS11Object.DSA, var8_7 /* !! */ , Boolean.TRUE, Boolean.FALSE, var11_12.getParams().getP(), var11_12.getParams().getQ(), var11_12.getParams().getG()};
                        var10_11 = this.createPrivateKeyObject(var1_1, (int[])var12_13, var13_15, (byte[])var8_7 /* !! */ , false);
                    } else {
                        throw new KeyStoreException("Invalid key type");
                    }
                    var11_12 = null;
                    try {
                        var12_13 = CertificateFactory.getInstance("X509", "IBMPKCS11");
                        var11_12 = new PKCS11Object[var4_4.length];
                        var13_16 = 0;
                        while (var13_16 < var4_4.length) {
                            if (var4_4[var13_16] instanceof X509Certificate) {
                                var14_18 = null;
                                var15_19 = null;
                                var16_20 = null;
                                var17_21 = null;
                                var18_22 = null;
                                if (var4_4[var13_16] instanceof X509CertImpl) {
                                    var19_23 /* !! */  = (X509CertImpl)var4_4[var13_16];
                                    var18_22 = new DerOutputStream();
                                    ((X500Name)var19_23 /* !! */ .getSubjectDN()).encode(var18_22);
                                    var14_18 = var18_22.toByteArray();
                                    var18_22 = new DerOutputStream();
                                    ((X500Name)var19_23 /* !! */ .getIssuerDN()).encode(var18_22);
                                    var16_20 = var18_22.toByteArray();
                                    var17_21 = var19_23 /* !! */ .getSerialNumber();
                                    var11_12[var13_16] = this.createCertObject(var10_11.getSession(), var1_1, var19_23 /* !! */ .getEncoded(), var14_18, var10_11.getID(), var16_20, var17_21);
                                } else {
                                    var19_23 /* !! */  = new ByteArrayInputStream(var4_4[var13_16].getEncoded());
                                    var20_24 = (X509CertImpl)var12_13.generateCertificate((InputStream)var19_23 /* !! */ );
                                    var18_22 = new DerOutputStream();
                                    ((X500Name)var20_24.getSubjectDN()).encode(var18_22);
                                    var14_18 = var18_22.toByteArray();
                                    var18_22 = new DerOutputStream();
                                    ((X500Name)var20_24.getIssuerDN()).encode(var18_22);
                                    var17_21 = var20_24.getSerialNumber();
                                    var11_12[var13_16] = this.createCertObject(var10_11.getSession(), var1_1, var20_24.getEncoded(), var14_18, var10_11.getID(), var16_20, var17_21);
                                }
                            } else {
                                throw new KeyStoreException("Unsupported certificate type. Only X509 certificate is supported");
                            }
                            ++var13_16;
                        }
                        break block31;
                    }
                    catch (Exception var12_14) {
                        if (var10_11 != null && var10_11.getObject() != null) {
                            var10_11.getObject().destroy();
                        }
                        if (var11_12 == null) break block32;
                        var13_17 = 0;
                        ** while (var13_17 < var11_12.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (var11_12[var13_17] != null) {
                            var11_12[var13_17].destroy();
                        }
                        ++var13_17;
                        continue;
                    }
                }
                throw new KeyStoreException(var12_14.toString());
            }
            var9_10.key = var10_11;
            if (var4_4 != null) {
                var9_10.chain = (Certificate[])var4_4.clone();
                var9_10.certObjects = var11_12;
            }
            this.entries.put(var1_1.toLowerCase(), var9_10);
        }
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("This method is not supported for PKCS#11");
    }

    public int engineSize() {
        return this.entries.size();
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        int n = 0;
        while (n < this.openSessions.length) {
            this.openSessions[n].close();
            this.tokenSlots[n].closeAllSessions();
            ++n;
        }
        if (this.pkcs11 != null) {
            this.pkcs11.libFinalize();
            this.libInitialized = false;
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
        }
    }

    protected void finalize() {
    }

    private Object[] getAttributes(PKCS11Object pKCS11Object) {
        return null;
    }

    private MessageDigest getPreKeyedHash(char[] cArray) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA", "IBMPKCS11");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            byArray[n2++] = (byte)(cArray[n] >> 8);
            byArray[n2++] = (byte)cArray[n];
            ++n;
        }
        messageDigest.update(byArray);
        n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
        messageDigest.update("Mighty Aphrodite".getBytes("UTF8"));
        return messageDigest;
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        Object object = null;
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            return null;
        }
        return object;
    }

    class PrivateKeyEntry {
        Key key;
        byte[] protectedKey;
        Certificate[] chain;
        PKCS11Object[] certObjects;

        PrivateKeyEntry() {
        }
    }

    class TrustedCertEntry {
        int slotNumber;
        Certificate cert;
        PKCS11Object certObject;

        TrustedCertEntry() {
        }
    }

    class CertObject {
        PKCS11Object certObject;
        X509Certificate cert;
        boolean flag;

        CertObject() {
        }
    }
}

