/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util.entity;

import com.ibm.xml.b2b.util.SymbolTable;
import com.ibm.xml.b2b.util.URI;
import com.ibm.xml.b2b.util.entity.DTDEntityEventHandler;
import com.ibm.xml.b2b.util.entity.EntityDeclPool;
import com.ibm.xml.b2b.util.entity.EntityEventHandler;
import com.ibm.xml.b2b.util.entity.EntityInputSource;
import com.ibm.xml.b2b.util.entity.ParsedEntity;
import com.ibm.xml.b2b.util.entity.ParsedEntityFactory;
import java.io.File;

public final class EntityManager {
    private boolean fStandalone;
    private int fEntityDepth;
    private int[] fEntityStack;
    private EntityEventHandler fHandler;
    private DTDEntityEventHandler fDTDHandler;
    private SymbolTable fSymbolTable;
    private ParsedEntityFactory fEntityFactory;
    private EntityDeclPool fDefaultEntityDeclPool;
    private EntityDeclPool fEntityDeclPool;
    private boolean fScanExternalGeneralEntities = true;
    private boolean fScanExternalParameterEntities = true;
    private boolean fInExternalEntity;
    private int fActiveReferences;
    private int[] fActiveReferencesStack;
    private int fActivePEReferences;
    private int[] fActivePEReferencesStack;
    private int[] fEntityHandleStack;
    private boolean[] fEntityExternalStack;
    private int fEntityStackDepth;
    private int fEntityCount;
    private int fFreeEntities;
    private ParsedEntity[] fParsedEntity;
    private String[] fBaseURIString;
    private int[] fBaseURI;

    public EntityManager(EntityEventHandler entityEventHandler, SymbolTable symbolTable, ParsedEntityFactory parsedEntityFactory) {
        this.fHandler = entityEventHandler;
        this.fSymbolTable = symbolTable;
        this.fEntityFactory = parsedEntityFactory;
        this.fEntityDeclPool = this.fDefaultEntityDeclPool = new EntityDeclPool(symbolTable);
        this.fEntityStack = new int[16];
        this.fActiveReferencesStack = new int[16];
        this.fActivePEReferencesStack = new int[16];
        this.fEntityHandleStack = new int[16];
        this.fEntityExternalStack = new boolean[16];
        this.fParsedEntity = new ParsedEntity[16];
        this.fBaseURIString = new String[16];
        this.fBaseURI = new int[16];
    }

    public void setDTDEntityEventHandler(DTDEntityEventHandler dTDEntityEventHandler) {
        this.fDTDHandler = dTDEntityEventHandler;
    }

    public void setEntityDeclPool(EntityDeclPool entityDeclPool) {
        this.fEntityDeclPool = entityDeclPool == null ? this.fDefaultEntityDeclPool : entityDeclPool;
    }

    public void reset(boolean bl) {
        int n = 0;
        while (n < this.fEntityCount) {
            if (this.fParsedEntity[n] != null) {
                this.fParsedEntity[n].release();
                this.fParsedEntity[n] = null;
            }
            ++n;
        }
        this.fStandalone = false;
        this.fEntityCount = 0;
        this.fFreeEntities = 0;
        this.fEntityDepth = 0;
        this.fInExternalEntity = false;
        this.fActiveReferences = 0;
        this.fActivePEReferences = 0;
        this.fEntityStackDepth = 0;
    }

    public void setScanExternalGeneralEntities(boolean bl) {
        this.fScanExternalGeneralEntities = bl;
    }

    public boolean getScanExternalGeneralEntities() {
        return this.fScanExternalGeneralEntities;
    }

    public void setScanExternalParameterEntities(boolean bl) {
        this.fScanExternalParameterEntities = bl;
    }

    public boolean getScanExternalParameterEntities() {
        return this.fScanExternalParameterEntities;
    }

    public void setStandalone() {
        this.fStandalone = true;
    }

    public boolean isStandalone() {
        return this.fStandalone;
    }

    public int currentBaseURI() {
        if (this.fEntityDepth > 0) {
            int n = this.fEntityStack[this.fEntityDepth - 1];
            int n2 = this.fBaseURI[n];
            if (n2 == -1) {
                String string = this.fBaseURIString[n];
                n2 = this.fBaseURI[n] = this.fSymbolTable.addSymbol(string);
            }
            return n2;
        }
        return -1;
    }

    public String getSystemID() {
        return this.fSymbolTable.toString(this.currentBaseURI());
    }

    public boolean inExternalEntity() {
        return this.fInExternalEntity;
    }

    public boolean scanDocumentEntity(EntityInputSource entityInputSource) {
        int n = this.allocateDocumentEntity(entityInputSource);
        if (n == -1) {
            return false;
        }
        ParsedEntity parsedEntity = this.getParsedEntity(n);
        boolean bl = this.fHandler.scanDocument(parsedEntity);
        this.releaseEntity(n);
        return bl;
    }

    public boolean entityReferenceInContent(int n) {
        String string;
        String string2;
        if (this.isRecursiveReference(n)) {
            return this.fHandler.recursiveReferenceInContent(n, this.entityReferencePath(n));
        }
        int n2 = this.fEntityDeclPool.lookupEntity(n);
        if (n2 == -1) {
            return this.fHandler.undeclaredEntityInContent(this.fSymbolTable.toString(n));
        }
        int[] nArray = this.fEntityDeclPool.getDeclArray(n2);
        int n3 = this.fEntityDeclPool.getDeclBase(n2);
        int n4 = nArray[n3 + 0];
        int n5 = n4 & 0xFFFF;
        if (this.fStandalone && (n4 & 0x10000) != 0 && !this.fHandler.externallyDeclaredEntityInContent(this.fSymbolTable.toString(n))) {
            return false;
        }
        if (n5 == 0) {
            int n6 = nArray[n3 + 2];
            this.fHandler.character(n, n6, true);
            return true;
        }
        if (n5 == 1) {
            int n7 = this.allocateInternalEntity(nArray, n3);
            if (n7 == -1) {
                return false;
            }
            ParsedEntity parsedEntity = this.getParsedEntity(n7);
            this.pushEntityReference(n);
            if (!this.fHandler.scanContent(n, parsedEntity)) {
                return false;
            }
            this.popEntityReference();
            this.releaseEntity(n7);
            return true;
        }
        if (n5 == 5) {
            return this.fHandler.unparsedEntityInContent(n);
        }
        if (!this.fScanExternalGeneralEntities) {
            return this.fHandler.skippedEntityInContent(n);
        }
        int n8 = nArray[n3 + 3];
        int n9 = nArray[n3 + 4];
        int n10 = nArray[n3 + 2];
        boolean bl = this.fInExternalEntity;
        String string3 = this.fSymbolTable.toString(n8);
        EntityInputSource entityInputSource = new EntityInputSource(string3, string2 = this.fSymbolTable.toString(n9));
        int n11 = this.allocateExternalEntity(entityInputSource, string = this.fSymbolTable.toString(n10));
        if (n11 == -1) {
            return false;
        }
        ParsedEntity parsedEntity = this.getParsedEntity(n11);
        this.fInExternalEntity = true;
        this.pushEntityReference(n);
        if (!this.fHandler.scanContent(n, parsedEntity)) {
            return false;
        }
        this.popEntityReference();
        this.fInExternalEntity = bl;
        this.releaseEntity(n11);
        return true;
    }

    public boolean entityReferenceInAttValue(int n) {
        if (this.isRecursiveReference(n)) {
            return this.fHandler.recursiveReferenceInAttValue(n, this.entityReferencePath(n));
        }
        int n2 = this.fEntityDeclPool.lookupEntity(n);
        if (n2 == -1) {
            return this.fHandler.undeclaredEntityInAttValue(this.fSymbolTable.toString(n));
        }
        int[] nArray = this.fEntityDeclPool.getDeclArray(n2);
        int n3 = this.fEntityDeclPool.getDeclBase(n2);
        int n4 = nArray[n3 + 0];
        int n5 = n4 & 0xFFFF;
        if (this.fStandalone && (n4 & 0x10000) != 0 && !this.fHandler.externallyDeclaredEntityInAttValue(this.fSymbolTable.toString(n))) {
            return false;
        }
        if (n5 == 0) {
            int n6 = nArray[n3 + 2];
            this.fHandler.attributeValueCharacter(n, n6, true);
            return true;
        }
        if (n5 == 1) {
            int n7 = this.allocateInternalEntity(nArray, n3);
            if (n7 == -1) {
                return false;
            }
            ParsedEntity parsedEntity = this.getParsedEntity(n7);
            this.pushEntityReference(n);
            this.fHandler.scanAttValue(n, parsedEntity);
            this.popEntityReference();
            this.releaseEntity(n7);
            return true;
        }
        return this.fHandler.externalEntityInAttValue(n);
    }

    public boolean entityReferenceInDefaultAttValue(int n) {
        if (this.isRecursiveReference(n)) {
            return this.fHandler.recursiveReferenceInDefaultAttValue(n, this.entityReferencePath(n));
        }
        int n2 = this.fEntityDeclPool.lookupEntity(n);
        if (n2 == -1) {
            return this.fHandler.undeclaredEntityInDefaultAttValue(n);
        }
        int[] nArray = this.fEntityDeclPool.getDeclArray(n2);
        int n3 = this.fEntityDeclPool.getDeclBase(n2);
        int n4 = nArray[n3 + 0];
        int n5 = n4 & 0xFFFF;
        if (this.fStandalone && (n4 & 0x10000) != 0 && !this.fHandler.externallyDeclaredEntityInDefaultAttValue(this.fSymbolTable.toString(n))) {
            return false;
        }
        if (n5 == 0) {
            int n6 = nArray[n3 + 2];
            this.fDTDHandler.defaultAttValueCharacter(n, n6, true);
            return true;
        }
        if (n5 == 1) {
            int n7 = this.allocateInternalEntity(nArray, n3);
            if (n7 == -1) {
                return false;
            }
            ParsedEntity parsedEntity = this.getParsedEntity(n7);
            this.pushEntityReference(n);
            this.fDTDHandler.scanDefaultAttValue(n, parsedEntity);
            this.popEntityReference();
            this.releaseEntity(n7);
            return true;
        }
        return this.fHandler.externalEntityInDefaultAttValue(n);
    }

    public boolean peReference(int n) {
        String string;
        String string2;
        int n2;
        if (this.isRecursivePEReference(n)) {
            return this.fHandler.recursivePEReference(n, this.peReferencePath(n));
        }
        int n3 = this.fEntityDeclPool.lookupPE(n);
        if (n3 == -1) {
            return this.fHandler.undeclaredParameterEntity(n);
        }
        int[] nArray = this.fEntityDeclPool.getDeclArray(n3);
        int n4 = nArray[(n2 = this.fEntityDeclPool.getDeclBase(n3)) + 0] & 0xFFFF;
        if (n4 == 3) {
            int n5 = this.allocateInternalEntity(nArray, n2);
            if (n5 == -1) {
                return false;
            }
            ParsedEntity parsedEntity = this.getParsedEntity(n5);
            this.pushPEReference(n);
            if (this.fInExternalEntity) {
                this.fDTDHandler.scanExtSubsetDecl(n, parsedEntity);
            } else {
                this.fDTDHandler.scanIntSubsetDecl(n, parsedEntity);
            }
            this.popPEReference();
            this.releaseEntity(n5);
            return true;
        }
        if (!this.fScanExternalParameterEntities) {
            this.fHandler.skippedParameterEntity(n);
            return true;
        }
        int n6 = nArray[n2 + 3];
        int n7 = nArray[n2 + 4];
        int n8 = nArray[n2 + 2];
        boolean bl = this.fInExternalEntity;
        String string3 = this.fSymbolTable.toString(n6);
        EntityInputSource entityInputSource = new EntityInputSource(string3, string2 = this.fSymbolTable.toString(n7));
        int n9 = this.allocateExternalEntity(entityInputSource, string = this.fSymbolTable.toString(n8));
        if (n9 == -1) {
            return false;
        }
        ParsedEntity parsedEntity = this.getParsedEntity(n9);
        this.fInExternalEntity = true;
        this.pushPEReference(n);
        this.fDTDHandler.scanExtSubsetDecl(n, parsedEntity);
        this.popPEReference();
        this.fInExternalEntity = bl;
        this.releaseEntity(n9);
        return true;
    }

    public boolean scanExternalSubset(String string, String string2) {
        if (!this.fScanExternalParameterEntities) {
            this.fHandler.skippedExternalSubsetEntity();
            return true;
        }
        EntityInputSource entityInputSource = new EntityInputSource(string, string2);
        String string3 = this.fEntityDepth > 0 ? this.fBaseURIString[this.fEntityStack[this.fEntityDepth - 1]] : null;
        int n = this.allocateExternalEntity(entityInputSource, string3);
        if (n == -1) {
            return false;
        }
        ParsedEntity parsedEntity = this.getParsedEntity(n);
        this.fInExternalEntity = true;
        if (!this.fDTDHandler.scanExternalSubset(parsedEntity)) {
            return false;
        }
        this.fInExternalEntity = false;
        this.releaseEntity(n);
        return true;
    }

    public boolean peReferenceInEntityValue(int n) {
        String string;
        String string2;
        int n2;
        if (this.isRecursivePEReference(n)) {
            return this.fHandler.recursivePEReference(n, this.peReferencePath(n));
        }
        int n3 = this.fEntityDeclPool.lookupPE(n);
        if (n3 == -1) {
            return this.fHandler.undeclaredParameterEntity(n);
        }
        int[] nArray = this.fEntityDeclPool.getDeclArray(n3);
        int n4 = nArray[(n2 = this.fEntityDeclPool.getDeclBase(n3)) + 0] & 0xFFFF;
        if (n4 == 3) {
            int n5 = this.allocateInternalEntity(nArray, n2);
            if (n5 == -1) {
                return false;
            }
            ParsedEntity parsedEntity = this.getParsedEntity(n5);
            this.pushPEReference(n);
            this.fDTDHandler.scanEntityValue(n, parsedEntity);
            this.popPEReference();
            this.releaseEntity(n5);
            return true;
        }
        if (!this.fScanExternalParameterEntities) {
            this.fHandler.skippedParameterEntity(n);
            return true;
        }
        int n6 = nArray[n2 + 3];
        int n7 = nArray[n2 + 4];
        int n8 = nArray[n2 + 2];
        String string3 = this.fSymbolTable.toString(n6);
        EntityInputSource entityInputSource = new EntityInputSource(string3, string2 = this.fSymbolTable.toString(n7));
        int n9 = this.allocateExternalEntity(entityInputSource, string = this.fSymbolTable.toString(n8));
        if (n9 == -1) {
            return false;
        }
        ParsedEntity parsedEntity = this.getParsedEntity(n9);
        this.pushPEReference(n);
        this.fDTDHandler.scanEntityValue(n, parsedEntity);
        this.popPEReference();
        this.releaseEntity(n9);
        return true;
    }

    public boolean startPEReferenceWithinMarkup(int n) {
        boolean bl;
        int n2;
        int n3;
        if (this.isRecursivePEReference(n)) {
            return this.fHandler.recursivePEReference(n, this.peReferencePath(n));
        }
        int n4 = this.fEntityDeclPool.lookupPE(n);
        if (n4 == -1) {
            return this.fHandler.undeclaredParameterEntity(n);
        }
        int[] nArray = this.fEntityDeclPool.getDeclArray(n4);
        int n5 = nArray[(n3 = this.fEntityDeclPool.getDeclBase(n4)) + 0] & 0xFFFF;
        if (n5 == 3) {
            n2 = this.allocateInternalEntity(nArray, n3);
            if (n2 == -1) {
                return false;
            }
            bl = this.fInExternalEntity;
        } else {
            String string;
            String string2;
            if (!this.fScanExternalParameterEntities) {
                this.fHandler.skippedParameterEntity(n);
                return true;
            }
            int n6 = nArray[n3 + 3];
            int n7 = nArray[n3 + 4];
            int n8 = nArray[n3 + 2];
            String string3 = this.fSymbolTable.toString(n6);
            EntityInputSource entityInputSource = new EntityInputSource(string3, string2 = this.fSymbolTable.toString(n7));
            n2 = this.allocateExternalEntity(entityInputSource, string = this.fSymbolTable.toString(n8));
            if (n2 == -1) {
                return false;
            }
            bl = true;
        }
        ParsedEntity parsedEntity = this.getParsedEntity(n2);
        if (this.fEntityStackDepth == this.fEntityHandleStack.length) {
            int[] nArray2 = new int[this.fEntityStackDepth << 1];
            boolean[] blArray = new boolean[this.fEntityStackDepth << 1];
            System.arraycopy(this.fEntityHandleStack, 0, nArray2, 0, this.fEntityStackDepth);
            System.arraycopy(this.fEntityExternalStack, 0, blArray, 0, this.fEntityStackDepth);
            this.fEntityHandleStack = nArray2;
            this.fEntityExternalStack = blArray;
        }
        this.fEntityHandleStack[this.fEntityStackDepth] = n2;
        this.fEntityExternalStack[this.fEntityStackDepth] = this.fInExternalEntity;
        ++this.fEntityStackDepth;
        this.pushPEReference(n);
        this.fInExternalEntity = bl;
        return this.fDTDHandler.scanPEWithinMarkup(n, parsedEntity);
    }

    public void endPEReferenceWithinMarkup() {
        this.popPEReference();
        --this.fEntityStackDepth;
        int n = this.fEntityHandleStack[this.fEntityStackDepth];
        this.releaseEntity(n);
        this.fInExternalEntity = this.fEntityExternalStack[this.fEntityStackDepth];
    }

    public String currentPEReferenceName() {
        return this.fSymbolTable.toString(this.fActivePEReferencesStack[this.fActivePEReferences - 1]);
    }

    private ParsedEntity getParsedEntity(int n) {
        return this.fParsedEntity[n];
    }

    private int allocateDocumentEntity(EntityInputSource entityInputSource) {
        String string = this.resolveDocumentEntity(entityInputSource);
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(entityInputSource, true);
        if (parsedEntity == null) {
            return -1;
        }
        int n = this.allocateHandle();
        this.fParsedEntity[n] = parsedEntity;
        this.fBaseURIString[n] = string;
        if (!this.fHandler.scanXMLDecl(parsedEntity)) {
            this.deallocateHandle(n);
            return -1;
        }
        this.fEntityStack[this.fEntityDepth++] = n;
        return n;
    }

    private int allocateExternalEntity(EntityInputSource entityInputSource, String string) {
        String string2 = this.resolveExternalEntity(entityInputSource, string);
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(entityInputSource, false);
        if (parsedEntity == null) {
            return -1;
        }
        int n = this.allocateHandle();
        this.fParsedEntity[n] = parsedEntity;
        this.fBaseURIString[n] = string2;
        if (!this.fHandler.scanTextDecl(parsedEntity)) {
            this.deallocateHandle(n);
            return -1;
        }
        this.fEntityStack[this.fEntityDepth++] = n;
        return n;
    }

    private int allocateInternalEntity(int[] nArray, int n) {
        int n2 = nArray[n + 2];
        int n3 = this.currentBaseURI();
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(this.fEntityDeclPool.getInternalEntityContent(n2));
        if (parsedEntity == null) {
            return -1;
        }
        int n4 = this.allocateHandle();
        this.fParsedEntity[n4] = parsedEntity;
        this.fBaseURIString[n4] = this.fSymbolTable.toString(n3);
        this.fBaseURI[n4] = n3;
        this.fEntityStack[this.fEntityDepth++] = n4;
        return n4;
    }

    private void releaseEntity(int n) {
        this.deallocateHandle(n);
        --this.fEntityDepth;
    }

    private synchronized int allocateHandle() {
        int n = -1;
        if (this.fFreeEntities > 0) {
            int n2 = 0;
            while (n2 < this.fEntityCount) {
                if (this.fBaseURI[n2] == 0) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            --this.fFreeEntities;
        } else if ((n = this.fEntityCount++) == this.fParsedEntity.length) {
            ParsedEntity[] parsedEntityArray = new ParsedEntity[n << 1];
            System.arraycopy(this.fParsedEntity, 0, parsedEntityArray, 0, n);
            this.fParsedEntity = parsedEntityArray;
            int[] nArray = new int[n << 1];
            System.arraycopy(this.fBaseURI, 0, nArray, 0, n);
            this.fBaseURI = nArray;
            String[] stringArray = new String[n << 1];
            System.arraycopy(this.fBaseURIString, 0, stringArray, 0, n);
            this.fBaseURIString = stringArray;
        }
        this.fBaseURI[n] = -1;
        return n;
    }

    private void deallocateHandle(int n) {
        this.fParsedEntity[n].release();
        this.fParsedEntity[n] = null;
        this.fBaseURI[n] = 0;
        this.fBaseURIString[n] = null;
        ++this.fFreeEntities;
    }

    private String resolveDocumentEntity(EntityInputSource entityInputSource) {
        String string = entityInputSource.getSystemId();
        if (string == null) {
            return null;
        }
        String string2 = this.expandSystemID(string, null);
        if (string2 != string) {
            entityInputSource.setSystemId(string2);
        }
        return string2;
    }

    private String resolveExternalEntity(EntityInputSource entityInputSource, String string) {
        String string2 = entityInputSource.getSystemId();
        if (string2 == null) {
            return null;
        }
        String string3 = this.expandSystemID(string2, string);
        if (string3 != string2) {
            entityInputSource.setSystemId(string3);
        }
        if (!this.fHandler.resolveExternalEntity(entityInputSource)) {
            return null;
        }
        return string3;
    }

    private String expandSystemID(String string, String string2) {
        URI uRI;
        String string3 = string;
        if (string3 == null || string3.length() == 0) {
            return string;
        }
        URI uRI2 = URI.parse(string3);
        if (uRI2 != null) {
            return string;
        }
        string3 = EntityManager.fixURI(string3);
        if (string2 == null) {
            String string4;
            try {
                string4 = EntityManager.fixURI(System.getProperty("user.dir"));
            }
            catch (SecurityException securityException) {
                string4 = "";
            }
            if (!string4.endsWith("/")) {
                string4 = string4 + "/";
            }
            uRI = URI.parse("file", "", string4);
        } else {
            uRI = URI.parse(string2);
        }
        uRI2 = URI.parse(uRI, string3);
        if (uRI2 == null) {
            return string;
        }
        string3 = uRI2.toString();
        return string3;
    }

    private static String fixURI(String string) {
        char c;
        char c2;
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2 && (c2 = string.charAt(1)) == ':' && (c = Character.toUpperCase(string.charAt(0))) >= 'A' && c <= 'Z') {
            string = "/" + string;
        }
        return string;
    }

    private void pushEntityReference(int n) {
        if (this.fActiveReferences == this.fActiveReferencesStack.length) {
            int[] nArray = new int[this.fActiveReferences << 1];
            System.arraycopy(this.fActiveReferencesStack, 0, nArray, 0, this.fActiveReferences);
            this.fActiveReferencesStack = nArray;
        }
        this.fActiveReferencesStack[this.fActiveReferences++] = n;
    }

    private void popEntityReference() {
        --this.fActiveReferences;
    }

    private boolean isRecursiveReference(int n) {
        int n2 = 0;
        while (n2 < this.fActiveReferences) {
            if (this.fActiveReferencesStack[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String entityReferencePath(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('|');
        int n2 = 0;
        while (n2 < this.fActiveReferences) {
            if (this.fActiveReferencesStack[n2] >= 0) {
                stringBuffer.append('-');
                stringBuffer.append('&');
                stringBuffer.append(this.fSymbolTable.toString(this.fActiveReferencesStack[n2]));
                stringBuffer.append(';');
            }
            ++n2;
        }
        stringBuffer.append('-');
        stringBuffer.append('&');
        stringBuffer.append(this.fSymbolTable.toString(n));
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    private void pushPEReference(int n) {
        if (this.fActivePEReferences == this.fActivePEReferencesStack.length) {
            int[] nArray = new int[this.fActivePEReferences << 1];
            System.arraycopy(this.fActivePEReferencesStack, 0, nArray, 0, this.fActivePEReferences);
            this.fActivePEReferencesStack = nArray;
        }
        this.fActivePEReferencesStack[this.fActivePEReferences++] = n;
    }

    private void popPEReference() {
        --this.fActivePEReferences;
    }

    private boolean isRecursivePEReference(int n) {
        int n2 = 0;
        while (n2 < this.fActivePEReferences) {
            if (this.fActivePEReferencesStack[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String peReferencePath(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('|');
        int n2 = 0;
        while (n2 < this.fActivePEReferences) {
            if (this.fActivePEReferencesStack[n2] >= 0) {
                stringBuffer.append('-');
                stringBuffer.append('%');
                stringBuffer.append(this.fSymbolTable.toString(this.fActivePEReferencesStack[n2]));
                stringBuffer.append(';');
            }
            ++n2;
        }
        stringBuffer.append('-');
        stringBuffer.append('%');
        stringBuffer.append(this.fSymbolTable.toString(n));
        stringBuffer.append(';');
        return stringBuffer.toString();
    }
}

