/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class JRELocator {
    public static final int DEFAULT_TIMEOUT = 15000;
    private static final String PRODUCT_ID = "productVersion=";
    private static final String PLATFORM_ID = "platformVersion=";
    static /* synthetic */ Class class$com$sun$javaws$JRELocator;

    public static ConfigProperties.JREInformation getVersion(File file) {
        return JRELocator.getVersion(file, 15000);
    }

    public static ConfigProperties.JREInformation getVersion(File file, int n) {
        String[] stringArray = JRELocator.execute(new String[]{file.getPath(), "-classpath", JRELocator.getClassPath(file), (class$com$sun$javaws$JRELocator == null ? (class$com$sun$javaws$JRELocator = JRELocator.class$("com.sun.javaws.JRELocator")) : class$com$sun$javaws$JRELocator).getName()}, n);
        ConfigProperties.JREInformation jREInformation = null;
        if (stringArray != null) {
            jREInformation = JRELocator.extractVersion(file.getPath(), stringArray[0]);
            if (jREInformation == null) {
                jREInformation = JRELocator.extractVersion(file.getPath(), stringArray[1]);
            }
            if (jREInformation != null && jREInformation.getPlatformVersionId().equals("1.2") && (stringArray = JRELocator.execute(new String[]{file.getPath(), "-fullversion"}, n)) != null && (jREInformation = JRELocator.extractVersionFor12(file.getPath(), stringArray[0])) == null) {
                jREInformation = JRELocator.extractVersionFor12(file.getPath(), stringArray[1]);
            }
        }
        if (Globals.TraceJRESearch) {
            Debug.println("\tjre search returning: " + jREInformation);
        }
        return jREInformation;
    }

    private static String[] execute(String[] stringArray, int n) {
        Process process = null;
        boolean bl = false;
        if (Globals.TraceJRESearch) {
            Debug.println("jre search executing");
            for (int i = 0; i < stringArray.length; ++i) {
                Debug.println(i + ": " + stringArray[i]);
            }
        }
        try {
            process = Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            bl = true;
        }
        int n2 = -1;
        int n3 = n / 100;
        while (!bl) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                n2 = process.exitValue();
                bl = true;
                if (!Globals.TraceJRESearch) continue;
                Debug.println("\tfinished executing " + n2);
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (--n3 != 0) continue;
                bl = true;
                if (Globals.TraceJRESearch) {
                    Debug.println("\tfailed " + n2);
                }
                process.destroy();
            }
        }
        if (bl && n2 == 0) {
            String[] stringArray2 = new String[]{JRELocator.readFromStream(process.getErrorStream()), JRELocator.readFromStream(process.getInputStream())};
            if (Globals.TraceJRESearch) {
                Debug.println("result: " + stringArray2[0]);
                Debug.println("result: " + stringArray2[1]);
            }
            return stringArray2;
        }
        return null;
    }

    private static String readFromStream(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            byte[] byArray = new byte[80];
            boolean bl = false;
            while (!bl) {
                int n = inputStream.read(byArray, 0, 80);
                if (n == -1) {
                    bl = true;
                    continue;
                }
                if (n <= 0) continue;
                stringBuffer.append(new String(byArray, 0, n));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private static ConfigProperties.JREInformation extractVersion(String string, String string2) {
        String string3 = JRELocator.extractString(PLATFORM_ID, string2);
        String string4 = JRELocator.extractString(PRODUCT_ID, string2);
        if (string3 != null && string4 != null) {
            return new ConfigProperties.JREInformation(string3, string4, null, string, 0, true, ConfigProperties.getNextAvailableUserJREIndex(), null, null);
        }
        return null;
    }

    private static String extractString(String string, String string2) {
        int n = string2.indexOf(string);
        if (n != -1) {
            int n2 = string2.indexOf(10, n);
            String string3 = n2 != -1 ? string2.substring(n + string.length(), n2) : string2.substring(n + string.length());
            if (string3.length() > 0 && string3.charAt(string3.length() - 1) == '\r') {
                string3 = string3.substring(0, string3.length() - 1);
            }
            return string3;
        }
        return null;
    }

    private static ConfigProperties.JREInformation extractVersionFor12(String string, String string2) {
        int n;
        int n2 = string2.indexOf("1.2");
        int n3 = string2.length();
        if (n2 != -1 && n2 < n3 - 1 && (n = string2.indexOf(34, n2)) != -1) {
            String string3 = string2.substring(n2, n);
            return new ConfigProperties.JREInformation("1.2", string3, null, string, 0, true, ConfigProperties.getNextAvailableUserJREIndex(), null, null);
        }
        return null;
    }

    private static String getClassPath(File file) {
        File file2 = file;
        if ((file2 = file2.getParentFile()) != null && (file2 = file2.getParentFile()) != null && (file2 = new File(file2, "lib")) != null && file2.exists() && (file2 = new File(file2, "classes.zip")) != null && file2.exists()) {
            return ConfigProperties.getJavaWSJarFilePath() + File.pathSeparator + file2.getPath();
        }
        return ConfigProperties.getJavaWSJarFilePath();
    }

    public static void main(String[] stringArray) {
        JRELocator.write(PLATFORM_ID, System.getProperty("java.specification.version"));
        JRELocator.write(PRODUCT_ID, System.getProperty("java.version"));
    }

    private static void write(String string, String string2) {
        if (string2 != null) {
            System.out.println(string + string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

