/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.javaws.exceptions.JNLPSigningException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.InstallerDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LibraryDesc;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.xml.XMLAttributeBuilder;
import com.sun.javaws.xml.XMLNode;
import com.sun.javaws.xml.XMLNodeBuilder;
import com.sun.javaws.xml.XMLable;
import java.net.URL;
import java.security.cert.Certificate;

public class LaunchDesc
implements XMLable {
    private String _specVersion;
    private String _version;
    private URL _home;
    private URL _codebase;
    private InformationDesc _information;
    private int _securiyModel;
    private ResourcesDesc _resources;
    private int _launchType;
    private ApplicationDesc _applicationDesc;
    private AppletDesc _appletDesc;
    private LibraryDesc _libraryDesc;
    private InstallerDesc _installerDesc;
    private String _internalCommand;
    private String _source;
    private boolean _propsSet = false;
    private Certificate[] _certChain;
    public static final int SANDBOX_SECURITY = 0;
    public static final int ALLPERMISSIONS_SECURITY = 1;
    public static final int J2EE_APP_CLIENT_SECURITY = 2;
    public static final int APPLICATION_DESC_TYPE = 1;
    public static final int APPLET_DESC_TYPE = 2;
    public static final int LIBRARY_DESC_TYPE = 3;
    public static final int INSTALLER_DESC_TYPE = 4;
    public static final int INTERNAL_TYPE = 5;

    public LaunchDesc(String string, URL uRL, URL uRL2, String string2, InformationDesc informationDesc, int n, ResourcesDesc resourcesDesc, int n2, ApplicationDesc applicationDesc, AppletDesc appletDesc, LibraryDesc libraryDesc, InstallerDesc installerDesc, String string3, String string4) {
        this._specVersion = string;
        this._version = string2;
        this._codebase = uRL;
        this._home = uRL2;
        this._information = informationDesc;
        this._securiyModel = n;
        this._resources = resourcesDesc;
        this._launchType = n2;
        this._applicationDesc = applicationDesc;
        this._appletDesc = appletDesc;
        this._libraryDesc = libraryDesc;
        this._installerDesc = installerDesc;
        this._internalCommand = string3;
        this._source = string4;
        this._certChain = null;
        if (this._resources != null) {
            this._resources.setParent(this);
        }
    }

    public String getSpecVersion() {
        return this._specVersion;
    }

    public synchronized URL getCodebase() {
        return this._codebase;
    }

    public synchronized URL getLocation() {
        return this._home;
    }

    public synchronized URL getCanonicalHome() {
        if (this._home == null && this._resources != null) {
            JARDesc jARDesc = this._resources.getMainJar(true);
            return jARDesc != null ? jARDesc.getLocation() : null;
        }
        return this._home;
    }

    public InformationDesc getInformation() {
        return this._information;
    }

    public int getSecurityModel() {
        return this._securiyModel;
    }

    public ResourcesDesc getResources() {
        return this._resources;
    }

    public boolean arePropsSet() {
        return this._propsSet;
    }

    public void setPropsSet(boolean bl) {
        this._propsSet = bl;
    }

    public int getLaunchType() {
        return this._launchType;
    }

    public ApplicationDesc getApplicationDescriptor() {
        return this._applicationDesc;
    }

    public AppletDesc getAppletDescriptor() {
        return this._appletDesc;
    }

    public InstallerDesc getInstallerDescriptor() {
        return this._installerDesc;
    }

    public boolean isApplication() {
        return this._launchType == 1;
    }

    public boolean isApplet() {
        return this._launchType == 2;
    }

    public boolean isLibrary() {
        return this._launchType == 3;
    }

    public boolean isInstaller() {
        return this._launchType == 4;
    }

    public boolean isApplicationDescriptor() {
        return this.isApplication() || this.isApplet();
    }

    public boolean isHttps() {
        return this._codebase.getProtocol().equals("https");
    }

    public String getSource() {
        return this._source;
    }

    public Certificate[] getCertificateChain() {
        return this._certChain;
    }

    public void setCertificateChain(Certificate[] certificateArray) {
        this._certChain = certificateArray;
    }

    public void checkSigning(LaunchDesc launchDesc) throws JNLPSigningException {
        if (!launchDesc.getSource().equals(this.getSource())) {
            throw new JNLPSigningException(this, launchDesc.getSource());
        }
    }

    public boolean isJRESpecified() {
        final boolean[] blArray = new boolean[1];
        final boolean[] blArray2 = new boolean[1];
        if (this.getResources() != null) {
            this.getResources().visit(new ResourceVisitor(){

                public void visitJARDesc(JARDesc jARDesc) {
                    blArray2[0] = true;
                }

                public void visitPropertyDesc(PropertyDesc propertyDesc) {
                }

                public void visitPackageDesc(PackageDesc packageDesc) {
                }

                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                    blArray2[0] = true;
                }

                public void visitJREDesc(JREDesc jREDesc) {
                    blArray[0] = true;
                }
            });
        }
        if (this._launchType == 1 || this._launchType == 2) {
            blArray2[0] = true;
        }
        return blArray[0] || !blArray2[0];
    }

    public XMLNode asXML() {
        XMLAttributeBuilder xMLAttributeBuilder = new XMLAttributeBuilder();
        xMLAttributeBuilder.add("spec", this._specVersion);
        xMLAttributeBuilder.add("codebase", this._codebase);
        xMLAttributeBuilder.add("version", this._version);
        xMLAttributeBuilder.add("href", this._home);
        XMLNodeBuilder xMLNodeBuilder = new XMLNodeBuilder("jnlp", xMLAttributeBuilder.getAttributeList());
        xMLNodeBuilder.add(this._information);
        if (this._securiyModel == 1) {
            xMLNodeBuilder.add(new XMLNode("security", null, new XMLNode("all-permissions", null), null));
        } else if (this._securiyModel == 2) {
            xMLNodeBuilder.add(new XMLNode("security", null, new XMLNode("j2ee-application-client-permissions", null), null));
        }
        xMLNodeBuilder.add(this._resources);
        xMLNodeBuilder.add(this._applicationDesc);
        xMLNodeBuilder.add(this._appletDesc);
        xMLNodeBuilder.add(this._libraryDesc);
        xMLNodeBuilder.add(this._installerDesc);
        return xMLNodeBuilder.getNode();
    }

    public String toString() {
        return this.asXML().toString();
    }
}

