/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.prefs;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.JRELocator;
import com.sun.javaws.Resources;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.ui.general.AbstractController;
import com.sun.javaws.ui.general.GeneralUtilities;
import com.sun.javaws.ui.general.Subcontroller;
import com.sun.javaws.ui.prefs.PluggablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class JRESearcher
extends PluggablePanel {
    private static String defaultClassPath;
    private static final int CANCEL_INDEX = 0;
    private static final int PREVIOUS_INDEX = 1;
    private static final int NEXT_INDEX = 2;
    private JButton _cancelButton;
    private JDialog dialog;
    private File directory;
    private ResourceBundle resources;
    private AbstractController controller;
    private ConfigProperties.JREInformation[] jres;
    private String description;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$javax$swing$JFileChooser;

    public ConfigProperties.JREInformation[] search(Component component, ResourceBundle resourceBundle, String string) {
        this.resources = resourceBundle;
        this.description = string;
        this.setJREs(null);
        String[] stringArray = new String[]{Resources.getString("jresearcher.cancelButton"), Resources.getString("jresearcher.previousButton"), Resources.getString("jresearcher.nextButton")};
        this.setButtons(stringArray);
        this.setTitle(Resources.getString("jresearcher.title"));
        this.getAccessibleContext().setAccessibleName(Resources.getString("jresearcher.title"));
        this.buttons[1].setMnemonic(Resources.getVKCode("jresearcher.previousButtonMnemonic"));
        this.buttons[2].setMnemonic(Resources.getVKCode("jresearcher.nextButtonMnemonic"));
        this._cancelButton = this.buttons[0];
        this.buttons[1].getAccessibleContext().setAccessibleDescription(Resources.getString("jresearcher.previousButton.desc"));
        this.buttons[0].getAccessibleContext().setAccessibleDescription(Resources.getString("jresearcher.cancelButton.desc"));
        if (this.controller == null) {
            this.createController();
            this.setButtonFocus(1);
        }
        SimpleController simpleController = new SimpleController();
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFont(UIManager.getFont("Label.font"));
        jTextArea.setFocusable(false);
        simpleController.setComponent(jTextArea);
        this.controller.setSubcontroller(0, simpleController);
        this.directory = null;
        this.setState(0);
        this.show(component);
        return this.jres;
    }

    private void createController() {
        this.controller = new AbstractController(){

            protected Subcontroller createSubcontroller(int n) {
                switch (n) {
                    case 1: {
                        return new PathController();
                    }
                }
                return new SearchController();
            }
        };
    }

    private void show(Component component) {
        Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = JRESearcher.class$("java.awt.Frame")) : class$java$awt$Frame, component);
        this.dialog = GeneralUtilities.createDialog(frame, Resources.getString("jresearcher.maintitle"), true);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)this, "Center");
        this.dialog.pack();
        Dimension dimension = this.dialog.getSize();
        dimension.width = Math.max(dimension.width, 525);
        dimension.height = Math.max(dimension.height, 435);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setBounds((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
        this.dialog.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = Resources.getVKCode("jresearcher.cancelButtonMnemonic");
                if (keyEvent.getKeyCode() == n) {
                    JRESearcher.this._cancelButton.doClick();
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JRESearcher.this.dialog.dispose();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(Resources.getVKCode("jresearcher.cancelButtonMnemonic"), 0);
        this.dialog.getRootPane().registerKeyboardAction(actionListener, keyStroke, 2);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                JRESearcher.this.setButtonFocus(2);
            }
        });
        this.dialog.show();
        this.dialog.dispose();
        this.setState(-1);
    }

    protected void cancel() {
        this.setJREs(null);
        this.dialog.setVisible(false);
    }

    protected void next() {
        int n = this.getState();
        if (++n == 3) {
            this.dialog.setVisible(false);
        } else {
            this.setState(n);
        }
    }

    protected void previous() {
        int n = this.getState();
        this.setState(--n);
    }

    protected void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.cancel();
                break;
            }
            case 1: {
                this.previous();
                break;
            }
            default: {
                this.next();
            }
        }
    }

    private void setDirectory(File file) {
        this.directory = file;
        this.setButtonEnabled(2, this.directory != null);
    }

    private File getDirectory() {
        return this.directory;
    }

    private void setJREs(ConfigProperties.JREInformation[] jREInformationArray) {
        this.jres = jREInformationArray;
    }

    private void setState(int n) {
        if (n == 0) {
            this.buttons[2].getAccessibleContext().setAccessibleName(Resources.getString("jresearcher.title") + ". " + this.description + ". " + this.buttons[2].getText());
            this.buttons[2].getAccessibleContext().setAccessibleDescription(this.description + ". " + Resources.getString("jresearcher.nextButton.desc"));
        } else {
            this.buttons[2].getAccessibleContext().setAccessibleDescription(Resources.getString("jresearcher.nextButton.desc"));
        }
        this.setButtonEnabled(0, true);
        this.setButtonEnabled(1, false);
        this.setButtonEnabled(2, true);
        this.controller.setActiveSubcontrollerIndex(n);
        if (n == 1) {
            this.setJREs(null);
        }
        if (n != -1) {
            this.setComponent(this.controller.getActiveSubcontroller().getComponent());
        }
        this.revalidate();
        this.repaint();
    }

    private int getState() {
        return this.controller.getActiveSubcontrollerIndex();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SearchController
    extends SimpleController
    implements ActionListener {
        private DefaultListModel model;
        private JList list;
        private JList finalList;
        private DefaultListModel modelFinal;
        private JButton addButton;
        private JButton remButton;
        private JLabel selectLabel;
        private JLabel searchLabel;
        private String searchPrefix;
        private JLabel titleLabel;
        private Searcher searcher;
        private Timer timer;
        private boolean active;

        private SearchController() {
        }

        public void start() {
            this.active = true;
            JRESearcher.this.setButtonEnabled(2, false);
            JRESearcher.this.setButtonEnabled(1, true);
            if (this.model != null) {
                this.model.removeAllElements();
            }
            if (this.modelFinal != null) {
                this.modelFinal.removeAllElements();
            }
            this.timer = new Timer(100, this);
            this.timer.setRepeats(true);
            this.timer.start();
            this.searcher = new Searcher();
            this.searcher.start(JRESearcher.this.getDirectory());
        }

        public void stop() {
            this.active = false;
            this.stopSearching();
        }

        private void stopSearching() {
            if (this.searcher != null) {
                this.searcher.stop();
                this.searcher = null;
                this.timer.stop();
                this.timer = null;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.searcher.isFinished()) {
                this.titleLabel.setText(Resources.getString("jresearcher.searchingTitle"));
                this.titleLabel.setLabelFor(this.list);
                this.selectLabel.setText(Resources.getString("jresearcher.selectedJREsTitle"));
                this.selectLabel.setLabelFor(this.finalList);
                File file = this.searcher.getCurrentFile();
                if (file != null) {
                    this.searchLabel.setText(this.searchPrefix + file.getPath());
                } else {
                    this.searchLabel.setText(this.searchPrefix);
                }
                this.list.requestFocus();
            } else {
                if (this.model.getSize() > 0) {
                    this.titleLabel.setText(Resources.getString("jresearcher.foundJREsTitle"));
                    if (this.modelFinal.isEmpty()) {
                        this.selectLabel.getAccessibleContext().setAccessibleName(this.selectLabel.getText() + Resources.getString("controlpanel.proxy.noProxy"));
                    }
                    this.titleLabel.getAccessibleContext().setAccessibleName(this.titleLabel.getText() + ((ConfigProperties.JREInformation)this.model.get(0)).getInstalledPath());
                    this.addButton.setEnabled(true);
                    this.addButton.requestFocus();
                    this.list.requestFocus();
                } else {
                    this.titleLabel.setText(Resources.getString("jresearcher.noJREsTitle"));
                    this.list.getAccessibleContext().setAccessibleName(this.titleLabel.getText());
                    this.addButton.setEnabled(false);
                    JRESearcher.this.setButtonFocus(1);
                    this.list.requestFocus();
                }
                JRESearcher.this.setButtonEnabled(2, true);
                this.searchLabel.setText(" ");
                this.stopSearching();
            }
        }

        protected Component createComponent() {
            this.searchPrefix = Resources.getString("jresearcher.searchingPrefix");
            this.model = new DefaultListModel();
            this.list = new JList(this.model);
            this.modelFinal = new DefaultListModel();
            this.finalList = new JList(this.modelFinal);
            this.finalList.getAccessibleContext().setAccessibleDescription(Resources.getString("jresearcher.finalList.desc"));
            ImageIcon imageIcon = new ImageIcon();
            ImageIcon imageIcon2 = new ImageIcon();
            imageIcon = Resources.getIcon("jresearcher.forward.image");
            imageIcon2 = Resources.getIcon("jresearcher.remove.image");
            this.addButton = new JButton(imageIcon);
            this.remButton = new JButton(imageIcon2);
            this.addButton.getAccessibleContext().setAccessibleName(Resources.getString("jresearcher.addButton.name"));
            this.remButton.getAccessibleContext().setAccessibleName(Resources.getString("jresearcher.remButton.name"));
            this.addButton.setToolTipText(Resources.getString("jresearcher.forward.tooltip"));
            this.remButton.setToolTipText(Resources.getString("jresearcher.remove.tooltip"));
            this.addButton.setEnabled(false);
            this.remButton.setEnabled(false);
            this.list.setCellRenderer(new DefaultListCellRenderer(this){
                private final /* synthetic */ SearchController this$1;
                {
                    this.this$1 = searchController;
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    if (object instanceof ConfigProperties.JREInformation) {
                        object = ((ConfigProperties.JREInformation)object).getInstalledPath();
                    }
                    return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                }
            });
            this.finalList.setCellRenderer(new DefaultListCellRenderer(this){
                private final /* synthetic */ SearchController this$1;
                {
                    this.this$1 = searchController;
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    if (object instanceof ConfigProperties.JREInformation) {
                        object = ((ConfigProperties.JREInformation)object).getInstalledPath();
                    }
                    return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                }
            });
            this.addButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ SearchController this$1;
                {
                    this.this$1 = searchController;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = SearchController.access$1000(this.this$1).getSelectedIndices();
                    int n = 0;
                    if (nArray != null && nArray.length > 0) {
                        SearchController.access$1100(this.this$1).setEnabled(true);
                        for (n = 0; n < nArray.length; ++n) {
                            if (SearchController.access$1300(this.this$1).contains(SearchController.access$1200(this.this$1).get(nArray[n]))) continue;
                            SearchController.access$1300(this.this$1).addElement(SearchController.access$1200(this.this$1).get(nArray[n]));
                        }
                        SearchController.access$1400(this.this$1);
                        if (SearchController.access$1300(this.this$1).getSize() > 0) {
                            SearchController.access$1500(this.this$1).getAccessibleContext().setAccessibleName(SearchController.access$1500(this.this$1).getText() + ((ConfigProperties.JREInformation)SearchController.access$1300(this.this$1).get(0)).getInstalledPath());
                        }
                    }
                }
            });
            this.remButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ SearchController this$1;
                {
                    this.this$1 = searchController;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = SearchController.access$1600(this.this$1).getSelectedIndices();
                    int n = 0;
                    int n2 = nArray.length;
                    if (nArray != null && nArray.length > 0) {
                        for (n = 0; n < nArray.length; ++n) {
                            int n3 = nArray[n];
                            SearchController.access$1300(this.this$1).add(0, SearchController.access$1300(this.this$1).get(n3));
                            SearchController.access$1300(this.this$1).remove(++n3);
                        }
                        for (n = 0; n < n2; ++n) {
                            SearchController.access$1300(this.this$1).remove(0);
                        }
                        SearchController.access$1400(this.this$1);
                    }
                    if (SearchController.access$1300(this.this$1).isEmpty()) {
                        SearchController.access$1100(this.this$1).setEnabled(false);
                        SearchController.access$1500(this.this$1).getAccessibleContext().setAccessibleName(SearchController.access$1500(this.this$1).getText() + Resources.getString("controlpanel.proxy.noProxy"));
                    }
                }
            });
            this.searchLabel = new JLabel(" ");
            this.titleLabel = new JLabel(Resources.getString("jresearcher.searchingTitle"));
            this.selectLabel = new JLabel("");
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 2, 0, 2);
            gridBagConstraints.gridy = 0;
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel jPanel2 = new JPanel(gridBagLayout);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets.left = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.anchor = 17;
            jPanel2.add((Component)this.titleLabel, gridBagConstraints2);
            gridBagConstraints2.insets.right = 30;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.anchor = 13;
            jPanel2.add((Component)this.selectLabel, gridBagConstraints2);
            jPanel.add((Component)jPanel2, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            jPanel.add((Component)this.searchLabel, gridBagConstraints);
            GridLayout gridLayout = new GridLayout(1, 3);
            JPanel jPanel3 = new JPanel(gridLayout);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets.bottom = 0;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)jPanel3, gridBagConstraints);
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            JPanel jPanel4 = new JPanel(gridBagLayout2);
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.insets.top = 50;
            gridBagConstraints3.anchor = 11;
            jPanel4.add((Component)this.addButton, gridBagConstraints3);
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.insets.bottom = 50;
            gridBagConstraints3.anchor = 15;
            jPanel4.add((Component)this.remButton, gridBagConstraints3);
            jPanel3.add(new JScrollPane(this.list));
            jPanel3.add(jPanel4);
            jPanel3.add(new JScrollPane(this.finalList));
            return jPanel;
        }

        private void updateJREs() {
            if (!this.active) {
                return;
            }
            if (this.modelFinal != null) {
                int n = this.modelFinal.getSize();
                if (n > 0) {
                    JRESearcher.this.setButtonEnabled(2, true);
                    ConfigProperties.JREInformation[] jREInformationArray = new ConfigProperties.JREInformation[n];
                    for (int i = 0; i < n; ++i) {
                        jREInformationArray[i] = (ConfigProperties.JREInformation)this.modelFinal.getElementAt(i);
                    }
                    JRESearcher.this.setJREs(jREInformationArray);
                } else {
                    JRESearcher.this.setJREs(null);
                    JRESearcher.this.setButtonEnabled(2, false);
                }
            } else {
                JRESearcher.this.setJREs(null);
            }
        }

        private void add(Searcher searcher, ConfigProperties.JREInformation jREInformation) {
            SwingUtilities.invokeLater(new Runnable(this, searcher, jREInformation){
                private final /* synthetic */ Searcher val$searcher;
                private final /* synthetic */ ConfigProperties.JREInformation val$jre;
                private final /* synthetic */ SearchController this$1;
                {
                    this.this$1 = searchController;
                    this.val$searcher = searcher;
                    this.val$jre = jREInformation;
                }

                public void run() {
                    if (SearchController.access$1800(this.this$1) == this.val$searcher) {
                        SearchController.access$1200(this.this$1).addElement(this.val$jre);
                        SearchController.access$1400(this.this$1);
                    }
                }
            });
        }

        static /* synthetic */ JList access$1000(SearchController searchController) {
            return searchController.list;
        }

        static /* synthetic */ JButton access$1100(SearchController searchController) {
            return searchController.remButton;
        }

        static /* synthetic */ DefaultListModel access$1200(SearchController searchController) {
            return searchController.model;
        }

        static /* synthetic */ DefaultListModel access$1300(SearchController searchController) {
            return searchController.modelFinal;
        }

        static /* synthetic */ JLabel access$1500(SearchController searchController) {
            return searchController.selectLabel;
        }

        static /* synthetic */ JList access$1600(SearchController searchController) {
            return searchController.finalList;
        }

        static /* synthetic */ Searcher access$1800(SearchController searchController) {
            return searchController.searcher;
        }

        private class Searcher
        implements Runnable {
            private File file;
            private boolean stop;
            private File currentFile;
            private boolean finished;

            private Searcher() {
            }

            void start(File file) {
                this.file = file;
                new Thread(this).start();
                SearchController.this.updateJREs();
            }

            public File getCurrentFile() {
                return this.currentFile;
            }

            public void stop() {
                this.stop = true;
            }

            public void run() {
                this.check(this.file);
                this.finished = true;
            }

            public boolean isFinished() {
                return this.finished;
            }

            private void check(File file) {
                String[] stringArray;
                this.currentFile = file;
                String string = file.getName();
                if (file.isFile() && (string.equals("java") || string.equals("javaw.exe"))) {
                    ConfigProperties.JREInformation jREInformation = this.getVersion(file);
                    if (jREInformation != null) {
                        SearchController.this.add(this, jREInformation);
                    }
                } else if (!file.isFile() && (stringArray = file.list()) != null) {
                    int n = stringArray.length;
                    for (int i = 0; i < n && !this.stop; ++i) {
                        this.check(new File(file, stringArray[i]));
                    }
                }
            }

            private ConfigProperties.JREInformation getVersion(File file) {
                if (Globals.TraceJRESearch) {
                    Debug.println("checking " + file);
                }
                if (!this.isValidJavaPath(file)) {
                    if (Globals.TraceJRESearch) {
                        Debug.println("\tisn't valid java path");
                    }
                    return null;
                }
                ConfigProperties.JREInformation jREInformation = JRELocator.getVersion(file);
                jREInformation.setOsInfo(Globals.osName, Globals.osArch);
                return jREInformation;
            }

            private boolean isValidJavaPath(File file) {
                String string = file.getParent();
                if (string.endsWith(File.separator + "native_threads") || string.endsWith(File.separator + "green_threads")) {
                    return false;
                }
                String string2 = File.separator + "jre" + File.separator + "bin";
                if (string.endsWith(string2) && string.length() > string2.length()) {
                    String string3 = string.substring(0, string.length() - string2.length() + 1) + "bin" + File.separator;
                    File file2 = new File(string3 + "java");
                    if (file2.exists() && file2.isFile()) {
                        return false;
                    }
                    file2 = new File(string3 + "javaw.exe");
                    if (file2.exists() && file2.isFile()) {
                        return false;
                    }
                }
                return true;
            }
        }
    }

    private class PathController
    extends SimpleController {
        private JFileChooser fc;

        private PathController() {
        }

        public void start() {
            JRESearcher.this.setButtonEnabled(2, JRESearcher.this.getDirectory() != null);
            JRESearcher.this.setButtonEnabled(1, true);
        }

        protected Component createComponent() {
            this.fc = new JFileChooser();
            this.fc.setFileSelectionMode(2);
            this.fc.addActionListener(new ActionListener(this){
                private final /* synthetic */ PathController this$1;
                {
                    this.this$1 = pathController;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if ("ApproveSelection".equals(actionEvent.getActionCommand())) {
                        JFileChooser jFileChooser;
                        File file;
                        if (actionEvent.getSource() instanceof JFileChooser && (file = (jFileChooser = (JFileChooser)actionEvent.getSource()).getSelectedFile()) != null && file.isDirectory()) {
                            jFileChooser.setCurrentDirectory(file);
                        }
                        PathController.access$600(this.this$1);
                    } else if ("CancelSelection".equals(actionEvent.getActionCommand())) {
                        PathController.access$700(this.this$1).cancel();
                    }
                }
            });
            this.fc.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ PathController this$1;
                {
                    this.this$1 = pathController;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName()) || "directoryChanged".equals(propertyChangeEvent.getPropertyName())) {
                        PathController.access$600(this.this$1);
                    }
                }
            });
            try {
                Class[] classArray = new Class[]{Boolean.TYPE};
                Method method = (class$javax$swing$JFileChooser == null ? (class$javax$swing$JFileChooser = JRESearcher.class$("javax.swing.JFileChooser")) : class$javax$swing$JFileChooser).getMethod("setControlButtonsAreShown", classArray);
                if (method != null) {
                    Object[] objectArray = new Object[]{Boolean.FALSE};
                    method.invoke((Object)this.fc, objectArray);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            this.fc.setDialogType(0);
            this.updateDirectory();
            return this.fc;
        }

        private void updateDirectory() {
            File file = this.fc.getSelectedFile();
            if (file == null) {
                file = this.fc.getCurrentDirectory();
            }
            JRESearcher.this.setDirectory(file);
        }

        static /* synthetic */ void access$600(PathController pathController) {
            pathController.updateDirectory();
        }

        static /* synthetic */ JRESearcher access$700(PathController pathController) {
            return pathController.JRESearcher.this;
        }
    }

    private class SimpleController
    implements Subcontroller {
        private Component component;

        private SimpleController() {
        }

        public void setComponent(Component component) {
            this.component = component;
        }

        public Component getComponent() {
            if (this.component == null) {
                this.setComponent(this.createComponent());
            }
            return this.component;
        }

        protected Component createComponent() {
            return null;
        }

        public void start() {
        }

        public void stop() {
        }

        public void apply() {
        }

        public void revert() {
        }
    }
}

